/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support.test.collections;

import com.github.robtimus.junit.support.ThrowableAssertions;
import com.github.robtimus.junit.support.test.collections.MapEntryTests;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public interface UnmodifiableMapEntryTests<K, V>
extends MapEntryTests<K, V> {

    @DisplayName(value="setValue(Object)")
    public static interface SetValueTests<K, V>
    extends UnmodifiableMapEntryTests<K, V> {
        public UnaryOperator<V> replaceValueOperator();

        @Test
        @DisplayName(value="setValue(Object) with same value")
        default public void testSetValueWithSameValue() {
            Map map = this.map();
            for (Map.Entry entry : map.entrySet()) {
                Object value = entry.getValue();
                ThrowableAssertions.assertOptionallyThrows(UnsupportedOperationException.class, () -> Assertions.assertEquals((Object)value, (Object)entry.setValue(value)));
            }
            Assertions.assertEquals(this.expectedEntries(), map);
        }

        @Test
        @DisplayName(value="setValue(Object) with updated value")
        default public void testSetValueWithUpdatedValue() {
            Map map = this.map();
            UnaryOperator operator = this.replaceValueOperator();
            for (Map.Entry entry : map.entrySet()) {
                Object value = entry.getValue();
                Assertions.assertThrows(UnsupportedOperationException.class, () -> entry.setValue(operator.apply(value)));
            }
            Assertions.assertEquals(this.expectedEntries(), map);
        }
    }
}

