/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support.test.collections;

import com.github.robtimus.junit.support.ThrowableAsserter;
import com.github.robtimus.junit.support.ThrowableAssertions;
import com.github.robtimus.junit.support.test.collections.CollectionAssertions;
import com.github.robtimus.junit.support.test.collections.CollectionTests;
import com.github.robtimus.junit.support.test.collections.IncompatibleObject;
import com.github.robtimus.junit.support.test.collections.IterableTests;
import com.github.robtimus.junit.support.test.collections.IteratorTests;
import com.github.robtimus.junit.support.test.collections.MapTests;
import com.github.robtimus.junit.support.test.collections.SetTests;
import com.github.robtimus.junit.support.test.collections.UnmodifiableCollectionTests;
import com.github.robtimus.junit.support.test.collections.UnmodifiableIteratorTests;
import com.github.robtimus.junit.support.test.collections.UnmodifiableSetTests;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

public interface UnmodifiableMapTests<K, V>
extends MapTests<K, V> {

    @DisplayName(value="merge(Object, Object, BiFunction)")
    public static interface MergeTests<K, V>
    extends MapTests<K, V> {
        public BinaryOperator<V> combineValuesOperator();

        @Test
        @DisplayName(value="merge(Object, Object, BiFunction)")
        default public void testMerge() {
            Map map = this.map();
            BinaryOperator operator = this.combineValuesOperator();
            Map expectedEntries = this.expectedEntries();
            for (Map.Entry entry : expectedEntries.entrySet()) {
                Assertions.assertThrows(UnsupportedOperationException.class, () -> map.merge(entry.getKey(), entry.getValue(), operator));
            }
            for (Map.Entry entry : this.nonContainedEntries().entrySet()) {
                Assertions.assertThrows(UnsupportedOperationException.class, () -> map.merge(entry.getKey(), entry.getValue(), operator));
            }
            Assertions.assertEquals(expectedEntries, map);
        }

        @Test
        @DisplayName(value="merge(Object, Object, BiFunction) with function returning null")
        default public void testMergeWithFunctionReturningNull() {
            Map map = this.map();
            Map expectedEntries = this.expectedEntries();
            for (Map.Entry entry : expectedEntries.entrySet()) {
                Assertions.assertThrows(UnsupportedOperationException.class, () -> map.merge(entry.getKey(), entry.getValue(), (v1, v2) -> null));
            }
            for (Map.Entry entry : this.nonContainedEntries().entrySet()) {
                ThrowableAssertions.assertOptionallyThrows(UnsupportedOperationException.class, () -> map.merge(entry.getKey(), entry.getValue(), (v1, v2) -> null));
            }
            Assertions.assertEquals(expectedEntries, map);
        }

        @Test
        @DisplayName(value="merge(Object, Object, BiFunction) with throwing function")
        default public void testMergeWithThrowingFunction() {
            Map map = this.map();
            IllegalArgumentException exception = new IllegalArgumentException();
            BinaryOperator operator = (v1, v2) -> {
                throw exception;
            };
            Map expectedEntries = this.expectedEntries();
            for (Map.Entry entry : expectedEntries.entrySet()) {
                ThrowableAsserter.whenThrows(UnsupportedOperationException.class, () -> map.merge(entry.getKey(), entry.getValue(), operator)).thenAssertNothing().whenThrows(IllegalArgumentException.class).thenAssert(thrown -> Assertions.assertSame((Object)exception, (Object)thrown)).execute();
            }
            for (Map.Entry entry : this.nonContainedEntries().entrySet()) {
                ThrowableAsserter.whenThrows(UnsupportedOperationException.class, () -> map.merge(entry.getKey(), entry.getValue(), operator)).thenAssertNothing().whenThrows(IllegalArgumentException.class).thenAssert(thrown -> Assertions.assertSame((Object)exception, (Object)thrown)).execute();
            }
            Assertions.assertEquals(expectedEntries, map);
        }

        @Test
        @DisplayName(value="merge(Object, Object, BiFunction) with null function")
        default public void testMergeWithNullFunction() {
            Map map = this.map();
            Map expectedEntries = this.expectedEntries();
            for (Map.Entry entry : expectedEntries.entrySet()) {
                ThrowableAssertions.assertThrowsOneOf(UnsupportedOperationException.class, NullPointerException.class, () -> map.merge(entry.getKey(), entry.getValue(), null));
            }
            for (Map.Entry entry : this.nonContainedEntries().entrySet()) {
                ThrowableAssertions.assertThrowsOneOf(UnsupportedOperationException.class, NullPointerException.class, () -> map.merge(entry.getKey(), entry.getValue(), null));
            }
            Assertions.assertEquals(expectedEntries, map);
        }
    }

    @DisplayName(value="compute(Object, BiFunction)")
    public static interface ComputeTests<K, V>
    extends MapTests<K, V> {
        public UnaryOperator<V> replaceValueOperator();

        @Test
        @DisplayName(value="compute(Object, BiFunction)")
        default public void testCompute() {
            Map map = this.map();
            UnaryOperator operator = this.replaceValueOperator();
            Map expectedEntries = this.expectedEntries();
            Map nonContainedEntries = this.nonContainedEntries();
            for (Map.Entry entry : expectedEntries.entrySet()) {
                Assertions.assertThrows(UnsupportedOperationException.class, () -> map.compute(entry.getKey(), (k, v) -> operator.apply(v)));
            }
            for (Map.Entry entry : nonContainedEntries.entrySet()) {
                Object value = entry.getValue();
                Assertions.assertThrows(UnsupportedOperationException.class, () -> map.compute(entry.getKey(), (k, v) -> value));
            }
            Assertions.assertEquals(expectedEntries, map);
        }

        @Test
        @DisplayName(value="compute(Object, BiFunction) with function returning null")
        default public void testComputeWithFunctionReturningNull() {
            Map map = this.map();
            Map expectedEntries = this.expectedEntries();
            for (Object key : expectedEntries.keySet()) {
                Assertions.assertThrows(UnsupportedOperationException.class, () -> map.compute(key, (k, v) -> null));
            }
            for (Object key : this.nonContainedEntries().keySet()) {
                Assertions.assertThrows(UnsupportedOperationException.class, () -> map.compute(key, (k, v) -> null));
            }
            Assertions.assertEquals(expectedEntries, map);
        }

        @Test
        @DisplayName(value="compute(Object, BiFunction) with throwing function")
        default public void testComputeWithThrowingFunction() {
            Map map = this.map();
            IllegalArgumentException exception = new IllegalArgumentException();
            BiFunction<Object, Object, Object> function = (k, v) -> {
                throw exception;
            };
            Map expectedEntries = this.expectedEntries();
            for (Object key : expectedEntries.keySet()) {
                ThrowableAsserter.whenThrows(UnsupportedOperationException.class, () -> map.compute(key, function)).thenAssertNothing().whenThrows(IllegalArgumentException.class).thenAssert(thrown -> Assertions.assertSame((Object)exception, (Object)thrown)).execute();
            }
            for (Object key : this.nonContainedEntries().keySet()) {
                ThrowableAsserter.whenThrows(UnsupportedOperationException.class, () -> map.compute(key, function)).thenAssertNothing().whenThrows(IllegalArgumentException.class).thenAssert(thrown -> Assertions.assertSame((Object)exception, (Object)thrown)).execute();
            }
            Assertions.assertEquals(expectedEntries, map);
        }

        @Test
        @DisplayName(value="compute(Object, BiFunction) with null function")
        default public void testComputeWithNullFunction() {
            Map map = this.map();
            Map expectedEntries = this.expectedEntries();
            for (Object key : expectedEntries.keySet()) {
                ThrowableAssertions.assertThrowsOneOf(UnsupportedOperationException.class, NullPointerException.class, () -> map.compute(key, null));
            }
            for (Object key : this.nonContainedEntries().keySet()) {
                ThrowableAssertions.assertThrowsOneOf(UnsupportedOperationException.class, NullPointerException.class, () -> map.compute(key, null));
            }
            Assertions.assertEquals(expectedEntries, map);
        }
    }

    @DisplayName(value="computeIfPresent(Object, BiFunction)")
    public static interface ComputeIfPresentTests<K, V>
    extends MapTests<K, V> {
        @Test
        @DisplayName(value="computeIfPresent(Object, BiFunction)")
        default public void testComputeIfPresent() {
            Map map = this.map();
            Map nonContainedEntries = this.nonContainedEntries();
            Object nonContained = nonContainedEntries.values().iterator().next();
            Map expectedEntries = this.expectedEntries();
            for (Object k : expectedEntries.keySet()) {
                Assertions.assertThrows(UnsupportedOperationException.class, () -> map.computeIfPresent(key, (k, v) -> nonContained));
            }
            for (Map.Entry entry : nonContainedEntries.entrySet()) {
                Object value = entry.getValue();
                ThrowableAssertions.assertOptionallyThrows(UnsupportedOperationException.class, () -> Assertions.assertNull((Object)map.computeIfPresent(entry.getKey(), (k, v) -> value)));
            }
            Assertions.assertEquals(expectedEntries, map);
        }

        @Test
        @DisplayName(value="computeIfPresent(Object, BiFunction) with function returning null")
        default public void testComputeIfPresentWithFunctionReturningNull() {
            Map map = this.map();
            Map expectedEntries = this.expectedEntries();
            for (Object key : expectedEntries.keySet()) {
                Assertions.assertThrows(UnsupportedOperationException.class, () -> map.computeIfPresent(key, (k, v) -> null));
            }
            for (Object key : this.nonContainedEntries().keySet()) {
                ThrowableAssertions.assertOptionallyThrows(UnsupportedOperationException.class, () -> Assertions.assertNull((Object)map.computeIfPresent(key, (k, v) -> null)));
            }
            Assertions.assertEquals(expectedEntries, map);
        }

        @Test
        @DisplayName(value="computeIfPresent(Object, BiFunction) with throwing function")
        default public void testComputeIfPresentWithThrowingFunction() {
            Map map = this.map();
            IllegalArgumentException exception = new IllegalArgumentException();
            BiFunction<Object, Object, Object> function = (k, v) -> {
                throw exception;
            };
            Map expectedEntries = this.expectedEntries();
            for (Object key : expectedEntries.keySet()) {
                ThrowableAsserter.whenThrows(UnsupportedOperationException.class, () -> map.computeIfPresent(key, function)).thenAssertNothing().whenThrows(IllegalArgumentException.class).thenAssert(thrown -> Assertions.assertSame((Object)exception, (Object)thrown)).execute();
            }
            for (Object key : this.nonContainedEntries().keySet()) {
                ThrowableAssertions.assertOptionallyThrows(UnsupportedOperationException.class, () -> Assertions.assertNull(map.computeIfPresent(key, function)));
            }
            Assertions.assertEquals(expectedEntries, map);
        }

        @Test
        @DisplayName(value="computeIfPresent(Object, BiFunction) with null function")
        default public void testComputeIfPresentWithNullFunction() {
            Map map = this.map();
            Map expectedEntries = this.expectedEntries();
            for (Object key : expectedEntries.keySet()) {
                ThrowableAssertions.assertThrowsOneOf(UnsupportedOperationException.class, NullPointerException.class, () -> map.computeIfPresent(key, null));
            }
            for (Object key : this.nonContainedEntries().keySet()) {
                ThrowableAssertions.assertThrowsOneOf(UnsupportedOperationException.class, NullPointerException.class, () -> map.computeIfPresent(key, null));
            }
            Assertions.assertEquals(expectedEntries, map);
        }
    }

    @DisplayName(value="computeIfAbsent(Object, Function)")
    public static interface ComputeIfAbsentTests<K, V>
    extends MapTests<K, V> {
        @Test
        @DisplayName(value="computeIfAbsent(Object, Function)")
        default public void testComputeIfAbsent() {
            Map map = this.map();
            Map nonContainedEntries = this.nonContainedEntries();
            Object nonContained = nonContainedEntries.values().iterator().next();
            Map expectedEntries = this.expectedEntries();
            for (Map.Entry entry : expectedEntries.entrySet()) {
                ThrowableAssertions.assertOptionallyThrows(UnsupportedOperationException.class, () -> Assertions.assertEquals(entry.getValue(), (Object)map.computeIfAbsent(entry.getKey(), k -> nonContained)));
            }
            for (Map.Entry entry : nonContainedEntries.entrySet()) {
                Object value = entry.getValue();
                Assertions.assertThrows(UnsupportedOperationException.class, () -> map.computeIfAbsent(entry.getKey(), k -> value));
            }
            Assertions.assertEquals(expectedEntries, map);
        }

        @Test
        @DisplayName(value="computeIfAbsent(Object, Function) with function returning null")
        default public void testComputeIfAbsentWithFunctionReturningNull() {
            Map map = this.map();
            Map expectedEntries = this.expectedEntries();
            for (Object k : expectedEntries.keySet()) {
                Assertions.assertThrows(UnsupportedOperationException.class, () -> map.computeIfAbsent(key, k -> null));
            }
            for (Map.Entry entry : this.nonContainedEntries().entrySet()) {
                ThrowableAssertions.assertOptionallyThrows(UnsupportedOperationException.class, () -> Assertions.assertNull((Object)map.computeIfAbsent(entry.getKey(), k -> null)));
            }
            Assertions.assertEquals(expectedEntries, map);
        }

        @Test
        @DisplayName(value="computeIfAbsent(Object, Function) with throwing function")
        default public void testComputeIfAbsentWithThrowingFunction() {
            Map map = this.map();
            IllegalArgumentException exception = new IllegalArgumentException();
            Function<Object, Object> function = k -> {
                throw exception;
            };
            Map expectedEntries = this.expectedEntries();
            for (Map.Entry entry : expectedEntries.entrySet()) {
                ThrowableAssertions.assertOptionallyThrows(UnsupportedOperationException.class, () -> Assertions.assertEquals(entry.getValue(), map.computeIfAbsent(entry.getKey(), function)));
            }
            for (Map.Entry key : this.nonContainedEntries().keySet()) {
                ThrowableAsserter.whenThrows(UnsupportedOperationException.class, () -> map.computeIfAbsent(key, function)).thenAssertNothing().whenThrows(IllegalArgumentException.class).thenAssert(thrown -> Assertions.assertSame((Object)exception, (Object)thrown)).execute();
            }
            Assertions.assertEquals(expectedEntries, map);
        }

        @Test
        @DisplayName(value="computeIfAbsent(Object, Function) with null function")
        default public void testComputeIfAbsentWithNullFunction() {
            Map map = this.map();
            Map expectedEntries = this.expectedEntries();
            for (Object key : expectedEntries.keySet()) {
                ThrowableAssertions.assertThrowsOneOf(UnsupportedOperationException.class, NullPointerException.class, () -> map.computeIfAbsent(key, null));
            }
            for (Object key : this.nonContainedEntries().keySet()) {
                ThrowableAssertions.assertThrowsOneOf(UnsupportedOperationException.class, NullPointerException.class, () -> map.computeIfAbsent(key, null));
            }
            Assertions.assertEquals(expectedEntries, map);
        }
    }

    @DisplayName(value="replace(Object, Object)")
    public static interface ReplaceTests<K, V>
    extends UnmodifiableMapTests<K, V> {
        @Test
        @DisplayName(value="replace(Object, Object) with contained elements")
        default public void testReplaceWithContainedElements() {
            Map map = this.map();
            Map expectedEntries = this.expectedEntries();
            Map nonContainedEntries = this.nonContainedEntries();
            Object nonContained = nonContainedEntries.values().iterator().next();
            for (Map.Entry entry : expectedEntries.entrySet()) {
                Assertions.assertThrows(UnsupportedOperationException.class, () -> map.replace(entry.getKey(), nonContained));
                ThrowableAssertions.assertOptionallyThrows(UnsupportedOperationException.class, () -> Assertions.assertEquals(entry.getValue(), map.replace(entry.getKey(), entry.getValue())));
            }
            Assertions.assertEquals(expectedEntries, map);
        }

        @Test
        @DisplayName(value="replace(Object, Object) with non-contained elements")
        default public void testReplaceWithNonContainedElements() {
            Map map = this.map();
            for (Map.Entry entry : this.nonContainedEntries().entrySet()) {
                ThrowableAssertions.assertOptionallyThrows(UnsupportedOperationException.class, () -> Assertions.assertNull(map.replace(entry.getKey(), entry.getValue())));
            }
            Assertions.assertEquals(this.expectedEntries(), map);
        }

        @Test
        @DisplayName(value="replace(Object, Object) with null key")
        default public void testReplaceWithNullKey() {
            Map map = this.map();
            Object nonContained = this.nonContainedEntries().values().iterator().next();
            ThrowableAssertions.assertOptionallyThrows(UnsupportedOperationException.class, () -> Assertions.assertNull((Object)map.replace(null, nonContained)));
            Assertions.assertEquals(this.expectedEntries(), map);
        }

        @Test
        @DisplayName(value="replace(Object, Object) with null value")
        default public void testReplaceWithNullValue() {
            Map map = this.map();
            Object nonContained = this.nonContainedEntries().keySet().iterator().next();
            ThrowableAssertions.assertOptionallyThrows(UnsupportedOperationException.class, () -> Assertions.assertNull(map.replace(nonContained, null)));
            Assertions.assertEquals(this.expectedEntries(), map);
        }
    }

    @DisplayName(value="replace(Object, Object, Object)")
    public static interface ReplaceExactValueTests<K, V>
    extends UnmodifiableMapTests<K, V> {
        @Test
        @DisplayName(value="replace(Object, Object, Object) with contained elements")
        default public void testReplaceExactValueWithContainedElements() {
            Map map = this.map();
            Map expectedEntries = this.expectedEntries();
            Map nonContainedEntries = this.nonContainedEntries();
            Object nonContained = nonContainedEntries.values().iterator().next();
            for (Map.Entry entry : expectedEntries.entrySet()) {
                Assertions.assertThrows(UnsupportedOperationException.class, () -> map.replace(entry.getKey(), entry.getValue(), nonContained));
                ThrowableAssertions.assertOptionallyThrows(UnsupportedOperationException.class, () -> Assertions.assertTrue((boolean)map.replace(entry.getKey(), entry.getValue(), entry.getValue())));
            }
            Assertions.assertEquals(expectedEntries, map);
        }

        @Test
        @DisplayName(value="replace(Object, Object, Object) with non-contained elements")
        default public void testReplaceExactValueWithNonContainedElements() {
            Map map = this.map();
            Map nonContainedEntries = this.nonContainedEntries();
            Object nonContained = nonContainedEntries.values().iterator().next();
            for (Map.Entry entry : nonContainedEntries.entrySet()) {
                ThrowableAssertions.assertOptionallyThrows(UnsupportedOperationException.class, () -> Assertions.assertFalse((boolean)map.replace(entry.getKey(), entry.getValue(), nonContained)));
            }
            Assertions.assertEquals(this.expectedEntries(), map);
        }

        @Test
        @DisplayName(value="replace(Object, Object, Object) with null key")
        default public void testReplaceExactValueWithNullKey() {
            Map map = this.map();
            Object nonContained = this.nonContainedEntries().values().iterator().next();
            ThrowableAssertions.assertOptionallyThrows(UnsupportedOperationException.class, () -> Assertions.assertFalse((boolean)map.replace(null, nonContained, nonContained)));
            Assertions.assertEquals(this.expectedEntries(), map);
        }

        @Test
        @DisplayName(value="replace(Object, Object, Object) with null value")
        default public void testReplaceExactValueWithNullValue() {
            Map map = this.map();
            Object nonContained = this.nonContainedEntries().keySet().iterator().next();
            ThrowableAssertions.assertOptionallyThrows(UnsupportedOperationException.class, () -> Assertions.assertFalse((boolean)map.replace(nonContained, null, null)));
            Assertions.assertEquals(this.expectedEntries(), map);
        }
    }

    @DisplayName(value="remove(Object, Object)")
    public static interface RemoveExactValueTests<K, V>
    extends UnmodifiableMapTests<K, V> {
        @Test
        @DisplayName(value="remove(Object, Object) with contained elements")
        default public void testRemoveExactValueWithContainedElements() {
            Map map = this.map();
            Map expectedEntries = this.expectedEntries();
            for (Map.Entry entry : expectedEntries.entrySet()) {
                Assertions.assertThrows(UnsupportedOperationException.class, () -> map.remove(entry.getKey(), entry.getValue()));
            }
            Assertions.assertEquals(expectedEntries, map);
        }

        @Test
        @DisplayName(value="remove(Object, Object) with non-contained elements")
        default public void testRemoveExactValueWithNonContainedElements() {
            Map map = this.map();
            for (Map.Entry entry : this.nonContainedEntries().entrySet()) {
                ThrowableAssertions.assertOptionallyThrows(UnsupportedOperationException.class, () -> Assertions.assertNull((Object)map.remove(entry.getKey(), entry.getValue())));
            }
            Assertions.assertEquals(this.expectedEntries(), map);
        }

        @Test
        @DisplayName(value="remove(Object, Object) with null key")
        default public void testRemoveExactValueWithNullKey() {
            Map map = this.map();
            Object nonContained = this.nonContainedEntries().values().iterator().next();
            ThrowableAssertions.assertOptionallyThrows(UnsupportedOperationException.class, () -> Assertions.assertNull((Object)map.remove(null, nonContained)));
            Assertions.assertEquals(this.expectedEntries(), map);
        }

        @Test
        @DisplayName(value="remove(Object, Object) with an incompatible key")
        default public void testRemoveExactValueWithIncompatibleObjectKey() {
            Map map = this.map();
            Object nonContained = this.nonContainedEntries().values().iterator().next();
            ThrowableAssertions.assertOptionallyThrows(UnsupportedOperationException.class, () -> Assertions.assertNull((Object)map.remove(new IncompatibleObject(), nonContained)));
            Assertions.assertEquals(this.expectedEntries(), map);
        }

        @Test
        @DisplayName(value="remove(Object, Object) with null value")
        default public void testRemoveExactValueWithNullValue() {
            Map map = this.map();
            Object nonContained = this.nonContainedEntries().keySet().iterator().next();
            ThrowableAssertions.assertOptionallyThrows(UnsupportedOperationException.class, () -> Assertions.assertNull((Object)map.remove(nonContained, null)));
            Assertions.assertEquals(this.expectedEntries(), map);
        }

        @Test
        @DisplayName(value="remove(Object, Object) with an incompatible value")
        default public void testRemoveExactValueWithIncompatibleObjectValue() {
            Map map = this.map();
            Object nonContained = this.nonContainedEntries().keySet().iterator().next();
            ThrowableAssertions.assertOptionallyThrows(UnsupportedOperationException.class, () -> Assertions.assertNull((Object)map.remove(nonContained, new IncompatibleObject())));
            Assertions.assertEquals(this.expectedEntries(), map);
        }
    }

    @DisplayName(value="putIfAbsent(Object, Object)")
    public static interface PutIfAbsentTests<K, V>
    extends MapTests<K, V> {
        @Test
        @DisplayName(value="putIfAbsent(Object, Object)")
        default public void testPutIfAbsent() {
            Map map = this.map();
            Map nonContainedEntries = this.nonContainedEntries();
            Object nonContained = nonContainedEntries.values().iterator().next();
            Map expectedEntries = this.expectedEntries();
            for (Map.Entry entry : expectedEntries.entrySet()) {
                ThrowableAssertions.assertOptionallyThrows(UnsupportedOperationException.class, () -> Assertions.assertEquals(entry.getValue(), (Object)map.putIfAbsent(entry.getKey(), nonContained)));
            }
            Assertions.assertEquals(expectedEntries, map);
            for (Map.Entry entry : nonContainedEntries.entrySet()) {
                Assertions.assertThrows(UnsupportedOperationException.class, () -> map.putIfAbsent(entry.getKey(), entry.getValue()));
            }
            Assertions.assertEquals(expectedEntries, map);
        }
    }

    @DisplayName(value="replaceAll(BiFunction)")
    public static interface ReplaceAllTests<K, V>
    extends MapTests<K, V> {
        public BiFunction<K, V, V> replaceValueFunction();

        @Test
        @DisplayName(value="replaceAll(BiFunction)")
        default public void testReplaceAll() {
            Map map = this.map();
            BiFunction function = this.replaceValueFunction();
            if (map.isEmpty()) {
                ThrowableAssertions.assertOptionallyThrows(UnsupportedOperationException.class, () -> map.replaceAll(function));
            } else {
                Assertions.assertThrows(UnsupportedOperationException.class, () -> map.replaceAll(function));
            }
            Assertions.assertEquals(this.expectedEntries(), map);
        }

        @Test
        @DisplayName(value="replaceAll(BiFunction) with null function")
        default public void testReplaceAllWithNullOperator() {
            Map map = this.map();
            ThrowableAssertions.assertThrowsOneOf(UnsupportedOperationException.class, NullPointerException.class, () -> map.replaceAll(null));
            Assertions.assertEquals(this.expectedEntries(), map);
        }
    }

    @DisplayName(value="entrySet()")
    public static interface EntrySetTests<K, V>
    extends UnmodifiableMapTests<K, V>,
    SetTests<Map.Entry<K, V>> {
        @Override
        default public Set<Map.Entry<K, V>> iterable() {
            return this.map().entrySet();
        }

        @Override
        default public Collection<Map.Entry<K, V>> expectedElements() {
            return this.expectedEntries().entrySet();
        }

        @Override
        default public Collection<Map.Entry<K, V>> nonContainedElements() {
            return this.nonContainedEntries().entrySet();
        }

        @DisplayName(value="spliterator()")
        public static interface SpliteratorTests<K, V>
        extends EntrySetTests<K, V>,
        SetTests.SpliteratorTests<Map.Entry<K, V>> {
        }

        @DisplayName(value="hashCode()")
        public static interface HashCodeTests<K, V>
        extends EntrySetTests<K, V>,
        SetTests.HashCodeTests<Map.Entry<K, V>> {
        }

        @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
        @DisplayName(value="equals(Object)")
        public static interface EqualsTests<K, V>
        extends EntrySetTests<K, V>,
        SetTests.EqualsTests<Map.Entry<K, V>> {
        }

        @DisplayName(value="clear()")
        public static interface ClearTests<K, V>
        extends EntrySetTests<K, V>,
        UnmodifiableCollectionTests.ClearTests<Map.Entry<K, V>> {
        }

        @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
        @DisplayName(value="retainAll(Collection)")
        public static interface RetainAllTests<K, V>
        extends EntrySetTests<K, V>,
        UnmodifiableCollectionTests.RetainAllTests<Map.Entry<K, V>> {
        }

        @DisplayName(value="removeIf(Predicate)")
        public static interface RemoveIfTests<K, V>
        extends EntrySetTests<K, V>,
        UnmodifiableCollectionTests.RemoveIfTests<Map.Entry<K, V>> {
        }

        @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
        @DisplayName(value="removeAll(Collection)")
        public static interface RemoveAllTests<K, V>
        extends EntrySetTests<K, V>,
        UnmodifiableCollectionTests.RemoveAllTests<Map.Entry<K, V>> {
        }

        @DisplayName(value="addAll(Collection)")
        public static interface AddAllTests<K, V>
        extends EntrySetTests<K, V>,
        UnmodifiableCollectionTests.AddAllTests<Map.Entry<K, V>> {
        }

        @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
        @DisplayName(value="containsAll(Collection)")
        public static interface ContainsAllTests<K, V>
        extends EntrySetTests<K, V>,
        CollectionTests.ContainsAllTests<Map.Entry<K, V>> {
        }

        @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
        @DisplayName(value="remove(Object)")
        public static interface RemoveTests<K, V>
        extends EntrySetTests<K, V>,
        UnmodifiableCollectionTests.RemoveTests<Map.Entry<K, V>> {
        }

        @DisplayName(value="add(Object)")
        public static interface AddTests<K, V>
        extends EntrySetTests<K, V>,
        UnmodifiableCollectionTests.AddTests<Map.Entry<K, V>> {
        }

        @DisplayName(value="toArray(IntFunction)")
        public static interface ToArrayWithGeneratorTests<K, V>
        extends EntrySetTests<K, V>,
        CollectionTests.ToArrayWithGeneratorTests<Map.Entry<K, V>> {
        }

        @DisplayName(value="toArray(Object[])")
        public static interface ToArrayTests<K, V>
        extends EntrySetTests<K, V>,
        CollectionTests.ToArrayTests<Map.Entry<K, V>> {
        }

        @DisplayName(value="toArray()")
        public static interface ToObjectArrayTests<K, V>
        extends EntrySetTests<K, V>,
        CollectionTests.ToObjectArrayTests<Map.Entry<K, V>> {
        }

        @DisplayName(value="contains(Object)")
        public static interface ContainsTests<K, V>
        extends EntrySetTests<K, V>,
        CollectionTests.ContainsTests<Map.Entry<K, V>> {
        }

        @DisplayName(value="forEach(Consumer)")
        public static interface ForEachTests<K, V>
        extends EntrySetTests<K, V>,
        IterableTests.ForEachTests<Map.Entry<K, V>> {
        }

        @DisplayName(value="forEach(Consumer)")
        public static interface IteratorTests<K, V>
        extends EntrySetTests<K, V>,
        UnmodifiableIteratorTests<Map.Entry<K, V>> {
            @Override
            default public Set<Map.Entry<K, V>> iterable() {
                return EntrySetTests.super.iterable();
            }

            @Override
            default public Collection<Map.Entry<K, V>> expectedElements() {
                return EntrySetTests.super.expectedElements();
            }

            @DisplayName(value="forEachRemaining(Consumer)")
            public static interface ForEachRemainingTests<K, V>
            extends IteratorTests<K, V>,
            com.github.robtimus.junit.support.test.collections.IteratorTests$ForEachRemainingTests<Map.Entry<K, V>> {
            }

            @DisplayName(value="remove()")
            public static interface RemoveTests<K, V>
            extends IteratorTests<K, V>,
            UnmodifiableIteratorTests.RemoveTests<Map.Entry<K, V>> {
                @Override
                @Test
                @DisplayName(value="remove() throws UnsupportedOperationException")
                default public void testRemove() {
                    Map map = this.map();
                    Set entrySet = map.entrySet();
                    Iterator iterator = entrySet.iterator();
                    while (iterator.hasNext()) {
                        iterator.next();
                        Assertions.assertThrows(UnsupportedOperationException.class, iterator::remove);
                    }
                    Map expectedEntries = this.expectedEntries();
                    Set expectedElements = expectedEntries.entrySet();
                    CollectionAssertions.assertHasElements(entrySet, expectedElements, this.fixedOrder());
                    Assertions.assertEquals(expectedEntries, map);
                }
            }

            @DisplayName(value="iteration")
            public static interface IterationTests<K, V>
            extends IteratorTests<K, V>,
            com.github.robtimus.junit.support.test.collections.IteratorTests$IterationTests<Map.Entry<K, V>> {
            }
        }
    }

    @DisplayName(value="values()")
    public static interface ValuesTests<K, V>
    extends UnmodifiableMapTests<K, V>,
    CollectionTests<V> {
        @Override
        default public Collection<V> iterable() {
            return this.map().values();
        }

        @Override
        default public Collection<V> expectedElements() {
            return this.expectedEntries().values();
        }

        @Override
        default public Collection<V> nonContainedElements() {
            return this.nonContainedEntries().values();
        }

        @DisplayName(value="clear()")
        public static interface ClearTests<K, V>
        extends ValuesTests<K, V>,
        UnmodifiableCollectionTests.ClearTests<V> {
        }

        @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
        @DisplayName(value="retainAll(Collection)")
        public static interface RetainAllTests<K, V>
        extends ValuesTests<K, V>,
        UnmodifiableCollectionTests.RetainAllTests<V> {
        }

        @DisplayName(value="removeIf(Predicate)")
        public static interface RemoveIfTests<K, V>
        extends ValuesTests<K, V>,
        UnmodifiableCollectionTests.RemoveIfTests<V> {
        }

        @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
        @DisplayName(value="removeAll(Collection)")
        public static interface RemoveAllTests<K, V>
        extends ValuesTests<K, V>,
        UnmodifiableCollectionTests.RemoveAllTests<V> {
        }

        @DisplayName(value="addAll(Collection)")
        public static interface AddAllTests<K, V>
        extends ValuesTests<K, V>,
        UnmodifiableCollectionTests.AddAllTests<V> {
        }

        @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
        @DisplayName(value="containsAll(Collection)")
        public static interface ContainsAllTests<K, V>
        extends ValuesTests<K, V>,
        CollectionTests.ContainsAllTests<V> {
        }

        @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
        @DisplayName(value="remove(Object)")
        public static interface RemoveTests<K, V>
        extends ValuesTests<K, V>,
        UnmodifiableCollectionTests.RemoveTests<V> {
        }

        @DisplayName(value="add(Object)")
        public static interface AddTests<K, V>
        extends ValuesTests<K, V>,
        UnmodifiableCollectionTests.AddTests<V> {
        }

        @DisplayName(value="toArray(IntFunction)")
        public static interface ToArrayWithGeneratorTests<K, V>
        extends ValuesTests<K, V>,
        CollectionTests.ToArrayWithGeneratorTests<V> {
        }

        @DisplayName(value="toArray(Object[])")
        public static interface ToArrayTests<K, V>
        extends ValuesTests<K, V>,
        CollectionTests.ToArrayTests<V> {
        }

        @DisplayName(value="toArray()")
        public static interface ToObjectArrayTests<K, V>
        extends ValuesTests<K, V>,
        CollectionTests.ToObjectArrayTests<V> {
        }

        @DisplayName(value="contains(Object)")
        public static interface ContainsTests<K, V>
        extends ValuesTests<K, V>,
        CollectionTests.ContainsTests<V> {
        }

        @DisplayName(value="forEach(Consumer)")
        public static interface ForEachTests<K, V>
        extends ValuesTests<K, V>,
        IterableTests.ForEachTests<V> {
        }

        @DisplayName(value="forEach(Consumer)")
        public static interface IteratorTests<K, V>
        extends ValuesTests<K, V>,
        UnmodifiableIteratorTests<V> {
            @Override
            default public Collection<V> iterable() {
                return ValuesTests.super.iterable();
            }

            @Override
            default public Collection<V> expectedElements() {
                return ValuesTests.super.expectedElements();
            }

            @DisplayName(value="forEachRemaining(Consumer)")
            public static interface ForEachRemainingTests<K, V>
            extends IteratorTests<K, V>,
            com.github.robtimus.junit.support.test.collections.IteratorTests$ForEachRemainingTests<V> {
            }

            @DisplayName(value="remove()")
            public static interface RemoveTests<K, V>
            extends IteratorTests<K, V>,
            UnmodifiableIteratorTests.RemoveTests<V> {
                @Override
                @Test
                @DisplayName(value="remove() throws UnsupportedOperationException")
                default public void testRemove() {
                    Map map = this.map();
                    Collection values = map.values();
                    Iterator iterator = values.iterator();
                    while (iterator.hasNext()) {
                        iterator.next();
                        Assertions.assertThrows(UnsupportedOperationException.class, iterator::remove);
                    }
                    Map expectedEntries = this.expectedEntries();
                    Collection expectedElements = expectedEntries.values();
                    CollectionAssertions.assertHasElements(values, expectedElements, this.fixedOrder());
                    Assertions.assertEquals(expectedEntries, map);
                }
            }

            @DisplayName(value="iteration")
            public static interface IterationTests<K, V>
            extends IteratorTests<K, V>,
            com.github.robtimus.junit.support.test.collections.IteratorTests$IterationTests<V> {
            }
        }
    }

    @DisplayName(value="keySet()")
    public static interface KeySetTests<K, V>
    extends UnmodifiableMapTests<K, V>,
    UnmodifiableSetTests<K> {
        @Override
        default public Set<K> iterable() {
            return this.map().keySet();
        }

        @Override
        default public Collection<K> expectedElements() {
            return this.expectedEntries().keySet();
        }

        @Override
        default public Collection<K> nonContainedElements() {
            return this.nonContainedEntries().keySet();
        }

        @DisplayName(value="spliterator()")
        public static interface SpliteratorTests<K, V>
        extends KeySetTests<K, V>,
        SetTests.SpliteratorTests<K> {
        }

        @DisplayName(value="hashCode()")
        public static interface HashCodeTests<K, V>
        extends KeySetTests<K, V>,
        SetTests.HashCodeTests<K> {
        }

        @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
        @DisplayName(value="equals(Object)")
        public static interface EqualsTests<K, V>
        extends KeySetTests<K, V>,
        SetTests.EqualsTests<K> {
        }

        @DisplayName(value="clear()")
        public static interface ClearTests<K, V>
        extends KeySetTests<K, V>,
        UnmodifiableCollectionTests.ClearTests<K> {
        }

        @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
        @DisplayName(value="retainAll(Collection)")
        public static interface RetainAllTests<K, V>
        extends KeySetTests<K, V>,
        UnmodifiableCollectionTests.RetainAllTests<K> {
        }

        @DisplayName(value="removeIf(Predicate)")
        public static interface RemoveIfTests<K, V>
        extends KeySetTests<K, V>,
        UnmodifiableCollectionTests.RemoveIfTests<K> {
        }

        @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
        @DisplayName(value="removeAll(Collection)")
        public static interface RemoveAllTests<K, V>
        extends KeySetTests<K, V>,
        UnmodifiableCollectionTests.RemoveAllTests<K> {
        }

        @DisplayName(value="addAll(Collection)")
        public static interface AddAllTests<K, V>
        extends KeySetTests<K, V>,
        UnmodifiableCollectionTests.AddAllTests<K> {
        }

        @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
        @DisplayName(value="containsAll(Collection)")
        public static interface ContainsAllTests<K, V>
        extends KeySetTests<K, V>,
        CollectionTests.ContainsAllTests<K> {
        }

        @TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
        @DisplayName(value="remove(Object)")
        public static interface RemoveTests<K, V>
        extends KeySetTests<K, V>,
        UnmodifiableCollectionTests.RemoveTests<K> {
        }

        @DisplayName(value="add(Object)")
        public static interface AddTests<K, V>
        extends KeySetTests<K, V>,
        UnmodifiableCollectionTests.AddTests<K> {
        }

        @DisplayName(value="toArray(IntFunction)")
        public static interface ToArrayWithGeneratorTests<K, V>
        extends KeySetTests<K, V>,
        CollectionTests.ToArrayWithGeneratorTests<K> {
        }

        @DisplayName(value="toArray(Object[])")
        public static interface ToArrayTests<K, V>
        extends KeySetTests<K, V>,
        CollectionTests.ToArrayTests<K> {
        }

        @DisplayName(value="toArray()")
        public static interface ToObjectArrayTests<K, V>
        extends KeySetTests<K, V>,
        CollectionTests.ToObjectArrayTests<K> {
        }

        @DisplayName(value="contains(Object)")
        public static interface ContainsTests<K, V>
        extends KeySetTests<K, V>,
        CollectionTests.ContainsTests<K> {
        }

        @DisplayName(value="forEach(Consumer)")
        public static interface ForEachTests<K, V>
        extends KeySetTests<K, V>,
        IterableTests.ForEachTests<K> {
        }

        @DisplayName(value="forEach(Consumer)")
        public static interface IteratorTests<K, V>
        extends KeySetTests<K, V>,
        UnmodifiableIteratorTests<K> {
            @Override
            default public Set<K> iterable() {
                return KeySetTests.super.iterable();
            }

            @Override
            default public Collection<K> expectedElements() {
                return KeySetTests.super.expectedElements();
            }

            @DisplayName(value="forEachRemaining(Consumer)")
            public static interface ForEachRemainingTests<K, V>
            extends IteratorTests<K, V>,
            com.github.robtimus.junit.support.test.collections.IteratorTests$ForEachRemainingTests<K> {
            }

            @DisplayName(value="remove()")
            public static interface RemoveTests<K, V>
            extends IteratorTests<K, V>,
            UnmodifiableIteratorTests.RemoveTests<K> {
                @Override
                @Test
                @DisplayName(value="remove() throws UnsupportedOperationException")
                default public void testRemove() {
                    Map map = this.map();
                    Set keySet = map.keySet();
                    Iterator iterator = keySet.iterator();
                    while (iterator.hasNext()) {
                        iterator.next();
                        Assertions.assertThrows(UnsupportedOperationException.class, iterator::remove);
                    }
                    Map expectedEntries = this.expectedEntries();
                    Set expectedElements = expectedEntries.keySet();
                    CollectionAssertions.assertHasElements(keySet, expectedElements, this.fixedOrder());
                    Assertions.assertEquals(expectedEntries, map);
                }
            }

            @DisplayName(value="iteration")
            public static interface IterationTests<K, V>
            extends IteratorTests<K, V>,
            com.github.robtimus.junit.support.test.collections.IteratorTests$IterationTests<K> {
            }
        }
    }

    @DisplayName(value="clear()")
    public static interface ClearTests<K, V>
    extends MapTests<K, V> {
        @Test
        @DisplayName(value="clear()")
        default public void testClear() {
            Map map = this.map();
            Assertions.assertThrows(UnsupportedOperationException.class, map::clear);
            Assertions.assertEquals(this.expectedEntries(), map);
        }
    }

    @DisplayName(value="putAll(Map)")
    public static interface PutAllTests<K, V>
    extends UnmodifiableMapTests<K, V> {
        public UnaryOperator<V> replaceValueOperator();

        @Test
        @DisplayName(value="putAll(Map) with contained entries")
        default public void testPutAllWithContainedEntries() {
            Map map = this.map();
            Map expectedEntries = this.expectedEntries();
            for (Map.Entry entry : expectedEntries.entrySet()) {
                Map m = Collections.singletonMap(entry.getKey(), entry.getValue());
                ThrowableAssertions.assertOptionallyThrows(UnsupportedOperationException.class, () -> map.putAll(m));
            }
            Assertions.assertEquals(expectedEntries, map);
        }

        @Test
        @DisplayName(value="putAll(Object, Object) with updated entries")
        default public void testPutAllWithUpdatedEntries() {
            Map map = this.map();
            Map expectedEntries = this.expectedEntries();
            UnaryOperator<V> operator = this.replaceValueOperator();
            for (Map.Entry entry : expectedEntries.entrySet()) {
                Object value = entry.getValue();
                Map m = Collections.singletonMap(entry.getKey(), operator.apply(value));
                Assertions.assertThrows(UnsupportedOperationException.class, () -> map.putAll(m));
            }
            Assertions.assertEquals(expectedEntries, map);
        }

        @Test
        @DisplayName(value="putAll(Map) with non-contained entries")
        default public void testPutAllWithNonContainedEntries() {
            Map map = this.map();
            for (Map.Entry entry : this.nonContainedEntries().entrySet()) {
                Map m = Collections.singletonMap(entry.getKey(), entry.getValue());
                Assertions.assertThrows(UnsupportedOperationException.class, () -> map.putAll(m));
            }
            Assertions.assertEquals(this.expectedEntries(), map);
        }

        @Test
        @DisplayName(value="putAll(Map) with an empty map")
        default public void testPutAllWithEmptyMap() {
            Map map = this.map();
            ThrowableAssertions.assertOptionallyThrows(UnsupportedOperationException.class, () -> map.putAll(Collections.emptyMap()));
            Assertions.assertEquals(this.expectedEntries(), map);
        }

        @Test
        @DisplayName(value="putAll(Collection) with null")
        default public void testPutAllWithNull() {
            Map map = this.map();
            ThrowableAssertions.assertThrowsOneOf(UnsupportedOperationException.class, NullPointerException.class, () -> map.putAll(null));
            Assertions.assertEquals(this.expectedEntries(), map);
        }

        @Test
        @DisplayName(value="putAll(Map) with a map with a null key")
        default public void testPutAllWithMapWithNullKey() {
            Map map = this.map();
            Object nonContainedValue = this.nonContainedEntries().values().iterator().next();
            Map m = Collections.singletonMap(null, nonContainedValue);
            Assertions.assertThrows(UnsupportedOperationException.class, () -> map.putAll(m));
            Assertions.assertEquals(this.expectedEntries(), map);
        }

        @Test
        @DisplayName(value="putAll(Object, Object) with a map with a null value")
        default public void testPutAllWithMapWithNullValue() {
            Map map = this.map();
            Object nonContainedKey = this.nonContainedEntries().keySet().iterator().next();
            Map m = Collections.singletonMap(nonContainedKey, null);
            Assertions.assertThrows(UnsupportedOperationException.class, () -> map.putAll(m));
            Assertions.assertEquals(this.expectedEntries(), map);
        }
    }

    @DisplayName(value="remove(Object)")
    public static interface RemoveTests<K, V>
    extends UnmodifiableMapTests<K, V> {
        @Test
        @DisplayName(value="remove(Object) with contained elements")
        default public void testRemoveContainedElements() {
            Map map = this.map();
            Map expectedEntries = this.expectedEntries();
            for (Object key : expectedEntries.keySet()) {
                Assertions.assertThrows(UnsupportedOperationException.class, () -> map.remove(key));
            }
            Assertions.assertEquals(expectedEntries, map);
        }

        @Test
        @DisplayName(value="remove(Object) with non-contained elements")
        default public void testRemoveNonContainedElements() {
            Map map = this.map();
            for (Object key : this.nonContainedEntries().keySet()) {
                ThrowableAssertions.assertOptionallyThrows(UnsupportedOperationException.class, () -> Assertions.assertNull(map.remove(key)));
            }
            Assertions.assertEquals(this.expectedEntries(), map);
        }

        @Test
        @DisplayName(value="remove(Object) with null")
        default public void testRemoveNull() {
            Map map = this.map();
            ThrowableAssertions.assertOptionallyThrows(UnsupportedOperationException.class, () -> Assertions.assertNull(map.remove(null)));
            Assertions.assertEquals(this.expectedEntries(), map);
        }

        @Test
        @DisplayName(value="remove(Object) with an incompatible object")
        default public void testRemoveIncompatibleObject() {
            Map map = this.map();
            ThrowableAssertions.assertOptionallyThrows(UnsupportedOperationException.class, () -> Assertions.assertNull(map.remove(new IncompatibleObject())));
            Assertions.assertEquals(this.expectedEntries(), map);
        }
    }

    @DisplayName(value="get(Object)")
    public static interface PutTests<K, V>
    extends MapTests<K, V> {
        public UnaryOperator<V> replaceValueOperator();

        @Test
        @DisplayName(value="put(Object, Object) with contained entries")
        default public void testPutWithContainedEntries() {
            Map map = this.map();
            Map expectedEntries = this.expectedEntries();
            for (Map.Entry entry : expectedEntries.entrySet()) {
                Object value = entry.getValue();
                ThrowableAssertions.assertOptionallyThrows(UnsupportedOperationException.class, () -> Assertions.assertEquals((Object)value, (Object)map.put(entry.getKey(), value)));
            }
            Assertions.assertEquals(expectedEntries, map);
        }

        @Test
        @DisplayName(value="put(Object, Object) with updated entries")
        default public void testPutWithUpdatedEntries() {
            Map map = this.map();
            Map expectedEntries = this.expectedEntries();
            UnaryOperator operator = this.replaceValueOperator();
            for (Map.Entry entry : expectedEntries.entrySet()) {
                Object value = entry.getValue();
                Assertions.assertThrows(UnsupportedOperationException.class, () -> map.put(entry.getKey(), operator.apply(value)));
            }
            Assertions.assertEquals(expectedEntries, map);
        }

        @Test
        @DisplayName(value="put(Object, Object) with null key")
        default public void testPutWithNullKey() {
            Map map = this.map();
            Object nonContainedValue = this.nonContainedEntries().values().iterator().next();
            Assertions.assertThrows(UnsupportedOperationException.class, () -> map.put(null, nonContainedValue));
            Assertions.assertEquals(this.expectedEntries(), map);
        }

        @Test
        @DisplayName(value="put(Object, Object) with null value")
        default public void testPutWithNullValue() {
            Map map = this.map();
            Map expectedEntries = this.expectedEntries();
            for (Map.Entry entry : expectedEntries.entrySet()) {
                Assertions.assertThrows(UnsupportedOperationException.class, () -> map.put(entry.getKey(), null));
            }
            Assertions.assertEquals(expectedEntries, map);
        }
    }
}

