/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support.test.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

final class IOUtils {
    private IOUtils() {
    }

    static int readAll(Reader reader, char[] buffer) throws IOException {
        int n;
        int index = 0;
        for (int remaining = buffer.length; remaining > 0; remaining -= n) {
            n = reader.read(buffer, index, remaining);
            if (n == -1) {
                return index == 0 ? -1 : index;
            }
            index += n;
        }
        return buffer.length;
    }

    static int readAll(InputStream inputStream, byte[] buffer) throws IOException {
        int n;
        int index = 0;
        for (int remaining = buffer.length; remaining > 0; remaining -= n) {
            n = inputStream.read(buffer, index, remaining);
            if (n == -1) {
                return index == 0 ? -1 : index;
            }
            index += n;
        }
        return buffer.length;
    }

    static long skipAll(InputStream inputStream, long n) throws IOException {
        long skipped;
        for (long remaining = n; remaining > 0L; remaining -= skipped) {
            skipped = inputStream.skip(remaining);
            if (skipped != 0L) continue;
            return n - remaining;
        }
        return n;
    }

    static long skipAll(Reader reader, long n) throws IOException {
        long skipped;
        for (long remaining = n; remaining > 0L; remaining -= skipped) {
            skipped = reader.skip(remaining);
            if (skipped != 0L) continue;
            return n - remaining;
        }
        return n;
    }
}

