/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support.test.io;

import com.github.robtimus.junit.support.IOAssertions;
import com.github.robtimus.junit.support.ThrowableAssertions;
import com.github.robtimus.junit.support.test.io.IOUtils;
import com.github.robtimus.junit.support.test.io.StreamAssertions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public interface InputStreamTests {
    public InputStream inputStream();

    public byte[] expectedContent();

    @DisplayName(value="transferTo(OutputStream)")
    public static interface TransferToTests
    extends InputStreamTests {
        @Test
        @DisplayName(value="transferTo(OutputStream) from the start")
        default public void testTransferToReadAllBytes() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (InputStream inputStream = this.inputStream();){
                    byte[] expected = this.expectedContent();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    Assertions.assertEquals((long)expected.length, (long)inputStream.transferTo(baos));
                    Assertions.assertArrayEquals((byte[])expected, (byte[])baos.toByteArray());
                }
            });
        }

        @Test
        @DisplayName(value="transferTo(OutputStream) after having read 10 bytes")
        default public void testTransferToAfterReading10Bytes() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (InputStream inputStream = this.inputStream();){
                    byte[] expected = this.expectedContent();
                    expected = expected.length < 10 ? new byte[]{} : Arrays.copyOfRange(expected, 10, expected.length);
                    Assertions.assertEquals((int)Math.min(10, expected.length), (int)inputStream.read(new byte[10]));
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    Assertions.assertEquals((long)expected.length, (long)inputStream.transferTo(baos));
                    Assertions.assertArrayEquals((byte[])expected, (byte[])baos.toByteArray());
                }
            });
        }

        @Test
        @DisplayName(value="transferTo(OutputStream) after everything has already been consumed")
        default public void testTransferToAfterConsumingStream() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (InputStream inputStream = this.inputStream();){
                    IOAssertions.assertContainsContent(inputStream, this.expectedContent());
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    Assertions.assertEquals((long)0L, (long)inputStream.transferTo(baos));
                    Assertions.assertArrayEquals((byte[])new byte[0], (byte[])baos.toByteArray());
                }
            });
        }
    }

    @DisplayName(value="mark(int) and reset()")
    public static interface MarkResetTests
    extends InputStreamTests {
        default public boolean hasDefaultMark() {
            return false;
        }

        @Test
        @DisplayName(value="markSupported()")
        default public void testMarkSupported() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (InputStream inputStream = this.inputStream();){
                    Assertions.assertTrue((boolean)inputStream.markSupported());
                }
            });
        }

        @Test
        @DisplayName(value="mark(int) and reset()")
        default public void testMarkAndReset() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (InputStream inputStream = this.inputStream();){
                    int len;
                    int readSize = 10;
                    byte[] fullExpectedContent = this.expectedContent();
                    ByteArrayOutputStream expectedContent = new ByteArrayOutputStream(fullExpectedContent.length * 3 / 2);
                    for (int i = 0; i < fullExpectedContent.length; i += 20) {
                        expectedContent.write(fullExpectedContent, i, Math.min(10, fullExpectedContent.length - i));
                        expectedContent.write(fullExpectedContent, i, Math.min(20, fullExpectedContent.length - i));
                    }
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(expectedContent.size());
                    byte[] markedBuffer = new byte[10];
                    byte[] buffer = new byte[20];
                    inputStream.mark(10);
                    while ((len = IOUtils.readAll(inputStream, markedBuffer)) != -1) {
                        baos.write(markedBuffer, 0, len);
                        inputStream.reset();
                        len = IOUtils.readAll(inputStream, buffer);
                        if (len == -1) continue;
                        baos.write(buffer, 0, len);
                        inputStream.mark(10);
                    }
                    Assertions.assertArrayEquals((byte[])expectedContent.toByteArray(), (byte[])baos.toByteArray());
                }
            });
        }

        @Test
        @DisplayName(value="reset() without mark(int)")
        default public void testResetWithoutMark() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (InputStream inputStream = this.inputStream();){
                    byte[] expectedContent = this.expectedContent();
                    if (this.hasDefaultMark()) {
                        int duplicateCount = Math.min(expectedContent.length, 10);
                        byte[] expectedContentWithDuplicateBytes = new byte[duplicateCount + expectedContent.length];
                        System.arraycopy(expectedContent, 0, expectedContentWithDuplicateBytes, 0, duplicateCount);
                        System.arraycopy(expectedContent, 0, expectedContentWithDuplicateBytes, duplicateCount, expectedContent.length);
                        expectedContent = expectedContentWithDuplicateBytes;
                    }
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(expectedContent.length);
                    byte[] buffer = new byte[10];
                    int len = IOUtils.readAll(inputStream, buffer);
                    if (len != -1) {
                        baos.write(buffer, 0, len);
                    }
                    if (this.hasDefaultMark()) {
                        Assertions.assertDoesNotThrow(inputStream::reset);
                    } else {
                        Assertions.assertThrows(IOException.class, inputStream::reset);
                    }
                    while ((len = IOUtils.readAll(inputStream, buffer)) != -1) {
                        baos.write(buffer, 0, len);
                    }
                    Assertions.assertArrayEquals((byte[])expectedContent, (byte[])baos.toByteArray());
                }
            });
        }
    }

    @DisplayName(value="available()")
    public static interface AvailableTests
    extends InputStreamTests {
        @Test
        @DisplayName(value="available()")
        default public void testAvailable() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (InputStream inputStream = this.inputStream();){
                    int len;
                    byte[] expectedContent = this.expectedContent();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(expectedContent.length);
                    MatcherAssert.assertThat((Object)inputStream.available(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
                    byte[] buffer = new byte[10];
                    while ((len = inputStream.read(buffer)) != -1) {
                        baos.write(buffer, 0, len);
                        if (baos.size() < expectedContent.length) {
                            MatcherAssert.assertThat((Object)inputStream.available(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
                            continue;
                        }
                        Assertions.assertEquals((int)0, (int)inputStream.available());
                    }
                    Assertions.assertEquals((int)0, (int)inputStream.available());
                }
            });
        }
    }

    @DisplayName(value="skip(long)")
    public static interface SkipTests
    extends InputStreamTests {
        public boolean allowNegativeSkip();

        @Test
        @DisplayName(value="skip(long)")
        default public void testSkip() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (InputStream inputStream = this.inputStream();){
                    int len;
                    int skipSize = 5;
                    int readSize = 5;
                    byte[] fullExpectedContent = this.expectedContent();
                    ByteArrayOutputStream expectedContent = new ByteArrayOutputStream(fullExpectedContent.length / 2);
                    for (int i = 5; i < fullExpectedContent.length; i += 10) {
                        expectedContent.write(fullExpectedContent, i, Math.min(5, fullExpectedContent.length - i));
                    }
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(expectedContent.size());
                    int remaining = fullExpectedContent.length;
                    Assertions.assertEquals((long)Math.min(5, remaining), (long)IOUtils.skipAll(inputStream, 5L));
                    remaining -= 5;
                    byte[] buffer = new byte[5];
                    while ((len = IOUtils.readAll(inputStream, buffer)) != -1) {
                        baos.write(buffer, 0, len);
                        if ((remaining -= 5) <= 0) continue;
                        Assertions.assertEquals((long)Math.min(5, remaining), (long)IOUtils.skipAll(inputStream, 5L));
                        remaining -= 5;
                    }
                    Assertions.assertArrayEquals((byte[])expectedContent.toByteArray(), (byte[])baos.toByteArray());
                }
            });
        }

        @Test
        @DisplayName(value="skip(long) with a zero index")
        default public void testSkipWithZeroIndex() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (InputStream inputStream = this.inputStream();){
                    int len;
                    byte[] expectedContent = this.expectedContent();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(expectedContent.length);
                    Assertions.assertEquals((long)0L, (long)inputStream.skip(0L));
                    byte[] buffer = new byte[10];
                    while ((len = inputStream.read(buffer)) != -1) {
                        baos.write(buffer, 0, len);
                        Assertions.assertEquals((long)0L, (long)inputStream.skip(0L));
                    }
                    Assertions.assertEquals((long)0L, (long)inputStream.skip(0L));
                    Assertions.assertArrayEquals((byte[])expectedContent, (byte[])baos.toByteArray());
                }
            });
        }

        @Test
        @DisplayName(value="skip(long) with a negative index")
        default public void testSkipWithNegativeIndex() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (InputStream inputStream = this.inputStream();){
                    int len;
                    byte[] expectedContent = this.expectedContent();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(expectedContent.length);
                    boolean allowNegativeSkip = this.allowNegativeSkip();
                    StreamAssertions.assertNegativeSkip(inputStream, allowNegativeSkip);
                    byte[] buffer = new byte[10];
                    while ((len = inputStream.read(buffer)) != -1) {
                        baos.write(buffer, 0, len);
                        StreamAssertions.assertNegativeSkip(inputStream, allowNegativeSkip);
                    }
                    StreamAssertions.assertNegativeSkip(inputStream, allowNegativeSkip);
                    Assertions.assertArrayEquals((byte[])expectedContent, (byte[])baos.toByteArray());
                }
            });
        }
    }

    @DisplayName(value="readNBytes(byte[], int, int)")
    public static interface ReadNBytesIntoByteArrayPortionTests
    extends InputStreamTests {
        @Test
        @DisplayName(value="readNBytes(byte[], int, int)")
        default public void testReadNBytesIntoByteArrayPortion() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (InputStream inputStream = this.inputStream();){
                    int len;
                    byte[] expected = this.expectedContent();
                    int bufferSize = 10;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(expected.length);
                    byte[] buffer = new byte[bufferSize + 10];
                    int off = 5;
                    int remaining = expected.length;
                    while ((len = inputStream.readNBytes(buffer, off, bufferSize)) != 0) {
                        Assertions.assertEquals((int)(remaining < bufferSize ? remaining : bufferSize), (int)len);
                        remaining -= len;
                        baos.write(buffer, off, len);
                    }
                    Assertions.assertEquals((int)-1, (int)inputStream.read());
                    Assertions.assertArrayEquals((byte[])expected, (byte[])baos.toByteArray());
                }
            });
        }

        @Test
        @DisplayName(value="readNBytes(byte[], int, int) with 0 length")
        default public void testReadNBytesIntoByteArrayPortionWithZeroLength() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (InputStream inputStream = this.inputStream();){
                    byte[] buffer = new byte[10];
                    Assertions.assertEquals((int)0, (int)inputStream.readNBytes(buffer, 5, 0));
                    IOAssertions.assertContainsContent(inputStream, this.expectedContent());
                }
            });
        }

        @Test
        @DisplayName(value="readNBytes(byte[], int, int) with a null array")
        default public void testReadNBytesIntoByteArrayPortionWithNullArray() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (InputStream inputStream = this.inputStream();){
                    byte[] buffer = null;
                    Assertions.assertThrows(NullPointerException.class, () -> inputStream.readNBytes(buffer, 0, 10));
                    IOAssertions.assertContainsContent(inputStream, this.expectedContent());
                }
            });
        }

        @Test
        @DisplayName(value="readNBytes(byte[], int, int) with a negative offset")
        default public void testReadNBytesIntoByteArrayPortionWithNegativeOffset() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (InputStream inputStream = this.inputStream();){
                    byte[] buffer = new byte[10];
                    ThrowableAssertions.assertThrowsOneOf(Arrays.asList(IndexOutOfBoundsException.class, IllegalArgumentException.class, IOException.class), () -> inputStream.readNBytes(buffer, -1, 10));
                    IOAssertions.assertContainsContent(inputStream, this.expectedContent());
                }
            });
        }

        @Test
        @DisplayName(value="readNBytes(byte[], int, int) with an offset that exceeds the array length")
        default public void testReadNBytesIntoByteArrayPortionWithTooHighOffset() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (InputStream inputStream = this.inputStream();){
                    byte[] buffer = new byte[10];
                    Assertions.assertThrows(IndexOutOfBoundsException.class, () -> inputStream.readNBytes(buffer, buffer.length + 1, 0));
                    IOAssertions.assertContainsContent(inputStream, this.expectedContent());
                }
            });
        }

        @Test
        @DisplayName(value="readNBytes(byte[], int, int) with a negative length")
        default public void testReadNBytesIntoByteArrayPortionWithNegativeLength() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (InputStream inputStream = this.inputStream();){
                    byte[] buffer = new byte[10];
                    ThrowableAssertions.assertThrowsOneOf(Arrays.asList(IndexOutOfBoundsException.class, IllegalArgumentException.class, IOException.class), () -> inputStream.readNBytes(buffer, 5, -1));
                    IOAssertions.assertContainsContent(inputStream, this.expectedContent());
                }
            });
        }

        @Test
        @DisplayName(value="read(byte[], int, int) with a length that exceeds the array length")
        default public void testReadNBytesIntoByteArrayPortionWithTooHighLength() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (InputStream inputStream = this.inputStream();){
                    byte[] buffer = new byte[10];
                    ThrowableAssertions.assertThrowsOneOf(Arrays.asList(IndexOutOfBoundsException.class, IllegalArgumentException.class, IOException.class), () -> inputStream.readNBytes(buffer, 1, buffer.length));
                    IOAssertions.assertContainsContent(inputStream, this.expectedContent());
                }
            });
        }
    }

    @DisplayName(value="readNBytes(int)")
    public static interface ReadNBytesTests
    extends InputStreamTests {
        @Test
        @DisplayName(value="readNBytes(int) with expected length")
        default public void testReadNBytesWithExpectedLength() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (InputStream inputStream = this.inputStream();){
                    byte[] expected = this.expectedContent();
                    byte[] content = inputStream.readNBytes(expected.length);
                    Assertions.assertArrayEquals((byte[])expected, (byte[])content);
                    Assertions.assertEquals((int)-1, (int)inputStream.read());
                }
            });
        }

        @Test
        @DisplayName(value="readNBytes(int) with smaller length")
        default public void testReadNBytesWithSmallerLength() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (InputStream inputStream = this.inputStream();){
                    byte[] expected = this.expectedContent();
                    byte[] content = inputStream.readNBytes(expected.length / 2);
                    Assertions.assertArrayEquals((byte[])Arrays.copyOfRange(expected, 0, expected.length / 2), (byte[])content);
                    IOAssertions.assertContainsContent(inputStream, Arrays.copyOfRange(expected, expected.length / 2, expected.length));
                }
            });
        }

        @Test
        @DisplayName(value="readNBytes(int) with 0 length")
        default public void testReadNBytesWithZeroLength() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (InputStream inputStream = this.inputStream();){
                    byte[] content = inputStream.readNBytes(0);
                    Assertions.assertArrayEquals((byte[])new byte[0], (byte[])content);
                    IOAssertions.assertContainsContent(inputStream, this.expectedContent());
                }
            });
        }

        @Test
        @DisplayName(value="readNBytes(byte[], int, int) with a negative length")
        default public void testReadNBytesWithNegativeLength() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (InputStream inputStream = this.inputStream();){
                    ThrowableAssertions.assertThrowsOneOf(Arrays.asList(IndexOutOfBoundsException.class, IllegalArgumentException.class, IOException.class), () -> inputStream.readNBytes(-1));
                    IOAssertions.assertContainsContent(inputStream, this.expectedContent());
                }
            });
        }

        @Test
        @DisplayName(value="readNBytes(int) with a length that exceeds the content length")
        default public void testReadNBytesWithLengthExceedingContentLength() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (InputStream inputStream = this.inputStream();){
                    byte[] expected = this.expectedContent();
                    byte[] content = inputStream.readNBytes(expected.length);
                    Assertions.assertArrayEquals((byte[])expected, (byte[])content);
                    Assertions.assertEquals((int)-1, (int)inputStream.read());
                }
            });
        }

        @Test
        @DisplayName(value="readNBytes(int) after everything has already been consumed")
        default public void testReadNBytesAfterConsumingStream() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (InputStream inputStream = this.inputStream();){
                    IOAssertions.assertContainsContent(inputStream, this.expectedContent());
                    byte[] content = inputStream.readNBytes(1);
                    Assertions.assertArrayEquals((byte[])new byte[0], (byte[])content);
                }
            });
        }
    }

    @DisplayName(value="readAllBytes()")
    public static interface ReadAllBytesTests
    extends InputStreamTests {
        @Test
        @DisplayName(value="readAllBytes() from the start")
        default public void testReadAllBytes() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (InputStream inputStream = this.inputStream();){
                    byte[] expected = this.expectedContent();
                    byte[] content = inputStream.readAllBytes();
                    Assertions.assertArrayEquals((byte[])expected, (byte[])content);
                }
            });
        }

        @Test
        @DisplayName(value="readAllBytes() after having read 10 bytes")
        default public void testReadAllBytesAfterReading10Bytes() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (InputStream inputStream = this.inputStream();){
                    byte[] expected = this.expectedContent();
                    expected = expected.length < 10 ? new byte[]{} : Arrays.copyOfRange(expected, 10, expected.length);
                    Assertions.assertEquals((int)Math.min(10, expected.length), (int)inputStream.read(new byte[10]));
                    byte[] content = inputStream.readAllBytes();
                    Assertions.assertArrayEquals((byte[])expected, (byte[])content);
                }
            });
        }

        @Test
        @DisplayName(value="readAllBytes() after everything has already been consumed")
        default public void testReadAllBytesAfterConsumingStream() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (InputStream inputStream = this.inputStream();){
                    IOAssertions.assertContainsContent(inputStream, this.expectedContent());
                    byte[] content = inputStream.readAllBytes();
                    Assertions.assertArrayEquals((byte[])new byte[0], (byte[])content);
                }
            });
        }
    }

    @DisplayName(value="read(byte[], int, int)")
    public static interface ReadIntoByteArrayPortionTests
    extends InputStreamTests {
        @Test
        @DisplayName(value="read(byte[], int, int)")
        default public void testReadIntoByteArrayPortion() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (InputStream inputStream = this.inputStream();){
                    int len;
                    byte[] expected = this.expectedContent();
                    int bufferSize = 10;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(expected.length);
                    byte[] buffer = new byte[bufferSize + 10];
                    int off = 5;
                    while ((len = inputStream.read(buffer, off, bufferSize)) != -1) {
                        Assertions.assertNotEquals((int)0, (int)len);
                        baos.write(buffer, off, len);
                    }
                    Assertions.assertArrayEquals((byte[])expected, (byte[])baos.toByteArray());
                }
            });
        }

        @Test
        @DisplayName(value="read(byte[], int, int) with 0 length")
        default public void testReadIntoByteArrayPortionWithZeroLength() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (InputStream inputStream = this.inputStream();){
                    byte[] buffer = new byte[10];
                    Assertions.assertEquals((int)0, (int)inputStream.read(buffer, 5, 0));
                    IOAssertions.assertContainsContent(inputStream, this.expectedContent());
                }
            });
        }

        @Test
        @DisplayName(value="read(byte[], int, int) with a null array")
        default public void testReadIntoByteArrayPortionWithNullArray() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (InputStream inputStream = this.inputStream();){
                    byte[] buffer = null;
                    Assertions.assertThrows(NullPointerException.class, () -> inputStream.read(buffer, 0, 10));
                    IOAssertions.assertContainsContent(inputStream, this.expectedContent());
                }
            });
        }

        @Test
        @DisplayName(value="read(byte[], int, int) with a negative offset")
        default public void testReadIntoByteArrayPortionWithNegativeOffset() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (InputStream inputStream = this.inputStream();){
                    byte[] buffer = new byte[10];
                    ThrowableAssertions.assertThrowsOneOf(Arrays.asList(IndexOutOfBoundsException.class, IllegalArgumentException.class, IOException.class), () -> inputStream.read(buffer, -1, 10));
                    IOAssertions.assertContainsContent(inputStream, this.expectedContent());
                }
            });
        }

        @Test
        @DisplayName(value="read(byte[], int, int) with an offset that exceeds the array length")
        default public void testReadIntoByteArrayPortionWithTooHighOffset() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (InputStream inputStream = this.inputStream();){
                    byte[] buffer = new byte[10];
                    ThrowableAssertions.assertThrowsOneOf(Arrays.asList(IndexOutOfBoundsException.class, IllegalArgumentException.class, IOException.class), () -> inputStream.read(buffer, buffer.length + 1, 0));
                    IOAssertions.assertContainsContent(inputStream, this.expectedContent());
                }
            });
        }

        @Test
        @DisplayName(value="read(byte[], int, int) with a negative length")
        default public void testReadIntoByteArrayPortionWithNegativeLength() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (InputStream inputStream = this.inputStream();){
                    byte[] buffer = new byte[10];
                    ThrowableAssertions.assertThrowsOneOf(Arrays.asList(IndexOutOfBoundsException.class, IllegalArgumentException.class, IOException.class), () -> inputStream.read(buffer, 5, -1));
                    IOAssertions.assertContainsContent(inputStream, this.expectedContent());
                }
            });
        }

        @Test
        @DisplayName(value="read(byte[], int, int) with a length that exceeds the array length")
        default public void testReadIntoByteArrayPortionWithTooHighLength() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (InputStream inputStream = this.inputStream();){
                    byte[] buffer = new byte[10];
                    ThrowableAssertions.assertThrowsOneOf(Arrays.asList(IndexOutOfBoundsException.class, IllegalArgumentException.class, IOException.class), () -> inputStream.read(buffer, 1, buffer.length));
                    IOAssertions.assertContainsContent(inputStream, this.expectedContent());
                }
            });
        }
    }

    @DisplayName(value="read(byte[])")
    public static interface ReadIntoByteArrayTests
    extends InputStreamTests {
        @Test
        @DisplayName(value="read(byte[])")
        default public void testReadIntoByteArray() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (InputStream inputStream = this.inputStream();){
                    int len;
                    byte[] expected = this.expectedContent();
                    int bufferSize = 10;
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(expected.length);
                    byte[] buffer = new byte[bufferSize];
                    while ((len = inputStream.read(buffer)) != -1) {
                        Assertions.assertNotEquals((int)0, (int)len);
                        baos.write(buffer, 0, len);
                    }
                    Assertions.assertArrayEquals((byte[])expected, (byte[])baos.toByteArray());
                }
            });
        }

        @Test
        @DisplayName(value="read(byte[]) with an empty array")
        default public void testReadIntoByteArrayWithEmptyArray() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (InputStream inputStream = this.inputStream();){
                    byte[] buffer = new byte[]{};
                    Assertions.assertEquals((int)0, (int)inputStream.read(buffer));
                    IOAssertions.assertContainsContent(inputStream, this.expectedContent());
                }
            });
        }

        @Test
        @DisplayName(value="read(byte[]) with a null array")
        default public void testReadIntoByteArrayWithNullArray() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (InputStream inputStream = this.inputStream();){
                    byte[] buffer = null;
                    Assertions.assertThrows(NullPointerException.class, () -> inputStream.read(buffer));
                    IOAssertions.assertContainsContent(inputStream, this.expectedContent());
                }
            });
        }
    }

    @DisplayName(value="read()")
    public static interface ReadByteTests
    extends InputStreamTests {
        @Test
        @DisplayName(value="read()")
        default public void testReadByte() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (InputStream inputStream = this.inputStream();){
                    int b;
                    byte[] expected = this.expectedContent();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(expected.length);
                    while ((b = inputStream.read()) != -1) {
                        baos.write(b);
                    }
                    Assertions.assertArrayEquals((byte[])expected, (byte[])baos.toByteArray());
                }
            });
        }
    }
}

