/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support.test.io;

import com.github.robtimus.junit.support.ThrowableAssertions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public interface OutputStreamDelegateTests {
    public OutputStream wrapOutputStream(OutputStream var1);

    public byte[] expectedContent(byte[] var1);

    default public byte[] contentToWrite() {
        return "Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa.".getBytes();
    }

    default public byte[] longContentToWrite() {
        byte[] content = this.contentToWrite();
        byte[] result = new byte[1000 * content.length];
        for (int i = 0; i < 1000; ++i) {
            System.arraycopy(content, 0, result, i * content.length, content.length);
        }
        return result;
    }

    @DisplayName(value="close()")
    public static interface CloseTests
    extends OutputStreamDelegateTests {
        @Test
        @DisplayName(value="close() delegates")
        default public void testCloseDelegates() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                OutputStream delegate = (OutputStream)Mockito.mock(OutputStream.class);
                OutputStream outputStream = this.wrapOutputStream(delegate);
                if (outputStream != null) {
                    outputStream.close();
                }
                ((OutputStream)Mockito.verify((Object)delegate)).close();
            });
        }
    }

    @DisplayName(value="flush()")
    public static interface FlushTests
    extends OutputStreamDelegateTests {
        @Test
        @DisplayName(value="flush() delegates")
        default public void testFlushDelegates() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                OutputStream delegate = (OutputStream)Mockito.mock(OutputStream.class);
                try (OutputStream outputStream = this.wrapOutputStream(delegate);){
                    outputStream.flush();
                    ((OutputStream)Mockito.verify((Object)delegate)).flush();
                }
            });
        }
    }

    @DisplayName(value="write(byte[], int, int)")
    public static interface WriteByteArrayPortionTests
    extends OutputStreamDelegateTests {
        @Test
        @DisplayName(value="write(byte[], int, int)")
        default public void testWriteByteArrayPortion() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                byte[] content = this.contentToWrite();
                byte[] expectedContent = this.expectedContent(content);
                int bufferSize = 10;
                ByteArrayOutputStream delegate = new ByteArrayOutputStream(expectedContent.length);
                try (OutputStream outputStream = this.wrapOutputStream(delegate);){
                    for (int i = 0; i < content.length; i += bufferSize) {
                        outputStream.write(content, i, Math.min(bufferSize, content.length - i));
                    }
                }
                Assertions.assertArrayEquals((byte[])expectedContent, (byte[])delegate.toByteArray());
            });
        }

        @Test
        @DisplayName(value="write(byte[], int, int) with a large array")
        default public void testWriteByteArrayPortionWithLargeArray() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                byte[] content = this.longContentToWrite();
                byte[] expectedContent = this.expectedContent(content);
                ByteArrayOutputStream delegate = new ByteArrayOutputStream(expectedContent.length);
                try (OutputStream outputStream = this.wrapOutputStream(delegate);){
                    outputStream.write(content, 0, content.length);
                }
                Assertions.assertArrayEquals((byte[])expectedContent, (byte[])delegate.toByteArray());
            });
        }

        @Test
        @DisplayName(value="write(byte[], int, int) with a null array")
        default public void testWriteByteArrayPortionWithNullArray() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                byte[] expectedContent = new byte[]{};
                ByteArrayOutputStream delegate = new ByteArrayOutputStream(expectedContent.length);
                try (OutputStream outputStream = this.wrapOutputStream(delegate);){
                    byte[] buffer = null;
                    Assertions.assertThrows(NullPointerException.class, () -> outputStream.write(buffer, 0, 10));
                }
                Assertions.assertArrayEquals((byte[])expectedContent, (byte[])delegate.toByteArray());
            });
        }

        @Test
        @DisplayName(value="write(byte[], int, int) with 0 length")
        default public void testWriteByteArrayPortionWithZeroLength() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                byte[] content = this.contentToWrite();
                byte[] expectedContent = this.expectedContent(new byte[0]);
                ByteArrayOutputStream delegate = new ByteArrayOutputStream(expectedContent.length);
                try (OutputStream outputStream = this.wrapOutputStream(delegate);){
                    outputStream.write(content, 5, 0);
                }
                Assertions.assertArrayEquals((byte[])expectedContent, (byte[])delegate.toByteArray());
            });
        }

        @Test
        @DisplayName(value="write(byte[], int, int) with a negative offset")
        default public void testWriteByteArrayPortionWithNegativeOffset() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                byte[] expectedContent = new byte[]{};
                ByteArrayOutputStream delegate = new ByteArrayOutputStream(expectedContent.length);
                try (OutputStream outputStream = this.wrapOutputStream(delegate);){
                    byte[] buffer = new byte[10];
                    ThrowableAssertions.assertThrowsOneOf(Arrays.asList(IndexOutOfBoundsException.class, IllegalArgumentException.class, IOException.class), () -> outputStream.write(buffer, -1, 10));
                }
                Assertions.assertArrayEquals((byte[])expectedContent, (byte[])delegate.toByteArray());
            });
        }

        @Test
        @DisplayName(value="write(byte[], int, int) with an offset that exceeds the array length")
        default public void testWriteByteArrayPortionWithTooHighOffset() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                byte[] expectedContent = new byte[]{};
                ByteArrayOutputStream delegate = new ByteArrayOutputStream(expectedContent.length);
                try (OutputStream outputStream = this.wrapOutputStream(delegate);){
                    byte[] buffer = new byte[10];
                    ThrowableAssertions.assertThrowsOneOf(Arrays.asList(IndexOutOfBoundsException.class, IllegalArgumentException.class, IOException.class), () -> outputStream.write(buffer, buffer.length + 1, 0));
                }
                Assertions.assertArrayEquals((byte[])expectedContent, (byte[])delegate.toByteArray());
            });
        }

        @Test
        @DisplayName(value="write(byte[], int, int) with a negative length")
        default public void testWriteByteArrayPortionWithNegativeLength() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                byte[] expectedContent = new byte[]{};
                ByteArrayOutputStream delegate = new ByteArrayOutputStream(expectedContent.length);
                try (OutputStream outputStream = this.wrapOutputStream(delegate);){
                    byte[] buffer = new byte[10];
                    ThrowableAssertions.assertThrowsOneOf(Arrays.asList(IndexOutOfBoundsException.class, IllegalArgumentException.class, IOException.class), () -> outputStream.write(buffer, 5, -1));
                }
                Assertions.assertArrayEquals((byte[])expectedContent, (byte[])delegate.toByteArray());
            });
        }

        @Test
        @DisplayName(value="write(byte[], int, int) with a length that exceeds the array length")
        default public void testWriteByteArrayPortionWithTooHighLength() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                byte[] expectedContent = new byte[]{};
                ByteArrayOutputStream delegate = new ByteArrayOutputStream(expectedContent.length);
                try (OutputStream outputStream = this.wrapOutputStream(delegate);){
                    byte[] buffer = new byte[10];
                    ThrowableAssertions.assertThrowsOneOf(Arrays.asList(IndexOutOfBoundsException.class, IllegalArgumentException.class, IOException.class), () -> outputStream.write(buffer, 1, buffer.length));
                }
                Assertions.assertArrayEquals((byte[])expectedContent, (byte[])delegate.toByteArray());
            });
        }
    }

    @DisplayName(value="write(byte[])")
    public static interface WriteByteArrayTests
    extends OutputStreamDelegateTests {
        @Test
        @DisplayName(value="write(byte[])")
        default public void testWriteByteArray() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                byte[] content = this.contentToWrite();
                byte[] expectedContent = this.expectedContent(content);
                int bufferSize = 10;
                ByteArrayOutputStream delegate = new ByteArrayOutputStream(expectedContent.length);
                try (OutputStream outputStream = this.wrapOutputStream(delegate);){
                    for (int i = 0; i < content.length; i += bufferSize) {
                        outputStream.write(Arrays.copyOfRange(content, i, Math.min(i + bufferSize, content.length)));
                    }
                }
                Assertions.assertArrayEquals((byte[])expectedContent, (byte[])delegate.toByteArray());
            });
        }

        @Test
        @DisplayName(value="write(byte[]) with a large array")
        default public void testWriteByteArrayWithLargeArray() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                byte[] content = this.longContentToWrite();
                byte[] expectedContent = this.expectedContent(content);
                ByteArrayOutputStream delegate = new ByteArrayOutputStream(expectedContent.length);
                try (OutputStream outputStream = this.wrapOutputStream(delegate);){
                    outputStream.write(content);
                }
                Assertions.assertArrayEquals((byte[])expectedContent, (byte[])delegate.toByteArray());
            });
        }

        @Test
        @DisplayName(value="write(byte[]) with an empty array")
        default public void testWriteByteArrayWithEmptyArray() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                byte[] content = new byte[]{};
                byte[] expectedContent = this.expectedContent(content);
                ByteArrayOutputStream delegate = new ByteArrayOutputStream(expectedContent.length);
                try (OutputStream outputStream = this.wrapOutputStream(delegate);){
                    outputStream.write(content);
                }
                Assertions.assertArrayEquals((byte[])expectedContent, (byte[])delegate.toByteArray());
            });
        }

        @Test
        @DisplayName(value="write(byte[]) with a null array")
        default public void testWriteByteArrayWithNullArray() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                byte[] expectedContent = new byte[]{};
                ByteArrayOutputStream delegate = new ByteArrayOutputStream(expectedContent.length);
                try (OutputStream outputStream = this.wrapOutputStream(delegate);){
                    byte[] buffer = null;
                    Assertions.assertThrows(NullPointerException.class, () -> outputStream.write(buffer));
                }
                Assertions.assertArrayEquals((byte[])expectedContent, (byte[])delegate.toByteArray());
            });
        }
    }

    @DisplayName(value="write(int)")
    public static interface WriteByteTests
    extends OutputStreamDelegateTests {
        @Test
        @DisplayName(value="write(int)")
        default public void testWriteByte() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                byte[] content = this.contentToWrite();
                byte[] expectedContent = this.expectedContent(content);
                ByteArrayOutputStream delegate = new ByteArrayOutputStream(expectedContent.length);
                try (OutputStream outputStream = this.wrapOutputStream(delegate);){
                    for (byte b : content) {
                        outputStream.write(b);
                    }
                }
                Assertions.assertArrayEquals((byte[])expectedContent, (byte[])delegate.toByteArray());
            });
        }
    }
}

