/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support.test.io;

import com.github.robtimus.junit.support.IOAssertions;
import com.github.robtimus.junit.support.ThrowableAssertions;
import com.github.robtimus.junit.support.test.io.IOUtils;
import com.github.robtimus.junit.support.test.io.StreamAssertions;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.nio.CharBuffer;
import java.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;

public interface ReaderTests {
    public Reader reader();

    public String expectedContent();

    @DisplayName(value="transferTo(Writer)")
    public static interface TransferToTests
    extends ReaderTests {
        @Test
        @DisplayName(value="transferTo(Writer) from the start")
        default public void testTransferToReadAllBytes() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (Reader reader = this.reader();){
                    String expected = this.expectedContent();
                    StringWriter sw = new StringWriter();
                    Assertions.assertEquals((long)expected.length(), (long)reader.transferTo(sw));
                    Assertions.assertEquals((Object)expected, (Object)sw.toString());
                }
            });
        }

        @Test
        @DisplayName(value="transferTo(Writer) after having read 10 chars")
        default public void testTransferToAfterReading10Bytes() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (Reader reader = this.reader();){
                    String expected = this.expectedContent();
                    expected = expected.length() < 10 ? "" : expected.substring(10);
                    Assertions.assertEquals((int)Math.min(10, expected.length()), (int)reader.read(new char[10]));
                    StringWriter sw = new StringWriter();
                    Assertions.assertEquals((long)expected.length(), (long)reader.transferTo(sw));
                    Assertions.assertEquals((Object)expected, (Object)sw.toString());
                }
            });
        }

        @Test
        @DisplayName(value="transferTo(OutputStream) after everything has already been consumed")
        default public void testTransferToAfterConsumingStream() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (Reader reader = this.reader();){
                    IOAssertions.assertContainsContent(reader, this.expectedContent());
                    StringWriter sw = new StringWriter();
                    Assertions.assertEquals((long)0L, (long)reader.transferTo(sw));
                    Assertions.assertEquals((Object)"", (Object)sw.toString());
                }
            });
        }
    }

    @DisplayName(value="mark(int) and reset()")
    public static interface MarkResetTests
    extends ReaderTests {
        default public boolean hasDefaultMark() {
            return false;
        }

        @Test
        @DisplayName(value="markSupported()")
        default public void testMarkSupported() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (Reader reader = this.reader();){
                    Assertions.assertTrue((boolean)reader.markSupported());
                }
            });
        }

        @Test
        @DisplayName(value="mark(int) and reset()")
        default public void testMarkAndReset() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (Reader reader = this.reader();){
                    int len;
                    int readSize = 10;
                    String fullExpectedContent = this.expectedContent();
                    StringBuilder expectedContent = new StringBuilder(fullExpectedContent.length() * 3 / 2);
                    for (int i = 0; i < fullExpectedContent.length(); i += 20) {
                        expectedContent.append(fullExpectedContent, i, Math.min(i + 10, fullExpectedContent.length()));
                        expectedContent.append(fullExpectedContent, i, Math.min(i + 20, fullExpectedContent.length()));
                    }
                    StringBuilder sb = new StringBuilder(expectedContent.length());
                    char[] markedBuffer = new char[10];
                    char[] buffer = new char[20];
                    reader.mark(10);
                    while ((len = IOUtils.readAll(reader, markedBuffer)) != -1) {
                        sb.append(markedBuffer, 0, len);
                        reader.reset();
                        len = IOUtils.readAll(reader, buffer);
                        if (len == -1) continue;
                        sb.append(buffer, 0, len);
                        reader.mark(10);
                    }
                    Assertions.assertEquals((Object)expectedContent.toString(), (Object)sb.toString());
                }
            });
        }

        @Test
        @DisplayName(value="reset() without mark(int)")
        default public void testResetWithoutMark() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (Reader reader = this.reader();){
                    Object expectedContent = this.expectedContent();
                    if (this.hasDefaultMark()) {
                        int duplicateCount = Math.min(((String)expectedContent).length(), 10);
                        expectedContent = ((String)expectedContent).substring(0, duplicateCount) + (String)expectedContent;
                    }
                    StringBuilder sb = new StringBuilder(((String)expectedContent).length());
                    char[] buffer = new char[10];
                    int len = IOUtils.readAll(reader, buffer);
                    if (len != -1) {
                        sb.append(buffer, 0, len);
                    }
                    if (this.hasDefaultMark()) {
                        Assertions.assertDoesNotThrow(reader::reset);
                    } else {
                        Assertions.assertThrows(IOException.class, reader::reset);
                    }
                    while ((len = IOUtils.readAll(reader, buffer)) != -1) {
                        sb.append(buffer, 0, len);
                    }
                    Assertions.assertEquals((Object)expectedContent, (Object)sb.toString());
                }
            });
        }
    }

    @DisplayName(value="ready()")
    public static interface ReadyTests
    extends ReaderTests {
        @Test
        @DisplayName(value="ready()")
        default public void testReady() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (Reader reader = this.reader();){
                    int len;
                    String expectedContent = this.expectedContent();
                    StringBuilder sb = new StringBuilder(expectedContent.length());
                    Assertions.assertTrue((boolean)reader.ready());
                    char[] buffer = new char[10];
                    while ((len = reader.read(buffer)) != -1) {
                        sb.append(buffer, 0, len);
                        Assertions.assertEquals((Object)(sb.length() < expectedContent.length() ? 1 : 0), (Object)reader.ready());
                    }
                    Assertions.assertFalse((boolean)reader.ready());
                }
            });
        }
    }

    @DisplayName(value="skip(long)")
    public static interface SkipTests
    extends ReaderTests {
        public boolean allowNegativeSkip();

        @Test
        @DisplayName(value="skip(long)")
        default public void testSkip() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (Reader reader = this.reader();){
                    int len;
                    int skipSize = 5;
                    int readSize = 5;
                    String fullExpectedContent = this.expectedContent();
                    StringBuilder expectedContent = new StringBuilder(fullExpectedContent.length() / 2);
                    for (int i = 5; i < fullExpectedContent.length(); i += 10) {
                        expectedContent.append(fullExpectedContent, i, Math.min(i + 5, fullExpectedContent.length()));
                    }
                    StringBuilder sb = new StringBuilder(expectedContent.length());
                    int remaining = fullExpectedContent.length();
                    Assertions.assertEquals((long)Math.min(5, remaining), (long)IOUtils.skipAll(reader, 5L));
                    remaining -= 5;
                    char[] buffer = new char[5];
                    while ((len = IOUtils.readAll(reader, buffer)) != -1) {
                        sb.append(buffer, 0, len);
                        if ((remaining -= 5) <= 0) continue;
                        Assertions.assertEquals((long)Math.min(5, remaining), (long)IOUtils.skipAll(reader, 5L));
                        remaining -= 5;
                    }
                    Assertions.assertEquals((Object)expectedContent.toString(), (Object)sb.toString());
                }
            });
        }

        @Test
        @DisplayName(value="skip(long) with a zero index")
        default public void testSkipWithZeroIndex() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (Reader reader = this.reader();){
                    int len;
                    String expectedContent = this.expectedContent();
                    StringBuilder sb = new StringBuilder(expectedContent.length());
                    Assertions.assertEquals((long)0L, (long)reader.skip(0L));
                    char[] buffer = new char[10];
                    while ((len = reader.read(buffer)) != -1) {
                        sb.append(buffer, 0, len);
                        Assertions.assertEquals((long)0L, (long)reader.skip(0L));
                    }
                    Assertions.assertEquals((long)0L, (long)reader.skip(0L));
                    Assertions.assertEquals((Object)expectedContent, (Object)sb.toString());
                }
            });
        }

        @Test
        @DisplayName(value="skip(long) with a negative index")
        default public void testSkipWithNegativeIndex() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (Reader reader = this.reader();){
                    int len;
                    String expectedContent = this.expectedContent();
                    StringBuilder sb = new StringBuilder(expectedContent.length());
                    boolean allowNegativeSkip = this.allowNegativeSkip();
                    StreamAssertions.assertNegativeSkip(reader, allowNegativeSkip);
                    char[] buffer = new char[10];
                    while ((len = reader.read(buffer)) != -1) {
                        sb.append(buffer, 0, len);
                        StreamAssertions.assertNegativeSkip(reader, allowNegativeSkip);
                    }
                    StreamAssertions.assertNegativeSkip(reader, allowNegativeSkip);
                    Assertions.assertEquals((Object)expectedContent, (Object)sb.toString());
                }
            });
        }
    }

    @DisplayName(value="read(char[], int, int)")
    public static interface ReadIntoCharArrayPortionTests
    extends ReaderTests {
        @Test
        @DisplayName(value="read(char[], int, int)")
        default public void testReadIntoCharArrayPortion() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (Reader reader = this.reader();){
                    int len;
                    String expected = this.expectedContent();
                    int bufferSize = 10;
                    StringBuilder sb = new StringBuilder(expected.length());
                    char[] buffer = new char[bufferSize + 10];
                    int off = 5;
                    while ((len = reader.read(buffer, off, bufferSize)) != -1) {
                        Assertions.assertNotEquals((int)0, (int)len);
                        sb.append(buffer, off, len);
                    }
                    Assertions.assertEquals((Object)expected, (Object)sb.toString());
                }
            });
        }

        @Test
        @DisplayName(value="read(char[], int, int) with 0 length")
        default public void testReadIntoCharArrayPortionWithZeroLength() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (Reader reader = this.reader();){
                    char[] buffer = new char[10];
                    Assertions.assertEquals((int)0, (int)reader.read(buffer, 5, 0));
                    IOAssertions.assertContainsContent(reader, this.expectedContent());
                }
            });
        }

        @Test
        @DisplayName(value="read(char[], int, int) with a null array")
        default public void testReadIntoCharArrayPortionWithNullArray() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (Reader reader = this.reader();){
                    char[] buffer = null;
                    Assertions.assertThrows(NullPointerException.class, () -> reader.read(buffer, 0, 10));
                    IOAssertions.assertContainsContent(reader, this.expectedContent());
                }
            });
        }

        @Test
        @DisplayName(value="read(char[], int, int) with a negative offset")
        default public void testReadIntoCharArrayPortionWithNegativeOffset() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (Reader reader = this.reader();){
                    char[] buffer = new char[10];
                    ThrowableAssertions.assertThrowsOneOf(Arrays.asList(IndexOutOfBoundsException.class, IllegalArgumentException.class, IOException.class), () -> reader.read(buffer, -1, 10));
                    IOAssertions.assertContainsContent(reader, this.expectedContent());
                }
            });
        }

        @Test
        @DisplayName(value="read(char[], int, int) with an offset that exceeds the array length")
        default public void testReadIntoCharArrayPortionWithTooHighOffset() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (Reader reader = this.reader();){
                    char[] buffer = new char[10];
                    ThrowableAssertions.assertThrowsOneOf(Arrays.asList(IndexOutOfBoundsException.class, IllegalArgumentException.class, IOException.class), () -> reader.read(buffer, buffer.length + 1, 0));
                    IOAssertions.assertContainsContent(reader, this.expectedContent());
                }
            });
        }

        @Test
        @DisplayName(value="read(char[], int, int) with a negative length")
        default public void testReadIntoCharArrayPortionWithNegativeLength() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (Reader reader = this.reader();){
                    char[] buffer = new char[10];
                    ThrowableAssertions.assertThrowsOneOf(Arrays.asList(IndexOutOfBoundsException.class, IllegalArgumentException.class, IOException.class), () -> reader.read(buffer, 5, -1));
                    IOAssertions.assertContainsContent(reader, this.expectedContent());
                }
            });
        }

        @Test
        @DisplayName(value="read(char[], int, int) with a length that exceeds the array length")
        default public void testReadIntoCharArrayPortionWithTooHighLength() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (Reader reader = this.reader();){
                    char[] buffer = new char[10];
                    ThrowableAssertions.assertThrowsOneOf(Arrays.asList(IndexOutOfBoundsException.class, IllegalArgumentException.class, IOException.class), () -> reader.read(buffer, 1, buffer.length));
                    IOAssertions.assertContainsContent(reader, this.expectedContent());
                }
            });
        }
    }

    @DisplayName(value="read(char[])")
    public static interface ReadIntoCharArrayTests
    extends ReaderTests {
        @Test
        @DisplayName(value="read(char[])")
        default public void testReadIntoCharArray() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (Reader reader = this.reader();){
                    int len;
                    String expected = this.expectedContent();
                    int bufferSize = 10;
                    StringBuilder sb = new StringBuilder(expected.length());
                    char[] buffer = new char[bufferSize];
                    while ((len = reader.read(buffer)) != -1) {
                        Assertions.assertNotEquals((int)0, (int)len);
                        sb.append(buffer, 0, len);
                    }
                    Assertions.assertEquals((Object)expected, (Object)sb.toString());
                }
            });
        }

        @Test
        @DisplayName(value="read(char[]) with an empty array")
        default public void testReadIntoCharArrayWithEmptyArray() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (Reader reader = this.reader();){
                    char[] buffer = new char[]{};
                    Assertions.assertEquals((int)0, (int)reader.read(buffer));
                    IOAssertions.assertContainsContent(reader, this.expectedContent());
                }
            });
        }

        @Test
        @DisplayName(value="read(char[]) with a null array")
        default public void testReadIntoCharArrayWithNullArray() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (Reader reader = this.reader();){
                    char[] buffer = null;
                    Assertions.assertThrows(NullPointerException.class, () -> reader.read(buffer));
                    IOAssertions.assertContainsContent(reader, this.expectedContent());
                }
            });
        }
    }

    @DisplayName(value="read()")
    public static interface ReadCharTests
    extends ReaderTests {
        @Test
        @DisplayName(value="read()")
        default public void testReadChar() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (Reader reader = this.reader();){
                    int c;
                    String expected = this.expectedContent();
                    StringBuilder sb = new StringBuilder(expected.length());
                    while ((c = reader.read()) != -1) {
                        sb.append((char)c);
                    }
                    Assertions.assertEquals((Object)expected, (Object)sb.toString());
                }
            });
        }
    }

    @DisplayName(value="read(CharBuffer)")
    public static interface ReadIntoCharBufferTests
    extends ReaderTests {
        @Test
        @DisplayName(value="read(CharBuffer)")
        default public void testReadIntoCharBuffer() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (Reader reader = this.reader();){
                    int len;
                    String expected = this.expectedContent();
                    int bufferSize = 10;
                    StringBuilder sb = new StringBuilder(expected.length());
                    CharBuffer buffer = CharBuffer.allocate(bufferSize);
                    while ((len = reader.read(buffer)) != -1) {
                        buffer.rewind();
                        sb.append(buffer, 0, len);
                        buffer.clear();
                    }
                    Assertions.assertEquals((Object)expected, (Object)sb.toString());
                }
            });
        }

        @Test
        @DisplayName(value="read(CharBuffer) with an empty CharBuffer")
        default public void testReadIntoCharBufferWithEmptyCharBuffer() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (Reader reader = this.reader();){
                    CharBuffer buffer = CharBuffer.allocate(0);
                    Assertions.assertEquals((int)0, (int)reader.read(buffer));
                    IOAssertions.assertContainsContent(reader, this.expectedContent());
                }
            });
        }

        @Test
        @DisplayName(value="read(CharBuffer) with a null CharBuffer")
        default public void testReadIntoCharBufferWithNullCharBuffer() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                try (Reader reader = this.reader();){
                    CharBuffer buffer = null;
                    Assertions.assertThrows(NullPointerException.class, () -> reader.read(buffer));
                    IOAssertions.assertContainsContent(reader, this.expectedContent());
                }
            });
        }
    }
}

