/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support.test.io;

import com.github.robtimus.junit.support.ThrowableAssertions;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.junit.jupiter.api.Assertions;

final class StreamAssertions {
    private StreamAssertions() {
    }

    static void assertNegativeSkip(Reader reader, boolean allowNegativeSkip) throws IOException {
        if (allowNegativeSkip) {
            Assertions.assertEquals((long)0L, (long)reader.skip(-1L));
        } else {
            ThrowableAssertions.assertThrowsOneOf(IllegalArgumentException.class, IOException.class, () -> reader.skip(-1L));
        }
    }

    static void assertNegativeSkip(InputStream inputStream, boolean allowNegativeSkip) throws IOException {
        if (allowNegativeSkip) {
            Assertions.assertEquals((long)0L, (long)inputStream.skip(-1L));
        } else {
            ThrowableAssertions.assertThrowsOneOf(IllegalArgumentException.class, IOException.class, () -> inputStream.skip(-1L));
        }
    }
}

