/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support.test.io;

import com.github.robtimus.junit.support.ThrowableAssertions;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;
import org.mockito.Mockito;

public interface WriterDelegateTests {
    public Writer wrapWriter(Writer var1);

    public String expectedContent(String var1);

    default public String contentToWrite() {
        return "Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa.";
    }

    default public String longContentToWrite() {
        String content = this.contentToWrite();
        StringBuilder sb = new StringBuilder(1000 * content.length());
        for (int i = 0; i < 1000; ++i) {
            sb.append(content);
        }
        return sb.toString();
    }

    public static class CharSequenceTransformationProvider
    implements ArgumentsProvider {
        public Stream<? extends Arguments> provideArguments(ExtensionContext context) throws Exception {
            return Stream.of(this.createArguments(String.class, Function.identity()), this.createArguments(StringBuilder.class, StringBuilder::new), this.createArguments(StringBuffer.class, StringBuffer::new), this.createArguments(CharSequence.class, CharBuffer::wrap));
        }

        private <T> Arguments createArguments(Class<T> type, Function<String, T> transformation) {
            return Arguments.arguments((Object[])new Object[]{type.getSimpleName(), transformation});
        }
    }

    @DisplayName(value="close()")
    public static interface CloseTests
    extends WriterDelegateTests {
        @Test
        @DisplayName(value="close() delegates")
        default public void testCloseDelegates() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                Writer delegate = (Writer)Mockito.mock(Writer.class);
                Writer writer = this.wrapWriter(delegate);
                if (writer != null) {
                    writer.close();
                }
                ((Writer)Mockito.verify((Object)delegate)).close();
            });
        }
    }

    @DisplayName(value="flush()")
    public static interface FlushTests
    extends WriterDelegateTests {
        @Test
        @DisplayName(value="flush() delegates")
        default public void testFlushDelegates() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                Writer delegate = (Writer)Mockito.mock(Writer.class);
                try (Writer writer = this.wrapWriter(delegate);){
                    writer.flush();
                    ((Writer)Mockito.verify((Object)delegate)).flush();
                }
            });
        }
    }

    @DisplayName(value="append(Char)")
    public static interface AppendCharTests
    extends WriterDelegateTests {
        @Test
        @DisplayName(value="append(char)")
        default public void testAppendChar() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                String content = this.contentToWrite();
                String expectedContent = this.expectedContent(content);
                StringWriter delegate = new StringWriter(expectedContent.length());
                try (Writer writer = this.wrapWriter(delegate);){
                    for (int i = 0; i < content.length(); ++i) {
                        Assertions.assertSame((Object)writer, (Object)writer.append(content.charAt(i)));
                    }
                }
                Assertions.assertEquals((Object)expectedContent, (Object)delegate.toString());
            });
        }
    }

    @DisplayName(value="append(CharSequence, int, int)")
    public static interface AppendCharSequencePortionTests
    extends WriterDelegateTests {
        @ParameterizedTest(name="type: {0}")
        @ArgumentsSource(value=CharSequenceTransformationProvider.class)
        @DisplayName(value="append(CharSequence, int, int)")
        default public void testAppendCharSequencePortion(String type, Function<String, CharSequence> contentTransformation) {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                String content = this.contentToWrite();
                String expectedContent = this.expectedContent(content);
                int bufferSize = 10;
                StringWriter delegate = new StringWriter(expectedContent.length());
                try (Writer writer = this.wrapWriter(delegate);){
                    for (int i = 0; i < content.length(); i += bufferSize) {
                        Assertions.assertSame((Object)writer, (Object)writer.append((CharSequence)contentTransformation.apply(content), i, Math.min(i + bufferSize, content.length())));
                    }
                }
                Assertions.assertEquals((Object)expectedContent, (Object)delegate.toString());
            });
        }

        @ParameterizedTest(name="type: {0}")
        @ArgumentsSource(value=CharSequenceTransformationProvider.class)
        @DisplayName(value="append(CharSequence, int, int) with a large CharSequence")
        default public void testAppendCharSequencePortionWithLargeCharSequence(String type, Function<String, CharSequence> contentTransformation) {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                String content = this.longContentToWrite();
                String expectedContent = this.expectedContent(content);
                StringWriter delegate = new StringWriter(expectedContent.length());
                try (Writer writer = this.wrapWriter(delegate);){
                    Assertions.assertSame((Object)writer, (Object)writer.append((CharSequence)contentTransformation.apply(content), 0, content.length()));
                }
                Assertions.assertEquals((Object)expectedContent, (Object)delegate.toString());
            });
        }

        @Test
        @DisplayName(value="append(CharSequence, int, int) with a null CharSequence")
        default public void testAppendCharSequencePortionWithNullCharSequence() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                String expectedContent = this.expectedContent("ul");
                StringWriter delegate = new StringWriter(expectedContent.length());
                try (Writer writer = this.wrapWriter(delegate);){
                    Assertions.assertSame((Object)writer, (Object)writer.append(null, 1, 3));
                }
                Assertions.assertEquals((Object)expectedContent, (Object)delegate.toString());
            });
        }

        @ParameterizedTest(name="type: {0}")
        @ArgumentsSource(value=CharSequenceTransformationProvider.class)
        @DisplayName(value="append(CharSequence, int, int) with start equal to end")
        default public void testAppendCharSequencePortionWithStartEqualToEnd(String type, Function<String, CharSequence> contentTransformation) {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                String content = this.contentToWrite();
                String expectedContent = this.expectedContent("");
                StringWriter delegate = new StringWriter(expectedContent.length());
                try (Writer writer = this.wrapWriter(delegate);){
                    Assertions.assertSame((Object)writer, (Object)writer.append((CharSequence)contentTransformation.apply(content), 5, 5));
                }
                Assertions.assertEquals((Object)expectedContent, (Object)delegate.toString());
            });
        }

        @Test
        @DisplayName(value="append(CharSequence, int, int) with a negative start")
        default public void testAppendCharSequencePortionWithNegativeStart() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                String expectedContent = "";
                StringWriter delegate = new StringWriter(expectedContent.length());
                try (Writer writer = this.wrapWriter(delegate);){
                    String string = "0123456789";
                    ThrowableAssertions.assertThrowsOneOf(Arrays.asList(IndexOutOfBoundsException.class, IllegalArgumentException.class, IOException.class), () -> writer.append(string, -1, 10));
                }
                Assertions.assertEquals((Object)expectedContent, (Object)delegate.toString());
            });
        }

        @Test
        @DisplayName(value="append(CharSequence, int, int) with a start that exceeds the CharSequence length")
        default public void testAppendCharSequencePortionWithTooHighStart() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                String expectedContent = "";
                StringWriter delegate = new StringWriter(expectedContent.length());
                try (Writer writer = this.wrapWriter(delegate);){
                    String string = "0123456789";
                    ThrowableAssertions.assertThrowsOneOf(Arrays.asList(IndexOutOfBoundsException.class, IllegalArgumentException.class, IOException.class), () -> writer.append(string, string.length() + 1, 0));
                }
                Assertions.assertEquals((Object)expectedContent, (Object)delegate.toString());
            });
        }

        @Test
        @DisplayName(value="append(CharSequence, int, int) with a negative end")
        default public void testAppendCharSequencePortionWithNegativeEnd() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                String expectedContent = "";
                StringWriter delegate = new StringWriter(expectedContent.length());
                try (Writer writer = this.wrapWriter(delegate);){
                    String string = "0123456789";
                    ThrowableAssertions.assertThrowsOneOf(Arrays.asList(IndexOutOfBoundsException.class, IllegalArgumentException.class, IOException.class), () -> writer.append(string, 0, -1));
                }
                Assertions.assertEquals((Object)expectedContent, (Object)delegate.toString());
            });
        }

        @Test
        @DisplayName(value="append(CharSequence, int, int) with an end that's smaller than the start")
        default public void testAppendCharSequencePortionWithEndSmallerThanStart() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                String expectedContent = "";
                StringWriter delegate = new StringWriter(expectedContent.length());
                try (Writer writer = this.wrapWriter(delegate);){
                    String string = "0123456789";
                    ThrowableAssertions.assertThrowsOneOf(Arrays.asList(IndexOutOfBoundsException.class, IllegalArgumentException.class, IOException.class), () -> writer.append(string, 5, 4));
                }
                Assertions.assertEquals((Object)expectedContent, (Object)delegate.toString());
            });
        }

        @Test
        @DisplayName(value="append(CharSequence, int, int) with an end that exceeds the CharSequence length")
        default public void testAppendCharSequencePortionWithTooHighEnd() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                String expectedContent = "";
                StringWriter delegate = new StringWriter(expectedContent.length());
                try (Writer writer = this.wrapWriter(delegate);){
                    String string = "0123456789";
                    ThrowableAssertions.assertThrowsOneOf(Arrays.asList(IndexOutOfBoundsException.class, IllegalArgumentException.class, IOException.class), () -> writer.append(string, 1, string.length() + 1));
                }
                Assertions.assertEquals((Object)expectedContent, (Object)delegate.toString());
            });
        }
    }

    @DisplayName(value="append(CharSequence)")
    public static interface AppendCharSequenceTests
    extends WriterDelegateTests {
        @ParameterizedTest(name="type: {0}")
        @ArgumentsSource(value=CharSequenceTransformationProvider.class)
        @DisplayName(value="append(CharSequence)")
        default public void testAppendCharSequence(String type, Function<String, CharSequence> contentTransformation) {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                String content = this.contentToWrite();
                String expectedContent = this.expectedContent(content);
                int bufferSize = 10;
                StringWriter delegate = new StringWriter(expectedContent.length());
                try (Writer writer = this.wrapWriter(delegate);){
                    for (int i = 0; i < content.length(); i += bufferSize) {
                        String portion = content.substring(i, Math.min(i + bufferSize, content.length()));
                        Assertions.assertSame((Object)writer, (Object)writer.append((CharSequence)contentTransformation.apply(portion)));
                    }
                }
                Assertions.assertEquals((Object)expectedContent, (Object)delegate.toString());
            });
        }

        @ParameterizedTest(name="type: {0}")
        @ArgumentsSource(value=CharSequenceTransformationProvider.class)
        @DisplayName(value="append(CharSequence) with a large CharSequence")
        default public void testAppendCharSequenceWithLargeCharSequence(String type, Function<String, CharSequence> contentTransformation) {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                String content = this.longContentToWrite();
                String expectedContent = this.expectedContent(content);
                StringWriter delegate = new StringWriter(expectedContent.length());
                try (Writer writer = this.wrapWriter(delegate);){
                    Assertions.assertSame((Object)writer, (Object)writer.append((CharSequence)contentTransformation.apply(content)));
                }
                Assertions.assertEquals((Object)expectedContent, (Object)delegate.toString());
            });
        }

        @ParameterizedTest(name="type: {0}")
        @ArgumentsSource(value=CharSequenceTransformationProvider.class)
        @DisplayName(value="append(CharSequence) with an empty CharSequence")
        default public void testAppendCharSequenceWithEmptyCharSequence(String type, Function<String, CharSequence> contentTransformation) {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                String expectedContent = this.expectedContent("");
                StringWriter delegate = new StringWriter(expectedContent.length());
                try (Writer writer = this.wrapWriter(delegate);){
                    Assertions.assertSame((Object)writer, (Object)writer.append((CharSequence)contentTransformation.apply("")));
                }
                Assertions.assertEquals((Object)expectedContent, (Object)delegate.toString());
            });
        }

        @Test
        @DisplayName(value="append(CharSequence) with a null CharSequence")
        default public void testAppendCharSequenceWithNullCharSequence() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                String expectedContent = this.expectedContent("null");
                StringWriter delegate = new StringWriter(expectedContent.length());
                try (Writer writer = this.wrapWriter(delegate);){
                    Assertions.assertSame((Object)writer, (Object)writer.append(null));
                }
                Assertions.assertEquals((Object)expectedContent, (Object)delegate.toString());
            });
        }
    }

    @DisplayName(value="write(String, int, int)")
    public static interface WriteStringPortionTests
    extends WriterDelegateTests {
        @Test
        @DisplayName(value="write(String, int, int)")
        default public void testWriteStringPortion() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                String content = this.contentToWrite();
                String expectedContent = this.expectedContent(content);
                int bufferSize = 10;
                StringWriter delegate = new StringWriter(expectedContent.length());
                try (Writer writer = this.wrapWriter(delegate);){
                    for (int i = 0; i < content.length(); i += bufferSize) {
                        writer.write(content, i, Math.min(bufferSize, content.length() - i));
                    }
                }
                Assertions.assertEquals((Object)expectedContent, (Object)delegate.toString());
            });
        }

        @Test
        @DisplayName(value="write(String, int, int) with a large String")
        default public void testWriteStringPortionWithLargeString() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                String content = this.longContentToWrite();
                String expectedContent = this.expectedContent(content);
                StringWriter delegate = new StringWriter(expectedContent.length());
                try (Writer writer = this.wrapWriter(delegate);){
                    writer.write(content, 0, content.length());
                }
                Assertions.assertEquals((Object)expectedContent, (Object)delegate.toString());
            });
        }

        @Test
        @DisplayName(value="write(String, int, int) with a null String")
        default public void testWriteStringPortionWithNullString() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                String expectedContent = "";
                StringWriter delegate = new StringWriter(expectedContent.length());
                try (Writer writer = this.wrapWriter(delegate);){
                    String string = null;
                    Assertions.assertThrows(NullPointerException.class, () -> writer.write(string, 0, 10));
                }
                Assertions.assertEquals((Object)expectedContent, (Object)delegate.toString());
            });
        }

        @Test
        @DisplayName(value="write(String, int, int) with 0 length")
        default public void testWriteStringPortionWithZeroLength() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                String content = this.contentToWrite();
                String expectedContent = this.expectedContent("");
                StringWriter delegate = new StringWriter(expectedContent.length());
                try (Writer writer = this.wrapWriter(delegate);){
                    writer.write(content, 5, 0);
                }
                Assertions.assertEquals((Object)expectedContent, (Object)delegate.toString());
            });
        }

        @Test
        @DisplayName(value="write(String, int, int) with a negative offset")
        default public void testWriteStringPortionWithNegativeOffset() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                String expectedContent = "";
                StringWriter delegate = new StringWriter(expectedContent.length());
                try (Writer writer = this.wrapWriter(delegate);){
                    String string = "0123456789";
                    ThrowableAssertions.assertThrowsOneOf(Arrays.asList(IndexOutOfBoundsException.class, IllegalArgumentException.class, IOException.class), () -> writer.write(string, -1, 10));
                }
                Assertions.assertEquals((Object)expectedContent, (Object)delegate.toString());
            });
        }

        @Test
        @DisplayName(value="write(String, int, int) with an offset that exceeds the String length")
        default public void testWriteStringPortionWithTooHighOffset() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                String expectedContent = "";
                StringWriter delegate = new StringWriter(expectedContent.length());
                try (Writer writer = this.wrapWriter(delegate);){
                    String string = "0123456789";
                    ThrowableAssertions.assertThrowsOneOf(Arrays.asList(IndexOutOfBoundsException.class, IllegalArgumentException.class, IOException.class), () -> writer.write(string, string.length() + 1, 0));
                }
                Assertions.assertEquals((Object)expectedContent, (Object)delegate.toString());
            });
        }

        @Test
        @DisplayName(value="write(String, int, int) with a negative length")
        default public void testWriteStringPortionWithNegativeLength() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                String expectedContent = "";
                StringWriter delegate = new StringWriter(expectedContent.length());
                try (Writer writer = this.wrapWriter(delegate);){
                    String string = "0123456789";
                    ThrowableAssertions.assertThrowsOneOf(Arrays.asList(IndexOutOfBoundsException.class, IllegalArgumentException.class, IOException.class), () -> writer.write(string, 5, -1));
                }
                Assertions.assertEquals((Object)expectedContent, (Object)delegate.toString());
            });
        }

        @Test
        @DisplayName(value="write(String, int, int) with a length that exceeds the String length")
        default public void testWriteStringPortionWithTooHighLength() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                String expectedContent = "";
                StringWriter delegate = new StringWriter(expectedContent.length());
                try (Writer writer = this.wrapWriter(delegate);){
                    String string = "0123456789";
                    ThrowableAssertions.assertThrowsOneOf(Arrays.asList(IndexOutOfBoundsException.class, IllegalArgumentException.class, IOException.class), () -> writer.write(string, 1, string.length()));
                }
                Assertions.assertEquals((Object)expectedContent, (Object)delegate.toString());
            });
        }
    }

    @DisplayName(value="write(String)")
    public static interface WriteStringTests
    extends WriterDelegateTests {
        @Test
        @DisplayName(value="write(String)")
        default public void testWriteString() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                String content = this.contentToWrite();
                String expectedContent = this.expectedContent(content);
                int bufferSize = 10;
                StringWriter delegate = new StringWriter(expectedContent.length());
                try (Writer writer = this.wrapWriter(delegate);){
                    for (int i = 0; i < content.length(); i += bufferSize) {
                        writer.write(content.substring(i, Math.min(i + bufferSize, content.length())));
                    }
                }
                Assertions.assertEquals((Object)expectedContent, (Object)delegate.toString());
            });
        }

        @Test
        @DisplayName(value="write(String) with a large String")
        default public void testWriteStringWithLargeString() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                String content = this.longContentToWrite();
                String expectedContent = this.expectedContent(content);
                StringWriter delegate = new StringWriter(expectedContent.length());
                try (Writer writer = this.wrapWriter(delegate);){
                    writer.write(content);
                }
                Assertions.assertEquals((Object)expectedContent, (Object)delegate.toString());
            });
        }

        @Test
        @DisplayName(value="write(String) with an empty String")
        default public void testWriteStringWithEmptyString() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                String expectedContent = this.expectedContent("");
                StringWriter delegate = new StringWriter(expectedContent.length());
                try (Writer writer = this.wrapWriter(delegate);){
                    writer.write("");
                }
                Assertions.assertEquals((Object)expectedContent, (Object)delegate.toString());
            });
        }

        @Test
        @DisplayName(value="write(String) with a null String")
        default public void testWriteStringWithNullString() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                String expectedContent = "";
                StringWriter delegate = new StringWriter(expectedContent.length());
                try (Writer writer = this.wrapWriter(delegate);){
                    String string = null;
                    Assertions.assertThrows(NullPointerException.class, () -> writer.write(string));
                }
                Assertions.assertEquals((Object)expectedContent, (Object)delegate.toString());
            });
        }
    }

    @DisplayName(value="write(char[], int, int)")
    public static interface WriteCharArrayPortionTests
    extends WriterDelegateTests {
        @Test
        @DisplayName(value="write(char[], int, int)")
        default public void testWriteCharArrayPortion() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                String content = this.contentToWrite();
                String expectedContent = this.expectedContent(content);
                int bufferSize = 10;
                char[] chars = content.toCharArray();
                StringWriter delegate = new StringWriter(expectedContent.length());
                try (Writer writer = this.wrapWriter(delegate);){
                    for (int i = 0; i < chars.length; i += bufferSize) {
                        writer.write(chars, i, Math.min(bufferSize, chars.length - i));
                    }
                }
                Assertions.assertEquals((Object)expectedContent, (Object)delegate.toString());
            });
        }

        @Test
        @DisplayName(value="write(char[], int, int) with a large array")
        default public void testWriteCharArrayPortionWithLargeArray() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                String content = this.longContentToWrite();
                String expectedContent = this.expectedContent(content);
                char[] chars = content.toCharArray();
                StringWriter delegate = new StringWriter(expectedContent.length());
                try (Writer writer = this.wrapWriter(delegate);){
                    writer.write(chars, 0, chars.length);
                }
                Assertions.assertEquals((Object)expectedContent, (Object)delegate.toString());
            });
        }

        @Test
        @DisplayName(value="write(char[], int, int) with a null array")
        default public void testWriteCharArrayPortionWithNullArray() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                String expectedContent = "";
                StringWriter delegate = new StringWriter(expectedContent.length());
                try (Writer writer = this.wrapWriter(delegate);){
                    char[] buffer = null;
                    Assertions.assertThrows(NullPointerException.class, () -> writer.write(buffer, 0, 10));
                }
                Assertions.assertEquals((Object)expectedContent, (Object)delegate.toString());
            });
        }

        @Test
        @DisplayName(value="write(char[], int, int) with 0 length")
        default public void testWriteCharArrayPortionWithZeroLength() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                String content = this.contentToWrite();
                String expectedContent = this.expectedContent("");
                char[] chars = content.toCharArray();
                StringWriter delegate = new StringWriter(expectedContent.length());
                try (Writer writer = this.wrapWriter(delegate);){
                    writer.write(chars, 5, 0);
                }
                Assertions.assertEquals((Object)expectedContent, (Object)delegate.toString());
            });
        }

        @Test
        @DisplayName(value="write(char[], int, int) with a negative offset")
        default public void testWriteCharArrayPortionWithNegativeOffset() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                String expectedContent = "";
                StringWriter delegate = new StringWriter(expectedContent.length());
                try (Writer writer = this.wrapWriter(delegate);){
                    char[] buffer = new char[10];
                    ThrowableAssertions.assertThrowsOneOf(Arrays.asList(IndexOutOfBoundsException.class, IllegalArgumentException.class, IOException.class), () -> writer.write(buffer, -1, 10));
                }
                Assertions.assertEquals((Object)expectedContent, (Object)delegate.toString());
            });
        }

        @Test
        @DisplayName(value="write(char[], int, int) with an offset that exceeds the array length")
        default public void testWriteCharArrayPortionWithTooHighOffset() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                String expectedContent = "";
                StringWriter delegate = new StringWriter(expectedContent.length());
                try (Writer writer = this.wrapWriter(delegate);){
                    char[] buffer = new char[10];
                    ThrowableAssertions.assertThrowsOneOf(Arrays.asList(IndexOutOfBoundsException.class, IllegalArgumentException.class, IOException.class), () -> writer.write(buffer, buffer.length + 1, 0));
                }
                Assertions.assertEquals((Object)expectedContent, (Object)delegate.toString());
            });
        }

        @Test
        @DisplayName(value="write(char[], int, int) with a negative length")
        default public void testWriteCharArrayPortionWithNegativeLength() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                String expectedContent = "";
                StringWriter delegate = new StringWriter(expectedContent.length());
                try (Writer writer = this.wrapWriter(delegate);){
                    char[] buffer = new char[10];
                    ThrowableAssertions.assertThrowsOneOf(Arrays.asList(IndexOutOfBoundsException.class, IllegalArgumentException.class, IOException.class), () -> writer.write(buffer, 5, -1));
                }
                Assertions.assertEquals((Object)expectedContent, (Object)delegate.toString());
            });
        }

        @Test
        @DisplayName(value="write(char[], int, int) with a length that exceeds the array length")
        default public void testWriteCharArrayPortionWithTooHighLength() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                String expectedContent = "";
                StringWriter delegate = new StringWriter(expectedContent.length());
                try (Writer writer = this.wrapWriter(delegate);){
                    char[] buffer = new char[10];
                    ThrowableAssertions.assertThrowsOneOf(Arrays.asList(IndexOutOfBoundsException.class, IllegalArgumentException.class, IOException.class), () -> writer.write(buffer, 1, buffer.length));
                }
                Assertions.assertEquals((Object)expectedContent, (Object)delegate.toString());
            });
        }
    }

    @DisplayName(value="write(char[])")
    public static interface WriteCharArrayTests
    extends WriterDelegateTests {
        @Test
        @DisplayName(value="write(char[])")
        default public void testWriteCharArray() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                String content = this.contentToWrite();
                String expectedContent = this.expectedContent(content);
                int bufferSize = 10;
                char[] chars = content.toCharArray();
                StringWriter delegate = new StringWriter(expectedContent.length());
                try (Writer writer = this.wrapWriter(delegate);){
                    for (int i = 0; i < chars.length; i += bufferSize) {
                        writer.write(Arrays.copyOfRange(chars, i, Math.min(i + bufferSize, chars.length)));
                    }
                }
                Assertions.assertEquals((Object)expectedContent, (Object)delegate.toString());
            });
        }

        @Test
        @DisplayName(value="write(char[]) with a large array")
        default public void testWriteCharArrayWithLargeArray() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                String content = this.longContentToWrite();
                String expectedContent = this.expectedContent(content);
                char[] chars = content.toCharArray();
                StringWriter delegate = new StringWriter(expectedContent.length());
                try (Writer writer = this.wrapWriter(delegate);){
                    writer.write(chars);
                }
                Assertions.assertEquals((Object)expectedContent, (Object)delegate.toString());
            });
        }

        @Test
        @DisplayName(value="write(char[]) with an empty array")
        default public void testWriteCharArrayWithEmptyArray() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                String expectedContent = this.expectedContent("");
                char[] chars = new char[]{};
                StringWriter delegate = new StringWriter(expectedContent.length());
                try (Writer writer = this.wrapWriter(delegate);){
                    writer.write(chars);
                }
                Assertions.assertEquals((Object)expectedContent, (Object)delegate.toString());
            });
        }

        @Test
        @DisplayName(value="write(char[]) with a null array")
        default public void testWriteCharArrayWithNullArray() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                String expectedContent = "";
                StringWriter delegate = new StringWriter(expectedContent.length());
                try (Writer writer = this.wrapWriter(delegate);){
                    char[] buffer = null;
                    Assertions.assertThrows(NullPointerException.class, () -> writer.write(buffer));
                }
                Assertions.assertEquals((Object)expectedContent, (Object)delegate.toString());
            });
        }
    }

    @DisplayName(value="write(int)")
    public static interface WriteCharTests
    extends WriterDelegateTests {
        @Test
        @DisplayName(value="write(int)")
        default public void testWriteChar() {
            ThrowableAssertions.assertDoesNotThrowCheckedException(() -> {
                String content = this.contentToWrite();
                String expectedContent = this.expectedContent(content);
                StringWriter delegate = new StringWriter(expectedContent.length());
                try (Writer writer = this.wrapWriter(delegate);){
                    for (int i = 0; i < content.length(); ++i) {
                        writer.write(content.charAt(i));
                    }
                }
                Assertions.assertEquals((Object)expectedContent, (Object)delegate.toString());
            });
        }
    }
}

