/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.junit.support.util;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.stream.Collectors;

public final class DisplayNameUtils {
    private DisplayNameUtils() {
    }

    public static String getMethodDisplayName(Method method) {
        return DisplayNameUtils.getMethodDisplayName(method.getName(), method.getParameterTypes());
    }

    public static String getMethodDisplayName(String name, Class<?>[] parameterTypes) {
        return Arrays.stream(parameterTypes).map(DisplayNameUtils::getTypeName).collect(Collectors.joining(", ", name + "(", ")"));
    }

    private static String getTypeName(Class<?> parameterType) {
        if (parameterType.isArray()) {
            return DisplayNameUtils.getTypeName(parameterType.getComponentType()) + "[]";
        }
        return parameterType.getSimpleName();
    }
}

