/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.filesystems.sftp;

import com.github.robtimus.filesystems.Messages;
import java.nio.file.CopyOption;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

final class CopyOptions {
    public final boolean replaceExisting;
    public final Collection<? extends CopyOption> options;

    private CopyOptions(boolean replaceExisting, Collection<? extends CopyOption> options) {
        this.replaceExisting = replaceExisting;
        this.options = options;
    }

    public Collection<OpenOption> toOpenOptions(OpenOption ... additional) {
        ArrayList<OpenOption> openOptions = new ArrayList<OpenOption>(this.options.size() + additional.length);
        for (CopyOption copyOption : this.options) {
            if (!(copyOption instanceof OpenOption)) continue;
            openOptions.add((OpenOption)((Object)copyOption));
        }
        Collections.addAll(openOptions, additional);
        return openOptions;
    }

    static CopyOptions forCopy(CopyOption ... options) {
        boolean replaceExisting = false;
        for (CopyOption option : options) {
            if (option == StandardCopyOption.REPLACE_EXISTING) {
                replaceExisting = true;
                continue;
            }
            if (CopyOptions.isIgnoredCopyOption(option)) continue;
            throw Messages.fileSystemProvider().unsupportedCopyOption(option);
        }
        return new CopyOptions(replaceExisting, Arrays.asList(options));
    }

    static CopyOptions forMove(boolean sameFileSystem, CopyOption ... options) {
        boolean replaceExisting = false;
        for (CopyOption option : options) {
            if (option == StandardCopyOption.REPLACE_EXISTING) {
                replaceExisting = true;
                continue;
            }
            if (option == StandardCopyOption.ATOMIC_MOVE && sameFileSystem || CopyOptions.isIgnoredCopyOption(option)) continue;
            throw Messages.fileSystemProvider().unsupportedCopyOption(option);
        }
        return new CopyOptions(replaceExisting, Arrays.asList(options));
    }

    private static boolean isIgnoredCopyOption(CopyOption option) {
        return option == LinkOption.NOFOLLOW_LINKS;
    }
}

