/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.filesystems.sftp;

import com.github.robtimus.filesystems.sftp.FileSystemExceptionFactory;
import com.jcraft.jsch.SftpException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileSystemException;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotLinkException;
import java.nio.file.OpenOption;
import java.util.Collection;

public class DefaultFileSystemExceptionFactory
implements FileSystemExceptionFactory {
    static final DefaultFileSystemExceptionFactory INSTANCE = new DefaultFileSystemExceptionFactory();

    @Override
    public FileSystemException createGetFileException(String file, SftpException exception) {
        return this.asFileSystemException(file, null, exception);
    }

    @Override
    public FileSystemException createReadLinkException(String link, SftpException exception) {
        if (exception.id == 2 || exception.id == 3) {
            return this.asFileSystemException(link, null, exception);
        }
        NotLinkException result = new NotLinkException(link, null, exception.getMessage());
        result.initCause((Throwable)exception);
        return result;
    }

    @Override
    public FileSystemException createListFilesException(String directory, SftpException exception) {
        return this.asFileSystemException(directory, null, exception);
    }

    @Override
    public FileSystemException createChangeWorkingDirectoryException(String directory, SftpException exception) {
        return this.asFileSystemException(directory, null, exception);
    }

    @Override
    public FileSystemException createCreateDirectoryException(String directory, SftpException exception) {
        return this.asFileSystemException(directory, null, exception);
    }

    @Override
    public FileSystemException createDeleteException(String file, SftpException exception, boolean isDirectory) {
        return this.asFileSystemException(file, null, exception);
    }

    @Override
    public FileSystemException createNewInputStreamException(String file, SftpException exception) {
        return this.asFileSystemException(file, null, exception);
    }

    @Override
    public FileSystemException createNewOutputStreamException(String file, SftpException exception, Collection<? extends OpenOption> options) {
        return this.asFileSystemException(file, null, exception);
    }

    @Override
    public FileSystemException createCopyException(String file, String other, SftpException exception) {
        return this.asFileSystemException(file, other, exception);
    }

    @Override
    public FileSystemException createMoveException(String file, String other, SftpException exception) {
        return this.asFileSystemException(file, other, exception);
    }

    @Override
    public FileSystemException createSetOwnerException(String file, SftpException exception) {
        return this.asFileSystemException(file, null, exception);
    }

    @Override
    public FileSystemException createSetGroupException(String file, SftpException exception) {
        return this.asFileSystemException(file, null, exception);
    }

    @Override
    public FileSystemException createSetPermissionsException(String file, SftpException exception) {
        return this.asFileSystemException(file, null, exception);
    }

    @Override
    public FileSystemException createSetModificationTimeException(String file, SftpException exception) {
        return this.asFileSystemException(file, null, exception);
    }

    private FileSystemException asFileSystemException(String file, String other, SftpException e) {
        FileSystemException exception;
        switch (e.id) {
            case 2: {
                exception = new NoSuchFileException(file, other, e.getMessage());
                break;
            }
            case 3: {
                exception = new AccessDeniedException(file, other, e.getMessage());
                break;
            }
            default: {
                exception = new FileSystemException(file, other, e.getMessage());
            }
        }
        exception.initCause((Throwable)e);
        return exception;
    }
}

