/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.filesystems.sftp;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import java.io.File;
import java.util.Objects;

public final class Identity {
    private final JSchConsumer consumer;

    private Identity(JSchConsumer consumer) {
        this.consumer = consumer;
    }

    void addIdentity(JSch jsch) throws JSchException {
        this.consumer.accept(jsch);
    }

    public static Identity fromFiles(File privateKeyFile) {
        Objects.requireNonNull(privateKeyFile);
        return new Identity(jsch -> jsch.addIdentity(privateKeyFile.getAbsolutePath()));
    }

    public static Identity fromFiles(File privateKeyFile, String passphrase) {
        Objects.requireNonNull(privateKeyFile);
        return new Identity(jsch -> jsch.addIdentity(privateKeyFile.getAbsolutePath(), passphrase));
    }

    public static Identity fromFiles(File privateKeyFile, byte[] passphrase) {
        Objects.requireNonNull(privateKeyFile);
        return new Identity(jsch -> jsch.addIdentity(privateKeyFile.getAbsolutePath(), passphrase));
    }

    public static Identity fromFiles(File privateKeyFile, File publicKeyFile, byte[] passphrase) {
        Objects.requireNonNull(privateKeyFile);
        String publicKeyPath = publicKeyFile == null ? null : publicKeyFile.getAbsolutePath();
        return new Identity(jsch -> jsch.addIdentity(privateKeyFile.getAbsolutePath(), publicKeyPath, passphrase));
    }

    public static Identity fromData(String name, byte[] privateKey, byte[] publicKey, byte[] passphrase) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(privateKey);
        return new Identity(jsch -> jsch.addIdentity(name, privateKey, publicKey, passphrase));
    }

    private static interface JSchConsumer {
        public void accept(JSch var1) throws JSchException;
    }
}

