/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.filesystems.sftp;

import com.github.robtimus.filesystems.Messages;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;

final class OpenOptions {
    public final boolean read;
    public final boolean write;
    public final boolean append;
    public final boolean create;
    public final boolean createNew;
    public final boolean deleteOnClose;
    public final Collection<? extends OpenOption> options;

    private OpenOptions(boolean read, boolean write, boolean append, boolean create, boolean createNew, boolean deleteOnClose, Collection<? extends OpenOption> options) {
        this.read = read;
        this.write = write;
        this.append = append;
        this.create = create;
        this.createNew = createNew;
        this.deleteOnClose = deleteOnClose;
        this.options = options;
    }

    static OpenOptions forNewInputStream(OpenOption ... options) {
        return OpenOptions.forNewInputStream(Arrays.asList(options));
    }

    static OpenOptions forNewInputStream(Collection<? extends OpenOption> options) {
        if (options.isEmpty()) {
            return new OpenOptions(true, false, false, false, false, false, Collections.emptySet());
        }
        boolean deleteOnClose = false;
        for (OpenOption openOption : options) {
            if (openOption == StandardOpenOption.DELETE_ON_CLOSE) {
                deleteOnClose = true;
                continue;
            }
            if (openOption == StandardOpenOption.READ || openOption == StandardOpenOption.TRUNCATE_EXISTING || OpenOptions.isIgnoredOpenOption(openOption)) continue;
            throw Messages.fileSystemProvider().unsupportedOpenOption(openOption);
        }
        return new OpenOptions(true, false, false, false, false, deleteOnClose, options);
    }

    static OpenOptions forNewOutputStream(OpenOption ... options) {
        return OpenOptions.forNewOutputStream(Arrays.asList(options));
    }

    static OpenOptions forNewOutputStream(Collection<? extends OpenOption> options) {
        if (options.isEmpty()) {
            return new OpenOptions(false, true, false, true, false, false, Collections.emptySet());
        }
        boolean append = false;
        boolean truncateExisting = false;
        boolean create = false;
        boolean createNew = false;
        boolean deleteOnClose = false;
        for (OpenOption openOption : options) {
            if (openOption == StandardOpenOption.APPEND) {
                append = true;
                continue;
            }
            if (openOption == StandardOpenOption.TRUNCATE_EXISTING) {
                truncateExisting = true;
                continue;
            }
            if (openOption == StandardOpenOption.CREATE) {
                create = true;
                continue;
            }
            if (openOption == StandardOpenOption.CREATE_NEW) {
                createNew = true;
                continue;
            }
            if (openOption == StandardOpenOption.DELETE_ON_CLOSE) {
                deleteOnClose = true;
                continue;
            }
            if (openOption == StandardOpenOption.WRITE || OpenOptions.isIgnoredOpenOption(openOption)) continue;
            throw Messages.fileSystemProvider().unsupportedOpenOption(openOption);
        }
        if (append && truncateExisting) {
            throw Messages.fileSystemProvider().illegalOpenOptionCombination(options);
        }
        return new OpenOptions(false, true, append, create, createNew, deleteOnClose, options);
    }

    static OpenOptions forNewByteChannel(Set<? extends OpenOption> options) {
        boolean read = false;
        boolean write = false;
        boolean append = false;
        boolean truncateExisting = false;
        boolean create = false;
        boolean createNew = false;
        boolean deleteOnClose = false;
        for (OpenOption openOption : options) {
            if (openOption == StandardOpenOption.READ) {
                read = true;
                continue;
            }
            if (openOption == StandardOpenOption.WRITE) {
                write = true;
                continue;
            }
            if (openOption == StandardOpenOption.APPEND) {
                append = true;
                continue;
            }
            if (openOption == StandardOpenOption.TRUNCATE_EXISTING) {
                truncateExisting = true;
                continue;
            }
            if (openOption == StandardOpenOption.CREATE) {
                create = true;
                continue;
            }
            if (openOption == StandardOpenOption.CREATE_NEW) {
                createNew = true;
                continue;
            }
            if (openOption == StandardOpenOption.DELETE_ON_CLOSE) {
                deleteOnClose = true;
                continue;
            }
            if (OpenOptions.isIgnoredOpenOption(openOption)) continue;
            throw Messages.fileSystemProvider().unsupportedOpenOption(openOption);
        }
        if (!(read || write || append)) {
            read = true;
        }
        if (read && (write || append || create || createNew)) {
            throw Messages.fileSystemProvider().illegalOpenOptionCombination(options);
        }
        if (append && truncateExisting) {
            throw Messages.fileSystemProvider().illegalOpenOptionCombination(options);
        }
        if (read && write || read && append || append && truncateExisting) {
            throw Messages.fileSystemProvider().illegalOpenOptionCombination(options);
        }
        return new OpenOptions(read, write, append, create, createNew, deleteOnClose, options);
    }

    private static boolean isIgnoredOpenOption(OpenOption option) {
        return option == StandardOpenOption.SPARSE || option == StandardOpenOption.SYNC || option == StandardOpenOption.DSYNC || option == LinkOption.NOFOLLOW_LINKS;
    }
}

