/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.filesystems.sftp;

import com.github.robtimus.filesystems.FileSystemProviderSupport;
import com.github.robtimus.filesystems.Messages;
import com.github.robtimus.filesystems.sftp.DefaultFileSystemExceptionFactory;
import com.github.robtimus.filesystems.sftp.FileSystemExceptionFactory;
import com.github.robtimus.filesystems.sftp.Identity;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.HostKeyRepository;
import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SocketFactory;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystemException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class SFTPEnvironment
implements Map<String, Object>,
Cloneable {
    private static final String USERNAME = "username";
    private static final String CONNECT_TIMEOUT = "connectTimeout";
    private static final String IDENTITY_REPOSITORY = "identityRepository";
    private static final String IDENTITIES = "identities";
    private static final String HOST_KEY_REPOSITORY = "hostKeyRepository";
    private static final String KNOWN_HOSTS = "knownHosts";
    private static final String PROXY = "proxy";
    private static final String USER_INFO = "userInfo";
    private static final String PASSWORD = "password";
    private static final String CONFIG = "config";
    private static final String SOCKET_FACTORY = "socketFactory";
    private static final String TIMEOUT = "timeOut";
    private static final String CLIENT_VERSION = "clientVersion";
    private static final String HOST_KEY_ALIAS = "hostKeyAlias";
    private static final String SERVER_ALIVE_INTERVAL = "serverAliveInterval";
    private static final String SERVER_ALIVE_COUNT_MAX = "serverAliveCountMax";
    private static final String AGENT_FORWARDING = "agentForwarding";
    private static final String FILENAME_ENCODING = "filenameEncoding";
    private static final String DEFAULT_DIR = "defaultDir";
    private static final int DEFAULT_CLIENT_CONNECTION_COUNT = 5;
    private static final long DEFAULT_CLIENT_CONNECTION_WAIT_TIMEOUT = 0L;
    private static final String CLIENT_CONNECTION_COUNT = "clientConnectionCount";
    private static final String CLIENT_CONNECTION_WAIT_TIMEOUT = "clientConnectionWaitTimeout";
    private static final String FILE_SYSTEM_EXCEPTION_FACTORY = "fileSystemExceptionFactory";
    private Map<String, Object> map;

    public SFTPEnvironment() {
        this.map = new HashMap<String, Object>();
    }

    public SFTPEnvironment(Map<String, Object> map) {
        this.map = Objects.requireNonNull(map);
    }

    static SFTPEnvironment wrap(Map<String, ?> map) {
        if (map instanceof SFTPEnvironment) {
            return (SFTPEnvironment)map;
        }
        return new SFTPEnvironment(map);
    }

    public SFTPEnvironment withUsername(String username) {
        this.put(USERNAME, (Object)username);
        return this;
    }

    public SFTPEnvironment withConnectTimeout(int timeout) {
        this.put(CONNECT_TIMEOUT, (Object)timeout);
        return this;
    }

    public SFTPEnvironment withProxy(Proxy proxy) {
        this.put(PROXY, (Object)proxy);
        return this;
    }

    public SFTPEnvironment withUserInfo(UserInfo userInfo) {
        this.put(USER_INFO, (Object)userInfo);
        return this;
    }

    public SFTPEnvironment withPassword(char[] password) {
        this.put(PASSWORD, (Object)password);
        return this;
    }

    public SFTPEnvironment withConfig(Properties config) {
        this.getConfig().putAll((Map<?, ?>)config);
        return this;
    }

    public SFTPEnvironment withConfig(String key, String value) {
        this.getConfig().setProperty(key, value);
        return this;
    }

    private Properties getConfig() {
        Properties config = (Properties)FileSystemProviderSupport.getValue((Map)this, (String)CONFIG, Properties.class, null);
        if (config == null) {
            config = new Properties();
            this.put(CONFIG, (Object)config);
        }
        return config;
    }

    public SFTPEnvironment withSocketFactory(SocketFactory factory) {
        this.put(SOCKET_FACTORY, (Object)factory);
        return this;
    }

    public SFTPEnvironment withTimeout(int timeout) {
        this.put(TIMEOUT, (Object)timeout);
        return this;
    }

    public SFTPEnvironment withClientVersion(String version) {
        this.put(CLIENT_VERSION, (Object)version);
        return this;
    }

    public SFTPEnvironment withHostKeyAlias(String alias) {
        this.put(HOST_KEY_ALIAS, (Object)alias);
        return this;
    }

    public SFTPEnvironment withServerAliveInterval(int interval) {
        this.put(SERVER_ALIVE_INTERVAL, (Object)interval);
        return this;
    }

    public SFTPEnvironment withServerAliveCountMax(int count) {
        this.put(SERVER_ALIVE_COUNT_MAX, (Object)count);
        return this;
    }

    public SFTPEnvironment withIdentityRepository(IdentityRepository repository) {
        this.put(IDENTITY_REPOSITORY, (Object)repository);
        return this;
    }

    public SFTPEnvironment withIdentity(Identity identity) {
        Objects.requireNonNull(identity);
        this.getIdentities().add(identity);
        return this;
    }

    public SFTPEnvironment withIdentities(Identity ... identities) {
        Collection<Identity> existingIdentities = this.getIdentities();
        for (Identity identity : identities) {
            Objects.requireNonNull(identity);
            existingIdentities.add(identity);
        }
        return this;
    }

    public SFTPEnvironment withIdentities(Collection<Identity> identities) {
        Collection<Identity> existingIdentities = this.getIdentities();
        for (Identity identity : identities) {
            Objects.requireNonNull(identity);
            existingIdentities.add(identity);
        }
        return this;
    }

    private Collection<Identity> getIdentities() {
        ArrayList identities = (ArrayList)FileSystemProviderSupport.getValue((Map)this, (String)IDENTITIES, List.class, null);
        if (identities == null) {
            identities = new ArrayList();
            this.put(IDENTITIES, (Object)identities);
        }
        return identities;
    }

    public SFTPEnvironment withHostKeyRepository(HostKeyRepository repository) {
        this.put(HOST_KEY_REPOSITORY, (Object)repository);
        return this;
    }

    public SFTPEnvironment withKnownHosts(File knownHosts) {
        Objects.requireNonNull(knownHosts);
        this.put(KNOWN_HOSTS, (Object)knownHosts);
        return this;
    }

    public SFTPEnvironment withAgentForwarding(boolean agentForwarding) {
        this.put(AGENT_FORWARDING, (Object)agentForwarding);
        return this;
    }

    public SFTPEnvironment withFilenameEncoding(String encoding) {
        this.put(FILENAME_ENCODING, (Object)encoding);
        return this;
    }

    public SFTPEnvironment withDefaultDirectory(String pathname) {
        this.put(DEFAULT_DIR, (Object)pathname);
        return this;
    }

    public SFTPEnvironment withClientConnectionCount(int count) {
        this.put(CLIENT_CONNECTION_COUNT, (Object)count);
        return this;
    }

    public SFTPEnvironment withClientConnectionWaitTimeout(long timeout) {
        this.put(CLIENT_CONNECTION_WAIT_TIMEOUT, (Object)timeout);
        return this;
    }

    public SFTPEnvironment withClientConnectionWaitTimeout(long duration, TimeUnit unit) {
        return this.withClientConnectionWaitTimeout(TimeUnit.MILLISECONDS.convert(duration, unit));
    }

    public SFTPEnvironment withFileSystemExceptionFactory(FileSystemExceptionFactory factory) {
        this.put(FILE_SYSTEM_EXCEPTION_FACTORY, (Object)factory);
        return this;
    }

    String getUsername() {
        return (String)FileSystemProviderSupport.getValue((Map)this, (String)USERNAME, String.class, null);
    }

    int getClientConnectionCount() {
        int count = FileSystemProviderSupport.getIntValue((Map)this, (String)CLIENT_CONNECTION_COUNT, (int)5);
        return Math.max(1, count);
    }

    long getClientConnectionWaitTimeout() {
        long timeout = FileSystemProviderSupport.getLongValue((Map)this, (String)CLIENT_CONNECTION_WAIT_TIMEOUT, (long)0L);
        return Math.max(0L, timeout);
    }

    FileSystemExceptionFactory getExceptionFactory() {
        return (FileSystemExceptionFactory)FileSystemProviderSupport.getValue((Map)this, (String)FILE_SYSTEM_EXCEPTION_FACTORY, FileSystemExceptionFactory.class, (Object)DefaultFileSystemExceptionFactory.INSTANCE);
    }

    JSch createJSch() throws IOException {
        JSch jsch = new JSch();
        this.initialize(jsch);
        return jsch;
    }

    void initialize(JSch jsch) throws IOException {
        if (this.containsKey(IDENTITY_REPOSITORY)) {
            IdentityRepository identityRepository = (IdentityRepository)FileSystemProviderSupport.getValue((Map)this, (String)IDENTITY_REPOSITORY, IdentityRepository.class, null);
            jsch.setIdentityRepository(identityRepository);
        }
        if (this.containsKey(IDENTITIES)) {
            Collection identities = (Collection)FileSystemProviderSupport.getValue((Map)this, (String)IDENTITIES, Collection.class);
            for (Object o : identities) {
                if (o instanceof Identity) {
                    Identity identity = (Identity)o;
                    try {
                        identity.addIdentity(jsch);
                        continue;
                    }
                    catch (JSchException e) {
                        throw this.asFileSystemException((Exception)((Object)e));
                    }
                }
                throw Messages.fileSystemProvider().env().invalidProperty(IDENTITIES, (Object)identities);
            }
        }
        if (this.containsKey(HOST_KEY_REPOSITORY)) {
            HostKeyRepository hostKeyRepository = (HostKeyRepository)FileSystemProviderSupport.getValue((Map)this, (String)HOST_KEY_REPOSITORY, HostKeyRepository.class, null);
            jsch.setHostKeyRepository(hostKeyRepository);
        }
        if (this.containsKey(KNOWN_HOSTS)) {
            File knownHosts = (File)FileSystemProviderSupport.getValue((Map)this, (String)KNOWN_HOSTS, File.class);
            try {
                jsch.setKnownHosts(knownHosts.getAbsolutePath());
            }
            catch (JSchException e) {
                throw this.asFileSystemException((Exception)((Object)e));
            }
        }
    }

    ChannelSftp openChannel(JSch jsch, String hostname, int port) throws IOException {
        Session session = this.getSession(jsch, hostname, port);
        try {
            this.initialize(session);
            ChannelSftp channel = this.connect(session);
            try {
                this.initializePreConnect(channel);
                this.connect(channel);
                this.initializePostConnect(channel);
                this.verifyConnection(channel);
                return channel;
            }
            catch (IOException e) {
                channel.disconnect();
                throw e;
            }
        }
        catch (IOException e) {
            session.disconnect();
            throw e;
        }
    }

    Session getSession(JSch jsch, String hostname, int port) throws IOException {
        String username = this.getUsername();
        try {
            return jsch.getSession(username, hostname, port == -1 ? 22 : port);
        }
        catch (JSchException e) {
            throw this.asFileSystemException((Exception)((Object)e));
        }
    }

    void initialize(Session session) throws IOException {
        if (this.containsKey(PROXY)) {
            Proxy proxy = (Proxy)FileSystemProviderSupport.getValue((Map)this, (String)PROXY, Proxy.class, null);
            session.setProxy(proxy);
        }
        if (this.containsKey(USER_INFO)) {
            UserInfo userInfo = (UserInfo)FileSystemProviderSupport.getValue((Map)this, (String)USER_INFO, UserInfo.class, null);
            session.setUserInfo(userInfo);
        }
        if (this.containsKey(PASSWORD)) {
            char[] password = (char[])FileSystemProviderSupport.getValue((Map)this, (String)PASSWORD, char[].class, null);
            session.setPassword(password == null ? null : new String(password));
        }
        if (this.containsKey(CONFIG)) {
            Properties config = (Properties)FileSystemProviderSupport.getValue((Map)this, (String)CONFIG, Properties.class, null);
            session.setConfig(config);
        }
        if (this.containsKey(SOCKET_FACTORY)) {
            SocketFactory socketFactory = (SocketFactory)FileSystemProviderSupport.getValue((Map)this, (String)SOCKET_FACTORY, SocketFactory.class, null);
            session.setSocketFactory(socketFactory);
        }
        if (this.containsKey(TIMEOUT)) {
            int timeout = FileSystemProviderSupport.getIntValue((Map)this, (String)TIMEOUT);
            try {
                session.setTimeout(timeout);
            }
            catch (JSchException e) {
                throw this.asFileSystemException((Exception)((Object)e));
            }
        }
        if (this.containsKey(CLIENT_VERSION)) {
            String clientVersion = (String)FileSystemProviderSupport.getValue((Map)this, (String)CLIENT_VERSION, String.class, null);
            session.setClientVersion(clientVersion);
        }
        if (this.containsKey(HOST_KEY_ALIAS)) {
            String hostKeyAlias = (String)FileSystemProviderSupport.getValue((Map)this, (String)HOST_KEY_ALIAS, String.class, null);
            session.setHostKeyAlias(hostKeyAlias);
        }
        if (this.containsKey(SERVER_ALIVE_INTERVAL)) {
            int interval = FileSystemProviderSupport.getIntValue((Map)this, (String)SERVER_ALIVE_INTERVAL);
            try {
                session.setServerAliveInterval(interval);
            }
            catch (JSchException e) {
                throw this.asFileSystemException((Exception)((Object)e));
            }
        }
        if (this.containsKey(SERVER_ALIVE_COUNT_MAX)) {
            int count = FileSystemProviderSupport.getIntValue((Map)this, (String)SERVER_ALIVE_COUNT_MAX);
            session.setServerAliveCountMax(count);
        }
    }

    ChannelSftp connect(Session session) throws IOException {
        try {
            if (this.containsKey(CONNECT_TIMEOUT)) {
                int connectTimeout = FileSystemProviderSupport.getIntValue((Map)this, (String)CONNECT_TIMEOUT);
                session.connect(connectTimeout);
            } else {
                session.connect();
            }
            return (ChannelSftp)session.openChannel("sftp");
        }
        catch (JSchException e) {
            throw this.asFileSystemException((Exception)((Object)e));
        }
    }

    void initializePreConnect(ChannelSftp channel) throws IOException {
        if (this.containsKey(AGENT_FORWARDING)) {
            boolean forwarding = FileSystemProviderSupport.getBooleanValue((Map)this, (String)AGENT_FORWARDING);
            channel.setAgentForwarding(forwarding);
        }
        if (this.containsKey(FILENAME_ENCODING)) {
            String filenameEncoding = (String)FileSystemProviderSupport.getValue((Map)this, (String)FILENAME_ENCODING, String.class, null);
            try {
                channel.setFilenameEncoding(filenameEncoding);
            }
            catch (SftpException e) {
                throw this.asFileSystemException((Exception)((Object)e));
            }
        }
    }

    void connect(ChannelSftp channel) throws IOException {
        try {
            if (this.containsKey(CONNECT_TIMEOUT)) {
                int connectTimeout = FileSystemProviderSupport.getIntValue((Map)this, (String)CONNECT_TIMEOUT);
                channel.connect(connectTimeout);
            } else {
                channel.connect();
            }
        }
        catch (JSchException e) {
            throw this.asFileSystemException((Exception)((Object)e));
        }
    }

    void initializePostConnect(ChannelSftp channel) throws IOException {
        String defaultDir = (String)FileSystemProviderSupport.getValue((Map)this, (String)DEFAULT_DIR, String.class, null);
        if (defaultDir != null) {
            try {
                channel.cd(defaultDir);
            }
            catch (SftpException e) {
                throw this.getExceptionFactory().createChangeWorkingDirectoryException(defaultDir, e);
            }
        }
    }

    void verifyConnection(ChannelSftp channel) throws IOException {
        try {
            channel.pwd();
        }
        catch (SftpException e) {
            throw this.asFileSystemException((Exception)((Object)e));
        }
    }

    FileSystemException asFileSystemException(Exception e) throws FileSystemException {
        if (e instanceof FileSystemException) {
            throw (FileSystemException)e;
        }
        FileSystemException exception = new FileSystemException(null, null, e.getMessage());
        exception.initCause(e);
        throw exception;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.map.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        return this.map.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        this.map.putAll(m);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.map.equals(o);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    public SFTPEnvironment clone() {
        try {
            SFTPEnvironment clone = (SFTPEnvironment)super.clone();
            clone.map = new HashMap<String, Object>(this.map);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }
}

