/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.filesystems.sftp;

import com.github.robtimus.filesystems.Messages;
import com.github.robtimus.filesystems.sftp.SFTPPath;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileStoreAttributeView;
import java.nio.file.attribute.PosixFileAttributeView;
import java.util.Objects;

class SFTPFileStore
extends FileStore {
    private final SFTPPath path;

    SFTPFileStore(SFTPPath path) {
        this.path = Objects.requireNonNull(path);
    }

    @Override
    public String name() {
        return "/";
    }

    @Override
    public String type() {
        return "sftp";
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public long getTotalSpace() throws IOException {
        return this.path.getTotalSpace();
    }

    @Override
    public long getUsableSpace() throws IOException {
        return this.path.getUsableSpace();
    }

    @Override
    public long getUnallocatedSpace() throws IOException {
        return this.path.getUnallocatedSpace();
    }

    @Override
    public boolean supportsFileAttributeView(Class<? extends FileAttributeView> type) {
        return type == BasicFileAttributeView.class || type == PosixFileAttributeView.class;
    }

    @Override
    public boolean supportsFileAttributeView(String name) {
        return "basic".equals(name) || "owner".equals(name) || "posix".equals(name);
    }

    @Override
    public <V extends FileStoreAttributeView> V getFileStoreAttributeView(Class<V> type) {
        Objects.requireNonNull(type);
        return null;
    }

    @Override
    public Object getAttribute(String attribute) throws IOException {
        if ("totalSpace".equals(attribute)) {
            return this.getTotalSpace();
        }
        if ("usableSpace".equals(attribute)) {
            return this.getUsableSpace();
        }
        if ("unallocatedSpace".equals(attribute)) {
            return this.getUnallocatedSpace();
        }
        throw Messages.fileStore().unsupportedAttribute(attribute);
    }
}

