/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.filesystems.sftp;

import com.github.robtimus.filesystems.AbstractDirectoryStream;
import com.github.robtimus.filesystems.FileSystemProviderSupport;
import com.github.robtimus.filesystems.LinkOptionSupport;
import com.github.robtimus.filesystems.Messages;
import com.github.robtimus.filesystems.PathMatcherSupport;
import com.github.robtimus.filesystems.URISupport;
import com.github.robtimus.filesystems.attribute.PosixFilePermissionSupport;
import com.github.robtimus.filesystems.attribute.SimpleGroupPrincipal;
import com.github.robtimus.filesystems.attribute.SimpleUserPrincipal;
import com.github.robtimus.filesystems.sftp.CopyOptions;
import com.github.robtimus.filesystems.sftp.OpenOptions;
import com.github.robtimus.filesystems.sftp.SFTPEnvironment;
import com.github.robtimus.filesystems.sftp.SFTPFileStore;
import com.github.robtimus.filesystems.sftp.SFTPFileSystemProvider;
import com.github.robtimus.filesystems.sftp.SFTPMessages;
import com.github.robtimus.filesystems.sftp.SFTPPath;
import com.github.robtimus.filesystems.sftp.SSHChannelPool;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpStatVFS;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.StandardOpenOption;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;

class SFTPFileSystem
extends FileSystem {
    private static final String CURRENT_DIR = ".";
    private static final String PARENT_DIR = "..";
    private static final Set<String> SUPPORTED_FILE_ATTRIBUTE_VIEWS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("basic", "owner", "posix")));
    private final SFTPFileSystemProvider provider;
    private final Iterable<Path> rootDirectories;
    private final Iterable<FileStore> fileStores;
    private final SSHChannelPool channelPool;
    private final URI uri;
    private final String defaultDirectory;
    private final AtomicBoolean open = new AtomicBoolean(true);
    private static final Set<String> BASIC_ATTRIBUTES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("basic:lastModifiedTime", "basic:lastAccessTime", "basic:creationTime", "basic:size", "basic:isRegularFile", "basic:isDirectory", "basic:isSymbolicLink", "basic:isOther", "basic:fileKey")));
    private static final Set<String> OWNER_ATTRIBUTES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("owner:owner")));
    private static final Set<String> POSIX_ATTRIBUTES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("posix:lastModifiedTime", "posix:lastAccessTime", "posix:creationTime", "posix:size", "posix:isRegularFile", "posix:isDirectory", "posix:isSymbolicLink", "posix:isOther", "posix:fileKey", "posix:owner", "posix:group", "posix:permissions")));

    SFTPFileSystem(SFTPFileSystemProvider provider, URI uri, SFTPEnvironment env) throws IOException {
        this.provider = Objects.requireNonNull(provider);
        SFTPPath rootPath = new SFTPPath(this, "/");
        this.rootDirectories = Collections.singleton(rootPath);
        this.fileStores = Collections.singleton(new SFTPFileStore(rootPath));
        this.channelPool = new SSHChannelPool(uri.getHost(), uri.getPort(), env);
        this.uri = Objects.requireNonNull(uri);
        try (SSHChannelPool.Channel channel = this.channelPool.get();){
            this.defaultDirectory = channel.pwd();
        }
    }

    @Override
    public FileSystemProvider provider() {
        return this.provider;
    }

    @Override
    public void close() throws IOException {
        if (this.open.getAndSet(false)) {
            this.provider.removeFileSystem(this.uri);
            this.channelPool.close();
        }
    }

    @Override
    public boolean isOpen() {
        return this.open.get();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public String getSeparator() {
        return "/";
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        return this.rootDirectories;
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        return this.fileStores;
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return SUPPORTED_FILE_ATTRIBUTE_VIEWS;
    }

    @Override
    public Path getPath(String first, String ... more) {
        StringBuilder sb = new StringBuilder(first);
        for (String s : more) {
            sb.append("/").append(s);
        }
        return new SFTPPath(this, sb.toString());
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        Pattern pattern = PathMatcherSupport.toPattern((String)syntaxAndPattern);
        return path -> pattern.matcher(path.toString()).matches();
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        throw Messages.unsupportedOperation(FileSystem.class, (String)"getUserPrincipalLookupService");
    }

    @Override
    public WatchService newWatchService() throws IOException {
        throw Messages.unsupportedOperation(FileSystem.class, (String)"newWatchService");
    }

    void keepAlive() throws IOException {
        this.channelPool.keepAlive();
    }

    URI toUri(SFTPPath path) {
        SFTPPath absPath = this.toAbsolutePath(path).normalize();
        return this.toUri(absPath.path());
    }

    URI toUri(String path) {
        return URISupport.create((String)this.uri.getScheme(), (String)this.uri.getUserInfo(), (String)this.uri.getHost(), (int)this.uri.getPort(), (String)path, null, null);
    }

    SFTPPath toAbsolutePath(SFTPPath path) {
        if (path.isAbsolute()) {
            return path;
        }
        return new SFTPPath(this, this.defaultDirectory + "/" + path.path());
    }

    SFTPPath toRealPath(SFTPPath path, LinkOption ... options) throws IOException {
        boolean followLinks = LinkOptionSupport.followLinks((LinkOption[])options);
        try (SSHChannelPool.Channel channel = this.channelPool.get();){
            SFTPPath sFTPPath = this.toRealPath(channel, path, followLinks).path;
            return sFTPPath;
        }
    }

    private SFTPPathAndAttributesPair toRealPath(SSHChannelPool.Channel channel, SFTPPath path, boolean followLinks) throws IOException {
        SFTPPath absPath = this.toAbsolutePath(path).normalize();
        SftpATTRS attributes = this.getAttributes(channel, absPath, false);
        if (followLinks && attributes.isLink()) {
            SFTPPath link = this.readSymbolicLink(channel, absPath);
            return this.toRealPath(channel, link, followLinks);
        }
        return new SFTPPathAndAttributesPair(absPath, attributes);
    }

    String toString(SFTPPath path) {
        return path.path();
    }

    InputStream newInputStream(SFTPPath path, OpenOption ... options) throws IOException {
        OpenOptions openOptions = OpenOptions.forNewInputStream(options);
        try (SSHChannelPool.Channel channel = this.channelPool.get();){
            InputStream inputStream = this.newInputStream(channel, path, openOptions);
            return inputStream;
        }
    }

    private InputStream newInputStream(SSHChannelPool.Channel channel, SFTPPath path, OpenOptions options) throws IOException {
        assert (options.read);
        return channel.newInputStream(path.path(), options);
    }

    OutputStream newOutputStream(SFTPPath path, OpenOption ... options) throws IOException {
        OpenOptions openOptions = OpenOptions.forNewOutputStream(options);
        try (SSHChannelPool.Channel channel = this.channelPool.get();){
            OutputStream outputStream = this.newOutputStream(channel, path, false, openOptions).out;
            return outputStream;
        }
    }

    private SFTPAttributesAndOutputStreamPair newOutputStream(SSHChannelPool.Channel channel, SFTPPath path, boolean requireAttributes, OpenOptions options) throws IOException {
        SftpATTRS attributes = null;
        if (!options.create || options.createNew) {
            attributes = this.findAttributes(channel, path, false);
            if (attributes != null && attributes.isDir()) {
                throw Messages.fileSystemProvider().isDirectory(path.path());
            }
            if (!options.createNew && attributes == null) {
                throw new NoSuchFileException(path.path());
            }
            if (options.createNew && attributes != null) {
                throw new FileAlreadyExistsException(path.path());
            }
        }
        if (attributes == null && requireAttributes) {
            attributes = this.findAttributes(channel, path, false);
        }
        OutputStream out = channel.newOutputStream(path.path(), options);
        return new SFTPAttributesAndOutputStreamPair(attributes, out);
    }

    SeekableByteChannel newByteChannel(SFTPPath path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        if (attrs.length > 0) {
            throw Messages.fileSystemProvider().unsupportedCreateFileAttribute(attrs[0].name());
        }
        OpenOptions openOptions = OpenOptions.forNewByteChannel(options);
        try (SSHChannelPool.Channel channel = this.channelPool.get();){
            if (openOptions.read) {
                SftpATTRS attributes = this.findAttributes(channel, path, false);
                InputStream in = this.newInputStream(channel, path, openOptions);
                long size = attributes == null ? 0L : attributes.getSize();
                SeekableByteChannel seekableByteChannel = FileSystemProviderSupport.createSeekableByteChannel((InputStream)in, (long)size);
                return seekableByteChannel;
            }
            boolean requireAttributes = openOptions.append;
            SFTPAttributesAndOutputStreamPair outPair = this.newOutputStream(channel, path, requireAttributes, openOptions);
            long initialPosition = outPair.attributes == null ? 0L : outPair.attributes.getSize();
            SeekableByteChannel seekableByteChannel = FileSystemProviderSupport.createSeekableByteChannel((OutputStream)outPair.out, (long)initialPosition);
            return seekableByteChannel;
        }
    }

    DirectoryStream<Path> newDirectoryStream(SFTPPath path, DirectoryStream.Filter<? super Path> filter) throws IOException {
        try (SSHChannelPool.Channel channel = this.channelPool.get();){
            SftpATTRS attributes;
            List<ChannelSftp.LsEntry> entries = channel.listFiles(path.path());
            boolean isDirectory = false;
            Iterator<ChannelSftp.LsEntry> i = entries.iterator();
            while (i.hasNext()) {
                ChannelSftp.LsEntry entry = i.next();
                String filename = entry.getFilename();
                if (CURRENT_DIR.equals(filename)) {
                    isDirectory = true;
                    i.remove();
                    continue;
                }
                if (!PARENT_DIR.equals(filename)) continue;
                i.remove();
            }
            if (!isDirectory && !(attributes = channel.readAttributes(path.path(), true)).isDir()) {
                throw new NotDirectoryException(path.path());
            }
            SFTPPathDirectoryStream sFTPPathDirectoryStream = new SFTPPathDirectoryStream(path, entries, filter);
            return sFTPPathDirectoryStream;
        }
    }

    void createDirectory(SFTPPath path, FileAttribute<?> ... attrs) throws IOException {
        if (attrs.length > 0) {
            throw Messages.fileSystemProvider().unsupportedCreateFileAttribute(attrs[0].name());
        }
        try (SSHChannelPool.Channel channel = this.channelPool.get();){
            channel.mkdir(path.path());
        }
    }

    void delete(SFTPPath path) throws IOException {
        try (SSHChannelPool.Channel channel = this.channelPool.get();){
            SftpATTRS attributes = this.getAttributes(channel, path, false);
            boolean isDirectory = attributes.isDir();
            channel.delete(path.path(), isDirectory);
        }
    }

    SFTPPath readSymbolicLink(SFTPPath path) throws IOException {
        try (SSHChannelPool.Channel channel = this.channelPool.get();){
            SFTPPath sFTPPath = this.readSymbolicLink(channel, path);
            return sFTPPath;
        }
    }

    private SFTPPath readSymbolicLink(SSHChannelPool.Channel channel, SFTPPath path) throws IOException {
        String link = channel.readSymbolicLink(path.path());
        return path.resolveSibling(link);
    }

    /*
     * Loose catch block
     */
    void copy(SFTPPath source, SFTPPath target, CopyOption ... options) throws IOException {
        block41: {
            SFTPPathAndAttributesPair sourcePair;
            Throwable throwable;
            SSHChannelPool.Channel channel;
            CopyOptions copyOptions;
            block38: {
                block39: {
                    block40: {
                        block35: {
                            block36: {
                                block37: {
                                    boolean sameFileSystem = this.haveSameFileSystem(source, target);
                                    copyOptions = CopyOptions.forCopy(options);
                                    channel = this.channelPool.get();
                                    throwable = null;
                                    sourcePair = this.toRealPath(channel, source, true);
                                    if (sameFileSystem) break block35;
                                    this.copyAcrossFileSystems(channel, source, sourcePair.attributes, target, copyOptions);
                                    if (channel == null) break block36;
                                    if (throwable == null) break block37;
                                    try {
                                        channel.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    break block36;
                                }
                                channel.close();
                            }
                            return;
                        }
                        if (!sourcePair.path.path().equals(this.toRealPath(channel, target, true).path.path())) break block38;
                        if (channel == null) break block39;
                        if (throwable == null) break block40;
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        break block39;
                    }
                    channel.close();
                }
                return;
            }
            try {
                block42: {
                    break block42;
                    catch (NoSuchFileException noSuchFileException) {
                        // empty catch block
                    }
                }
                SftpATTRS targetAttributes = this.findAttributes(channel, target, false);
                if (targetAttributes != null) {
                    if (copyOptions.replaceExisting) {
                        channel.delete(target.path(), targetAttributes.isDir());
                    } else {
                        throw new FileAlreadyExistsException(target.path());
                    }
                }
                if (sourcePair.attributes.isDir()) {
                    channel.mkdir(target.path());
                    break block41;
                }
                try (SSHChannelPool.Channel channel2 = this.channelPool.getOrCreate();){
                    this.copyFile(channel, source, channel2, target, copyOptions);
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            catch (Throwable throwable5) {
                throw throwable5;
            }
            finally {
                if (channel != null) {
                    if (throwable != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                    } else {
                        channel.close();
                    }
                }
            }
        }
    }

    private void copyAcrossFileSystems(SSHChannelPool.Channel sourceChannel, SFTPPath source, SftpATTRS sourceAttributes, SFTPPath target, CopyOptions options) throws IOException {
        SFTPFileSystem targetFileSystem = target.getFileSystem();
        try (SSHChannelPool.Channel targetChannel = targetFileSystem.channelPool.getOrCreate();){
            SftpATTRS targetAttributes = this.findAttributes(targetChannel, target, false);
            if (targetAttributes != null) {
                if (options.replaceExisting) {
                    targetChannel.delete(target.path(), targetAttributes.isDir());
                } else {
                    throw new FileAlreadyExistsException(target.path());
                }
            }
            if (sourceAttributes.isDir()) {
                targetChannel.mkdir(target.path());
            } else {
                this.copyFile(sourceChannel, source, targetChannel, target, options);
            }
        }
    }

    private void copyFile(SSHChannelPool.Channel sourceChannel, SFTPPath source, SSHChannelPool.Channel targetChannel, SFTPPath target, CopyOptions options) throws IOException {
        OpenOptions inOptions = OpenOptions.forNewInputStream(options.toOpenOptions(StandardOpenOption.READ));
        OpenOptions outOptions = OpenOptions.forNewOutputStream(options.toOpenOptions(StandardOpenOption.WRITE, StandardOpenOption.CREATE));
        try (InputStream in = sourceChannel.newInputStream(source.path(), inOptions);){
            targetChannel.storeFile(target.path(), in, outOptions.options);
        }
    }

    /*
     * Loose catch block
     */
    void move(SFTPPath source, SFTPPath target, CopyOption ... options) throws IOException {
        Throwable throwable;
        SSHChannelPool.Channel channel;
        CopyOptions copyOptions;
        block25: {
            block26: {
                block27: {
                    block22: {
                        block23: {
                            block24: {
                                boolean sameFileSystem = this.haveSameFileSystem(source, target);
                                copyOptions = CopyOptions.forMove(sameFileSystem, options);
                                channel = this.channelPool.get();
                                throwable = null;
                                if (sameFileSystem) break block22;
                                SftpATTRS attributes = this.getAttributes(channel, source, false);
                                if (attributes.isLink()) {
                                    throw new IOException(SFTPMessages.copyOfSymbolicLinksAcrossFileSystemsNotSupported());
                                }
                                this.copyAcrossFileSystems(channel, source, attributes, target, copyOptions);
                                channel.delete(source.path(), attributes.isDir());
                                if (channel == null) break block23;
                                if (throwable == null) break block24;
                                try {
                                    channel.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break block23;
                            }
                            channel.close();
                        }
                        return;
                    }
                    if (!this.isSameFile(channel, source, target)) break block25;
                    if (channel == null) break block26;
                    if (throwable == null) break block27;
                    try {
                        channel.close();
                    }
                    catch (Throwable attributes) {
                        throwable.addSuppressed(attributes);
                    }
                    break block26;
                }
                channel.close();
            }
            return;
        }
        try {
            block29: {
                break block29;
                catch (NoSuchFileException e) {
                    this.getAttributes(channel, source, false);
                }
            }
            if (this.toAbsolutePath(source).parentPath() == null) {
                throw new DirectoryNotEmptyException(source.path());
            }
            SftpATTRS targetAttributes = this.findAttributes(channel, target, false);
            if (copyOptions.replaceExisting && targetAttributes != null) {
                channel.delete(target.path(), targetAttributes.isDir());
            }
            channel.rename(source.path(), target.path());
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        catch (Throwable throwable4) {
            throw throwable4;
        }
        finally {
            if (channel != null) {
                if (throwable != null) {
                    try {
                        channel.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    channel.close();
                }
            }
        }
    }

    boolean isSameFile(SFTPPath path, SFTPPath path2) throws IOException {
        if (!this.haveSameFileSystem(path, path2)) {
            return false;
        }
        if (path.equals((Object)path2)) {
            return true;
        }
        try (SSHChannelPool.Channel channel = this.channelPool.get();){
            boolean bl = this.isSameFile(channel, path, path2);
            return bl;
        }
    }

    private boolean haveSameFileSystem(SFTPPath path, SFTPPath path2) {
        return path.getFileSystem() == path2.getFileSystem();
    }

    private boolean isSameFile(SSHChannelPool.Channel channel, SFTPPath path, SFTPPath path2) throws IOException {
        if (path.equals((Object)path2)) {
            return true;
        }
        return this.toRealPath(channel, path, true).path.path().equals(this.toRealPath(channel, path2, true).path.path());
    }

    boolean isHidden(SFTPPath path) throws IOException {
        try (SSHChannelPool.Channel channel = this.channelPool.get();){
            this.getAttributes(channel, path, false);
        }
        String fileName = path.fileName();
        return !CURRENT_DIR.equals(fileName) && !PARENT_DIR.equals(fileName) && fileName.startsWith(CURRENT_DIR);
    }

    FileStore getFileStore(SFTPPath path) throws IOException {
        try (SSHChannelPool.Channel channel = this.channelPool.get();){
            this.getAttributes(channel, path, false);
        }
        return new SFTPFileStore(path);
    }

    void checkAccess(SFTPPath path, AccessMode ... modes) throws IOException {
        try (SSHChannelPool.Channel channel = this.channelPool.get();){
            SftpATTRS attributes = this.getAttributes(channel, path, true);
            for (AccessMode mode : modes) {
                if (this.hasAccess(attributes, mode)) continue;
                throw new AccessDeniedException(path.path());
            }
        }
    }

    private boolean hasAccess(SftpATTRS attrs, AccessMode mode) {
        switch (mode) {
            case READ: {
                return PosixFilePermissionSupport.hasPermission((int)attrs.getPermissions(), (PosixFilePermission)PosixFilePermission.OWNER_READ);
            }
            case WRITE: {
                return PosixFilePermissionSupport.hasPermission((int)attrs.getPermissions(), (PosixFilePermission)PosixFilePermission.OWNER_WRITE);
            }
            case EXECUTE: {
                return PosixFilePermissionSupport.hasPermission((int)attrs.getPermissions(), (PosixFilePermission)PosixFilePermission.OWNER_EXECUTE);
            }
        }
        return false;
    }

    PosixFileAttributes readAttributes(SFTPPath path, LinkOption ... options) throws IOException {
        boolean followLinks = LinkOptionSupport.followLinks((LinkOption[])options);
        try (SSHChannelPool.Channel channel = this.channelPool.get();){
            SftpATTRS attributes = this.getAttributes(channel, path, followLinks);
            SFTPPathFileAttributes sFTPPathFileAttributes = new SFTPPathFileAttributes(attributes);
            return sFTPPathFileAttributes;
        }
    }

    Map<String, Object> readAttributes(SFTPPath path, String attributes, LinkOption ... options) throws IOException {
        Set<String> allowedAttributes;
        String view;
        int pos = attributes.indexOf(58);
        if (pos == -1) {
            view = "basic";
            attributes = "basic:" + attributes;
        } else {
            view = attributes.substring(0, pos);
        }
        if (!SUPPORTED_FILE_ATTRIBUTE_VIEWS.contains(view)) {
            throw Messages.fileSystemProvider().unsupportedFileAttributeView(view);
        }
        if (attributes.startsWith("basic:")) {
            allowedAttributes = BASIC_ATTRIBUTES;
        } else if (attributes.startsWith("owner:")) {
            allowedAttributes = OWNER_ATTRIBUTES;
        } else if (attributes.startsWith("posix:")) {
            allowedAttributes = POSIX_ATTRIBUTES;
        } else {
            throw Messages.fileSystemProvider().unsupportedFileAttributeView(attributes.substring(0, attributes.indexOf(58)));
        }
        Map<String, Object> result = this.getAttributeMap(attributes, allowedAttributes);
        PosixFileAttributes posixAttributes = this.readAttributes(path, options);
        block38: for (Map.Entry<String, Object> entry : result.entrySet()) {
            switch (entry.getKey()) {
                case "basic:lastModifiedTime": 
                case "posix:lastModifiedTime": {
                    entry.setValue(posixAttributes.lastModifiedTime());
                    continue block38;
                }
                case "basic:lastAccessTime": 
                case "posix:lastAccessTime": {
                    entry.setValue(posixAttributes.lastAccessTime());
                    continue block38;
                }
                case "basic:creationTime": 
                case "posix:creationTime": {
                    entry.setValue(posixAttributes.creationTime());
                    continue block38;
                }
                case "basic:size": 
                case "posix:size": {
                    entry.setValue(posixAttributes.size());
                    continue block38;
                }
                case "basic:isRegularFile": 
                case "posix:isRegularFile": {
                    entry.setValue(posixAttributes.isRegularFile());
                    continue block38;
                }
                case "basic:isDirectory": 
                case "posix:isDirectory": {
                    entry.setValue(posixAttributes.isDirectory());
                    continue block38;
                }
                case "basic:isSymbolicLink": 
                case "posix:isSymbolicLink": {
                    entry.setValue(posixAttributes.isSymbolicLink());
                    continue block38;
                }
                case "basic:isOther": 
                case "posix:isOther": {
                    entry.setValue(posixAttributes.isOther());
                    continue block38;
                }
                case "basic:fileKey": 
                case "posix:fileKey": {
                    entry.setValue(posixAttributes.fileKey());
                    continue block38;
                }
                case "owner:owner": 
                case "posix:owner": {
                    entry.setValue(posixAttributes.owner());
                    continue block38;
                }
                case "posix:group": {
                    entry.setValue(posixAttributes.group());
                    continue block38;
                }
                case "posix:permissions": {
                    entry.setValue(posixAttributes.permissions());
                    continue block38;
                }
            }
            throw new IllegalStateException("unexpected attribute name: " + entry.getKey());
        }
        return result;
    }

    private Map<String, Object> getAttributeMap(String attributes, Set<String> allowedAttributes) {
        int indexOfColon = attributes.indexOf(58);
        String prefix = attributes.substring(0, indexOfColon + 1);
        attributes = attributes.substring(indexOfColon + 1);
        String[] attributeList = attributes.split(",");
        HashMap<String, Object> result = new HashMap<String, Object>(allowedAttributes.size());
        for (String attribute : attributeList) {
            String prefixedAttribute = prefix + attribute;
            if (allowedAttributes.contains(prefixedAttribute)) {
                result.put(prefixedAttribute, null);
                continue;
            }
            if ("*".equals(attribute)) {
                for (String s : allowedAttributes) {
                    result.put(s, null);
                }
                continue;
            }
            throw Messages.fileSystemProvider().unsupportedFileAttribute(attribute);
        }
        return result;
    }

    void setOwner(SFTPPath path, UserPrincipal owner) throws IOException {
        this.setOwner(path, owner, false);
    }

    private void setOwner(SFTPPath path, UserPrincipal owner, boolean followLinks) throws IOException {
        try {
            int uid = Integer.parseInt(owner.getName());
            try (SSHChannelPool.Channel channel = this.channelPool.get();){
                if (followLinks) {
                    path = this.toRealPath(channel, path, followLinks).path;
                }
                channel.chown(path.path(), uid);
            }
        }
        catch (NumberFormatException e) {
            throw new IOException(e);
        }
    }

    void setGroup(SFTPPath path, GroupPrincipal group) throws IOException {
        this.setGroup(path, group, false);
    }

    private void setGroup(SFTPPath path, GroupPrincipal group, boolean followLinks) throws IOException {
        try {
            int gid = Integer.parseInt(group.getName());
            try (SSHChannelPool.Channel channel = this.channelPool.get();){
                if (followLinks) {
                    path = this.toRealPath(channel, path, followLinks).path;
                }
                channel.chgrp(path.path(), gid);
            }
        }
        catch (NumberFormatException e) {
            throw new IOException(e);
        }
    }

    void setPermissions(SFTPPath path, Set<PosixFilePermission> permissions) throws IOException {
        this.setPermissions(path, permissions, false);
    }

    private void setPermissions(SFTPPath path, Set<PosixFilePermission> permissions, boolean followLinks) throws IOException {
        try (SSHChannelPool.Channel channel = this.channelPool.get();){
            if (followLinks) {
                path = this.toRealPath(channel, path, followLinks).path;
            }
            channel.chmod(path.path(), PosixFilePermissionSupport.toMask(permissions));
        }
    }

    void setTimes(SFTPPath path, FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) throws IOException {
        if (lastAccessTime != null) {
            throw new IOException(Messages.fileSystemProvider().unsupportedFileAttribute("lastAccessTime"));
        }
        if (createTime != null) {
            throw new IOException(Messages.fileSystemProvider().unsupportedFileAttribute("createAccessTime"));
        }
        if (lastModifiedTime != null) {
            this.setLastModifiedTime(path, lastModifiedTime, false);
        }
    }

    void setLastModifiedTime(SFTPPath path, FileTime lastModifiedTime, boolean followLinks) throws IOException {
        try (SSHChannelPool.Channel channel = this.channelPool.get();){
            if (followLinks) {
                path = this.toRealPath(channel, path, followLinks).path;
            }
            channel.setMtime(path.path(), lastModifiedTime.to(TimeUnit.SECONDS));
        }
    }

    void setAttribute(SFTPPath path, String attribute, Object value, LinkOption ... options) throws IOException {
        String view;
        int pos = attribute.indexOf(58);
        if (pos == -1) {
            view = "basic";
            attribute = "basic:" + attribute;
        } else {
            view = attribute.substring(0, pos);
        }
        if (!("basic".equals(view) || "owner".equals(view) || "posix".equals(view))) {
            throw Messages.fileSystemProvider().unsupportedFileAttributeView(view);
        }
        boolean followLinks = LinkOptionSupport.followLinks((LinkOption[])options);
        switch (attribute) {
            case "basic:lastModifiedTime": 
            case "posix:lastModifiedTime": {
                this.setLastModifiedTime(path, (FileTime)value, followLinks);
                break;
            }
            case "owner:owner": 
            case "posix:owner": {
                this.setOwner(path, (UserPrincipal)value, followLinks);
                break;
            }
            case "posix:group": {
                this.setGroup(path, (GroupPrincipal)value, followLinks);
                break;
            }
            case "posix:permissions": {
                Set permissions = (Set)value;
                this.setPermissions(path, permissions, followLinks);
                break;
            }
            default: {
                throw Messages.fileSystemProvider().unsupportedFileAttribute(attribute);
            }
        }
    }

    private SftpATTRS getAttributes(SSHChannelPool.Channel channel, SFTPPath path, boolean followLinks) throws IOException {
        return channel.readAttributes(path.path(), followLinks);
    }

    private SftpATTRS findAttributes(SSHChannelPool.Channel channel, SFTPPath path, boolean followLinks) throws IOException {
        try {
            return this.getAttributes(channel, path, followLinks);
        }
        catch (NoSuchFileException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    long getTotalSpace(SFTPPath path) throws IOException {
        try (SSHChannelPool.Channel channel = this.channelPool.get();){
            SftpStatVFS stat = channel.statVFS(path.path());
            long l = stat.getFragmentSize() * stat.getBlocks();
            return l;
        }
        catch (UnsupportedOperationException e) {
            return Long.MAX_VALUE;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    long getUsableSpace(SFTPPath path) throws IOException {
        try (SSHChannelPool.Channel channel = this.channelPool.get();){
            SftpStatVFS stat = channel.statVFS(path.path());
            long l = stat.getFragmentSize() * stat.getAvailBlocks();
            return l;
        }
        catch (UnsupportedOperationException e) {
            return Long.MAX_VALUE;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    long getUnallocatedSpace(SFTPPath path) throws IOException {
        try (SSHChannelPool.Channel channel = this.channelPool.get();){
            SftpStatVFS stat = channel.statVFS(path.path());
            long l = stat.getFragmentSize() * stat.getFreeBlocks();
            return l;
        }
        catch (UnsupportedOperationException e) {
            return Long.MAX_VALUE;
        }
    }

    private static final class SFTPPathFileAttributes
    implements PosixFileAttributes {
        private final SftpATTRS attributes;

        private SFTPPathFileAttributes(SftpATTRS attributes) {
            this.attributes = attributes;
        }

        @Override
        public UserPrincipal owner() {
            String user = Integer.toString(this.attributes.getUId());
            return new SimpleUserPrincipal(user);
        }

        @Override
        public GroupPrincipal group() {
            String group = Integer.toString(this.attributes.getGId());
            return new SimpleGroupPrincipal(group);
        }

        @Override
        public Set<PosixFilePermission> permissions() {
            return PosixFilePermissionSupport.fromMask((int)this.attributes.getPermissions());
        }

        @Override
        public FileTime lastModifiedTime() {
            return FileTime.from(this.attributes.getMTime(), TimeUnit.SECONDS);
        }

        @Override
        public FileTime lastAccessTime() {
            return FileTime.from(this.attributes.getATime(), TimeUnit.SECONDS);
        }

        @Override
        public FileTime creationTime() {
            return this.lastModifiedTime();
        }

        @Override
        public boolean isRegularFile() {
            return this.attributes.isReg();
        }

        @Override
        public boolean isDirectory() {
            return this.attributes.isDir();
        }

        @Override
        public boolean isSymbolicLink() {
            return this.attributes.isLink();
        }

        @Override
        public boolean isOther() {
            return !this.isRegularFile() && !this.isDirectory() && !this.isSymbolicLink();
        }

        @Override
        public long size() {
            return this.attributes.getSize();
        }

        @Override
        public Object fileKey() {
            return null;
        }
    }

    private static final class SFTPPathDirectoryStream
    extends AbstractDirectoryStream<Path> {
        private final SFTPPath path;
        private final List<ChannelSftp.LsEntry> entries;
        private Iterator<ChannelSftp.LsEntry> iterator;

        private SFTPPathDirectoryStream(SFTPPath path, List<ChannelSftp.LsEntry> entries, DirectoryStream.Filter<? super Path> filter) {
            super(filter);
            this.path = path;
            this.entries = entries;
        }

        protected void setupIteration() {
            this.iterator = this.entries.iterator();
        }

        protected Path getNext() throws IOException {
            return this.iterator.hasNext() ? this.path.resolve(this.iterator.next().getFilename()) : null;
        }
    }

    private static final class SFTPAttributesAndOutputStreamPair {
        private final SftpATTRS attributes;
        private final OutputStream out;

        private SFTPAttributesAndOutputStreamPair(SftpATTRS attributes, OutputStream out) {
            this.attributes = attributes;
            this.out = out;
        }
    }

    private static final class SFTPPathAndAttributesPair {
        private final SFTPPath path;
        private final SftpATTRS attributes;

        private SFTPPathAndAttributesPair(SFTPPath path, SftpATTRS attributes) {
            this.path = path;
            this.attributes = attributes;
        }
    }
}

