/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.filesystems.sftp;

import com.github.robtimus.filesystems.Messages;
import com.github.robtimus.filesystems.URISupport;
import com.github.robtimus.filesystems.sftp.SFTPEnvironment;
import com.github.robtimus.filesystems.sftp.SFTPFileSystem;
import com.github.robtimus.filesystems.sftp.SFTPPath;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.spi.FileSystemProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class SFTPFileSystemProvider
extends FileSystemProvider {
    private final Map<URI, SFTPFileSystem> fileSystems = new HashMap<URI, SFTPFileSystem>();

    @Override
    public String getScheme() {
        return "sftp";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileSystem newFileSystem(URI uri, Map<String, ?> env) throws IOException {
        this.checkURI(uri, false, false);
        SFTPEnvironment environment = this.wrapEnvironment(env);
        String username = environment.getUsername();
        URI normalizedURI = this.normalizeWithUsername(uri, username);
        Map<URI, SFTPFileSystem> map = this.fileSystems;
        synchronized (map) {
            if (this.fileSystems.containsKey(normalizedURI)) {
                throw new FileSystemAlreadyExistsException(normalizedURI.toString());
            }
            SFTPFileSystem fs = new SFTPFileSystem(this, normalizedURI, environment);
            this.fileSystems.put(normalizedURI, fs);
            return fs;
        }
    }

    SFTPEnvironment wrapEnvironment(Map<String, ?> env) {
        return SFTPEnvironment.wrap(env);
    }

    @Override
    public FileSystem getFileSystem(URI uri) {
        this.checkURI(uri, true, false);
        return this.getExistingFileSystem(uri);
    }

    @Override
    public Path getPath(URI uri) {
        this.checkURI(uri, true, true);
        SFTPFileSystem fs = this.getExistingFileSystem(uri);
        return fs.getPath(uri.getPath(), new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SFTPFileSystem getExistingFileSystem(URI uri) {
        URI normalizedURI = this.normalizeWithoutPassword(uri);
        Map<URI, SFTPFileSystem> map = this.fileSystems;
        synchronized (map) {
            SFTPFileSystem fs = this.fileSystems.get(normalizedURI);
            if (fs == null) {
                throw new FileSystemNotFoundException(uri.toString());
            }
            return fs;
        }
    }

    private void checkURI(URI uri, boolean allowUserInfo, boolean allowPath) {
        if (!uri.isAbsolute()) {
            throw Messages.uri().notAbsolute(uri);
        }
        if (!this.getScheme().equalsIgnoreCase(uri.getScheme())) {
            throw Messages.uri().invalidScheme(uri, this.getScheme());
        }
        if (!allowUserInfo && uri.getUserInfo() != null && !uri.getUserInfo().isEmpty()) {
            throw Messages.uri().hasUserInfo(uri);
        }
        if (uri.isOpaque()) {
            throw Messages.uri().notHierarchical(uri);
        }
        if (!allowPath && uri.getPath() != null && !uri.getPath().isEmpty()) {
            throw Messages.uri().hasPath(uri);
        }
        if (uri.getQuery() != null && !uri.getQuery().isEmpty()) {
            throw Messages.uri().hasQuery(uri);
        }
        if (uri.getFragment() != null && !uri.getFragment().isEmpty()) {
            throw Messages.uri().hasFragment(uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFileSystem(URI uri) {
        URI normalizedURI = this.normalizeWithoutPassword(uri);
        Map<URI, SFTPFileSystem> map = this.fileSystems;
        synchronized (map) {
            this.fileSystems.remove(normalizedURI);
        }
    }

    private URI normalizeWithoutPassword(URI uri) {
        String userInfo = uri.getUserInfo();
        if (userInfo == null && uri.getPath() == null && uri.getQuery() == null && uri.getFragment() == null) {
            return uri;
        }
        String username = null;
        if (userInfo != null) {
            int index = userInfo.indexOf(58);
            username = index == -1 ? userInfo : userInfo.substring(0, index);
        }
        return URISupport.create((String)uri.getScheme(), (String)username, (String)uri.getHost(), (int)uri.getPort(), null, null, null);
    }

    private URI normalizeWithUsername(URI uri, String username) {
        if (username == null && uri.getUserInfo() == null && uri.getPath() == null && uri.getQuery() == null && uri.getFragment() == null) {
            return uri;
        }
        return URISupport.create((String)uri.getScheme(), (String)username, (String)uri.getHost(), (int)uri.getPort(), null, null, null);
    }

    @Override
    public InputStream newInputStream(Path path, OpenOption ... options) throws IOException {
        return SFTPFileSystemProvider.toSFTPPath(path).newInputStream(options);
    }

    @Override
    public OutputStream newOutputStream(Path path, OpenOption ... options) throws IOException {
        return SFTPFileSystemProvider.toSFTPPath(path).newOutputStream(options);
    }

    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return SFTPFileSystemProvider.toSFTPPath(path).newByteChannel(options, attrs);
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        return SFTPFileSystemProvider.toSFTPPath(dir).newDirectoryStream(filter);
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        SFTPFileSystemProvider.toSFTPPath(dir).createDirectory(attrs);
    }

    @Override
    public void delete(Path path) throws IOException {
        SFTPFileSystemProvider.toSFTPPath(path).delete();
    }

    @Override
    public Path readSymbolicLink(Path link) throws IOException {
        return SFTPFileSystemProvider.toSFTPPath(link).readSymbolicLink();
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        SFTPFileSystemProvider.toSFTPPath(source).copy(SFTPFileSystemProvider.toSFTPPath(target), options);
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) throws IOException {
        SFTPFileSystemProvider.toSFTPPath(source).move(SFTPFileSystemProvider.toSFTPPath(target), options);
    }

    @Override
    public boolean isSameFile(Path path, Path path2) throws IOException {
        return SFTPFileSystemProvider.toSFTPPath(path).isSameFile(path2);
    }

    @Override
    public boolean isHidden(Path path) throws IOException {
        return SFTPFileSystemProvider.toSFTPPath(path).isHidden();
    }

    @Override
    public FileStore getFileStore(Path path) throws IOException {
        return SFTPFileSystemProvider.toSFTPPath(path).getFileStore();
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) throws IOException {
        SFTPFileSystemProvider.toSFTPPath(path).checkAccess(modes);
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        Objects.requireNonNull(type);
        if (type == BasicFileAttributeView.class) {
            return (V)((FileAttributeView)type.cast(new AttributeView("basic", SFTPFileSystemProvider.toSFTPPath(path))));
        }
        if (type == FileOwnerAttributeView.class) {
            return (V)((FileAttributeView)type.cast(new AttributeView("owner", SFTPFileSystemProvider.toSFTPPath(path))));
        }
        if (type == PosixFileAttributeView.class) {
            return (V)((FileAttributeView)type.cast(new AttributeView("posix", SFTPFileSystemProvider.toSFTPPath(path))));
        }
        return null;
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        if (type == BasicFileAttributes.class || type == PosixFileAttributes.class) {
            return (A)((BasicFileAttributes)type.cast(SFTPFileSystemProvider.toSFTPPath(path).readAttributes(options)));
        }
        throw Messages.fileSystemProvider().unsupportedFileAttributesType(type);
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        return SFTPFileSystemProvider.toSFTPPath(path).readAttributes(attributes, options);
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) throws IOException {
        SFTPFileSystemProvider.toSFTPPath(path).setAttribute(attribute, value, options);
    }

    private static SFTPPath toSFTPPath(Path path) {
        Objects.requireNonNull(path);
        if (path instanceof SFTPPath) {
            return (SFTPPath)((Object)path);
        }
        throw new ProviderMismatchException();
    }

    public static void keepAlive(FileSystem fs) throws IOException {
        if (fs instanceof SFTPFileSystem) {
            ((SFTPFileSystem)fs).keepAlive();
            return;
        }
        throw new ProviderMismatchException();
    }

    private static final class AttributeView
    implements PosixFileAttributeView {
        private final String name;
        private final SFTPPath path;

        private AttributeView(String name, SFTPPath path) {
            this.name = Objects.requireNonNull(name);
            this.path = Objects.requireNonNull(path);
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public UserPrincipal getOwner() throws IOException {
            return this.readAttributes().owner();
        }

        @Override
        public PosixFileAttributes readAttributes() throws IOException {
            return this.path.readAttributes(new LinkOption[0]);
        }

        @Override
        public void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) throws IOException {
            this.path.setTimes(lastModifiedTime, lastAccessTime, createTime);
        }

        @Override
        public void setOwner(UserPrincipal owner) throws IOException {
            this.path.setOwner(owner);
        }

        @Override
        public void setGroup(GroupPrincipal group) throws IOException {
            this.path.setGroup(group);
        }

        @Override
        public void setPermissions(Set<PosixFilePermission> perms) throws IOException {
            this.path.setPermissions(perms);
        }
    }
}

