/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.filesystems.sftp;

import com.github.robtimus.filesystems.UTF8Control;
import java.io.IOException;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SFTPLogger {
    private static final String BUNDLE_NAME = "com.github.robtimus.filesystems.sftp.fs";
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("com.github.robtimus.filesystems.sftp.fs", (ResourceBundle.Control)UTF8Control.INSTANCE);

    private SFTPLogger() {
        throw new IllegalStateException("cannot create instances of " + this.getClass().getName());
    }

    public static Logger createLogger(Class<?> clazz) {
        try {
            return LoggerFactory.getLogger(clazz);
        }
        catch (NoClassDefFoundError e) {
            return null;
        }
    }

    private static synchronized String getMessage(String key) {
        return BUNDLE.getString(key);
    }

    public static void creatingPool(Logger logger, String hostname, int port, int poolSize, long poolWaitTimeout) {
        if (logger != null && logger.isDebugEnabled()) {
            if (port == -1) {
                logger.debug(String.format(SFTPLogger.getMessage("log.creatingPoolWithoutPort"), hostname, poolSize, poolWaitTimeout));
            } else {
                logger.debug(String.format(SFTPLogger.getMessage("log.creatingPoolWithPort"), hostname, port, poolSize, poolWaitTimeout));
            }
        }
    }

    public static void createdPool(Logger logger, String hostname, int port, int poolSize) {
        if (logger != null && logger.isDebugEnabled()) {
            if (port == -1) {
                logger.debug(String.format(SFTPLogger.getMessage("log.createdPoolWithoutPort"), hostname, poolSize));
            } else {
                logger.debug(String.format(SFTPLogger.getMessage("log.createdPoolWithPort"), hostname, port, poolSize));
            }
        }
    }

    public static void failedToCreatePool(Logger logger, IOException e) {
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug(SFTPLogger.getMessage("log.failedToCreatePool"), (Throwable)e);
        }
    }

    public static void createdChannel(Logger logger, String channelId, boolean pooled) {
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug(String.format(SFTPLogger.getMessage("log.createdChannel"), channelId, pooled));
        }
    }

    public static void tookChannel(Logger logger, String channelId, int poolSize) {
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug(String.format(SFTPLogger.getMessage("log.tookChannel"), channelId, poolSize));
        }
    }

    public static void channelNotConnected(Logger logger, String channelId) {
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug(String.format(SFTPLogger.getMessage("log.channelNotConnected"), channelId));
        }
    }

    public static void returnedChannel(Logger logger, String channelId, int poolSize) {
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug(String.format(SFTPLogger.getMessage("log.returnedChannel"), channelId, poolSize));
        }
    }

    public static void returnedBrokenChannel(Logger logger, String channelId, int poolSize) {
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug(String.format(SFTPLogger.getMessage("log.returnedBrokenChannel"), channelId, poolSize));
        }
    }

    public static void drainedPoolForKeepAlive(Logger logger) {
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug(SFTPLogger.getMessage("log.drainedPoolForKeepAlive"));
        }
    }

    public static void drainedPoolForClose(Logger logger) {
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug(SFTPLogger.getMessage("log.drainedPoolForClose"));
        }
    }

    public static void increasedRefCount(Logger logger, String channelId, int refCount) {
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug(String.format(SFTPLogger.getMessage("log.increasedRefCount"), channelId, refCount));
        }
    }

    public static void decreasedRefCount(Logger logger, String channelId, int refCount) {
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug(String.format(SFTPLogger.getMessage("log.decreasedRefCount"), channelId, refCount));
        }
    }

    public static void disconnectedChannel(Logger logger, String channelId) {
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug(String.format(SFTPLogger.getMessage("log.disconnectedChannel"), channelId));
        }
    }

    public static void createdInputStream(Logger logger, String channelId, String path) {
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug(String.format(SFTPLogger.getMessage("log.createdInputStream"), channelId, path));
        }
    }

    public static void closedInputStream(Logger logger, String channelId, String path) {
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug(String.format(SFTPLogger.getMessage("log.closedInputStream"), channelId, path));
        }
    }

    public static void createdOutputStream(Logger logger, String channelId, String path) {
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug(String.format(SFTPLogger.getMessage("log.createdOutputStream"), channelId, path));
        }
    }

    public static void closedOutputStream(Logger logger, String channelId, String path) {
        if (logger != null && logger.isDebugEnabled()) {
            logger.debug(String.format(SFTPLogger.getMessage("log.closedOutputStream"), channelId, path));
        }
    }
}

