/*
 * Decompiled with CFR 0.152.
 */
package com.github.robtimus.filesystems.sftp;

import com.github.robtimus.filesystems.Messages;
import com.github.robtimus.filesystems.SimpleAbstractPath;
import com.github.robtimus.filesystems.sftp.SFTPFileSystem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

class SFTPPath
extends SimpleAbstractPath {
    private final SFTPFileSystem fs;

    SFTPPath(SFTPFileSystem fs, String path) {
        super(path);
        this.fs = Objects.requireNonNull(fs);
    }

    private SFTPPath(SFTPFileSystem fs, String path, boolean normalized) {
        super(path, normalized);
        this.fs = Objects.requireNonNull(fs);
    }

    protected SFTPPath createPath(String path) {
        return new SFTPPath(this.fs, path, true);
    }

    public SFTPFileSystem getFileSystem() {
        return this.fs;
    }

    public SFTPPath getRoot() {
        return (SFTPPath)((Object)super.getRoot());
    }

    public SFTPPath getFileName() {
        return (SFTPPath)((Object)super.getFileName());
    }

    public SFTPPath getParent() {
        return (SFTPPath)((Object)super.getParent());
    }

    public SFTPPath getName(int index) {
        return (SFTPPath)((Object)super.getName(index));
    }

    public SFTPPath subpath(int beginIndex, int endIndex) {
        return (SFTPPath)((Object)super.subpath(beginIndex, endIndex));
    }

    public SFTPPath normalize() {
        return (SFTPPath)((Object)super.normalize());
    }

    public SFTPPath resolve(Path other) {
        return (SFTPPath)((Object)super.resolve(other));
    }

    public SFTPPath resolve(String other) {
        return (SFTPPath)((Object)super.resolve(other));
    }

    public SFTPPath resolveSibling(Path other) {
        return (SFTPPath)((Object)super.resolveSibling(other));
    }

    public SFTPPath resolveSibling(String other) {
        return (SFTPPath)((Object)super.resolveSibling(other));
    }

    public SFTPPath relativize(Path other) {
        return (SFTPPath)((Object)super.relativize(other));
    }

    public URI toUri() {
        return this.fs.toUri(this);
    }

    public SFTPPath toAbsolutePath() {
        return this.fs.toAbsolutePath(this);
    }

    public SFTPPath toRealPath(LinkOption ... options) throws IOException {
        return this.fs.toRealPath(this, options);
    }

    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        throw Messages.unsupportedOperation(Path.class, (String)"register");
    }

    public String toString() {
        return this.fs.toString(this);
    }

    InputStream newInputStream(OpenOption ... options) throws IOException {
        return this.fs.newInputStream(this, options);
    }

    OutputStream newOutputStream(OpenOption ... options) throws IOException {
        return this.fs.newOutputStream(this, options);
    }

    SeekableByteChannel newByteChannel(Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return this.fs.newByteChannel(this, options, attrs);
    }

    DirectoryStream<Path> newDirectoryStream(DirectoryStream.Filter<? super Path> filter) throws IOException {
        return this.fs.newDirectoryStream(this, filter);
    }

    void createDirectory(FileAttribute<?> ... attrs) throws IOException {
        this.fs.createDirectory(this, attrs);
    }

    void delete() throws IOException {
        this.fs.delete(this);
    }

    SFTPPath readSymbolicLink() throws IOException {
        return this.fs.readSymbolicLink(this);
    }

    void copy(SFTPPath target, CopyOption ... options) throws IOException {
        this.fs.copy(this, target, options);
    }

    void move(SFTPPath target, CopyOption ... options) throws IOException {
        this.fs.move(this, target, options);
    }

    boolean isSameFile(Path other) throws IOException {
        if (this.equals(other)) {
            return true;
        }
        if (other == null || this.getFileSystem() != other.getFileSystem()) {
            return false;
        }
        return this.fs.isSameFile(this, (SFTPPath)((Object)other));
    }

    boolean isHidden() throws IOException {
        return this.fs.isHidden(this);
    }

    FileStore getFileStore() throws IOException {
        return this.fs.getFileStore(this);
    }

    void checkAccess(AccessMode ... modes) throws IOException {
        this.fs.checkAccess(this, modes);
    }

    PosixFileAttributes readAttributes(LinkOption ... options) throws IOException {
        return this.fs.readAttributes(this, options);
    }

    Map<String, Object> readAttributes(String attributes, LinkOption ... options) throws IOException {
        return this.fs.readAttributes(this, attributes, options);
    }

    void setOwner(UserPrincipal owner) throws IOException {
        this.fs.setOwner(this, owner);
    }

    void setGroup(GroupPrincipal group) throws IOException {
        this.fs.setGroup(this, group);
    }

    void setPermissions(Set<PosixFilePermission> permissions) throws IOException {
        this.fs.setPermissions(this, permissions);
    }

    void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) throws IOException {
        this.fs.setTimes(this, lastModifiedTime, lastAccessTime, createTime);
    }

    void setAttribute(String attribute, Object value, LinkOption ... options) throws IOException {
        this.fs.setAttribute(this, attribute, value, options);
    }

    long getTotalSpace() throws IOException {
        return this.fs.getTotalSpace(this);
    }

    long getUsableSpace() throws IOException {
        return this.fs.getUsableSpace(this);
    }

    long getUnallocatedSpace() throws IOException {
        return this.fs.getUnallocatedSpace(this);
    }
}

