/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.json;

import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import org.joda.time.DateTime;
import org.joda.time.LocalTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import play.api.libs.json.EnvReads;
import play.api.libs.json.EnvReads$;
import play.api.libs.json.JsError;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsNumber;
import play.api.libs.json.JsPath;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsString;
import play.api.libs.json.JsSuccess;
import play.api.libs.json.JsSuccess$;
import play.api.libs.json.JsValue;
import play.api.libs.json.JsonValidationError;
import play.api.libs.json.JsonValidationError$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Reads$class;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.math.BigDecimal;
import scala.util.control.Exception$;

public abstract class EnvReads$class {
    public static Reads dateReads(EnvReads $this, String pattern2, Function1 corrector) {
        return new Reads<java.util.Date>($this, pattern2, corrector){
            private final /* synthetic */ EnvReads $outer;
            private final String pattern$1;
            private final Function1 corrector$1;

            public <B> Reads<B> map(Function1<java.util.Date, B> f) {
                return Reads$class.map(this, f);
            }

            public <B> Reads<B> flatMap(Function1<java.util.Date, Reads<B>> f) {
                return Reads$class.flatMap(this, f);
            }

            public Reads<java.util.Date> filter(Function1<java.util.Date, Object> f) {
                return Reads$class.filter(this, f);
            }

            public Reads<java.util.Date> filter(JsonValidationError error, Function1<java.util.Date, Object> f) {
                return Reads$class.filter(this, error, f);
            }

            public Reads<java.util.Date> filterNot(Function1<java.util.Date, Object> f) {
                return Reads$class.filterNot(this, f);
            }

            public Reads<java.util.Date> filterNot(JsonValidationError error, Function1<java.util.Date, Object> f) {
                return Reads$class.filterNot(this, error, f);
            }

            public <B> Reads<B> collect(JsonValidationError error, PartialFunction<java.util.Date, B> f) {
                return Reads$class.collect(this, error, f);
            }

            public Reads<java.util.Date> orElse(Reads<java.util.Date> v) {
                return Reads$class.orElse(this, v);
            }

            public <B extends JsValue> Reads<java.util.Date> compose(Reads<B> rb) {
                return Reads$class.compose(this, rb);
            }

            public <B> Reads<B> andThen(Reads<B> rb, Predef$.less.colon.less<java.util.Date, JsValue> witness) {
                return Reads$class.andThen(this, rb, witness);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public JsResult<java.util.Date> reads(JsValue json) {
                void var5_8;
                JsValue jsValue = json;
                if (jsValue instanceof JsNumber) {
                    JsNumber jsNumber = (JsNumber)jsValue;
                    BigDecimal d = jsNumber.value();
                    JsSuccess<java.util.Date> jsSuccess = new JsSuccess<java.util.Date>(new java.util.Date(d.toLong()), JsSuccess$.MODULE$.apply$default$2());
                    return var5_8;
                } else if (jsValue instanceof JsString) {
                    void var11_16;
                    JsString jsString = (JsString)jsValue;
                    String s = jsString.value();
                    Option option = EnvReads$class.play$api$libs$json$EnvReads$$parseJDate(this.$outer, this.pattern$1, (String)this.corrector$1.apply((Object)s));
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        java.util.Date d = (java.util.Date)some.x();
                        JsSuccess<java.util.Date> jsSuccess = new JsSuccess<java.util.Date>(d, JsSuccess$.MODULE$.apply$default$2());
                    } else {
                        None$ none$ = None$.MODULE$;
                        Option option2 = option;
                        if (none$ != null ? !none$.equals(option2) : option2 != null) throw new MatchError((Object)option);
                        JsError jsError = new JsError((Seq<Tuple2<JsPath, Seq<JsonValidationError>>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)JsPath$.MODULE$), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new JsonValidationError[]{JsonValidationError$.MODULE$.apply("error.expected.date.isoformat", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.pattern$1}))})))}))));
                    }
                    void var5_6 = var11_16;
                    return var5_8;
                } else {
                    JsError jsError = new JsError((Seq<Tuple2<JsPath, Seq<JsonValidationError>>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)JsPath$.MODULE$), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new JsonValidationError[]{JsonValidationError$.MODULE$.apply("error.expected.date", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]))})))}))));
                }
                return var5_8;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.pattern$1 = pattern$1;
                this.corrector$1 = corrector$1;
                Reads$class.$init$(this);
            }
        };
    }

    public static Function1 dateReads$default$2(EnvReads $this) {
        return new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x) {
                return (String)Predef$.MODULE$.identity((Object)x);
            }
        };
    }

    public static Option play$api$libs$json$EnvReads$$parseJDate(EnvReads $this, String pattern2, String input) {
        Some some;
        SimpleDateFormat df = new SimpleDateFormat(pattern2);
        df.setLenient(false);
        try {
            some = new Some((Object)df.parse(input));
        }
        catch (ParseException parseException) {
            some = None$.MODULE$;
        }
        return some;
    }

    public static Reads sqlDateReads(EnvReads $this, String pattern2, Function1 corrector) {
        return $this.dateReads(pattern2, (Function1<String, String>)corrector).map(new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Date apply(java.util.Date d) {
                return new Date(d.getTime());
            }
        });
    }

    public static Function1 sqlDateReads$default$2(EnvReads $this) {
        return new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x) {
                return (String)Predef$.MODULE$.identity((Object)x);
            }
        };
    }

    public static Reads localDateTimeReads(EnvReads $this, Object parsing, Function1 corrector, Function1 p) {
        return new EnvReads.TemporalReads($this, parsing, (Function1<String, String>)corrector, p, new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final LocalDateTime apply(long millis) {
                return LocalDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneOffset.UTC);
            }
        });
    }

    public static Function1 localDateTimeReads$default$2(EnvReads $this) {
        return new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x) {
                return (String)Predef$.MODULE$.identity((Object)x);
            }
        };
    }

    public static Reads offsetDateTimeReads(EnvReads $this, Object parsing, Function1 corrector, Function1 p) {
        return new Reads<OffsetDateTime>($this, parsing, corrector, p){
            private final Object parsing$1;
            private final Function1 corrector$2;
            private final Function1 p$1;

            public <B> Reads<B> map(Function1<OffsetDateTime, B> f) {
                return Reads$class.map(this, f);
            }

            public <B> Reads<B> flatMap(Function1<OffsetDateTime, Reads<B>> f) {
                return Reads$class.flatMap(this, f);
            }

            public Reads<OffsetDateTime> filter(Function1<OffsetDateTime, Object> f) {
                return Reads$class.filter(this, f);
            }

            public Reads<OffsetDateTime> filter(JsonValidationError error, Function1<OffsetDateTime, Object> f) {
                return Reads$class.filter(this, error, f);
            }

            public Reads<OffsetDateTime> filterNot(Function1<OffsetDateTime, Object> f) {
                return Reads$class.filterNot(this, f);
            }

            public Reads<OffsetDateTime> filterNot(JsonValidationError error, Function1<OffsetDateTime, Object> f) {
                return Reads$class.filterNot(this, error, f);
            }

            public <B> Reads<B> collect(JsonValidationError error, PartialFunction<OffsetDateTime, B> f) {
                return Reads$class.collect(this, error, f);
            }

            public Reads<OffsetDateTime> orElse(Reads<OffsetDateTime> v) {
                return Reads$class.orElse(this, v);
            }

            public <B extends JsValue> Reads<OffsetDateTime> compose(Reads<B> rb) {
                return Reads$class.compose(this, rb);
            }

            public <B> Reads<B> andThen(Reads<B> rb, Predef$.less.colon.less<OffsetDateTime, JsValue> witness) {
                return Reads$class.andThen(this, rb, witness);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public JsResult<OffsetDateTime> reads(JsValue json) {
                void var5_14;
                JsValue jsValue = json;
                if (jsValue instanceof JsString) {
                    void var9_10;
                    JsString jsString = (JsString)jsValue;
                    String s = jsString.value();
                    Option<T> option = ((EnvReads.TemporalParser)this.p$1.apply(this.parsing$1)).parse((String)this.corrector$2.apply((Object)s));
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        OffsetDateTime d = (OffsetDateTime)some.x();
                        JsSuccess<OffsetDateTime> jsSuccess = new JsSuccess<OffsetDateTime>(d, JsSuccess$.MODULE$.apply$default$2());
                    } else {
                        None$ none$ = None$.MODULE$;
                        Option<T> option2 = option;
                        if (none$ != null ? !none$.equals(option2) : option2 != null) throw new MatchError(option);
                        JsError jsError = new JsError((Seq<Tuple2<JsPath, Seq<JsonValidationError>>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)JsPath$.MODULE$), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new JsonValidationError[]{JsonValidationError$.MODULE$.apply("error.expected.date.isoformat", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.parsing$1}))})))}))));
                    }
                    void var5_12 = var9_10;
                    return var5_14;
                } else {
                    JsError jsError = new JsError((Seq<Tuple2<JsPath, Seq<JsonValidationError>>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)JsPath$.MODULE$), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new JsonValidationError[]{JsonValidationError$.MODULE$.apply("error.expected.date", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]))})))}))));
                }
                return var5_14;
            }
            {
                this.parsing$1 = parsing$1;
                this.corrector$2 = corrector$2;
                this.p$1 = p$1;
                Reads$class.$init$(this);
            }
        };
    }

    public static Function1 offsetDateTimeReads$default$2(EnvReads $this) {
        return new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x) {
                return (String)Predef$.MODULE$.identity((Object)x);
            }
        };
    }

    public static Reads zonedDateTimeReads(EnvReads $this, Object parsing, Function1 corrector, Function1 p) {
        return new EnvReads.TemporalReads($this, parsing, (Function1<String, String>)corrector, p, new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final ZonedDateTime apply(long millis) {
                return ZonedDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneOffset.UTC);
            }
        });
    }

    public static Function1 zonedDateTimeReads$default$2(EnvReads $this) {
        return new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x) {
                return (String)Predef$.MODULE$.identity((Object)x);
            }
        };
    }

    public static Reads localDateReads(EnvReads $this, Object parsing, Function1 corrector, Function1 p) {
        return new Reads<LocalDate>($this, parsing, corrector, p){
            private final Object parsing$2;
            private final Function1 corrector$3;
            private final Function1 p$2;

            public <B> Reads<B> map(Function1<LocalDate, B> f) {
                return Reads$class.map(this, f);
            }

            public <B> Reads<B> flatMap(Function1<LocalDate, Reads<B>> f) {
                return Reads$class.flatMap(this, f);
            }

            public Reads<LocalDate> filter(Function1<LocalDate, Object> f) {
                return Reads$class.filter(this, f);
            }

            public Reads<LocalDate> filter(JsonValidationError error, Function1<LocalDate, Object> f) {
                return Reads$class.filter(this, error, f);
            }

            public Reads<LocalDate> filterNot(Function1<LocalDate, Object> f) {
                return Reads$class.filterNot(this, f);
            }

            public Reads<LocalDate> filterNot(JsonValidationError error, Function1<LocalDate, Object> f) {
                return Reads$class.filterNot(this, error, f);
            }

            public <B> Reads<B> collect(JsonValidationError error, PartialFunction<LocalDate, B> f) {
                return Reads$class.collect(this, error, f);
            }

            public Reads<LocalDate> orElse(Reads<LocalDate> v) {
                return Reads$class.orElse(this, v);
            }

            public <B extends JsValue> Reads<LocalDate> compose(Reads<B> rb) {
                return Reads$class.compose(this, rb);
            }

            public <B> Reads<B> andThen(Reads<B> rb, Predef$.less.colon.less<LocalDate, JsValue> witness) {
                return Reads$class.andThen(this, rb, witness);
            }

            public JsResult<LocalDate> reads(JsValue json) {
                JsResult<LocalDate> jsResult;
                JsValue jsValue = json;
                if (jsValue instanceof JsNumber) {
                    JsNumber jsNumber = (JsNumber)jsValue;
                    BigDecimal d = jsNumber.value();
                    jsResult = new JsSuccess<LocalDate>(this.epoch(d.toLong()), JsSuccess$.MODULE$.apply$default$2());
                } else if (jsValue instanceof JsString) {
                    JsResult<LocalDate> jsResult2;
                    JsString jsString = (JsString)jsValue;
                    String s = jsString.value();
                    Option<T> option = ((EnvReads.TemporalParser)this.p$2.apply(this.parsing$2)).parse((String)this.corrector$3.apply((Object)s));
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        LocalDate d = (LocalDate)some.x();
                        jsResult2 = new JsSuccess<LocalDate>(d, JsSuccess$.MODULE$.apply$default$2());
                    } else {
                        jsResult2 = new JsError((Seq<Tuple2<JsPath, Seq<JsonValidationError>>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)JsPath$.MODULE$), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new JsonValidationError[]{JsonValidationError$.MODULE$.apply("error.expected.date.isoformat", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.parsing$2}))})))}))));
                    }
                    jsResult = jsResult2;
                } else {
                    jsResult = new JsError((Seq<Tuple2<JsPath, Seq<JsonValidationError>>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)JsPath$.MODULE$), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new JsonValidationError[]{JsonValidationError$.MODULE$.apply("error.expected.date", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]))})))}))));
                }
                return jsResult;
            }

            private LocalDate epoch(long millis) {
                return LocalDate.now(Clock.fixed(Instant.ofEpochMilli(millis), ZoneOffset.UTC));
            }
            {
                this.parsing$2 = parsing$2;
                this.corrector$3 = corrector$3;
                this.p$2 = p$2;
                Reads$class.$init$(this);
            }
        };
    }

    public static Function1 localDateReads$default$2(EnvReads $this) {
        return new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x) {
                return (String)Predef$.MODULE$.identity((Object)x);
            }
        };
    }

    public static Reads instantReads(EnvReads $this, Object parsing, Function1 corrector, Function1 p) {
        return new EnvReads.TemporalReads($this, parsing, (Function1<String, String>)corrector, p, new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Instant apply(long x$1) {
                return Instant.ofEpochMilli(x$1);
            }
        });
    }

    public static Function1 instantReads$default$2(EnvReads $this) {
        return new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x) {
                return (String)Predef$.MODULE$.identity((Object)x);
            }
        };
    }

    public static Reads localTimeReads(EnvReads $this, Object parsing, Function1 corrector, Function1 p) {
        return new Reads<java.time.LocalTime>($this, parsing, corrector, p){
            private final Object parsing$3;
            private final Function1 corrector$4;
            private final Function1 p$3;

            public <B> Reads<B> map(Function1<java.time.LocalTime, B> f) {
                return Reads$class.map(this, f);
            }

            public <B> Reads<B> flatMap(Function1<java.time.LocalTime, Reads<B>> f) {
                return Reads$class.flatMap(this, f);
            }

            public Reads<java.time.LocalTime> filter(Function1<java.time.LocalTime, Object> f) {
                return Reads$class.filter(this, f);
            }

            public Reads<java.time.LocalTime> filter(JsonValidationError error, Function1<java.time.LocalTime, Object> f) {
                return Reads$class.filter(this, error, f);
            }

            public Reads<java.time.LocalTime> filterNot(Function1<java.time.LocalTime, Object> f) {
                return Reads$class.filterNot(this, f);
            }

            public Reads<java.time.LocalTime> filterNot(JsonValidationError error, Function1<java.time.LocalTime, Object> f) {
                return Reads$class.filterNot(this, error, f);
            }

            public <B> Reads<B> collect(JsonValidationError error, PartialFunction<java.time.LocalTime, B> f) {
                return Reads$class.collect(this, error, f);
            }

            public Reads<java.time.LocalTime> orElse(Reads<java.time.LocalTime> v) {
                return Reads$class.orElse(this, v);
            }

            public <B extends JsValue> Reads<java.time.LocalTime> compose(Reads<B> rb) {
                return Reads$class.compose(this, rb);
            }

            public <B> Reads<B> andThen(Reads<B> rb, Predef$.less.colon.less<java.time.LocalTime, JsValue> witness) {
                return Reads$class.andThen(this, rb, witness);
            }

            public JsResult<java.time.LocalTime> reads(JsValue json) {
                JsResult<java.time.LocalTime> jsResult;
                JsValue jsValue = json;
                if (jsValue instanceof JsNumber) {
                    JsNumber jsNumber = (JsNumber)jsValue;
                    BigDecimal d = jsNumber.value();
                    jsResult = new JsSuccess<java.time.LocalTime>(this.epoch(d.toLong()), JsSuccess$.MODULE$.apply$default$2());
                } else if (jsValue instanceof JsString) {
                    JsResult<java.time.LocalTime> jsResult2;
                    JsString jsString = (JsString)jsValue;
                    String s = jsString.value();
                    Option<T> option = ((EnvReads.TemporalParser)this.p$3.apply(this.parsing$3)).parse((String)this.corrector$4.apply((Object)s));
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        java.time.LocalTime d = (java.time.LocalTime)some.x();
                        jsResult2 = new JsSuccess<java.time.LocalTime>(d, JsSuccess$.MODULE$.apply$default$2());
                    } else {
                        jsResult2 = new JsError((Seq<Tuple2<JsPath, Seq<JsonValidationError>>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)JsPath$.MODULE$), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new JsonValidationError[]{JsonValidationError$.MODULE$.apply("error.expected.date.isoformat", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.parsing$3}))})))}))));
                    }
                    jsResult = jsResult2;
                } else {
                    jsResult = new JsError((Seq<Tuple2<JsPath, Seq<JsonValidationError>>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)JsPath$.MODULE$), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new JsonValidationError[]{JsonValidationError$.MODULE$.apply("error.expected.date", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]))})))}))));
                }
                return jsResult;
            }

            private java.time.LocalTime epoch(long nanos) {
                return java.time.LocalTime.ofNanoOfDay(nanos);
            }
            {
                this.parsing$3 = parsing$3;
                this.corrector$4 = corrector$4;
                this.p$3 = p$3;
                Reads$class.$init$(this);
            }
        };
    }

    public static Function1 localTimeReads$default$2(EnvReads $this) {
        return new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x) {
                return (String)Predef$.MODULE$.identity((Object)x);
            }
        };
    }

    private static Reads jdurationNumberReads(EnvReads $this, TemporalUnit unit) {
        return Reads$.MODULE$.apply(new Serializable($this, unit){
            public static final long serialVersionUID = 0L;
            private final TemporalUnit unit$1;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final JsResult<Duration> apply(JsValue x0$5) {
                void var6_9;
                boolean bl = false;
                JsNumber jsNumber = null;
                JsValue jsValue = x0$5;
                if (jsValue instanceof JsNumber) {
                    bl = true;
                    jsNumber = (JsNumber)jsValue;
                    BigDecimal n = jsNumber.value();
                    if (!n.ulp().isValidLong()) {
                        JsError jsError = JsError$.MODULE$.apply("error.invalid.longDuration");
                        return var6_9;
                    }
                }
                if (bl) {
                    BigDecimal n = jsNumber.value();
                    JsSuccess<Duration> jsSuccess = new JsSuccess<Duration>(Duration.of(n.toLong(), this.unit$1), JsSuccess$.MODULE$.apply$default$2());
                    return var6_9;
                }
                JsError jsError = JsError$.MODULE$.apply("error.expected.lonDuration");
                return var6_9;
            }
            {
                this.unit$1 = unit$1;
            }
        });
    }

    public static Reads javaDurationNumberReads(EnvReads $this, TemporalUnit unit) {
        return EnvReads$class.jdurationNumberReads($this, unit);
    }

    public static Reads jodaDateReads(EnvReads $this, String pattern2, Function1 corrector) {
        return new Reads<DateTime>($this, pattern2, corrector){
            private final DateTimeFormatter play$api$libs$json$EnvReads$$anon$$df;
            private final String pattern$2;
            private final Function1 corrector$5;

            public <B> Reads<B> map(Function1<DateTime, B> f) {
                return Reads$class.map(this, f);
            }

            public <B> Reads<B> flatMap(Function1<DateTime, Reads<B>> f) {
                return Reads$class.flatMap(this, f);
            }

            public Reads<DateTime> filter(Function1<DateTime, Object> f) {
                return Reads$class.filter(this, f);
            }

            public Reads<DateTime> filter(JsonValidationError error, Function1<DateTime, Object> f) {
                return Reads$class.filter(this, error, f);
            }

            public Reads<DateTime> filterNot(Function1<DateTime, Object> f) {
                return Reads$class.filterNot(this, f);
            }

            public Reads<DateTime> filterNot(JsonValidationError error, Function1<DateTime, Object> f) {
                return Reads$class.filterNot(this, error, f);
            }

            public <B> Reads<B> collect(JsonValidationError error, PartialFunction<DateTime, B> f) {
                return Reads$class.collect(this, error, f);
            }

            public Reads<DateTime> orElse(Reads<DateTime> v) {
                return Reads$class.orElse(this, v);
            }

            public <B extends JsValue> Reads<DateTime> compose(Reads<B> rb) {
                return Reads$class.compose(this, rb);
            }

            public <B> Reads<B> andThen(Reads<B> rb, Predef$.less.colon.less<DateTime, JsValue> witness) {
                return Reads$class.andThen(this, rb, witness);
            }

            public DateTimeFormatter play$api$libs$json$EnvReads$$anon$$df() {
                return this.play$api$libs$json$EnvReads$$anon$$df;
            }

            public JsResult<DateTime> reads(JsValue json) {
                JsResult<Object> jsResult;
                JsValue jsValue = json;
                if (jsValue instanceof JsNumber) {
                    JsNumber jsNumber = (JsNumber)jsValue;
                    BigDecimal d = jsNumber.value();
                    jsResult = new JsSuccess<DateTime>(new DateTime(d.toLong()), JsSuccess$.MODULE$.apply$default$2());
                } else if (jsValue instanceof JsString) {
                    JsResult<Object> jsResult2;
                    JsString jsString = (JsString)jsValue;
                    String s = jsString.value();
                    Option<DateTime> option = this.parseDate((String)this.corrector$5.apply((Object)s));
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        DateTime d = (DateTime)some.x();
                        jsResult2 = new JsSuccess<DateTime>(d, JsSuccess$.MODULE$.apply$default$2());
                    } else {
                        jsResult2 = new JsError((Seq<Tuple2<JsPath, Seq<JsonValidationError>>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new JsPath(JsPath$.MODULE$.apply$default$1())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new JsonValidationError[]{JsonValidationError$.MODULE$.apply("error.expected.jodadate.format", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.pattern$2}))})))}))));
                    }
                    jsResult = jsResult2;
                } else {
                    jsResult = new JsError((Seq<Tuple2<JsPath, Seq<JsonValidationError>>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new JsPath(JsPath$.MODULE$.apply$default$1())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new JsonValidationError[]{JsonValidationError$.MODULE$.apply("error.expected.date", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]))})))}))));
                }
                return jsResult;
            }

            private Option<DateTime> parseDate(String input) {
                return Exception$.MODULE$.allCatch().opt((Function0)new Serializable(this, input){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ EnvReads$.anon.11 $outer;
                    private final String input$1;

                    public final DateTime apply() {
                        return DateTime.parse((String)this.input$1, (DateTimeFormatter)this.$outer.play$api$libs$json$EnvReads$$anon$$df());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.input$1 = input$1;
                    }
                });
            }
            {
                this.pattern$2 = pattern$2;
                this.corrector$5 = corrector$5;
                Reads$class.$init$(this);
                this.play$api$libs$json$EnvReads$$anon$$df = DateTimeFormat.forPattern((String)pattern$2);
            }
        };
    }

    public static Function1 jodaDateReads$default$2(EnvReads $this) {
        return new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x) {
                return (String)Predef$.MODULE$.identity((Object)x);
            }
        };
    }

    public static Reads jodaLocalDateReads(EnvReads $this, String pattern2, Function1 corrector) {
        return new Reads<org.joda.time.LocalDate>($this, pattern2, corrector){
            private final DateTimeFormatter play$api$libs$json$EnvReads$$anon$$df;
            private final String pattern$3;
            private final Function1 corrector$6;

            public <B> Reads<B> map(Function1<org.joda.time.LocalDate, B> f) {
                return Reads$class.map(this, f);
            }

            public <B> Reads<B> flatMap(Function1<org.joda.time.LocalDate, Reads<B>> f) {
                return Reads$class.flatMap(this, f);
            }

            public Reads<org.joda.time.LocalDate> filter(Function1<org.joda.time.LocalDate, Object> f) {
                return Reads$class.filter(this, f);
            }

            public Reads<org.joda.time.LocalDate> filter(JsonValidationError error, Function1<org.joda.time.LocalDate, Object> f) {
                return Reads$class.filter(this, error, f);
            }

            public Reads<org.joda.time.LocalDate> filterNot(Function1<org.joda.time.LocalDate, Object> f) {
                return Reads$class.filterNot(this, f);
            }

            public Reads<org.joda.time.LocalDate> filterNot(JsonValidationError error, Function1<org.joda.time.LocalDate, Object> f) {
                return Reads$class.filterNot(this, error, f);
            }

            public <B> Reads<B> collect(JsonValidationError error, PartialFunction<org.joda.time.LocalDate, B> f) {
                return Reads$class.collect(this, error, f);
            }

            public Reads<org.joda.time.LocalDate> orElse(Reads<org.joda.time.LocalDate> v) {
                return Reads$class.orElse(this, v);
            }

            public <B extends JsValue> Reads<org.joda.time.LocalDate> compose(Reads<B> rb) {
                return Reads$class.compose(this, rb);
            }

            public <B> Reads<B> andThen(Reads<B> rb, Predef$.less.colon.less<org.joda.time.LocalDate, JsValue> witness) {
                return Reads$class.andThen(this, rb, witness);
            }

            public DateTimeFormatter play$api$libs$json$EnvReads$$anon$$df() {
                return this.play$api$libs$json$EnvReads$$anon$$df;
            }

            public JsResult<org.joda.time.LocalDate> reads(JsValue json) {
                JsResult<Object> jsResult;
                JsValue jsValue = json;
                if (jsValue instanceof JsString) {
                    JsResult<Object> jsResult2;
                    JsString jsString = (JsString)jsValue;
                    String s = jsString.value();
                    Option<org.joda.time.LocalDate> option = this.parseDate((String)this.corrector$6.apply((Object)s));
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        org.joda.time.LocalDate d = (org.joda.time.LocalDate)some.x();
                        jsResult2 = new JsSuccess<org.joda.time.LocalDate>(d, JsSuccess$.MODULE$.apply$default$2());
                    } else {
                        jsResult2 = new JsError((Seq<Tuple2<JsPath, Seq<JsonValidationError>>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new JsPath(JsPath$.MODULE$.apply$default$1())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new JsonValidationError[]{JsonValidationError$.MODULE$.apply("error.expected.jodadate.format", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.pattern$3}))})))}))));
                    }
                    jsResult = jsResult2;
                } else {
                    jsResult = new JsError((Seq<Tuple2<JsPath, Seq<JsonValidationError>>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new JsPath(JsPath$.MODULE$.apply$default$1())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new JsonValidationError[]{JsonValidationError$.MODULE$.apply("error.expected.date", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]))})))}))));
                }
                return jsResult;
            }

            private Option<org.joda.time.LocalDate> parseDate(String input) {
                return Exception$.MODULE$.allCatch().opt((Function0)new Serializable(this, input){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ EnvReads$.anon.12 $outer;
                    private final String input$2;

                    public final org.joda.time.LocalDate apply() {
                        return org.joda.time.LocalDate.parse((String)this.input$2, (DateTimeFormatter)this.$outer.play$api$libs$json$EnvReads$$anon$$df());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.input$2 = input$2;
                    }
                });
            }
            {
                this.pattern$3 = pattern$3;
                this.corrector$6 = corrector$6;
                Reads$class.$init$(this);
                String string = pattern$3;
                String string2 = "";
                this.play$api$libs$json$EnvReads$$anon$$df = !(string != null ? !string.equals(string2) : string2 != null) ? ISODateTimeFormat.localDateParser() : DateTimeFormat.forPattern((String)pattern$3);
            }
        };
    }

    public static Function1 jodaLocalDateReads$default$2(EnvReads $this) {
        return new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x) {
                return (String)Predef$.MODULE$.identity((Object)x);
            }
        };
    }

    public static Reads jodaLocalTimeReads(EnvReads $this, String pattern2, Function1 corrector) {
        return new Reads<LocalTime>($this, pattern2, corrector){
            private final DateTimeFormatter play$api$libs$json$EnvReads$$anon$$df;
            private final String pattern$4;
            private final Function1 corrector$7;

            public <B> Reads<B> map(Function1<LocalTime, B> f) {
                return Reads$class.map(this, f);
            }

            public <B> Reads<B> flatMap(Function1<LocalTime, Reads<B>> f) {
                return Reads$class.flatMap(this, f);
            }

            public Reads<LocalTime> filter(Function1<LocalTime, Object> f) {
                return Reads$class.filter(this, f);
            }

            public Reads<LocalTime> filter(JsonValidationError error, Function1<LocalTime, Object> f) {
                return Reads$class.filter(this, error, f);
            }

            public Reads<LocalTime> filterNot(Function1<LocalTime, Object> f) {
                return Reads$class.filterNot(this, f);
            }

            public Reads<LocalTime> filterNot(JsonValidationError error, Function1<LocalTime, Object> f) {
                return Reads$class.filterNot(this, error, f);
            }

            public <B> Reads<B> collect(JsonValidationError error, PartialFunction<LocalTime, B> f) {
                return Reads$class.collect(this, error, f);
            }

            public Reads<LocalTime> orElse(Reads<LocalTime> v) {
                return Reads$class.orElse(this, v);
            }

            public <B extends JsValue> Reads<LocalTime> compose(Reads<B> rb) {
                return Reads$class.compose(this, rb);
            }

            public <B> Reads<B> andThen(Reads<B> rb, Predef$.less.colon.less<LocalTime, JsValue> witness) {
                return Reads$class.andThen(this, rb, witness);
            }

            public DateTimeFormatter play$api$libs$json$EnvReads$$anon$$df() {
                return this.play$api$libs$json$EnvReads$$anon$$df;
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public JsResult<LocalTime> reads(JsValue json) {
                void var5_8;
                JsValue jsValue = json;
                if (jsValue instanceof JsNumber) {
                    JsNumber jsNumber = (JsNumber)jsValue;
                    BigDecimal n = jsNumber.value();
                    JsSuccess<LocalTime> jsSuccess = new JsSuccess<LocalTime>(new LocalTime(n.toLong()), JsSuccess$.MODULE$.apply$default$2());
                    return var5_8;
                } else if (jsValue instanceof JsString) {
                    void var11_16;
                    JsString jsString = (JsString)jsValue;
                    String s = jsString.value();
                    Option<LocalTime> option = this.parseTime((String)this.corrector$7.apply((Object)s));
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        LocalTime d = (LocalTime)some.x();
                        JsSuccess<LocalTime> jsSuccess = new JsSuccess<LocalTime>(d, JsSuccess$.MODULE$.apply$default$2());
                    } else {
                        None$ none$ = None$.MODULE$;
                        Option<LocalTime> option2 = option;
                        if (none$ != null ? !none$.equals(option2) : option2 != null) throw new MatchError(option);
                        JsError jsError = new JsError((Seq<Tuple2<JsPath, Seq<JsonValidationError>>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new JsPath(JsPath$.MODULE$.apply$default$1())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new JsonValidationError[]{JsonValidationError$.MODULE$.apply("error.expected.jodatime.format", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.pattern$4}))})))}))));
                    }
                    void var5_6 = var11_16;
                    return var5_8;
                } else {
                    JsError jsError = new JsError((Seq<Tuple2<JsPath, Seq<JsonValidationError>>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new JsPath(JsPath$.MODULE$.apply$default$1())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new JsonValidationError[]{JsonValidationError$.MODULE$.apply("error.expected.time", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]))})))}))));
                }
                return var5_8;
            }

            private Option<LocalTime> parseTime(String input) {
                return Exception$.MODULE$.allCatch().opt((Function0)new Serializable(this, input){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ EnvReads$.anon.13 $outer;
                    private final String input$3;

                    public final LocalTime apply() {
                        return LocalTime.parse((String)this.input$3, (DateTimeFormatter)this.$outer.play$api$libs$json$EnvReads$$anon$$df());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.input$3 = input$3;
                    }
                });
            }
            {
                this.pattern$4 = pattern$4;
                this.corrector$7 = corrector$7;
                Reads$class.$init$(this);
                String string = pattern$4;
                String string2 = "";
                this.play$api$libs$json$EnvReads$$anon$$df = !(string != null ? !string.equals(string2) : string2 != null) ? ISODateTimeFormat.localTimeParser() : DateTimeFormat.forPattern((String)pattern$4);
            }
        };
    }

    public static Function1 jodaLocalTimeReads$default$2(EnvReads $this) {
        return new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x) {
                return (String)Predef$.MODULE$.identity((Object)x);
            }
        };
    }

    public static void $init$(EnvReads $this) {
        $this.play$api$libs$json$EnvReads$_setter_$DefaultDateReads_$eq($this.dateReads("yyyy-MM-dd", $this.dateReads$default$2()));
        $this.play$api$libs$json$EnvReads$_setter_$DefaultSqlDateReads_$eq($this.sqlDateReads("yyyy-MM-dd", $this.sqlDateReads$default$2()));
        $this.play$api$libs$json$EnvReads$_setter_$DefaultLocalDateTimeReads_$eq($this.localDateTimeReads(java.time.format.DateTimeFormatter.ISO_DATE_TIME, $this.localDateTimeReads$default$2(), new EnvReads$.anonfun.1($this)));
        $this.play$api$libs$json$EnvReads$_setter_$DefaultOffsetDateTimeReads_$eq($this.offsetDateTimeReads(java.time.format.DateTimeFormatter.ISO_OFFSET_DATE_TIME, $this.offsetDateTimeReads$default$2(), new EnvReads$.anonfun.2($this)));
        $this.play$api$libs$json$EnvReads$_setter_$DefaultZonedDateTimeReads_$eq($this.zonedDateTimeReads(java.time.format.DateTimeFormatter.ISO_DATE_TIME, $this.zonedDateTimeReads$default$2(), new EnvReads$.anonfun.3($this)));
        $this.play$api$libs$json$EnvReads$_setter_$DefaultLocalDateReads_$eq($this.localDateReads(java.time.format.DateTimeFormatter.ISO_DATE, $this.localDateReads$default$2(), new EnvReads$.anonfun.4($this)));
        $this.play$api$libs$json$EnvReads$_setter_$DefaultInstantReads_$eq($this.instantReads(java.time.format.DateTimeFormatter.ISO_DATE_TIME, $this.instantReads$default$2(), new EnvReads$.anonfun.5($this)));
        $this.play$api$libs$json$EnvReads$_setter_$DefaultLocalTimeReads_$eq($this.localTimeReads(java.time.format.DateTimeFormatter.ISO_TIME, $this.localTimeReads$default$2(), new EnvReads$.anonfun.6($this)));
        $this.play$api$libs$json$EnvReads$_setter_$ZoneIdReads_$eq(Reads$.MODULE$.apply(new EnvReads$.anonfun.7($this)));
        $this.play$api$libs$json$EnvReads$_setter_$localeReads_$eq(Reads$.MODULE$.apply(new EnvReads$.anonfun.8($this)));
        $this.play$api$libs$json$EnvReads$_setter_$localeObjectReads_$eq(Reads$.MODULE$.apply(new EnvReads$.anonfun.9($this)));
        $this.play$api$libs$json$EnvReads$_setter_$javaDurationMillisReads_$eq($this.javaDurationNumberReads(ChronoUnit.MILLIS));
        $this.play$api$libs$json$EnvReads$_setter_$DefaultJavaDurationReads_$eq(Reads$.MODULE$.apply(new EnvReads$.anonfun.10($this)));
        $this.play$api$libs$json$EnvReads$_setter_$javaPeriodDaysReads_$eq(Reads$.MODULE$.IntReads().map(new EnvReads$.anonfun.11($this)));
        $this.play$api$libs$json$EnvReads$_setter_$javaPeriodWeeksReads_$eq(Reads$.MODULE$.IntReads().map(new EnvReads$.anonfun.12($this)));
        $this.play$api$libs$json$EnvReads$_setter_$javaPeriodMonthsReads_$eq(Reads$.MODULE$.IntReads().map(new EnvReads$.anonfun.13($this)));
        $this.play$api$libs$json$EnvReads$_setter_$javaPeriodYearsReads_$eq(Reads$.MODULE$.IntReads().map(new EnvReads$.anonfun.14($this)));
        $this.play$api$libs$json$EnvReads$_setter_$DefaultJavaPeriodReads_$eq(Reads$.MODULE$.apply(new EnvReads$.anonfun.15($this)));
        $this.play$api$libs$json$EnvReads$_setter_$DefaultJodaDateReads_$eq($this.jodaDateReads("yyyy-MM-dd", $this.jodaDateReads$default$2()));
        $this.play$api$libs$json$EnvReads$_setter_$DefaultJodaLocalDateReads_$eq($this.jodaLocalDateReads("", $this.jodaLocalDateReads$default$2()));
        $this.play$api$libs$json$EnvReads$_setter_$DefaultJodaLocalTimeReads_$eq($this.jodaLocalTimeReads("", $this.jodaLocalTimeReads$default$2()));
    }
}

