/*
 * Decompiled with CFR 0.152.
 */
package com.roxstudio.utils;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.ConnectException;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpCookie;
import java.net.HttpRetryException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public final class CUrl {
    private static final String VERSION = "1.2.2";
    private static final String DEFAULT_USER_AGENT = "Java-CURL version 1.2.2 by Rocks Wang(https://github.com/rockswang)";
    private static final Pattern ptnOptionName = Pattern.compile("-{1,2}[a-zA-Z][a-zA-Z0-9\\-.]*");
    private static final CookieStore cookieStore = new CookieStore();
    private static HostnameVerifier insecureVerifier = null;
    private static SSLSocketFactory insecureFactory = null;
    private static final Map<String, Integer> optMap;
    private static final String BOUNDARY = "------------aia113jBkadk7289";
    private static final byte[] NEWLINE;
    private final List<String> options = new ArrayList<String>();
    private final Map<String, IO> iomap = new HashMap<String, IO>();
    private final Map<String, String> tags = new LinkedHashMap<String, String>();
    private final Map<String, String> headers = new LinkedHashMap<String, String>();
    private final List<List<String[]>> responseHeaders = new ArrayList<List<String[]>>(4);
    private final List<URL> locations = new ArrayList<URL>(4);
    private long startTime;
    private long execTime;
    private int httpCode;
    private byte[] rawStdout;
    private static final HashSet<Class> RECOVERABLES;
    public static final Resolver<byte[]> RAW;
    public static final ToStringResolver UTF8;
    public static final ToStringResolver GBK;
    public static final ToStringResolver ISO_8859_1;

    public CUrl() {
    }

    public CUrl(String url) {
        this.url(url);
    }

    public final CUrl opt(String ... options) {
        for (String o : options) {
            if (o.startsWith("'") && o.endsWith("'")) {
                o = o.substring(1, o.length() - 1);
            }
            this.options.add(o);
        }
        return this;
    }

    public final CUrl url(String url) {
        return this.opt("--url", url);
    }

    public final CUrl location() {
        return this.opt("-L");
    }

    public final CUrl proxy(String host, int port) {
        return this.opt("-x", host + ":" + port);
    }

    public final CUrl insecure() {
        return this.opt("-k");
    }

    public final CUrl retry(int retry, float retryDelay, float retryMaxTime) {
        return this.opt("--retry", Integer.toString(retry), "--retry-delay", Float.toString(retryDelay), "--retry-max-time", Float.toString(retryMaxTime));
    }

    public final CUrl timeout(float connectTimeoutSeconds, float readTimeoutSeconds) {
        return this.opt("--connect-timeout", Float.toString(connectTimeoutSeconds), "--max-time", Float.toString(readTimeoutSeconds));
    }

    public final CUrl header(String headerLine) {
        return this.opt("-H", headerLine);
    }

    public final CUrl headers(Map<String, ?> headers) {
        for (Map.Entry<String, ?> kv : headers.entrySet()) {
            String k = kv.getKey();
            Object v = kv.getValue();
            this.opt("-H", v == null ? k + ":" : (v.toString().length() == 0 ? k + ";" : k + ": " + v));
        }
        return this;
    }

    public final CUrl data(String data) {
        return this.data(data, false);
    }

    public final CUrl data(String data, boolean raw) {
        return this.opt(raw ? "--data-raw" : "-d", data);
    }

    public final CUrl data(IO input, boolean binary) {
        String key = "IO#" + this.iomap.size();
        this.iomap.put(key, input);
        return this.opt(binary ? "--data-binary" : "-d", "@" + key);
    }

    public final CUrl data(String data, String charset) {
        return this.opt("--data-urlencode" + (charset != null ? "-" + charset : ""), data);
    }

    public final CUrl form(String name, String content) {
        return this.opt("-F", name + "=" + content);
    }

    public final CUrl form(String name, IO input) {
        String key = "IO#" + this.iomap.size();
        this.iomap.put(key, input);
        return this.opt("-F", name + "=@" + key);
    }

    public final CUrl form(String formString) {
        return this.opt("--form-string", formString);
    }

    public final CUrl cookieJar(String output) {
        return this.opt("-c", output);
    }

    public final CUrl cookieJar(IO output) {
        String key = "IO#" + this.iomap.size();
        this.iomap.put(key, output);
        return this.opt("-c", key);
    }

    public final CUrl cookie(String input) {
        return this.opt("-b", input);
    }

    public final CUrl cookie(IO input) {
        String key = "IO#" + this.iomap.size();
        this.iomap.put(key, input);
        return this.opt("-b", key);
    }

    public final CUrl dumpHeader(String output) {
        return this.opt("-D", output);
    }

    public final CUrl dumpHeader(IO output) {
        String key = "IO#" + this.iomap.size();
        this.iomap.put(key, output);
        return this.opt("-D", key);
    }

    public final CUrl cert(IO certificate, String password) {
        String key = "IO#" + this.iomap.size();
        this.iomap.put(key, certificate);
        return this.opt("-E", key + ":" + password);
    }

    public final CUrl stderr(String output) {
        return this.opt("--stderr", output);
    }

    public final CUrl stderr(IO output) {
        String key = "IO#" + this.iomap.size();
        this.iomap.put(key, output);
        return this.opt("--stderr", key);
    }

    public final CUrl output(String output) {
        return this.opt("-o", output);
    }

    public final CUrl output(IO output) {
        String key = "IO#" + this.iomap.size();
        this.iomap.put(key, output);
        return this.opt("-o", key);
    }

    public final CUrl io(String key, IO io) {
        this.iomap.put(key, io);
        return this;
    }

    public static java.net.CookieStore getCookieStore() {
        return cookieStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveCookies(IO output) {
        if (output instanceof CookieIO) {
            CookieIO cs;
            CookieIO cookieIO = cs = (CookieIO)output;
            synchronized (cookieIO) {
                for (HttpCookie c : cookieStore.getCookies()) {
                    cs.add(null, c);
                }
            }
        } else {
            String s = CUrl.dumpCookies(cookieStore.getCookies());
            CUrl.writeOutput(output, Util.s2b(s, null), false);
        }
    }

    public static String dumpCookie(HttpCookie cookie) {
        StringBuilder sb = new StringBuilder();
        long expire = cookie.getMaxAge() <= 0L || cookie.getMaxAge() >= Integer.MAX_VALUE ? Integer.MAX_VALUE : cookie.getMaxAge() + System.currentTimeMillis() / 1000L;
        sb.append(cookie.getDomain()).append('\t').append("FALSE").append('\t').append(cookie.getPath()).append('\t').append(cookie.getSecure() ? "TRUE" : "FALSE").append('\t').append(expire).append('\t').append(cookie.getName()).append('\t').append(cookie.getValue()).append('\n');
        return sb.toString();
    }

    public static String dumpCookies(List<HttpCookie> cookies) {
        StringBuilder sb = new StringBuilder();
        for (HttpCookie cookie : cookies) {
            sb.append(CUrl.dumpCookie(cookie));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadCookies(IO input) {
        if (input instanceof CookieIO) {
            CookieIO cs;
            CookieIO cookieIO = cs = (CookieIO)input;
            synchronized (cookieIO) {
                for (HttpCookie c : cs.getCookies()) {
                    cookieStore.add(null, c);
                }
            }
        } else {
            List<HttpCookie> cookies = CUrl.parseCookies(Util.b2s(CUrl.readInput(input), null, null));
            for (HttpCookie c : cookies) {
                cookieStore.add(null, c);
            }
        }
    }

    public static List<HttpCookie> parseCookies(String input) {
        BufferedReader br = new BufferedReader(new StringReader(input));
        ArrayList<HttpCookie> result = new ArrayList<HttpCookie>();
        try {
            String line = br.readLine();
            while (line != null) {
                String[] l;
                if (line.trim().length() != 0 && !line.startsWith("# ") && (l = line.split("\t")).length >= 7) {
                    HttpCookie cookie = new HttpCookie(l[5], l[6]);
                    cookie.setDomain(l[0]);
                    cookie.setPath(l[2]);
                    cookie.setSecure("TRUE".equals(l[3]));
                    long expire = Long.parseLong(l[4]);
                    cookie.setMaxAge(expire >= Integer.MAX_VALUE ? Integer.MAX_VALUE : expire * 1000L - System.currentTimeMillis());
                    if (!cookie.hasExpired()) {
                        cookieStore.add(null, cookie);
                    }
                }
                line = br.readLine();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder("curl");
        for (String s : this.options) {
            sb.append(' ').append(ptnOptionName.matcher(s).matches() ? s : '\"' + s + '\"');
        }
        if (this.iomap.size() > 0) {
            sb.append("\r\n> IOMap: ").append(this.iomap);
        }
        return sb.toString();
    }

    public final List<String> getOptions() {
        return this.options;
    }

    public final String getOption(String name) {
        String next;
        if (!ptnOptionName.matcher(name).matches()) {
            throw new IllegalArgumentException("Invalid option name: " + name);
        }
        int idx = this.options.indexOf(name);
        if (idx < 0) {
            return null;
        }
        String string = next = idx + 1 < this.options.size() ? this.options.get(idx + 1) : null;
        if (next != null && ptnOptionName.matcher(next).matches()) {
            next = null;
        }
        return next != null ? next : "TRUE";
    }

    public final Map<String, String> getTags() {
        return this.tags;
    }

    public final Map<String, String> getHeaders() {
        return this.headers;
    }

    public final List<List<String[]>> getResponseHeaders() {
        return this.responseHeaders;
    }

    public final long getExecTime() {
        return this.execTime;
    }

    public final int getHttpCode() {
        return this.httpCode;
    }

    public final <T> T getStdout(Resolver<T> resolver, T fallback) {
        try {
            return resolver.resolve(this.httpCode, this.rawStdout);
        }
        catch (Throwable throwable) {
            return fallback;
        }
    }

    public final List<URL> getLocations() {
        return this.locations;
    }

    public final String exec(String encoding) {
        return this.exec(encoding != null ? new ToStringResolver(encoding) : UTF8, null);
    }

    public final byte[] exec() {
        return this.exec(RAW, null);
    }

    /*
     * WARNING - void declaration
     */
    public final <T> T exec(Resolver<T> resolver, T fallback) {
        MemIO stdout;
        this.startTime = System.currentTimeMillis();
        this.tags.clear();
        this.headers.clear();
        this.responseHeaders.clear();
        this.locations.clear();
        this.execTime = 0L;
        this.httpCode = -1;
        this.rawStdout = null;
        Proxy proxy = Proxy.NO_PROXY;
        String url = null;
        String redirect = null;
        String method = null;
        String cookie = null;
        String charset = "UTF-8";
        String cert = null;
        IO stderr = stdout = new MemIO();
        IO output = stdout;
        IO cookieJar = null;
        IO dumpHeader = null;
        StringBuilder dataSb = new StringBuilder();
        LinkedHashMap<String, Util.Ref<String>> form = new LinkedHashMap<String, Util.Ref<String>>();
        float connectTimeout = 0.0f;
        float maxTime = 0.0f;
        float retryDelay = 0.0f;
        float retryMaxTime = 0.0f;
        int retry = 0;
        int maxDownload = 0;
        boolean location = false;
        boolean silent = false;
        boolean mergeData = false;
        boolean insecure = false;
        Util.mapPut(this.headers, "Accept", "*/*", "User-Agent", DEFAULT_USER_AGENT);
        this.iomap.put("-", stdout);
        Throwable lastEx = null;
        int n = this.options.size();
        for (int i = 0; i < n; ++i) {
            String opt = this.options.get(i);
            if (opt.startsWith("http://") || opt.startsWith("https://")) {
                url = opt;
                continue;
            }
            if (opt.startsWith("--data-urlencode-")) {
                charset = opt.substring(17);
                opt = "--data-urlencode";
            }
            switch (Util.mapGet(optMap, opt, -1)) {
                case 32: {
                    cert = this.options.get(++i);
                    break;
                }
                case 1: {
                    this.headers.put("Accept-Encoding", "gzip, deflate");
                    break;
                }
                case 2: {
                    connectTimeout = Float.parseFloat(this.options.get(++i));
                    break;
                }
                case 3: {
                    cookie = this.options.get(++i);
                    break;
                }
                case 4: {
                    cookieJar = this.getIO(this.options.get(++i));
                    break;
                }
                case 5: {
                    String data = this.options.get(++i);
                    if (data.startsWith("@")) {
                        data = Util.b2s(CUrl.readInput(this.getIO(data.substring(1))), null, null).replaceAll("[\r\n]+", "");
                    }
                    mergeData = dataSb.length() > 0;
                    dataSb.append(mergeData ? "&" : "").append(data);
                    break;
                }
                case 51: {
                    mergeData = dataSb.length() > 0;
                    dataSb.append(mergeData ? "&" : "").append(this.options.get(++i));
                    break;
                }
                case 52: {
                    String data = this.options.get(++i);
                    if (data.startsWith("@")) {
                        data = Util.b2s(CUrl.readInput(this.getIO(data.substring(1))), null, null);
                    }
                    mergeData = dataSb.length() > 0;
                    dataSb.append(mergeData ? "&" : "").append(data);
                    break;
                }
                case 53: {
                    Object m;
                    mergeData = dataSb.length() > 0;
                    String data = this.options.get(++i);
                    int idx = data.indexOf("=");
                    switch (idx) {
                        case -1: {
                            int atIdx = data.indexOf("@");
                            if (atIdx >= 0) {
                                String prefix = atIdx > 0 ? data.substring(0, atIdx) + "=" : "";
                                try {
                                    data = prefix + URLEncoder.encode(Util.b2s(CUrl.readInput(this.getIO(data.substring(atIdx + 1))), null, ""), charset);
                                }
                                catch (Exception e) {
                                    lastEx = e;
                                }
                                break;
                            }
                        }
                        case 0: {
                            try {
                                data = URLEncoder.encode(data.substring(idx + 1), charset);
                            }
                            catch (Exception e) {
                                lastEx = e;
                            }
                            break;
                        }
                        default: {
                            m = Util.split(data, "&", "=", new LinkedHashMap<String, String>());
                            for (Map.Entry entry : m.entrySet()) {
                                try {
                                    entry.setValue(URLEncoder.encode((String)entry.getValue(), "UTF-8"));
                                }
                                catch (Exception exception) {}
                            }
                            data = Util.join(m, "&", "=");
                        }
                    }
                    dataSb.append(mergeData ? "&" : "").append(data);
                    break;
                }
                case 6: {
                    dumpHeader = this.getIO(this.options.get(++i));
                    break;
                }
                case 7: {
                    String data = this.options.get(++i);
                    int idx = data.indexOf(61);
                    form.put(data.substring(0, idx), new Util.Ref<String>(1, data.substring(idx + 1)));
                    break;
                }
                case 71: {
                    void var36_54;
                    Object m = Util.split(this.options.get(++i), "&", "=");
                    int e = ((String[][])m).length;
                    boolean bl = false;
                    while (var36_54 < e) {
                        String[] pair = m[var36_54];
                        form.put(pair[0], new Util.Ref<String>(pair[1]));
                        ++var36_54;
                    }
                    break;
                }
                case 8: {
                    method = "GET";
                    break;
                }
                case 10: {
                    String[] hh = this.options.get(++i).split(":", 2);
                    String name = hh[0].trim();
                    if (hh.length == 1 && name.endsWith(";")) {
                        this.headers.put(name.substring(0, name.length() - 1), "");
                        break;
                    }
                    if (hh.length == 1 || Util.empty(hh[1])) {
                        this.headers.remove(name);
                        break;
                    }
                    this.headers.put(name, hh[1].trim());
                    break;
                }
                case 11: {
                    method = "HEAD";
                    break;
                }
                case 13: {
                    location = true;
                    break;
                }
                case 14: {
                    maxTime = Float.parseFloat(this.options.get(++i));
                    break;
                }
                case 16: {
                    output = this.getIO(this.options.get(++i));
                    break;
                }
                case 17: {
                    String[] stringArray = this.options.get(++i).split(":");
                    InetSocketAddress addr = new InetSocketAddress(stringArray[0], stringArray.length > 1 ? Integer.parseInt(stringArray[1]) : 1080);
                    proxy = new Proxy(Proxy.Type.HTTP, addr);
                    break;
                }
                case 18: {
                    final String proxyAuth = this.options.get(++i);
                    this.headers.put("Proxy-Authorization", "Basic " + Util.base64Encode(proxyAuth.getBytes()));
                    Authenticator.setDefault(new Authenticator(){

                        @Override
                        protected PasswordAuthentication getPasswordAuthentication() {
                            String[] up = proxyAuth.split(":");
                            return new PasswordAuthentication(up[0], (up.length > 1 ? up[1] : "").toCharArray());
                        }
                    });
                    break;
                }
                case 19: {
                    this.headers.put("Referer", this.options.get(++i));
                    break;
                }
                case 20: {
                    retry = Integer.parseInt(this.options.get(++i));
                    break;
                }
                case 21: {
                    retryDelay = Float.parseFloat(this.options.get(++i));
                    break;
                }
                case 22: {
                    retryMaxTime = Float.parseFloat(this.options.get(++i));
                    break;
                }
                case 23: {
                    silent = true;
                    break;
                }
                case 24: {
                    stderr = this.getIO(this.options.get(++i));
                    break;
                }
                case 25: {
                    url = this.options.get(++i);
                    break;
                }
                case 26: {
                    this.headers.put("User-Agent", this.options.get(++i));
                    break;
                }
                case 27: {
                    method = this.options.get(++i);
                    break;
                }
                case 28: {
                    this.headers.put("Authorization", "Basic " + Util.base64Encode(this.options.get(++i).getBytes()));
                    break;
                }
                case 29: {
                    maxDownload = Integer.parseInt(this.options.get(++i));
                    break;
                }
                case 30: {
                    Util.split(this.options.get(++i), "&", "=", this.tags);
                    break;
                }
                case 31: {
                    insecure = true;
                    break;
                }
                default: {
                    lastEx = new IllegalArgumentException("option " + opt + ": is unknown");
                }
            }
            if (lastEx == null) continue;
            return this.error(stdout, stderr, lastEx, silent, resolver, fallback);
        }
        if (url == null) {
            lastEx = new IllegalArgumentException("no URL specified!");
            return this.error(stdout, stderr, lastEx, silent, resolver, fallback);
        }
        if (dataSb.length() > 0 && form.size() > 0 || dataSb.length() > 0 && "HEAD".equals(method) || form.size() > 0 && "HEAD".equals(method)) {
            lastEx = new IllegalArgumentException("Warning: You can only select one HTTP request!");
            return this.error(stdout, stderr, lastEx, silent, resolver, fallback);
        }
        String dataStr = "";
        if (form.size() > 0) {
            if (method == null) {
                method = "POST";
            }
        } else if (dataSb.length() > 0) {
            String string = dataStr = !mergeData ? dataSb.toString() : Util.join(Util.split(dataSb.toString(), "&", "=", new LinkedHashMap<String, String>()), "&", "=");
            if (method == null) {
                method = "POST";
            }
        }
        if (method == null) {
            method = "GET";
        }
        if (cookie != null) {
            cookieStore.removeAll();
            if (cookie.indexOf(61) > 0) {
                CUrl.parseCookies(url, cookie);
            } else if (cookie.trim().length() > 0) {
                CUrl.loadCookies(this.getIO(cookie));
            }
        }
        boolean needRetry = false;
        if (dataStr.length() > 0 && "GET".equals(method)) {
            url = url + (url.contains("?") ? "&" : "?") + dataStr;
        }
        URL urlObj = null;
        int retryLeft = retry;
        do {
            try {
                InputStream is;
                if (redirect != null) {
                    urlObj = new URL(urlObj, redirect);
                    method = "GET";
                } else {
                    urlObj = new URL(url);
                }
                if (retryLeft == retry) {
                    if (this.locations.size() > 51) {
                        redirect = null;
                        throw new RuntimeException("Too many redirects.");
                    }
                    this.locations.add(urlObj);
                    this.responseHeaders.add(new ArrayList());
                }
                HttpURLConnection con = (HttpURLConnection)urlObj.openConnection(proxy);
                con.setRequestMethod(method);
                con.setUseCaches(false);
                con.setConnectTimeout((int)(connectTimeout * 1000.0f));
                con.setReadTimeout((int)(maxTime * 1000.0f));
                con.setInstanceFollowRedirects(false);
                if (con instanceof HttpsURLConnection) {
                    if (insecure) {
                        ((HttpsURLConnection)con).setHostnameVerifier(insecureVerifier);
                        ((HttpsURLConnection)con).setSSLSocketFactory(insecureFactory);
                    } else if (cert != null) {
                        int idx = cert.lastIndexOf(58);
                        ((HttpsURLConnection)con).setSSLSocketFactory(CUrl.getSocketFactory(this.getIO(cert.substring(0, idx)), cert.substring(idx + 1)));
                    }
                }
                for (Map.Entry<String, String> h : this.headers.entrySet()) {
                    con.setRequestProperty(h.getKey(), h.getValue());
                }
                if ("POST".equals(method) || "PUT".equals(method)) {
                    byte[] data;
                    OutputStream os;
                    con.setDoInput(true);
                    con.setDoOutput(true);
                    if (form.size() > 0) {
                        con.setRequestProperty("Content-Type", "multipart/form-data; boundary=------------aia113jBkadk7289");
                        os = new ByteArrayOutputStream();
                        for (Map.Entry en : form.entrySet()) {
                            byte[] bb;
                            String name = (String)en.getKey();
                            String filename = null;
                            String type = null;
                            Util.Ref val = (Util.Ref)en.getValue();
                            if (val.getInt() == 1) {
                                String[][] ll = Util.split((String)val.get(), ";", "=");
                                String _1st = CUrl.unquote(ll[0][0].trim());
                                for (int j = 1; j < ll.length; ++j) {
                                    if (ll[j].length > 1 && "type".equals(ll[j][0].trim())) {
                                        type = CUrl.unquote(ll[j][1].trim());
                                        continue;
                                    }
                                    if (ll[j].length <= 1 || !"filename".equals(ll[j][0].trim())) continue;
                                    filename = CUrl.unquote(ll[j][1].trim());
                                }
                                if (_1st.startsWith("@") || _1st.startsWith("<")) {
                                    File f;
                                    IO in = this.getIO(_1st.substring(1));
                                    File file = f = in instanceof FileIO ? ((FileIO)in).f : null;
                                    String string = _1st.startsWith("<") ? null : (filename != null ? filename : (filename = f != null ? f.getAbsolutePath() : name));
                                    if (!(f == null || f.exists() && f.isFile() && f.canRead())) {
                                        throw new IllegalArgumentException("couldn't open file \"" + filename + "\"");
                                    }
                                    bb = CUrl.readInput(in);
                                } else {
                                    bb = Util.s2b(_1st, null);
                                }
                            } else {
                                bb = Util.s2b((String)val.get(), null);
                            }
                            os.write("--------------aia113jBkadk7289\r\n".getBytes());
                            os.write(("Content-Disposition: form-data; name=\"" + name + "\"").getBytes());
                            if (filename != null) {
                                os.write(("; filename=\"" + filename + "\"").getBytes());
                            }
                            if (type != null) {
                                os.write(("\r\nContent-Type: " + type).getBytes());
                            }
                            os.write(NEWLINE);
                            os.write(NEWLINE);
                            os.write(bb);
                            os.write(NEWLINE);
                        }
                        os.write("--------------aia113jBkadk7289--\r\n".getBytes());
                        data = ((ByteArrayOutputStream)os).toByteArray();
                    } else {
                        data = Util.s2b(dataStr, null);
                        con.setRequestProperty("Content-Length", Integer.toString(data.length));
                        if (!this.headers.containsKey("Content-Type")) {
                            con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                        }
                    }
                    try {
                        os = con.getOutputStream();
                        os.write(data);
                        os.flush();
                    }
                    catch (Exception ex) {
                        throw new Recoverable(ex, -1);
                    }
                }
                redirect = null;
                this.httpCode = con.getResponseCode();
                if (this.httpCode >= 300 && this.httpCode < 400) {
                    redirect = con.getHeaderField("Location");
                }
                if (redirect != null) {
                    retryLeft = retry;
                }
                try {
                    is = con.getInputStream();
                }
                catch (Exception e) {
                    if (this.httpCode == 407 && proxy != Proxy.NO_PROXY && "https".equals(urlObj.getProtocol()) && this.headers.containsKey("Proxy-Authorization")) {
                        throw new RuntimeException(e.getMessage() + "\nTry using VM argument \"-Djdk.http.auth.tunneling.disabledSchemes=\"", e);
                    }
                    if (redirect == null) {
                        lastEx = e;
                    }
                    is = con.getErrorStream();
                }
                if (is == null && lastEx != null) {
                    throw lastEx;
                }
                byte[] bb = Util.readStream(is, maxDownload, true);
                if (maxDownload <= 0 && bb != null && bb.length > 2) {
                    byte by;
                    byte b0 = bb[0];
                    if (b0 == 31 && bb[1] == -117) {
                        is = new GZIPInputStream(new ByteArrayInputStream(bb));
                    }
                    if (b0 == 120 && ((by = bb[1]) == 1 || by == 94 || by == -100 || by == -38)) {
                        is = new InflaterInputStream(new ByteArrayInputStream(bb));
                    }
                    if (is instanceof InflaterInputStream) {
                        bb = Util.readStream(is, false);
                    }
                }
                int idx = this.locations.size() - 1;
                CUrl.fillResponseHeaders(con, this.responseHeaders.get(idx));
                if (dumpHeader != null) {
                    CUrl.dumpHeader(this.responseHeaders.get(idx), dumpHeader);
                }
                if (bb != null && bb.length > 0) {
                    CUrl.writeOutput(output, bb, output == dumpHeader);
                }
                if (lastEx != null) {
                    throw lastEx;
                }
                if (redirect == null || !location) {
                    this.rawStdout = stdout.toByteArray();
                    this.execTime = System.currentTimeMillis() - this.startTime;
                    if (cookieJar != null) {
                        CUrl.saveCookies(cookieJar);
                    }
                    return silent ? fallback : this.getStdout(resolver, fallback);
                }
            }
            catch (Throwable e) {
                needRetry = CUrl.isRecoverable(e.getClass());
                Throwable throwable = lastEx = e instanceof Recoverable ? e.getCause() : e;
                if (!needRetry || retryLeft <= 0 || !(retryDelay > 0.0f)) continue;
                try {
                    Thread.sleep((long)((double)retryDelay * 1000.0));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        } while (location && redirect != null || needRetry && --retryLeft >= 0 && (retryMaxTime <= 0.0f || System.currentTimeMillis() - this.startTime < (long)((double)retryMaxTime * 1000.0)));
        return this.error(stdout, stderr, lastEx, silent, resolver, fallback);
    }

    private IO getIO(String key) {
        IO io = this.iomap.get(key);
        return io == null ? new FileIO(key) : io;
    }

    private <T> T error(IO stdout, IO stderr, Throwable ex, boolean silent, Resolver<T> rr, T fallback) {
        CUrl.writeOutput(stderr, Util.dumpStackTrace(ex, false).getBytes(), true);
        this.httpCode = ex instanceof Recoverable ? ((Recoverable)ex).httpCode : -1;
        this.rawStdout = ((MemIO)stdout).toByteArray();
        this.execTime = System.currentTimeMillis() - this.startTime;
        return silent ? fallback : this.getStdout(rr, fallback);
    }

    private static void parseCookies(String url, String input) {
        String host = null;
        try {
            host = new URI(url).getHost();
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (String[] pair : Util.split(input, ";", "=")) {
            HttpCookie cookie = new HttpCookie(pair[0], Util.urlDecode(pair[1], "UTF-8"));
            cookie.setDomain(host);
            cookie.setPath("/");
            cookie.setSecure(false);
            cookieStore.add(null, cookie);
        }
    }

    private static String unquote(String s) {
        return s.startsWith("'") && s.endsWith("'") || s.startsWith("\"") && s.endsWith("\"") ? s.substring(1, s.length() - 1) : s;
    }

    private static void fillResponseHeaders(HttpURLConnection con, List<String[]> headers) {
        String[] values;
        String[] keys;
        Integer nkeys;
        Object delegate;
        headers.clear();
        Object responses = Util.getField(con, null, "responses", null, true);
        if (responses == null && (delegate = Util.getField(con, null, "delegate", null, true)) != null) {
            responses = Util.getField(delegate, null, "responses", null, true);
        }
        if (responses != null && (nkeys = (Integer)Util.getField(responses, null, "nkeys", null, true)) != null && (keys = (String[])Util.getField(responses, null, "keys", null, true)) != null && (values = (String[])Util.getField(responses, null, "values", null, true)) != null) {
            for (int i = 0; i < nkeys; ++i) {
                headers.add(new String[]{keys[i], values[i]});
            }
        } else {
            try {
                headers.add(new String[]{null, con.getResponseMessage()});
            }
            catch (Exception i) {
                // empty catch block
            }
            int i = 0;
            while (true) {
                String k = con.getHeaderFieldKey(i);
                String v = con.getHeaderField(i);
                if (k == null && v == null) break;
                headers.add(new String[]{k, v});
                ++i;
            }
        }
    }

    private static void dumpHeader(List<String[]> headers, IO dumpHeader) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        for (String[] kv : headers) {
            bos.write(((kv[0] != null ? kv[0] + ": " : "") + (kv[1] != null ? kv[1] : "") + "\r\n").getBytes());
        }
        bos.write(NEWLINE);
        CUrl.writeOutput(dumpHeader, bos.toByteArray(), false);
    }

    private static byte[] readInput(IO in) {
        byte[] bb;
        InputStream is = in.getInputStream();
        if (is == null || (bb = Util.readStream(is, false)) == null) {
            bb = new byte[]{};
        }
        in.close();
        return bb;
    }

    private static void writeOutput(IO out, byte[] bb, boolean append) {
        out.setAppend(append);
        OutputStream os = out.getOutputStream();
        if (os == null) {
            return;
        }
        try {
            os.write(bb);
            os.flush();
        }
        catch (Exception e) {
            Util.logStderr("CUrl.writeOutput: out=%s,bb=%s,append=%s,ex=%s", out, bb, append, Util.dumpStackTrace(e, true));
        }
        out.close();
    }

    private static boolean isRecoverable(Class<? extends Throwable> errCls) {
        if (RECOVERABLES.contains(errCls)) {
            return true;
        }
        for (Class re : RECOVERABLES) {
            if (!re.isAssignableFrom(errCls)) continue;
            return true;
        }
        return false;
    }

    private static SSLSocketFactory getSocketFactory(IO cert, String password) throws Exception {
        TrustManager[] managers;
        if (cert == null) {
            managers = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] arg0, String arg1) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] arg0, String arg1) {
                }
            }};
        } else {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(cert.getInputStream(), password.toCharArray());
            cert.close();
            TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            factory.init(keyStore);
            managers = factory.getTrustManagers();
        }
        SSLContext sc = SSLContext.getInstance("TLS");
        sc.init(null, managers, new SecureRandom());
        return sc.getSocketFactory();
    }

    public static void main(String[] args) {
        System.out.println(new CUrl().opt(args).exec(null));
    }

    static {
        try {
            System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
            CookieManager.setDefault(new CookieManager(cookieStore, CookiePolicy.ACCEPT_ALL));
            insecureVerifier = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            insecureFactory = CUrl.getSocketFactory(null, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        optMap = Util.mapPut(new LinkedHashMap(), "-E", 32, "--cert", 32, "--compressed", 1, "--connect-timeout", 2, "-b", 3, "--cookie", 3, "-c", 4, "--cookie-jar", 4, "-d", 5, "--data", 5, "--data-ascii", 5, "--data-raw", 51, "--data-binary", 52, "--data-urlencode", 53, "-D", 6, "--dump-header", 6, "-F", 7, "--form", 7, "--form-string", 71, "-G", 8, "--get", 8, "-H", 10, "--header", 10, "-I", 11, "--head", 11, "-k", 31, "--insecure", 31, "-L", 13, "--location", 13, "-m", 14, "--max-time", 14, "-o", 16, "--output", 16, "-x", 17, "--proxy", 17, "-U", 18, "--proxy-user", 18, "-e", 19, "--referer", 19, "--retry", 20, "--retry-delay", 21, "--retry-max-time", 22, "-s", 23, "--silent", 23, "--stderr", 24, "-u", 28, "--user", 28, "--url", 25, "-A", 26, "--user-agent", 26, "-X", 27, "--request", 27, "--x-max-download", 29, "--x-tags", 30, "", 0);
        NEWLINE = "\r\n".getBytes();
        RECOVERABLES = Util.listAdd(new HashSet(), Recoverable.class, ConnectException.class, HttpRetryException.class, SocketException.class, SocketTimeoutException.class, NoRouteToHostException.class);
        RAW = new Resolver<byte[]>(){

            @Override
            public byte[] resolve(int httpCode, byte[] raw) {
                return raw;
            }
        };
        UTF8 = new ToStringResolver("UTF-8");
        GBK = new ToStringResolver("GBK");
        ISO_8859_1 = new ToStringResolver("ISO-8859-1");
    }

    static final class Util {
        public static final int PIPE_COUNT_MASK = Integer.MAX_VALUE;
        private static final int BUFFER_SIZE = 10000;
        private static final Map<String, Object> primaryTypes = Util.newMap(Byte.TYPE, Character.valueOf('B'), Character.TYPE, Character.valueOf('C'), Double.TYPE, Character.valueOf('D'), Float.TYPE, Character.valueOf('F'), Integer.TYPE, Character.valueOf('I'), Long.TYPE, Character.valueOf('J'), Short.TYPE, Character.valueOf('S'), Void.TYPE, Character.valueOf('V'), Boolean.TYPE, Character.valueOf('Z'));
        private static final Map<Class<?>, Map<String, List<MemberInfo>>> mapClassMembers = new HashMap();

        Util() {
        }

        public static boolean empty(String s) {
            return s == null || s.length() == 0;
        }

        public static <T> List<T> asList(Object o) {
            if (o == null) {
                return new ArrayList(0);
            }
            if (o instanceof Collection) {
                return new ArrayList((Collection)o);
            }
            if (o.getClass().isArray()) {
                ArrayList<Object> list = new ArrayList<Object>();
                int n = Array.getLength(o);
                for (int i = 0; i < n; ++i) {
                    list.add(Array.get(o, i));
                }
                return list;
            }
            return Util.listAdd(new ArrayList(1), o);
        }

        public static String qt(Object o) {
            return o == null || o instanceof Boolean || o instanceof Number ? "" + o : (o instanceof Character ? "'" + o + "'" : "\"" + o + "\"");
        }

        public static String dumpStackTrace(Throwable e, boolean singleLine) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            String s = sw.toString();
            return singleLine ? s.replace("\r", "\\r").replace("\n", "\\n").replace("\t", "\\t") : s;
        }

        public static void logStderr(String msg, Object ... args) {
            if (args.length > 0) {
                msg = String.format(msg, args);
            }
            System.err.println("[ERR] [" + new Date() + "] " + msg);
        }

        public static <K, V> V mapGet(Map<K, V> map, K key, V fallback) {
            V v;
            return map != null && (v = map.get(key)) != null ? v : fallback;
        }

        public static <K, V> Map<K, List<V>> mapListAdd(Map<K, List<V>> map, K key, V ... val) {
            return Util.mapListAdd(map, ArrayList.class, key, val);
        }

        public static <K, V, L extends Collection<V>> Map<K, L> mapListAdd(Map<K, L> map, Class<? extends Collection> collectionClass, K key, V ... val) {
            Collection l = (Collection)map.get(key);
            if (l == null) {
                try {
                    l = collectionClass.newInstance();
                    map.put(key, l);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Collections.addAll(l, val);
            return map;
        }

        public static <K, S, V, M extends Map<S, V>> V mapMapGet(Map<K, M> map, K key, S subkey, V fallback) {
            Object ret;
            Map m = (Map)map.get(key);
            return m != null && (ret = m.get(subkey)) != null ? ret : fallback;
        }

        public static <T> Iterable<T> safeIter(Iterable<T> iter) {
            return iter != null ? iter : new ArrayList(0);
        }

        public static <T> T[] safeArray(T[] array, Class<T> componentType) {
            return array != null ? array : (Object[])Array.newInstance(componentType, 0);
        }

        public static Map<String, Object> newMap(Object ... keyValuePairs) {
            return Util.mapPut(new LinkedHashMap(), keyValuePairs);
        }

        public static <K, V, M extends Map<K, V>> M mapPut(M map, Object ... keyValuePairs) {
            if ((keyValuePairs.length & 1) != 0) {
                throw new IllegalArgumentException("the number of keyValuePairs arguments must be odd");
            }
            int n = keyValuePairs.length;
            for (int i = 0; i < n; i += 2) {
                map.put((Object)keyValuePairs[i], (Object)keyValuePairs[i + 1]);
            }
            return map;
        }

        public static <T, L extends Collection<T>> L listAdd(L list, T ... values) {
            list.addAll(Arrays.asList(values));
            return list;
        }

        public static String urlDecode(String s, String enc) {
            if (!Util.empty(s)) {
                try {
                    return URLDecoder.decode(s, enc);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return s;
        }

        public static String b2s(byte[] bb, String charset, String fallback) {
            return Util.b2s(bb, 0, bb.length, charset, fallback);
        }

        public static String b2s(byte[] bb, int offset, int count, String charset, String fallback) {
            try {
                int start = bb.length - offset >= 3 && bb[offset] == 239 && bb[offset + 1] == 187 && bb[offset + 2] == 191 ? 3 : 0;
                return new String(bb, offset + start, count - start, charset == null ? "UTF-8" : charset);
            }
            catch (Exception e) {
                return fallback;
            }
        }

        public static byte[] s2b(String s, String charset) {
            try {
                return s.getBytes(charset == null ? "UTF-8" : charset);
            }
            catch (Exception e) {
                return null;
            }
        }

        public static String[][] split(String s, String delim1, String delim2) {
            String[] ss = s.split(delim1);
            String[][] result = new String[ss.length][];
            int i = ss.length;
            while (--i >= 0) {
                result[i] = ss[i].split(delim2);
            }
            return result;
        }

        public static Map<String, String> split(String s, String entryDelim, String kvDelim, Map<String, String> toMap) {
            String[] ss = s.split(entryDelim);
            if (toMap == null) {
                toMap = new HashMap<String, String>(ss.length);
            }
            for (String l : ss) {
                String[] sub = l.split(kvDelim);
                toMap.put(sub[0].trim(), sub.length > 1 ? sub[1].trim() : "");
            }
            return toMap;
        }

        public static String join(Object mapOrColl, String delim, String subDelim) {
            ArrayList<List<Object>> all = new ArrayList<List<Object>>();
            if (mapOrColl != null) {
                if (mapOrColl instanceof Map) {
                    for (Map.Entry kv : ((Map)mapOrColl).entrySet()) {
                        all.add(Util.listAdd(new ArrayList(2), kv.getKey(), kv.getValue()));
                    }
                } else if (mapOrColl instanceof Collection) {
                    for (Object o : (Collection)mapOrColl) {
                        all.add(Util.asList(o));
                    }
                } else if (mapOrColl.getClass().isArray()) {
                    int i = 0;
                    int n = Array.getLength(mapOrColl);
                    while (i < n) {
                        all.add(Util.asList(Array.get(mapOrColl, i++)));
                    }
                } else {
                    all.add(Util.asList(mapOrColl));
                }
            }
            StringBuilder sb = new StringBuilder();
            int i = 0;
            for (List list : all) {
                if (i++ > 0) {
                    sb.append(delim);
                }
                int j = 0;
                for (Object o : list) {
                    sb.append(j++ > 0 ? subDelim : "").append(o);
                }
            }
            return sb.toString();
        }

        public static String base64Encode(byte[] bb) {
            Class<?> clz = Util.getClass("java.util.Base64", null);
            if (clz != null) {
                Object encoder = Util.invokeSilent(null, clz, "getEncoder", false, null, new Object[0]);
                return (String)Util.invokeSilent(encoder, null, "encodeToString", false, "[B", new Object[]{bb});
            }
            clz = Util.getClass("sun.misc.BASE64Encoder", null);
            if (clz != null) {
                Object encoder = Util.createInstance(clz, "", true, new Object[0]);
                return ((String)Util.invokeSilent(encoder, null, "encode", true, "[B", new Object[]{bb})).replaceAll("[\r\n]+", "");
            }
            clz = Util.getClass("org.apache.commons.codec.binary.Base64", null);
            if (clz != null) {
                return (String)Util.invokeSilent(null, clz, "encodeBase64String", false, "[B", new Object[]{bb});
            }
            clz = Util.getClass("android.util.Base64", null);
            if (clz != null) {
                return (String)Util.invokeSilent(null, clz, "encodeToString", false, "[BI", bb, 2);
            }
            throw new RuntimeException(new NoSuchMethodException("base64Encode"));
        }

        public static byte[] readStream(InputStream is, boolean close) {
            return Util.readStream(is, 0, close);
        }

        public static byte[] readStream(InputStream is, int interruptOnSize, boolean close) {
            byte[] result;
            int count;
            int c;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            for (count = 0; (c = Util.pipeStream(is, bos)) > 0 && (interruptOnSize <= 0 || count < interruptOnSize); count += c) {
            }
            if (c < 0) {
                count += c & Integer.MAX_VALUE;
            }
            Object object = result = (Object)(c < 0 && count == 0 ? null : bos.toByteArray());
            if (close) {
                try {
                    is.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return result;
        }

        public static int pipeStream(InputStream source, OutputStream destination) {
            int len;
            byte[] bb = new byte[10000];
            int count = 0;
            do {
                len = 0;
                try {
                    len = source.read(bb);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                }
                catch (SocketException e) {
                    len = -1;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (len <= 0) continue;
                try {
                    destination.write(bb, 0, len);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                count += len;
            } while (len == 10000);
            return len < 0 ? Integer.MIN_VALUE | count : count;
        }

        public static void mkdirs(File dir) {
            File parent = dir.getAbsoluteFile();
            ArrayList<File> mkdir = new ArrayList<File>();
            while (!parent.exists() || !parent.isDirectory()) {
                mkdir.add(parent);
                parent = parent.getParentFile();
            }
            int i = mkdir.size();
            while (--i >= 0) {
                File d = (File)mkdir.get(i);
                d.mkdir();
                d.setReadable(true, false);
                d.setWritable(true, false);
            }
        }

        public static Class<?> getClass(String className, ClassLoader cl) {
            try {
                return (cl != null ? cl : CUrl.class.getClassLoader()).loadClass(className);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        public static <T> T createInstance(Class<T> cls, String signature, boolean ignoreAccess, Object ... args) {
            if (signature == null && args.length == 0) {
                try {
                    return cls.newInstance();
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException(ex);
                }
            }
            return (T)Util.invoke(null, cls, "<init>", ignoreAccess, signature, args);
        }

        public static Object getField(Object thiz, Class<?> cls, String fieldName, Object fallback, boolean ignoreAccess) {
            if (thiz == null && cls == null || fieldName == null) {
                throw new NullPointerException("inst=" + thiz + ",class=" + cls + ",field=" + fieldName);
            }
            try {
                for (MemberInfo mi : Util.safeIter(Util.getMembers(thiz != null ? thiz.getClass() : cls, fieldName))) {
                    AccessibleObject acc;
                    if (-1 != mi.numArgs || !ignoreAccess && (mi.member.getModifiers() & 1) == 0) continue;
                    if (ignoreAccess && !(acc = (AccessibleObject)((Object)mi.member)).isAccessible()) {
                        acc.setAccessible(true);
                    }
                    return ((Field)mi.member).get(thiz);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return fallback;
        }

        public static Object invokeSilent(Object thiz, Class<?> cls, String methodName, boolean ignoreAccess, String signature, Object ... args) {
            try {
                return Util.invoke(thiz, cls, methodName, ignoreAccess, signature, args);
            }
            catch (Exception exception) {
                return null;
            }
        }

        public static Object invoke(Object thiz, Class<?> cls, String methodName, boolean ignoreAccess, String signature, Object ... args) {
            if (thiz == null && cls == null || methodName == null) {
                throw new NullPointerException("inst=" + thiz + ",class=" + cls + ",method=" + methodName);
            }
            List<MemberInfo> found = Util.getMembers(thiz != null ? thiz.getClass() : cls, methodName);
            try {
                AccessibleObject acc;
                Member m = null;
                if (found != null) {
                    if (signature == null) {
                        int len = args.length;
                        for (MemberInfo mi : found) {
                            if (len != mi.numArgs || !ignoreAccess && (mi.member.getModifiers() & 1) == 0) continue;
                            m = mi.member;
                            break;
                        }
                    } else {
                        signature = signature.replace('/', '.');
                        for (MemberInfo mi : found) {
                            if (!signature.equals(mi.signature) || !ignoreAccess && (mi.member.getModifiers() & 1) == 0) continue;
                            m = mi.member;
                            break;
                        }
                    }
                }
                if (m == null) {
                    StringBuilder msg = new StringBuilder().append('\"').append(methodName).append('\"');
                    if (signature == null) {
                        msg.append(" with ").append(args.length).append(" parameter(s)");
                    } else {
                        msg.append(" with signature \"").append(signature).append("\"");
                    }
                    throw new NoSuchMethodException(msg.toString());
                }
                if (ignoreAccess && !(acc = (AccessibleObject)((Object)m)).isAccessible()) {
                    acc.setAccessible(true);
                }
                return m instanceof Method ? ((Method)m).invoke(thiz, args) : ((Constructor)m).newInstance(args);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(ex);
            }
        }

        public static String getSignature(Class<?> ... types) {
            StringBuilder sb = new StringBuilder();
            for (Class<?> t : types) {
                while (t.isArray()) {
                    sb.append('[');
                    t = t.getComponentType();
                }
                Character c = (Character)primaryTypes.get(t);
                if (c != null) {
                    sb.append(c);
                    continue;
                }
                sb.append('L').append(t.getName()).append(';');
            }
            return sb.toString();
        }

        private static synchronized List<MemberInfo> getMembers(Class<?> cls, String name) {
            if (!mapClassMembers.containsKey(cls)) {
                LinkedHashMap map = new LinkedHashMap();
                mapClassMembers.put(cls, map);
                for (Class<?> clss = cls; clss != null && !Object.class.equals(clss); clss = clss.getSuperclass()) {
                    Class<?>[] ptypes;
                    for (Constructor constructor : Util.safeArray(clss.getDeclaredConstructors(), Constructor.class)) {
                        ptypes = constructor.getParameterTypes();
                        Util.mapListAdd(map, "<init>", new MemberInfo(Util.getSignature(ptypes), ptypes.length, constructor));
                    }
                    for (Executable executable : Util.safeArray(clss.getDeclaredMethods(), Method.class)) {
                        ptypes = ((Method)executable).getParameterTypes();
                        Util.mapListAdd(map, ((Method)executable).getName(), new MemberInfo(Util.getSignature(ptypes), ptypes.length, executable));
                    }
                    for (AccessibleObject accessibleObject : Util.safeArray(clss.getDeclaredFields(), Field.class)) {
                        Util.mapListAdd(map, ((Field)accessibleObject).getName(), new MemberInfo(null, -1, (Member)((Object)accessibleObject)));
                    }
                }
            }
            return Util.mapMapGet(mapClassMembers, cls, name, null);
        }

        private static class MemberInfo {
            String signature;
            int numArgs;
            Member member;

            MemberInfo(String sign, int num, Member member) {
                this.signature = sign;
                this.numArgs = num;
                this.member = member;
            }

            public final String toString() {
                return this.member.toString();
            }
        }

        public static class Ref<T> {
            public int i;
            public T v;

            public Ref(T v) {
                this(0, v);
            }

            public Ref(int i, T v) {
                this.setInt(i);
                this.set(v);
            }

            public T get() {
                return this.v;
            }

            public void set(T v) {
                this.v = v;
            }

            public int getInt() {
                return this.i;
            }

            public void setInt(int i) {
                this.i = i;
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof Ref)) {
                    return false;
                }
                Ref o = (Ref)obj;
                return o != null && this.i == o.i && (this.v == null ? o.v == null : this.v.equals(o.v));
            }

            public int hashCode() {
                return this.i + (this.v == null ? 0 : this.v.hashCode());
            }

            public String toString() {
                return String.format("Ref{%s, %s}", this.i, Util.qt(this.v));
            }
        }
    }

    public static final class Recoverable
    extends Exception {
        private final int httpCode;

        public Recoverable() {
            this(null, -1);
        }

        public Recoverable(Throwable cause, int httpCode) {
            super(cause);
            this.httpCode = httpCode;
        }
    }

    public static final class CookieStore
    extends CookieIO {
        private final ThreadLocal<Map<String, List<HttpCookie>>> cookies = new ThreadLocal<Map<String, List<HttpCookie>>>(){

            @Override
            protected synchronized Map<String, List<HttpCookie>> initialValue() {
                return new HashMap<String, List<HttpCookie>>();
            }
        };

        @Override
        protected Map<String, List<HttpCookie>> getCookiesMap() {
            return this.cookies.get();
        }
    }

    public static class CookieIO
    implements IO,
    java.net.CookieStore {
        protected final Map<String, List<HttpCookie>> cookiesMap = new HashMap<String, List<HttpCookie>>();

        @Override
        public InputStream getInputStream() {
            throw new RuntimeException();
        }

        @Override
        public OutputStream getOutputStream() {
            throw new RuntimeException();
        }

        @Override
        public void setAppend(boolean append) {
        }

        @Override
        public void close() {
        }

        protected Map<String, List<HttpCookie>> getCookiesMap() {
            return this.cookiesMap;
        }

        public void add(String uri, String key, String value) {
            try {
                this.add(new URI(uri), new HttpCookie(key, value));
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        public void add(URI uri, HttpCookie cookie) {
            CookieIO.normalize(uri, cookie);
            Map<String, List<HttpCookie>> map = Util.mapListAdd(this.getCookiesMap(), ArrayList.class, cookie.getDomain(), new HttpCookie[0]);
            List<HttpCookie> cc = map.get(cookie.getDomain());
            cc.remove(cookie);
            if (cookie.getMaxAge() != 0L) {
                cc.add(cookie);
            }
        }

        @Override
        public List<HttpCookie> get(URI uri) {
            List<HttpCookie> result = this.getCookies();
            String host = uri.getHost();
            ListIterator<HttpCookie> it = result.listIterator();
            while (it.hasNext()) {
                String domain = it.next().getDomain();
                if (CookieIO.domainMatches(domain, host)) continue;
                it.remove();
            }
            return result;
        }

        @Override
        public List<HttpCookie> getCookies() {
            ArrayList<HttpCookie> result = new ArrayList<HttpCookie>();
            for (List<HttpCookie> cc : this.getCookiesMap().values()) {
                ListIterator<HttpCookie> it = cc.listIterator();
                while (it.hasNext()) {
                    if (!it.next().hasExpired()) continue;
                    it.remove();
                }
                result.addAll(cc);
            }
            return result;
        }

        @Override
        public List<URI> getURIs() {
            HashSet<URI> result = new HashSet<URI>();
            for (HttpCookie cookie : this.getCookies()) {
                String scheme = cookie.getSecure() ? "https" : "http";
                String domain = cookie.getDomain();
                if (domain.startsWith(".")) {
                    domain = domain.substring(1);
                }
                try {
                    result.add(new URI(scheme, domain, cookie.getPath(), null));
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
            return new ArrayList<URI>(result);
        }

        @Override
        public boolean remove(URI uri, HttpCookie cookie) {
            CookieIO.normalize(uri, cookie);
            List<HttpCookie> cc = this.getCookiesMap().get(cookie.getDomain());
            return cc != null && cc.remove(cookie);
        }

        @Override
        public boolean removeAll() {
            this.getCookiesMap().clear();
            return true;
        }

        private static void normalize(URI uri, HttpCookie cookie) {
            if (cookie.getDomain() == null && uri != null) {
                cookie.setDomain(uri.getHost());
            }
            if (cookie.getPath() == null && uri != null) {
                cookie.setPath(uri.getPath());
            }
            if (Util.empty(cookie.getDomain())) {
                throw new IllegalArgumentException("illegal cookie domain: " + cookie.getDomain());
            }
            if (Util.empty(cookie.getPath())) {
                cookie.setPath("/");
            }
            cookie.setVersion(0);
        }

        private static boolean domainMatches(String domain, String host) {
            if (domain == null || host == null) {
                return false;
            }
            if (domain.startsWith(".")) {
                return host.toLowerCase().endsWith(domain.toLowerCase());
            }
            return host.equalsIgnoreCase(domain);
        }
    }

    public static final class MemIO
    extends ByteArrayOutputStream
    implements IO {
        public MemIO() {
            super(0);
        }

        @Override
        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.buf, 0, this.count);
        }

        @Override
        public OutputStream getOutputStream() {
            return this;
        }

        @Override
        public void setAppend(boolean append) {
            if (!append) {
                this.reset();
            }
        }

        @Override
        public void close() {
        }

        @Override
        public String toString() {
            return "MemIO<" + this.hashCode() + ">";
        }

        public Map<String, String> parseDumpedHeader() {
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            String s = Util.b2s(this.toByteArray(), null, null);
            for (String l : s.split("[\r\n]+")) {
                if (l.trim().length() == 0) continue;
                String[] kv = l.split(":", 2);
                result.put(kv[0], kv.length > 1 ? kv[1].trim() : "");
            }
            return result;
        }

        public List<HttpCookie> parseCookieJar() {
            return CUrl.parseCookies(Util.b2s(this.toByteArray(), null, null));
        }
    }

    public static final class FileIO
    implements IO {
        private File f;
        private transient InputStream is;
        private transient OutputStream os;
        boolean append = false;

        public FileIO(File f) {
            this.f = f.getAbsoluteFile();
        }

        public FileIO(String path) {
            this(new File(path));
        }

        @Override
        public InputStream getInputStream() {
            if (this.f.exists() && this.f.isFile() && this.f.canRead()) {
                try {
                    this.is = new FileInputStream(this.f);
                    return this.is;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        @Override
        public OutputStream getOutputStream() {
            Util.mkdirs(this.f.getParentFile());
            try {
                this.f.createNewFile();
                this.f.setReadable(true, false);
                this.f.setWritable(true, false);
                this.os = new FileOutputStream(this.f, this.append);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.os;
        }

        @Override
        public void setAppend(boolean append) {
            this.append = append;
        }

        @Override
        public void close() {
            try {
                if (this.is != null) {
                    this.is.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.os != null) {
                    this.os.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public String toString() {
            return "FileIO<" + this.f + ">";
        }
    }

    public static final class WrappedIO
    implements IO {
        final InputStream is;
        final OutputStream os;

        public WrappedIO(String s, String charset) {
            this(Util.s2b(s, charset));
        }

        public WrappedIO(byte[] byteArray) {
            this(new ByteArrayInputStream(byteArray));
        }

        public WrappedIO(InputStream is) {
            this.is = is;
            this.os = null;
        }

        public WrappedIO(OutputStream os) {
            this.is = null;
            this.os = os;
        }

        @Override
        public InputStream getInputStream() {
            return this.is;
        }

        @Override
        public OutputStream getOutputStream() {
            return this.os;
        }

        @Override
        public void setAppend(boolean append) {
        }

        @Override
        public void close() {
        }

        public String toString() {
            return "WrappedIO<" + this.is + "," + this.os + ">";
        }
    }

    public static interface IO {
        public InputStream getInputStream();

        public OutputStream getOutputStream();

        public void setAppend(boolean var1);

        public void close();
    }

    public static class ToStringResolver
    implements Resolver<String> {
        private final String charset;

        public ToStringResolver(String charset) {
            this.charset = charset;
        }

        @Override
        public String resolve(int httpCode, byte[] raw) throws Throwable {
            return new String(raw, this.charset);
        }
    }

    public static interface Resolver<T> {
        public T resolve(int var1, byte[] var2) throws Throwable;
    }
}

