/*
 * Decompiled with CFR 0.152.
 */
package com.github.romankh3.image.comparison;

import com.github.romankh3.image.comparison.ImageComparisonUtil;
import com.github.romankh3.image.comparison.model.ExcludedAreas;
import com.github.romankh3.image.comparison.model.ImageComparisonResult;
import com.github.romankh3.image.comparison.model.Rectangle;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class ImageComparison {
    private int threshold = 5;
    private final BufferedImage expected;
    private final BufferedImage actual;
    private int rectangleLineWidth = 1;
    private File destination;
    private int counter;
    private int regionCount = this.counter = 2;
    private Integer minimalRectangleSize = 1;
    private Integer maximalRectangleCount = -1;
    private double pixelToleranceLevel = 0.1;
    private double differenceConstant;
    private int[][] matrix;
    private ExcludedAreas excludedAreas = new ExcludedAreas();
    private boolean drawExcludedRectangles = false;
    private float differencePercent;

    public ImageComparison(String expected, String actual) {
        this(ImageComparisonUtil.readImageFromResources(expected), ImageComparisonUtil.readImageFromResources(actual), null);
    }

    public ImageComparison(BufferedImage expected, BufferedImage actual, File destination) {
        this.expected = expected;
        this.actual = actual;
        this.destination = destination;
        this.differenceConstant = this.calculateDifferenceConstant();
    }

    public ImageComparison(BufferedImage expected, BufferedImage actual) {
        this(expected, actual, null);
    }

    public ImageComparisonResult compareImages() {
        if (this.isImageSizesNotEqual(this.expected, this.actual)) {
            BufferedImage actualResized = ImageComparisonUtil.resize(this.actual, this.expected.getWidth(), this.expected.getHeight());
            this.differencePercent = ImageComparisonUtil.getDifferencePercent(actualResized, this.expected);
            return ImageComparisonResult.defaultSizeMisMatchResult(this.expected, this.actual, this.differencePercent);
        }
        List<Rectangle> rectangles = this.populateRectangles();
        if (rectangles.isEmpty()) {
            ImageComparisonResult matchResult = ImageComparisonResult.defaultMatchResult(this.expected, this.actual);
            if (this.drawExcludedRectangles) {
                matchResult.setResult(this.drawRectangles(rectangles));
                this.saveImageForDestination(matchResult.getResult());
            }
            return matchResult;
        }
        BufferedImage resultImage = this.drawRectangles(rectangles);
        this.saveImageForDestination(resultImage);
        return ImageComparisonResult.defaultMisMatchResult(this.expected, this.actual).setResult(resultImage);
    }

    private boolean isImageSizesNotEqual(BufferedImage expected, BufferedImage actual) {
        return expected.getHeight() != actual.getHeight() || expected.getWidth() != actual.getWidth();
    }

    private void populateTheMatrixOfTheDifferences() {
        this.matrix = new int[this.expected.getHeight()][this.expected.getWidth()];
        for (int y = 0; y < this.expected.getHeight(); ++y) {
            for (int x = 0; x < this.expected.getWidth(); ++x) {
                Point point = new Point(x, y);
                if (this.excludedAreas.contains(point)) continue;
                this.matrix[y][x] = this.isDifferentPixels(this.expected.getRGB(x, y), this.actual.getRGB(x, y)) ? 1 : 0;
            }
        }
    }

    private boolean isDifferentPixels(int expectedRgb, int actualRgb) {
        if (expectedRgb == actualRgb) {
            return false;
        }
        if (this.pixelToleranceLevel == 0.0) {
            return true;
        }
        int red1 = expectedRgb >> 16 & 0xFF;
        int green1 = expectedRgb >> 8 & 0xFF;
        int blue1 = expectedRgb & 0xFF;
        int red2 = actualRgb >> 16 & 0xFF;
        int green2 = actualRgb >> 8 & 0xFF;
        int blue2 = actualRgb & 0xFF;
        return Math.pow(red2 - red1, 2.0) + Math.pow(green2 - green1, 2.0) + Math.pow(blue2 - blue1, 2.0) > this.differenceConstant;
    }

    private List<Rectangle> populateRectangles() {
        this.populateTheMatrixOfTheDifferences();
        this.groupRegions();
        ArrayList<Rectangle> rectangles = new ArrayList<Rectangle>();
        while (this.counter <= this.regionCount) {
            Rectangle rectangle = this.createRectangle();
            if (!rectangle.equals(Rectangle.createDefault()) && rectangle.size() >= this.minimalRectangleSize) {
                rectangles.add(rectangle);
            }
            ++this.counter;
        }
        return this.mergeRectangles(rectangles);
    }

    private Rectangle createRectangle() {
        Rectangle rectangle = Rectangle.createDefault();
        for (int y = 0; y < this.matrix.length; ++y) {
            for (int x = 0; x < this.matrix[0].length; ++x) {
                if (this.matrix[y][x] != this.counter) continue;
                this.updateRectangleCreation(rectangle, x, y);
            }
        }
        return rectangle;
    }

    private void updateRectangleCreation(Rectangle rectangle, int x, int y) {
        if ((double)x < rectangle.getMinPoint().getX()) {
            rectangle.getMinPoint().x = x;
        }
        if ((double)x > rectangle.getMaxPoint().getX()) {
            rectangle.getMaxPoint().x = x;
        }
        if ((double)y < rectangle.getMinPoint().getY()) {
            rectangle.getMinPoint().y = y;
        }
        if ((double)y > rectangle.getMaxPoint().getY()) {
            rectangle.getMaxPoint().y = y;
        }
    }

    private List<Rectangle> mergeRectangles(List<Rectangle> rectangles) {
        for (int position = 0; position < rectangles.size(); ++position) {
            for (int i = 1 + position; i < rectangles.size(); ++i) {
                Rectangle r1 = rectangles.get(position);
                Rectangle r2 = rectangles.get(i);
                if (r1.equals(Rectangle.createZero()) || !r1.isOverlapping(r2)) continue;
                rectangles.set(position, r1.merge(r2));
                r2.makeZeroRectangle();
                if (position == 0) continue;
                --position;
            }
        }
        return rectangles.stream().filter(it -> !it.equals(Rectangle.createZero())).collect(Collectors.toList());
    }

    private BufferedImage drawRectangles(List<Rectangle> rectangles) {
        BufferedImage resultImage = ImageComparisonUtil.deepCopy(this.actual);
        Graphics2D graphics = this.preparedGraphics2D(resultImage);
        this.drawExcludedRectangles(graphics);
        this.drawRectanglesOfDifferences(rectangles, graphics);
        return resultImage;
    }

    private void drawExcludedRectangles(Graphics2D graphics) {
        if (this.drawExcludedRectangles) {
            graphics.setColor(Color.GREEN);
            this.draw(graphics, this.excludedAreas.getExcluded());
        }
    }

    private void drawRectanglesOfDifferences(List<Rectangle> rectangles, Graphics2D graphics) {
        graphics.setColor(Color.RED);
        List<Rectangle> rectanglesForDraw = this.maximalRectangleCount > 0 ? rectangles.stream().sorted(Comparator.comparing(Rectangle::size)).skip(rectangles.size() - this.maximalRectangleCount).collect(Collectors.toList()) : new ArrayList<Rectangle>(rectangles);
        this.draw(graphics, rectanglesForDraw);
    }

    private Graphics2D preparedGraphics2D(BufferedImage image) {
        Graphics2D graphics = image.createGraphics();
        graphics.setStroke(new BasicStroke(this.rectangleLineWidth));
        return graphics;
    }

    private void saveImageForDestination(BufferedImage image) {
        if (Objects.nonNull(this.destination)) {
            ImageComparisonUtil.saveImage(this.destination, image);
        }
    }

    private void draw(Graphics2D graphics, List<Rectangle> rectangles) {
        rectangles.forEach(rectangle -> graphics.drawRect(rectangle.getMinPoint().x, rectangle.getMinPoint().y, rectangle.getWidth() - 1, rectangle.getHeight() - 1));
    }

    private void groupRegions() {
        for (int y = 0; y < this.matrix.length; ++y) {
            for (int x = 0; x < this.matrix[y].length; ++x) {
                if (this.matrix[y][x] != 1) continue;
                this.joinToRegion(x, y);
                ++this.regionCount;
            }
        }
    }

    private void joinToRegion(int x, int y) {
        if (this.isJumpRejected(x, y)) {
            return;
        }
        this.matrix[y][x] = this.regionCount;
        for (int i = 0; i < this.threshold; ++i) {
            this.joinToRegion(x + 1 + i, y);
            this.joinToRegion(x, y + 1 + i);
            this.joinToRegion(x + 1 + i, y - 1 - i);
            this.joinToRegion(x - 1 - i, y + 1 + i);
            this.joinToRegion(x + 1 + i, y + 1 + i);
        }
    }

    public List<Rectangle> createMask() {
        return this.populateRectangles();
    }

    private boolean isJumpRejected(int x, int y) {
        return y < 0 || y >= this.matrix.length || x < 0 || x >= this.matrix[y].length || this.matrix[y][x] != 1;
    }

    public double getPixelToleranceLevel() {
        return this.pixelToleranceLevel;
    }

    public ImageComparison setPixelToleranceLevel(double pixelToleranceLevel) {
        if (0.0 <= pixelToleranceLevel && pixelToleranceLevel < 1.0) {
            this.pixelToleranceLevel = pixelToleranceLevel;
            this.differenceConstant = this.calculateDifferenceConstant();
        }
        return this;
    }

    private double calculateDifferenceConstant() {
        return Math.pow(this.pixelToleranceLevel * Math.sqrt(Math.pow(255.0, 2.0) * 3.0), 2.0);
    }

    public boolean isDrawExcludedRectangles() {
        return this.drawExcludedRectangles;
    }

    public ImageComparison setDrawExcludedRectangles(boolean drawExcludedRectangles) {
        this.drawExcludedRectangles = drawExcludedRectangles;
        return this;
    }

    public int getThreshold() {
        return this.threshold;
    }

    public ImageComparison setThreshold(int threshold) {
        this.threshold = threshold;
        return this;
    }

    public Optional<File> getDestination() {
        return Optional.ofNullable(this.destination);
    }

    public ImageComparison setDestination(File destination) {
        this.destination = destination;
        return this;
    }

    public BufferedImage getExpected() {
        return this.expected;
    }

    public BufferedImage getActual() {
        return this.actual;
    }

    public int getRectangleLineWidth() {
        return this.rectangleLineWidth;
    }

    public ImageComparison setRectangleLineWidth(int rectangleLineWidth) {
        this.rectangleLineWidth = rectangleLineWidth;
        return this;
    }

    public Integer getMinimalRectangleSize() {
        return this.minimalRectangleSize;
    }

    public ImageComparison setMinimalRectangleSize(Integer minimalRectangleSize) {
        this.minimalRectangleSize = minimalRectangleSize;
        return this;
    }

    public Integer getMaximalRectangleCount() {
        return this.maximalRectangleCount;
    }

    public ImageComparison setMaximalRectangleCount(Integer maximalRectangleCount) {
        this.maximalRectangleCount = maximalRectangleCount;
        return this;
    }

    public ImageComparison setExcludedAreas(List<Rectangle> excludedAreas) {
        this.excludedAreas = new ExcludedAreas(excludedAreas);
        return this;
    }
}

