/*
 * Decompiled with CFR 0.152.
 */
package com.github.romankh3.image.comparison.model;

import com.github.romankh3.image.comparison.ImageComparisonUtil;
import com.github.romankh3.image.comparison.model.ImageComparisonState;
import java.awt.image.BufferedImage;
import java.io.File;

public class ImageComparisonResult {
    private BufferedImage expected;
    private BufferedImage actual;
    private BufferedImage result;
    private ImageComparisonState imageComparisonState;
    private float differencePercent;

    public static ImageComparisonResult defaultSizeMisMatchResult(BufferedImage expected, BufferedImage actual, float differencePercent) {
        return new ImageComparisonResult().setImageComparisonState(ImageComparisonState.SIZE_MISMATCH).setDifferencePercent(differencePercent).setExpected(expected).setActual(actual).setResult(actual);
    }

    public static ImageComparisonResult defaultMisMatchResult(BufferedImage expected, BufferedImage actual) {
        return new ImageComparisonResult().setImageComparisonState(ImageComparisonState.MISMATCH).setExpected(expected).setActual(actual).setResult(actual);
    }

    public static ImageComparisonResult defaultMatchResult(BufferedImage expected, BufferedImage actual) {
        return new ImageComparisonResult().setImageComparisonState(ImageComparisonState.MATCH).setExpected(expected).setActual(actual).setResult(actual);
    }

    public ImageComparisonResult writeResultTo(File file) {
        ImageComparisonUtil.saveImage(file, this.result);
        return this;
    }

    public BufferedImage getExpected() {
        return this.expected;
    }

    public ImageComparisonResult setExpected(BufferedImage expected) {
        this.expected = expected;
        return this;
    }

    public BufferedImage getActual() {
        return this.actual;
    }

    public ImageComparisonResult setActual(BufferedImage actual) {
        this.actual = actual;
        return this;
    }

    public BufferedImage getResult() {
        return this.result;
    }

    public ImageComparisonResult setResult(BufferedImage result) {
        this.result = result;
        return this;
    }

    public ImageComparisonState getImageComparisonState() {
        return this.imageComparisonState;
    }

    public ImageComparisonResult setImageComparisonState(ImageComparisonState imageComparisonState) {
        this.imageComparisonState = imageComparisonState;
        return this;
    }

    public float getDifferencePercent() {
        return this.differencePercent;
    }

    ImageComparisonResult setDifferencePercent(float differencePercent) {
        this.differencePercent = differencePercent;
        return this;
    }
}

