/*
 * Decompiled with CFR 0.152.
 */
package com.github.roookeee.datus.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public interface Mapper<In, Out> {
    public Out convert(In var1);

    default public List<Out> convert(Collection<? extends In> input) {
        ArrayList<Out> result = new ArrayList<Out>(input.size());
        for (In in : input) {
            result.add(this.convert(in));
        }
        return result;
    }

    default public LinkedHashMap<In, Out> convertToMap(Collection<? extends In> input) {
        LinkedHashMap<In, Out> result = new LinkedHashMap<In, Out>();
        for (In in : input) {
            result.put(in, this.convert(in));
        }
        return result;
    }

    default public <KeyType> LinkedHashMap<KeyType, Out> convertToMap(Collection<? extends In> input, Function<? super In, ? extends KeyType> keyFunction) {
        LinkedHashMap<KeyType, Out> result = new LinkedHashMap<KeyType, Out>();
        for (In in : input) {
            result.put(keyFunction.apply(in), this.convert(in));
        }
        return result;
    }

    default public Stream<Out> conversionStream(Collection<? extends In> input) {
        return input.stream().map(this::convert);
    }

    default public Mapper<In, Optional<Out>> predicateInput(Predicate<? super In> predicate) {
        Mapper mapper = this;
        return input -> {
            if (!predicate.test((Object)input)) {
                return Optional.empty();
            }
            return Optional.of(mapper.convert(input));
        };
    }

    default public Mapper<In, Optional<Out>> predicateOutput(Predicate<? super Out> predicate) {
        Mapper mapper = this;
        return input -> {
            Object output = mapper.convert(input);
            if (!predicate.test((Object)output)) {
                return Optional.empty();
            }
            return Optional.of(output);
        };
    }

    default public Mapper<In, Optional<Out>> predicate(Predicate<? super In> inputPredicate, Predicate<? super Out> outputPredicate) {
        Mapper mapper = this;
        return input -> {
            if (!inputPredicate.test((Object)input)) {
                return Optional.empty();
            }
            Object output = mapper.convert(input);
            if (!outputPredicate.test((Object)output)) {
                return Optional.empty();
            }
            return Optional.of(output);
        };
    }
}

