/*
 * Decompiled with CFR 0.152.
 */
package com.github.roookeee.datus.immutable;

import com.github.roookeee.datus.conditional.ConditionalEnd;
import com.github.roookeee.datus.shared.LambdaHelper;
import com.github.roookeee.datus.shared.SafetyMode;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public final class ConstructorParameterBinding<In, CurrentType, Ctor> {
    private final Ctor ctor;
    private final Function<? super In, ? extends CurrentType> getter;
    private final SafetyMode safetyMode;

    ConstructorParameterBinding(Ctor ctor, Function<? super In, ? extends CurrentType> getter, SafetyMode safetyMode) {
        this.ctor = ctor;
        this.getter = getter;
        this.safetyMode = safetyMode;
    }

    public ConstructorParameterBinding<In, CurrentType, Ctor> nullsafe() {
        return new ConstructorParameterBinding<In, CurrentType, Ctor>(this.ctor, this.getter, SafetyMode.NULL_SAFE);
    }

    public <IntermediateType> ConstructorParameterBinding<In, IntermediateType, Ctor> map(Function<? super CurrentType, ? extends IntermediateType> mapper) {
        return new ConstructorParameterBinding<In, IntermediateType, Ctor>(this.ctor, LambdaHelper.andThen(this.getter, this.handleSafetyMode(mapper)), this.safetyMode);
    }

    public <ResultType> ResultType to(BiFunction<Ctor, Function<? super In, ? extends CurrentType>, ResultType> parameterBinder) {
        return parameterBinder.apply(this.ctor, this.getter);
    }

    public <IntermediateType> ConditionalEnd<In, CurrentType, IntermediateType, ConstructorParameterBinding<In, IntermediateType, Ctor>> given(Predicate<? super CurrentType> predicate, IntermediateType value) {
        return this.given(predicate, (? super In in, ? super CurrentType v) -> value);
    }

    public <IntermediateType> ConditionalEnd<In, CurrentType, IntermediateType, ConstructorParameterBinding<In, IntermediateType, Ctor>> given(Predicate<? super CurrentType> predicate, Supplier<? extends IntermediateType> supplier) {
        return this.given(predicate, (? super In in, ? super CurrentType v) -> supplier.get());
    }

    public <IntermediateType> ConditionalEnd<In, CurrentType, IntermediateType, ConstructorParameterBinding<In, IntermediateType, Ctor>> given(Predicate<? super CurrentType> predicate, Function<? super CurrentType, ? extends IntermediateType> mapper) {
        return this.given(predicate, (? super In in, ? super CurrentType v) -> mapper.apply((Object)v));
    }

    public <IntermediateType> ConditionalEnd<In, CurrentType, IntermediateType, ConstructorParameterBinding<In, IntermediateType, Ctor>> given(Predicate<? super CurrentType> predicate, BiFunction<? super In, ? super CurrentType, ? extends IntermediateType> mapper) {
        return new ConditionalEnd<In, CurrentType, IntermediateType, ConstructorParameterBinding>(this.getter, predicate, newGetter -> new ConstructorParameterBinding<In, CurrentType, Ctor>(this.ctor, newGetter, this.safetyMode), mapper, this.safetyMode);
    }

    private <T, U> Function<T, U> handleSafetyMode(Function<T, U> mapper) {
        if (this.safetyMode == SafetyMode.NONE) {
            return mapper;
        }
        return LambdaHelper.nullsafe(mapper);
    }
}

