/*
 * Decompiled with CFR 0.152.
 */
package com.github.roookeee.datus.mutable;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;

class MappingOptimizer {
    private static final int LAST_CASE_MAPPING_COUNT = 8;

    static <In, Out> BiFunction<? super In, ? super Out, ? extends Out> flattenAndOptimizeMappings(List<BiFunction<? super In, ? super Out, ? extends Out>> mappings) {
        switch (mappings.size()) {
            case 1: {
                return mappings.get(0);
            }
            case 2: {
                return MappingOptimizer.optimize2Mappings(mappings);
            }
            case 3: {
                return MappingOptimizer.optimize3Mappings(mappings);
            }
            case 4: {
                return MappingOptimizer.optimize4Mappings(mappings);
            }
            case 5: {
                return MappingOptimizer.optimize5Mappings(mappings);
            }
            case 6: {
                return MappingOptimizer.optimize6Mappings(mappings);
            }
            case 7: {
                return MappingOptimizer.optimize7Mappings(mappings);
            }
            case 8: {
                return MappingOptimizer.optimize8Mappings(mappings);
            }
        }
        BiFunction<? super In, ? extends Out, ? extends Out> firstEightMappings = MappingOptimizer.optimize8Mappings(mappings);
        BiFunction<? super In, ? extends Out, ? extends Out> remainingMappings = MappingOptimizer.flattenAndOptimizeMappings(mappings.subList(8, mappings.size()));
        ArrayList<BiFunction<In, Out, Out>> toOptimize = new ArrayList<BiFunction<In, Out, Out>>();
        toOptimize.add(firstEightMappings);
        toOptimize.add(remainingMappings);
        return MappingOptimizer.optimize2Mappings(toOptimize);
    }

    private static <In, Out> BiFunction<? super In, ? super Out, ? extends Out> optimize2Mappings(List<BiFunction<? super In, ? super Out, ? extends Out>> remaining) {
        BiFunction a = remaining.get(0);
        BiFunction b = remaining.get(1);
        return (in, out) -> b.apply((Object)in, (Object)a.apply((Object)in, (Object)out));
    }

    private static <In, Out> BiFunction<? super In, ? super Out, ? extends Out> optimize3Mappings(List<BiFunction<? super In, ? super Out, ? extends Out>> remaining) {
        BiFunction a = remaining.get(0);
        BiFunction b = remaining.get(1);
        BiFunction c = remaining.get(2);
        return (in, out) -> c.apply((Object)in, (Object)b.apply((Object)in, (Object)a.apply((Object)in, (Object)out)));
    }

    private static <In, Out> BiFunction<? super In, ? super Out, ? extends Out> optimize4Mappings(List<BiFunction<? super In, ? super Out, ? extends Out>> remaining) {
        BiFunction a = remaining.get(0);
        BiFunction b = remaining.get(1);
        BiFunction c = remaining.get(2);
        BiFunction d = remaining.get(3);
        return (in, out) -> d.apply((Object)in, (Object)c.apply((Object)in, (Object)b.apply((Object)in, (Object)a.apply((Object)in, (Object)out))));
    }

    private static <In, Out> BiFunction<? super In, ? super Out, ? extends Out> optimize5Mappings(List<BiFunction<? super In, ? super Out, ? extends Out>> remaining) {
        BiFunction a = remaining.get(0);
        BiFunction b = remaining.get(1);
        BiFunction c = remaining.get(2);
        BiFunction d = remaining.get(3);
        BiFunction e = remaining.get(4);
        return (in, out) -> e.apply((Object)in, (Object)d.apply((Object)in, (Object)c.apply((Object)in, (Object)b.apply((Object)in, (Object)a.apply((Object)in, (Object)out)))));
    }

    private static <In, Out> BiFunction<? super In, ? super Out, ? extends Out> optimize6Mappings(List<BiFunction<? super In, ? super Out, ? extends Out>> remaining) {
        BiFunction a = remaining.get(0);
        BiFunction b = remaining.get(1);
        BiFunction c = remaining.get(2);
        BiFunction d = remaining.get(3);
        BiFunction e = remaining.get(4);
        BiFunction f = remaining.get(5);
        return (in, out) -> f.apply((Object)in, (Object)e.apply((Object)in, (Object)d.apply((Object)in, (Object)c.apply((Object)in, (Object)b.apply((Object)in, (Object)a.apply((Object)in, (Object)out))))));
    }

    private static <In, Out> BiFunction<? super In, ? super Out, ? extends Out> optimize7Mappings(List<BiFunction<? super In, ? super Out, ? extends Out>> remaining) {
        BiFunction a = remaining.get(0);
        BiFunction b = remaining.get(1);
        BiFunction c = remaining.get(2);
        BiFunction d = remaining.get(3);
        BiFunction e = remaining.get(4);
        BiFunction f = remaining.get(5);
        BiFunction g = remaining.get(6);
        return (in, out) -> g.apply((Object)in, (Object)f.apply((Object)in, (Object)e.apply((Object)in, (Object)d.apply((Object)in, (Object)c.apply((Object)in, (Object)b.apply((Object)in, (Object)a.apply((Object)in, (Object)out)))))));
    }

    private static <In, Out> BiFunction<? super In, ? super Out, ? extends Out> optimize8Mappings(List<BiFunction<? super In, ? super Out, ? extends Out>> remaining) {
        BiFunction a = remaining.get(0);
        BiFunction b = remaining.get(1);
        BiFunction c = remaining.get(2);
        BiFunction d = remaining.get(3);
        BiFunction e = remaining.get(4);
        BiFunction f = remaining.get(5);
        BiFunction g = remaining.get(6);
        BiFunction h = remaining.get(7);
        return (in, out) -> h.apply((Object)in, (Object)g.apply((Object)in, (Object)f.apply((Object)in, (Object)e.apply((Object)in, (Object)d.apply((Object)in, (Object)c.apply((Object)in, (Object)b.apply((Object)in, (Object)a.apply((Object)in, (Object)out))))))));
    }

    private MappingOptimizer() {
    }
}

