/*
 * Decompiled with CFR 0.152.
 */
package com.github.roookeee.datus.mutable;

import com.github.roookeee.datus.api.Mapper;
import com.github.roookeee.datus.mutable.MutableConstructionStep;
import com.github.roookeee.datus.shared.LambdaHelper;
import com.github.roookeee.datus.shared.SafetyMode;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public final class MutableMappingBuilder<In, Out> {
    private final List<BiFunction<? super In, ? super Out, ? extends Out>> mappers = new ArrayList<BiFunction<? super In, ? super Out, ? extends Out>>();
    private final Supplier<? extends Out> generator;

    public MutableMappingBuilder(Supplier<? extends Out> generator) {
        this.generator = generator;
    }

    public <A> MutableConstructionStep<In, A, Out> from(Function<? super In, ? extends A> getter) {
        return new MutableConstructionStep(this, getter, SafetyMode.NONE);
    }

    public MutableMappingBuilder<In, Out> process(BiFunction<? super In, ? super Out, ? extends Out> processor) {
        this.mappers.add(processor);
        return this;
    }

    public MutableMappingBuilder<In, Out> spy(BiConsumer<? super In, ? super Out> consumer) {
        this.process((in, out) -> {
            consumer.accept((Object)in, (Object)out);
            return out;
        });
        return this;
    }

    public Mapper<In, Out> build() {
        BiFunction<? super In, ? super Out, ? extends Out> mappingProcess = null;
        for (BiFunction<? super In, ? super Out, ? extends Out> biFunction : this.mappers) {
            if (mappingProcess == null) {
                mappingProcess = biFunction;
                continue;
            }
            mappingProcess = LambdaHelper.andThen(mappingProcess, biFunction);
        }
        BiFunction<? super In, ? super Out, ? extends Out> result = mappingProcess;
        Supplier<? extends Out> supplier = this.generator;
        return input -> result.apply((Object)input, (Object)generator.get());
    }

    void addMapper(BiFunction<? super In, ? super Out, ? extends Out> mapper) {
        this.mappers.add(mapper);
    }
}

