/*
 * Decompiled with CFR 0.152.
 */
package com.github.roookeee.datus.shared;

import com.github.roookeee.datus.immutable.ConstructorParameterBinding;
import com.github.roookeee.datus.mutable.MutableConstructionStep;
import com.github.roookeee.datus.mutable.MutableMappingBuilder;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;

public final class LambdaHelper {
    static final Set<String> WHITELISTED_CALLEES;
    static boolean OPTIMIZE;

    public static <T, U, R> BiFunction<T, R, R> toBiFunction(Function<? super T, ? extends U> getter, BiConsumer<? super R, ? super U> setter) {
        LambdaHelper.checkPrivileges();
        if (!OPTIMIZE) {
            return new SetterBiFn<T, U, R>(getter, setter);
        }
        return LambdaHelper.optimize(SetterBiFn.class, BiFunction.class, getter, setter);
    }

    public static <T, U, V, R> BiFunction<T, U, R> andThen(BiFunction<? super T, ? super U, ? extends V> first, BiFunction<? super T, ? super V, ? extends R> second) {
        LambdaHelper.checkPrivileges();
        if (!OPTIMIZE) {
            return new BiFunctionCombinator<T, U, V, R>(first, second);
        }
        return LambdaHelper.optimize(BiFunctionCombinator.class, BiFunction.class, first, second);
    }

    public static <T, U, R> Function<T, R> andThen(Function<? super T, ? extends U> first, Function<? super U, ? extends R> second) {
        LambdaHelper.checkPrivileges();
        if (!OPTIMIZE) {
            return new FunctionCombinator<T, U, R>(first, second);
        }
        return LambdaHelper.optimize(FunctionCombinator.class, Function.class, first, second);
    }

    public static <T, R> Function<T, R> nullsafe(Function<T, R> fn) {
        LambdaHelper.checkPrivileges();
        if (!OPTIMIZE) {
            return new NullSafeFunction<T, R>(fn);
        }
        return LambdaHelper.optimize(NullSafeFunction.class, Function.class, fn);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T, U extends T> T optimize(Class<U> clazz, Class<T> interfaceType, Object ... ctorArgs) {
        URL classLocation = clazz.getProtectionDomain().getCodeSource().getLocation();
        try (URLClassLoader cl = new URLClassLoader(new URL[]{classLocation}, null);){
            Class[] parameterInterfaceTypes = (Class[])Arrays.stream(ctorArgs).map(Object::getClass).map(c -> c.getInterfaces()[0]).toArray(Class[]::new);
            Constructor<T> ctor = cl.loadClass(clazz.getName()).asSubclass(interfaceType).getConstructor(parameterInterfaceTypes);
            ctor.setAccessible(true);
            T t = ctor.newInstance(ctorArgs);
            return t;
        }
        catch (IOException | ReflectiveOperationException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static void checkPrivileges() {
        Optional<String> firstExternalCaller = Arrays.stream(Thread.currentThread().getStackTrace()).skip(1L).map(StackTraceElement::getClassName).filter(className -> !className.equals(LambdaHelper.class.getName())).findFirst();
        if (!firstExternalCaller.isPresent()) {
            throw new IllegalStateException("Using datus internal functionality is forbidden. These APIs are highly unstable / brittle and thus not included in datus public API / versioning scheme!");
        }
        String caller = firstExternalCaller.get();
        if (!WHITELISTED_CALLEES.contains(caller)) {
            throw new IllegalStateException("Using datus internal functionality is forbidden. These APIs are highly unstable / brittle and thus not included in datus public API / versioning scheme!");
        }
    }

    private LambdaHelper() {
    }

    static {
        boolean disableOptimization;
        WHITELISTED_CALLEES = new HashSet<String>(Arrays.asList(OptimizationInitializer.class.getName(), MutableConstructionStep.class.getName(), ConstructorParameterBinding.class.getName(), MutableMappingBuilder.class.getName()));
        boolean isNativeImage = System.getProperty("org.graalvm.nativeimage.imagecode") != null;
        boolean bl = disableOptimization = System.getProperty("com.github.roookeee.datus.optimization.disable") != null;
        if (!isNativeImage && !disableOptimization) {
            OptimizationInitializer.init();
        }
    }

    private static final class OptimizationInitializer {
        private OptimizationInitializer() {
        }

        static void init() {
            OPTIMIZE = true;
            try {
                boolean allNonNull = Stream.of(LambdaHelper.toBiFunction(a -> null, (a, b) -> {}), LambdaHelper.andThen((a, b) -> null, (a, b) -> null), LambdaHelper.andThen(a -> null, a -> null), LambdaHelper.nullsafe(a -> null)).allMatch(Objects::nonNull);
                if (!allNonNull) {
                    throw new RuntimeException("datus mapper optimization did not work as expected - please file an issue at https://github.com/roookeee/datus. You can set the system property 'com.github.roookeee.datus.optimization.disable' to avoid this message for now");
                }
            }
            catch (Exception ex) {
                throw ex;
            }
            catch (Throwable t) {
                System.out.println("WARNING: datus tried to optimize the mapper code generation but failed to do so because a fatal error occured. This most likely means that your JVM does not support dynamic class loading. Set the system property 'com.github.roookeee.datus.optimization.disable' to avoid this warning in future executions. datus is falling back to unoptimized routines");
                OPTIMIZE = false;
            }
        }
    }

    static final class SetterBiFn<T, U, R>
    implements BiFunction<T, R, R> {
        private final Function<? super T, ? extends U> getter;
        private final BiConsumer<? super R, ? super U> setter;

        public SetterBiFn(Function<? super T, ? extends U> getter, BiConsumer<? super R, ? super U> setter) {
            this.getter = getter;
            this.setter = setter;
        }

        @Override
        public R apply(T t, R r) {
            this.setter.accept(r, this.getter.apply(t));
            return r;
        }
    }

    static class NullSafeFunction<T, R>
    implements Function<T, R> {
        private final Function<? super T, ? extends R> fn;

        public NullSafeFunction(Function<? super T, ? extends R> fn) {
            this.fn = fn;
        }

        @Override
        public R apply(T t) {
            if (t == null) {
                return null;
            }
            return this.fn.apply(t);
        }
    }

    static final class FunctionCombinator<T, U, R>
    implements Function<T, R> {
        private final Function<? super T, ? extends U> first;
        private final Function<? super U, ? extends R> second;

        public FunctionCombinator(Function<? super T, ? extends U> first, Function<? super U, ? extends R> second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public R apply(T t) {
            return this.second.apply(this.first.apply(t));
        }
    }

    static final class BiFunctionCombinator<T, U, V, R>
    implements BiFunction<T, U, R> {
        private final BiFunction<? super T, ? super U, ? extends V> first;
        private final BiFunction<? super T, ? super V, ? extends R> second;

        public BiFunctionCombinator(BiFunction<? super T, ? super U, ? extends V> first, BiFunction<? super T, ? super V, ? extends R> second) {
            this.first = first;
            this.second = second;
        }

        @Override
        public R apply(T t, U u) {
            return this.second.apply(t, this.first.apply(t, u));
        }
    }
}

