/*
 * Decompiled with CFR 0.152.
 */
package com.github.rozidan.springboot.logger;

import java.util.Objects;
import org.slf4j.LoggerFactory;
import org.springframework.boot.logging.LogLevel;
import org.springframework.stereotype.Component;

@Component
public final class Logger {
    public void log(LogLevel level, Class<?> clazz, String message, Object ... args) {
        this.log(LoggerFactory.getLogger(clazz), level, message, args);
    }

    public void log(LogLevel level, String name, String message, Object ... args) {
        this.log(LoggerFactory.getLogger((String)name), level, message, args);
    }

    public boolean isEnabled(LogLevel level, Class<?> clazz) {
        return this.isEnabled(LoggerFactory.getLogger(clazz), level);
    }

    public boolean isEnabled(LogLevel level, String name) {
        return this.isEnabled(LoggerFactory.getLogger((String)name), level);
    }

    private void log(org.slf4j.Logger logger, LogLevel level, String message, Object ... args) {
        Objects.requireNonNull(level, "LogLevel must not be null.");
        switch (level) {
            case TRACE: {
                logger.trace(message, args);
                break;
            }
            case DEBUG: {
                logger.debug(message, args);
                break;
            }
            case INFO: {
                logger.info(message, args);
                break;
            }
            case WARN: {
                logger.warn(message, args);
                break;
            }
            case ERROR: 
            case FATAL: {
                logger.error(message, args);
                break;
            }
        }
    }

    private boolean isEnabled(org.slf4j.Logger logger, LogLevel level) {
        Objects.requireNonNull(level, "LogLevel must not be null.");
        switch (level) {
            case TRACE: {
                return logger.isTraceEnabled();
            }
            case DEBUG: {
                return logger.isDebugEnabled();
            }
            case INFO: {
                return logger.isInfoEnabled();
            }
            case WARN: {
                return logger.isWarnEnabled();
            }
            case ERROR: 
            case FATAL: {
                return logger.isErrorEnabled();
            }
        }
        throw new IllegalArgumentException("LogLevel must be one of the enabled levels.");
    }
}

