/*
 * Decompiled with CFR 0.152.
 */
package com.github.rozidan.springboot.logger;

import com.github.rozidan.springboot.logger.Loggable;
import com.github.rozidan.springboot.logger.Logger;
import com.github.rozidan.springboot.logger.LoggerMsgArgsGenerator;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.logging.LogLevel;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class LoggerInterceptor {
    private Logger logger;
    private LoggerMsgArgsGenerator lmag = new LoggerMsgArgsGenerator();
    private Set<WarnPoint> warnPoints;
    private ScheduledExecutorService warnService;

    @Autowired
    public LoggerInterceptor(Logger logger) {
        this.logger = logger;
    }

    @PostConstruct
    protected void construct() {
        this.warnPoints = new ConcurrentSkipListSet<WarnPoint>();
        this.warnService = Executors.newSingleThreadScheduledExecutor();
        this.warnService.scheduleAtFixedRate(() -> {
            for (WarnPoint wp : this.warnPoints) {
                long duration = System.nanoTime() - wp.getStart();
                if (!this.isOver(duration, wp.getLoggable())) continue;
                this.log(LogLevel.WARN, "#{}({}): in {} and still running (max {})", wp.getPoint(), wp.getLoggable(), this.lmag.warnBefore(wp.getPoint(), wp.getLoggable(), duration));
                this.warnPoints.remove(wp);
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    @Pointcut(value="execution(public * *(..)) && !execution(String *.toString()) && !execution(int *.hashCode()) && !execution(boolean *.canEqual(Object)) && !execution(boolean *.equals(Object))")
    protected void publicMethod() {
    }

    @Pointcut(value="@annotation(loggable)")
    protected void loggableMethod(Loggable loggable) {
    }

    @Pointcut(value="@within(loggable)")
    protected void loggableClass(Loggable loggable) {
    }

    @Around(value="publicMethod() && loggableMethod(loggable)", argNames="joinPoint,loggable")
    public Object logExecutionMethod(ProceedingJoinPoint joinPoint, Loggable loggable) throws Throwable {
        return this.logMethod(joinPoint, loggable);
    }

    @Around(value="publicMethod() && loggableClass(loggable) && !loggableMethod(com.github.rozidan.springboot.logger.Loggable)", argNames="joinPoint,loggable")
    public Object logExecutionClass(ProceedingJoinPoint joinPoint, Loggable loggable) throws Throwable {
        return this.logMethod(joinPoint, loggable);
    }

    public Object logMethod(ProceedingJoinPoint joinPoint, Loggable loggable) throws Throwable {
        long start = System.nanoTime();
        WarnPoint warnPoint = null;
        if (this.isLevelEnabled(joinPoint, loggable) && loggable.warnOver() >= 0L) {
            warnPoint = new WarnPoint(joinPoint, loggable, start);
            this.warnPoints.add(warnPoint);
        }
        if (loggable.entered()) {
            this.log(loggable.value(), "#{}({}): entered", joinPoint, loggable, this.lmag.enter(joinPoint, loggable));
        }
        try {
            Object returnVal = joinPoint.proceed();
            long nano = System.nanoTime() - start;
            if (this.isOver(nano, loggable)) {
                this.log(LogLevel.WARN, "#{}({}): {} in {} (max {})", joinPoint, loggable, this.lmag.warnAfter(joinPoint, loggable, returnVal, nano));
            } else {
                this.log(loggable.value(), "#{}({}): {} in {}", joinPoint, loggable, this.lmag.after(joinPoint, loggable, returnVal, nano));
            }
            Object object = returnVal;
            return object;
        }
        catch (Throwable ex) {
            if (this.contains(loggable.ignore(), ex)) {
                this.log(LogLevel.ERROR, "#{}({}): thrown {}({}) from {}[{}] in {}", joinPoint, loggable, this.lmag.error(joinPoint, loggable, System.nanoTime() - start, ex));
            } else {
                this.log(LogLevel.ERROR, "#{}({}): thrown {}({}) from {}[{}] in {}", joinPoint, loggable, this.lmag.errorWithException(joinPoint, loggable, System.nanoTime() - start, ex));
            }
            throw ex;
        }
        finally {
            if (warnPoint != null) {
                this.warnPoints.remove(warnPoint);
            }
        }
    }

    private void log(LogLevel level, String message, ProceedingJoinPoint joinPoint, Loggable loggable, Object ... args) {
        if (loggable.name().isEmpty()) {
            this.logger.log(level, ((MethodSignature)joinPoint.getSignature()).getMethod().getDeclaringClass(), message, args);
        } else {
            this.logger.log(level, loggable.name(), message, args);
        }
    }

    private boolean isLevelEnabled(ProceedingJoinPoint joinPoint, Loggable loggable) {
        return loggable.name().isEmpty() ? this.logger.isEnabled(LogLevel.WARN, ((MethodSignature)joinPoint.getSignature()).getMethod().getDeclaringClass()) : this.logger.isEnabled(LogLevel.WARN, loggable.name());
    }

    private boolean isOver(long nano, Loggable loggable) {
        return loggable.warnOver() >= 0L && TimeUnit.NANOSECONDS.toMillis(nano) > loggable.warnUnit().toMillis(loggable.warnOver());
    }

    private boolean contains(Class<? extends Throwable>[] array, Throwable exp) {
        boolean contains = false;
        for (Class<? extends Throwable> type : array) {
            if (!this.instanceOf(exp.getClass(), type)) continue;
            contains = true;
            break;
        }
        return contains;
    }

    private boolean instanceOf(Class<?> child, Class<?> parent) {
        boolean instance;
        boolean bl = instance = child.equals(parent) || child.getSuperclass() != null && this.instanceOf(child.getSuperclass(), parent);
        if (!instance) {
            Class<?> iface;
            Class<?>[] classArray = child.getInterfaces();
            int n = classArray.length;
            for (int i = 0; i < n && !(instance = this.instanceOf(iface = classArray[i], parent)); ++i) {
            }
        }
        return instance;
    }

    protected static class WarnPoint
    implements Comparable<WarnPoint> {
        private ProceedingJoinPoint point;
        private Loggable loggable;
        private long start;

        @Override
        public int compareTo(WarnPoint obj) {
            return Long.compare(obj.getStart(), this.start);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WarnPoint)) {
                return false;
            }
            WarnPoint other = (WarnPoint)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ProceedingJoinPoint this$point = this.getPoint();
            ProceedingJoinPoint other$point = other.getPoint();
            return !(this$point == null ? other$point != null : !this$point.equals(other$point));
        }

        protected boolean canEqual(Object other) {
            return other instanceof WarnPoint;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ProceedingJoinPoint $point = this.getPoint();
            result = result * 59 + ($point == null ? 43 : $point.hashCode());
            return result;
        }

        public WarnPoint(ProceedingJoinPoint point, Loggable loggable, long start) {
            this.point = point;
            this.loggable = loggable;
            this.start = start;
        }

        public ProceedingJoinPoint getPoint() {
            return this.point;
        }

        public Loggable getLoggable() {
            return this.loggable;
        }

        public long getStart() {
            return this.start;
        }
    }
}

