/*
 * Decompiled with CFR 0.152.
 */
package com.github.rozidan.springboot.logger;

import com.github.rozidan.springboot.logger.Loggable;
import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;

final class LoggerMsgArgsGenerator {
    public Object[] enter(ProceedingJoinPoint joinPoint, Loggable loggable) {
        return new Object[]{this.methodName((JoinPoint)joinPoint), this.methodArgs((JoinPoint)joinPoint, loggable)};
    }

    public Object[] warnBefore(ProceedingJoinPoint joinPoint, Loggable loggable, long nano) {
        return new Object[]{this.methodName((JoinPoint)joinPoint), this.methodArgs((JoinPoint)joinPoint, loggable), this.durationString(nano), this.warnDuration(loggable)};
    }

    public Object[] warnAfter(ProceedingJoinPoint joinPoint, Loggable loggable, Object result, long nano) {
        return new Object[]{this.methodName((JoinPoint)joinPoint), this.methodArgs((JoinPoint)joinPoint, loggable), this.methodResults(result, loggable), this.durationString(nano), this.warnDuration(loggable)};
    }

    public Object[] after(ProceedingJoinPoint joinPoint, Loggable loggable, Object result, long nano) {
        return new Object[]{this.methodName((JoinPoint)joinPoint), this.methodArgs((JoinPoint)joinPoint, loggable), this.methodResults(result, loggable), this.durationString(nano)};
    }

    public Object[] error(ProceedingJoinPoint joinPoint, Loggable loggable, long nano, Throwable err) {
        return new Object[]{this.methodName((JoinPoint)joinPoint), this.methodArgs((JoinPoint)joinPoint, loggable), this.errClass(err), this.errMsg(err), this.errSourceClass(err), this.errLine(err), this.durationString(nano)};
    }

    public Object[] errorWithException(ProceedingJoinPoint joinPoint, Loggable loggable, long nano, Throwable err) {
        return new Object[]{this.methodName((JoinPoint)joinPoint), this.methodArgs((JoinPoint)joinPoint, loggable), this.errClass(err), this.errMsg(err), this.errSourceClass(err), this.errLine(err), this.durationString(nano), err};
    }

    private String warnDuration(Loggable loggable) {
        return Duration.ofMillis(loggable.warnUnit().toMillis(loggable.warnOver())).toString();
    }

    private String methodName(JoinPoint joinPoint) {
        return ((MethodSignature)joinPoint.getSignature()).getMethod().getName();
    }

    private String methodArgs(JoinPoint joinPoint, Loggable loggable) {
        return loggable.skipArgs() ? ".." : this.argsToString(joinPoint.getArgs());
    }

    private String methodResults(Object result, Loggable loggable) {
        return loggable.skipResult() ? ".." : this.argsToString(result);
    }

    private String errClass(Throwable err) {
        return err.getClass().getName();
    }

    private String errMsg(Throwable err) {
        return err.getMessage();
    }

    private int errLine(Throwable err) {
        if (err.getStackTrace().length > 0) {
            return err.getStackTrace()[0].getLineNumber();
        }
        return -1;
    }

    private String errSourceClass(Throwable err) {
        if (err.getStackTrace().length > 0) {
            return err.getStackTrace()[0].getClassName();
        }
        return "somewhere";
    }

    private String durationString(long nano) {
        return Duration.ofMillis(TimeUnit.NANOSECONDS.toMillis(nano)).toString();
    }

    private String argsToString(Object arg) {
        String text;
        if (arg == null) {
            return "NULL";
        }
        if (arg.getClass().isArray()) {
            text = arg instanceof Object[] ? this.objectArraysToString((Object[])arg) : this.primitiveArrayToString(arg);
        } else {
            String origin = arg.toString();
            text = arg instanceof String || origin.isEmpty() ? String.format("'%s'", origin) : origin;
        }
        return text;
    }

    private String objectArraysToString(Object ... arg) {
        StringBuilder bldr = new StringBuilder();
        bldr.append('[');
        for (Object item : arg) {
            if (bldr.length() > 1) {
                bldr.append(",").append(" ");
            }
            bldr.append(this.argsToString(item));
        }
        return bldr.append(']').toString();
    }

    private String primitiveArrayToString(Object arg) {
        String text = arg instanceof char[] ? Arrays.toString((char[])arg) : (arg instanceof byte[] ? Arrays.toString((byte[])arg) : (arg instanceof short[] ? Arrays.toString((short[])arg) : (arg instanceof int[] ? Arrays.toString((int[])arg) : (arg instanceof long[] ? Arrays.toString((long[])arg) : (arg instanceof float[] ? Arrays.toString((float[])arg) : (arg instanceof double[] ? Arrays.toString((double[])arg) : (arg instanceof boolean[] ? Arrays.toString((boolean[])arg) : "[unknown]")))))));
        return text;
    }
}

