/*
 * Decompiled with CFR 0.152.
 */
package com.github.rozidan.springboot.modelmapper;

import com.github.rozidan.springboot.modelmapper.ConfigurationConfigurer;
import com.github.rozidan.springboot.modelmapper.ConverterConfigurer;
import com.github.rozidan.springboot.modelmapper.TypeMapConfigurer;
import java.util.List;
import org.modelmapper.ModelMapper;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;

public class ModelMapperFactoryBean
implements FactoryBean<ModelMapper> {
    @Autowired(required=false)
    private ConfigurationConfigurer mapperConfigurer;
    @Autowired(required=false)
    private List<TypeMapConfigurer> configurers;
    @Autowired(required=false)
    private List<ConverterConfigurer> converters;

    public ModelMapper getObject() {
        ModelMapper modelMapper = new ModelMapper();
        this.configure(modelMapper);
        return modelMapper;
    }

    public Class<?> getObjectType() {
        return ModelMapper.class;
    }

    public boolean isSingleton() {
        return true;
    }

    private void configure(ModelMapper modelMapper) {
        if (this.mapperConfigurer != null) {
            this.mapperConfigurer.configureImpl(modelMapper);
        }
        if (this.converters != null) {
            this.converters.forEach(typeMapConfigurer -> typeMapConfigurer.configureImpl(modelMapper));
        }
        if (this.configurers != null) {
            this.configurers.forEach(typeMapConfigurer -> typeMapConfigurer.configureImpl(modelMapper));
        }
    }
}

