/*
 * Decompiled with CFR 0.152.
 */
package com.github.rtyley.android.screenshot.paparazzo.processors.util;

public class Dimensions {
    public final int width;
    public final int height;
    public final double aspectRatio;

    public Dimensions(int width, int height) {
        this.width = width;
        this.height = height;
        this.aspectRatio = (double)width / (double)height;
    }

    public static Dimensions square(int size) {
        return new Dimensions(size, size);
    }

    public Dimensions scaledPreservingAspectRatioToFitWithin(Dimensions bounds) {
        return bounds.aspectRatio > this.aspectRatio ? this.scaleToHeight(bounds.height) : this.scaleToWidth(bounds.width);
    }

    private Dimensions scaleToWidth(int targetWidth) {
        return new Dimensions(targetWidth, (int)Math.round((double)targetWidth / this.aspectRatio));
    }

    private Dimensions scaleToHeight(int targetHeight) {
        return new Dimensions((int)Math.round((double)targetHeight * this.aspectRatio), targetHeight);
    }

    public boolean contains(int w, int h) {
        return this.width >= w && this.height >= h;
    }

    public boolean contains(Dimensions otherDimensions) {
        return this.contains(otherDimensions.width, otherDimensions.height);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.toSimpleString() + "]";
    }

    public String toSimpleString() {
        return "" + this.width + "x" + this.height;
    }
}

