/*
 * Decompiled with CFR 0.152.
 */
package com.github.rubensousa.previewseekbar.animator;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.widget.FrameLayout;
import com.github.rubensousa.previewseekbar.PreviewBar;
import com.github.rubensousa.previewseekbar.animator.PreviewAnimator;

public class PreviewFadeAnimator
implements PreviewAnimator {
    private static final int FADE_DURATION = 350;
    private long showDuration;
    private long hideDuration;

    public PreviewFadeAnimator() {
        this(350L, 350L);
    }

    public PreviewFadeAnimator(long showDuration, long hideDuration) {
        this.showDuration = showDuration;
        this.hideDuration = hideDuration;
    }

    @Override
    public void move(FrameLayout previewView, PreviewBar previewBar) {
    }

    @Override
    public void show(FrameLayout previewView, PreviewBar previewBar) {
        previewView.animate().setListener(null);
        previewView.animate().cancel();
        previewView.setAlpha(0.0f);
        previewView.setVisibility(0);
        previewView.animate().setDuration(this.showDuration).alpha(1.0f);
    }

    @Override
    public void hide(final FrameLayout previewView, PreviewBar previewBar) {
        previewView.animate().setListener(null);
        previewView.animate().cancel();
        previewView.setVisibility(0);
        previewView.setAlpha(1.0f);
        previewView.animate().setDuration(this.hideDuration).alpha(0.0f).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                previewView.setAlpha(1.0f);
                previewView.setVisibility(4);
            }

            public void onAnimationCancel(Animator animation) {
                super.onAnimationCancel(animation);
                previewView.setAlpha(1.0f);
                previewView.setVisibility(4);
            }
        });
    }

    @Override
    public void cancel(FrameLayout previewView, PreviewBar previewBar) {
        previewView.animate().setListener(null);
        previewView.animate().cancel();
    }
}

