/*
 * Decompiled with CFR 0.152.
 */
package com.github.rubensousa.previewseekbar.animator;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewAnimationUtils;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.widget.FrameLayout;
import androidx.core.graphics.drawable.DrawableCompat;
import com.github.rubensousa.previewseekbar.PreviewBar;
import com.github.rubensousa.previewseekbar.R;
import com.github.rubensousa.previewseekbar.animator.PreviewAnimator;

@TargetApi(value=21)
public class PreviewMorphAnimator
implements PreviewAnimator {
    private static final int MORPH_SHOW_DURATION = 125;
    private static final int MORPH_HIDE_DURATION = 125;
    private static final int TRANSLATION_SHOW_DURATION = 100;
    private static final int TRANSLATION_HIDE_DURATION = 100;
    private long showTranslationDuration;
    private long morphShowDuration;
    private long hideTranslationDuration;
    private long morphHideDuration;
    private boolean isShowing;
    private boolean isHiding;
    private boolean isMovingToShow;
    private boolean isMovingToHide;
    private boolean isMorphingToShow;
    private boolean isMorphingToHide;
    private Animator morphAnimator;
    private ValueAnimator translationAnimator;

    public PreviewMorphAnimator() {
        this(100L, 125L, 125L, 100L);
    }

    public PreviewMorphAnimator(long showTranslationDuration, long morphShowDuration, long morphHideDuration, long hideTranslationDuration) {
        this.showTranslationDuration = showTranslationDuration;
        this.morphShowDuration = morphShowDuration;
        this.morphHideDuration = morphHideDuration;
        this.hideTranslationDuration = hideTranslationDuration;
    }

    @Override
    public void cancel(FrameLayout previewView, PreviewBar previewBar) {
        View overlayView = this.getOrCreateOverlayView(previewView);
        View morphView = this.getOrCreateMorphView(previewView, previewBar);
        overlayView.setVisibility(4);
        morphView.setVisibility(4);
        this.cancelPendingAnimations(previewView, overlayView, morphView);
    }

    @Override
    public void move(FrameLayout previewView, PreviewBar previewBar) {
        if (!this.isMovingToHide && !this.isMovingToShow) {
            return;
        }
        View morphView = this.getOrCreateMorphView(previewView, previewBar);
        float nextX = this.isMovingToShow ? this.getMorphEndX(previewView, previewBar) : this.getMorphStartX(previewBar, this.getOffset(previewBar));
        if (this.translationAnimator != null) {
            this.translationAnimator.removeAllUpdateListeners();
            this.translationAnimator.cancel();
        }
        morphView.setX(nextX);
    }

    @Override
    public void show(FrameLayout previewView, PreviewBar previewBar) {
        if (previewBar.getMax() == 0 || this.isShowing) {
            return;
        }
        this.isHiding = false;
        this.isShowing = true;
        View overlayView = this.getOrCreateOverlayView(previewView);
        View morphView = this.getOrCreateMorphView(previewView, previewBar);
        this.cancelPendingAnimations(previewView, overlayView, morphView);
        if (this.isMovingToHide || this.isMorphingToHide) {
            this.isMovingToHide = false;
            this.isMorphingToHide = false;
            this.startCircularReveal(previewView, overlayView, morphView);
            return;
        }
        this.tintViews(previewBar, morphView, overlayView);
        morphView.setY(this.getMorphStartY(previewBar));
        morphView.setX(this.getMorphStartX(previewBar, this.getOffset(previewBar)));
        morphView.setScaleX(0.0f);
        morphView.setScaleY(0.0f);
        morphView.setAlpha(1.0f);
        this.startShowTranslation(previewView, previewBar, overlayView, morphView);
    }

    @Override
    public void hide(FrameLayout previewView, PreviewBar previewBar) {
        if (this.isHiding) {
            return;
        }
        this.isShowing = false;
        this.isHiding = true;
        View morphView = this.getOrCreateMorphView(previewView, previewBar);
        View overlayView = this.getOrCreateOverlayView(previewView);
        this.cancelPendingAnimations(previewView, overlayView, morphView);
        if (this.isMovingToShow) {
            this.isMovingToShow = false;
            this.startHideTranslation(previewView, previewBar, overlayView, morphView);
            return;
        }
        if (this.isMorphingToShow) {
            this.isMorphingToShow = false;
            this.startHideTranslation(previewView, previewBar, overlayView, morphView);
            return;
        }
        this.tintViews(previewBar, morphView, overlayView);
        overlayView.setVisibility(0);
        previewView.setVisibility(0);
        float targetScale = this.getMorphScale(previewView, morphView);
        morphView.setX(this.getMorphEndX(previewView, previewBar));
        morphView.setY(this.getMorphEndY(previewView, morphView));
        morphView.setScaleX(targetScale);
        morphView.setScaleY(targetScale);
        morphView.setVisibility(4);
        if (previewView.isAttachedToWindow()) {
            this.startReverseCircularReveal(previewView, previewBar, overlayView, morphView);
        }
    }

    private void startShowTranslation(final FrameLayout previewView, PreviewBar previewBar, final View overlayView, final View morphView) {
        this.isMovingToShow = true;
        float targetScale = this.getMorphScale(previewView, morphView);
        overlayView.setVisibility(4);
        previewView.setVisibility(4);
        morphView.setVisibility(0);
        this.animateMorphViewX(morphView, this.getMorphEndX(previewView, previewBar), this.showTranslationDuration);
        morphView.animate().y(this.getMorphEndY(previewView, morphView)).scaleY(targetScale).scaleX(targetScale).setDuration(this.showTranslationDuration).setInterpolator((TimeInterpolator)new AccelerateInterpolator()).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                PreviewMorphAnimator.this.isMovingToShow = false;
                overlayView.setAlpha(1.0f);
                if (previewView.isAttachedToWindow()) {
                    PreviewMorphAnimator.this.startCircularReveal(previewView, overlayView, morphView);
                }
            }
        }).start();
    }

    private void startCircularReveal(FrameLayout previewView, final View overlayView, View morphView) {
        this.isMorphingToShow = true;
        float startRadius = (float)previewView.getHeight() / 2.0f;
        float endRadius = this.getRadius((View)previewView);
        long duration = this.morphShowDuration;
        this.morphAnimator = ViewAnimationUtils.createCircularReveal((View)previewView, (int)this.getCenterX((View)previewView), (int)this.getCenterY((View)previewView), (float)startRadius, (float)endRadius);
        this.morphAnimator.setTarget((Object)previewView);
        this.morphAnimator.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        this.morphAnimator.setDuration(duration);
        this.morphAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                PreviewMorphAnimator.this.isMorphingToShow = false;
                PreviewMorphAnimator.this.isShowing = false;
                overlayView.setAlpha(0.0f);
                overlayView.setVisibility(4);
            }
        });
        this.morphAnimator.start();
        previewView.setVisibility(0);
        overlayView.setVisibility(0);
        morphView.setVisibility(4);
        overlayView.animate().alpha(0.0f).setDuration(this.morphShowDuration / 2L);
    }

    private void startReverseCircularReveal(final FrameLayout previewView, final PreviewBar previewBar, final View overlayView, final View morphView) {
        this.isMorphingToHide = true;
        float startRadius = this.getRadius((View)previewView);
        float endRadius = (float)previewView.getHeight() / 2.0f;
        long duration = this.morphHideDuration;
        this.morphAnimator = ViewAnimationUtils.createCircularReveal((View)previewView, (int)this.getCenterX((View)previewView), (int)this.getCenterY((View)previewView), (float)startRadius, (float)endRadius);
        this.morphAnimator.setDuration(duration);
        this.morphAnimator.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        this.morphAnimator.setTarget((Object)previewView);
        this.morphAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                PreviewMorphAnimator.this.isMorphingToHide = false;
                PreviewMorphAnimator.this.startHideTranslation(previewView, previewBar, overlayView, morphView);
            }
        });
        overlayView.setVisibility(0);
        overlayView.animate().alpha(1.0f).setDuration(this.morphHideDuration / 2L).setInterpolator((TimeInterpolator)new AccelerateInterpolator()).start();
        this.morphAnimator.start();
    }

    private void startHideTranslation(FrameLayout previewView, PreviewBar previewBar, View overlayView, final View morphView) {
        this.isMovingToHide = true;
        overlayView.setVisibility(4);
        previewView.setVisibility(4);
        morphView.setVisibility(0);
        this.animateMorphViewX(morphView, this.getMorphStartX(previewBar, this.getOffset(previewBar)), this.hideTranslationDuration);
        morphView.animate().y(this.getMorphStartY(previewBar)).scaleY(0.0f).scaleX(0.0f).setDuration(this.hideTranslationDuration).setInterpolator((TimeInterpolator)new AccelerateInterpolator()).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                PreviewMorphAnimator.this.isMovingToHide = false;
                PreviewMorphAnimator.this.isHiding = false;
                morphView.setVisibility(4);
            }
        }).start();
    }

    private void animateMorphViewX(final View morphView, float toX, long duration) {
        if (this.translationAnimator != null) {
            this.translationAnimator.removeAllUpdateListeners();
            this.translationAnimator.cancel();
        }
        this.translationAnimator = ValueAnimator.ofFloat((float[])new float[]{morphView.getX(), toX});
        this.translationAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                morphView.setX(((Float)animation.getAnimatedValue()).floatValue());
            }
        });
        this.translationAnimator.setDuration(duration);
        this.translationAnimator.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        this.translationAnimator.start();
    }

    private void cancelPendingAnimations(FrameLayout previewView, View overlayView, View morphView) {
        if (this.morphAnimator != null) {
            this.morphAnimator.removeAllListeners();
            this.morphAnimator.cancel();
            this.morphAnimator = null;
        }
        if (this.translationAnimator != null) {
            this.translationAnimator.removeAllUpdateListeners();
            this.translationAnimator.cancel();
            this.translationAnimator = null;
        }
        previewView.animate().setListener(null);
        previewView.animate().cancel();
        overlayView.animate().setListener(null);
        overlayView.animate().cancel();
        morphView.animate().setListener(null);
        morphView.animate().cancel();
    }

    private View getOrCreateOverlayView(FrameLayout previewView) {
        View overlay = previewView.findViewById(R.id.previewSeekBarOverlayViewId);
        if (overlay != null) {
            return overlay;
        }
        overlay = new View(previewView.getContext());
        overlay.setVisibility(4);
        overlay.setId(R.id.previewSeekBarOverlayViewId);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        previewView.addView(overlay, (ViewGroup.LayoutParams)layoutParams);
        return overlay;
    }

    private View getOrCreateMorphView(FrameLayout previewView, PreviewBar previewBar) {
        ViewGroup parent = (ViewGroup)previewView.getParent();
        View morphView = parent.findViewById(R.id.previewSeekBarMorphViewId);
        if (morphView != null) {
            return morphView;
        }
        morphView = new View(previewView.getContext());
        morphView.setVisibility(4);
        morphView.setBackgroundResource(R.drawable.previewseekbar_morph);
        morphView.setId(R.id.previewSeekBarMorphViewId);
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(previewBar.getThumbOffset(), previewBar.getThumbOffset());
        parent.addView(morphView, layoutParams);
        return morphView;
    }

    private void tintViews(PreviewBar previewBar, View morphView, View frameView) {
        int color = previewBar.getScrubberColor();
        if (morphView.getBackgroundTintList() == null || morphView.getBackgroundTintList().getDefaultColor() != color) {
            Drawable drawable2 = DrawableCompat.wrap((Drawable)morphView.getBackground());
            DrawableCompat.setTint((Drawable)drawable2, (int)color);
            morphView.setBackground(drawable2);
            frameView.setBackgroundColor(color);
        }
    }

    private float getOffset(PreviewBar previewBar) {
        if (previewBar.getMax() == 0) {
            return 0.0f;
        }
        return (float)previewBar.getProgress() / (float)previewBar.getMax();
    }

    private float getMorphScale(FrameLayout previewView, View morphView) {
        return previewView.getHeight() / morphView.getLayoutParams().height;
    }

    private float getRadius(View view) {
        return (float)Math.hypot((float)view.getWidth() / 2.0f, (float)view.getHeight() / 2.0f);
    }

    private int getCenterX(View view) {
        return view.getWidth() / 2;
    }

    private int getCenterY(View view) {
        return view.getHeight() / 2;
    }

    private float getMorphStartX(PreviewBar previewBar, float offset) {
        float previewPadding = previewBar.getThumbOffset();
        float previewLeftX = ((View)previewBar).getLeft();
        float previewRightX = ((View)previewBar).getRight();
        float previewSeekBarStartX = previewLeftX + previewPadding;
        float previewSeekBarEndX = previewRightX - previewPadding;
        float currentX = previewSeekBarStartX + (previewSeekBarEndX - previewSeekBarStartX) * offset;
        return currentX - previewPadding / 2.0f;
    }

    private float getMorphStartY(PreviewBar previewBar) {
        return ((View)previewBar).getY() + (float)previewBar.getThumbOffset();
    }

    private float getMorphEndX(FrameLayout previewView, PreviewBar previewBar) {
        return previewView.getX() + (float)previewView.getWidth() / 2.0f - (float)previewBar.getThumbOffset() / 2.0f;
    }

    private float getMorphEndY(FrameLayout previewView, View morphView) {
        return (float)((int)(previewView.getY() + (float)previewView.getHeight() / 2.0f)) - (float)morphView.getHeight() / 2.0f;
    }
}

