/*
 * Decompiled with CFR 0.152.
 */
package com.github.rubensousa.previewseekbar;

import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.github.rubensousa.previewseekbar.PreviewBar;
import com.github.rubensousa.previewseekbar.PreviewLoader;
import com.github.rubensousa.previewseekbar.animator.PreviewAnimator;
import com.github.rubensousa.previewseekbar.animator.PreviewMorphAnimator;
import java.util.ArrayList;
import java.util.List;

public class PreviewDelegate {
    private FrameLayout previewView;
    private PreviewLoader previewLoader;
    private PreviewAnimator animator;
    private PreviewBar previewBar;
    private List<PreviewBar.OnScrubListener> scrubListeners = new ArrayList<PreviewBar.OnScrubListener>();
    private List<PreviewBar.OnPreviewVisibilityListener> visibilityListeners = new ArrayList<PreviewBar.OnPreviewVisibilityListener>();
    private boolean showingPreview;
    private boolean previewViewAttached;
    private boolean previewEnabled;
    private boolean animationEnabled;
    private boolean previewAutoHide;
    private boolean isUserScrubbing;

    public PreviewDelegate(PreviewBar previewBar) {
        this.previewBar = previewBar;
        this.animationEnabled = true;
        this.previewAutoHide = true;
        this.animator = new PreviewMorphAnimator();
    }

    @Nullable
    public static FrameLayout findPreviewView(@NonNull ViewGroup parent, int previewViewId) {
        if (previewViewId == -1) {
            return null;
        }
        for (int i = 0; i < parent.getChildCount(); ++i) {
            View child = parent.getChildAt(i);
            if (child.getId() != previewViewId || !(child instanceof FrameLayout)) continue;
            return (FrameLayout)child;
        }
        return null;
    }

    public void onScrubStart() {
        for (PreviewBar.OnScrubListener listener : this.scrubListeners) {
            listener.onScrubStart(this.previewBar);
        }
    }

    public void onScrubMove(int progress, boolean fromUser) {
        if (!this.previewViewAttached) {
            return;
        }
        int targetX = this.updatePreviewX(progress, this.previewBar.getMax());
        this.previewView.setX((float)targetX);
        if (this.animationEnabled) {
            this.animator.move(this.previewView, this.previewBar);
        }
        if (!this.isUserScrubbing && fromUser && this.previewEnabled) {
            this.isUserScrubbing = true;
            this.show();
        }
        for (PreviewBar.OnScrubListener listener : this.scrubListeners) {
            listener.onScrubMove(this.previewBar, progress, fromUser);
        }
        if (this.previewLoader != null && this.showingPreview) {
            this.previewLoader.loadPreview(progress, this.previewBar.getMax());
        }
    }

    public void show() {
        if (!this.showingPreview && this.previewViewAttached && this.previewEnabled) {
            if (this.animationEnabled) {
                this.animator.show(this.previewView, this.previewBar);
            } else {
                this.animator.cancel(this.previewView, this.previewBar);
                this.previewView.setVisibility(0);
            }
            this.showingPreview = true;
            for (PreviewBar.OnPreviewVisibilityListener listener : this.visibilityListeners) {
                listener.onVisibilityChanged(this.previewBar, true);
            }
        }
    }

    public void onScrubStop() {
        this.isUserScrubbing = false;
        if (this.previewAutoHide) {
            this.hide();
        }
        for (PreviewBar.OnScrubListener listener : this.scrubListeners) {
            listener.onScrubStop(this.previewBar);
        }
    }

    public void setPreviewLoader(@Nullable PreviewLoader previewLoader) {
        this.previewLoader = previewLoader;
    }

    public void setAnimator(@NonNull PreviewAnimator animator) {
        this.animator = animator;
    }

    public boolean isPreviewEnabled() {
        return this.previewEnabled;
    }

    public boolean isShowingPreview() {
        return this.showingPreview;
    }

    public void hide() {
        if (this.showingPreview && this.previewViewAttached) {
            if (this.animationEnabled) {
                this.animator.hide(this.previewView, this.previewBar);
            } else {
                this.animator.cancel(this.previewView, this.previewBar);
                this.previewView.setVisibility(4);
            }
            this.showingPreview = false;
            for (PreviewBar.OnPreviewVisibilityListener listener : this.visibilityListeners) {
                listener.onVisibilityChanged(this.previewBar, false);
            }
        }
    }

    public void setPreviewEnabled(boolean previewEnabled) {
        this.previewEnabled = previewEnabled;
    }

    public void setAnimationEnabled(boolean enabled) {
        this.animationEnabled = enabled;
    }

    public void setAutoHidePreview(boolean autoHide) {
        this.previewAutoHide = autoHide;
    }

    public void attachPreviewView(@NonNull FrameLayout previewView) {
        this.previewView = previewView;
        this.previewView.setVisibility(4);
        this.previewViewAttached = true;
    }

    public boolean isPreviewViewAttached() {
        return this.previewViewAttached;
    }

    public boolean isUserScrubbing() {
        return this.isUserScrubbing;
    }

    public void updateProgress(int progress, int max) {
        if (this.isShowingPreview() && !this.isUserScrubbing()) {
            this.onScrubMove(progress, false);
        }
    }

    public void addOnScrubListener(PreviewBar.OnScrubListener listener) {
        if (!this.scrubListeners.contains(listener)) {
            this.scrubListeners.add(listener);
        }
    }

    public void removeOnScrubListener(PreviewBar.OnScrubListener listener) {
        this.scrubListeners.remove(listener);
    }

    public void addOnPreviewVisibilityListener(PreviewBar.OnPreviewVisibilityListener listener) {
        if (!this.visibilityListeners.contains(listener)) {
            this.visibilityListeners.add(listener);
        }
    }

    private int updatePreviewX(int progress, int max) {
        if (max == 0) {
            return 0;
        }
        ViewGroup parent = (ViewGroup)this.previewView.getParent();
        ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)this.previewView.getLayoutParams();
        float offset = (float)progress / (float)max;
        int minimumX = this.previewView.getLeft();
        int maximumX = parent.getWidth() - parent.getPaddingRight() - layoutParams.rightMargin;
        float previewPadding = this.previewBar.getThumbOffset();
        float previewLeftX = ((View)this.previewBar).getLeft();
        float previewRightX = ((View)this.previewBar).getRight();
        float previewSeekBarStartX = previewLeftX + previewPadding;
        float previewSeekBarEndX = previewRightX - previewPadding;
        float currentX = previewSeekBarStartX + (previewSeekBarEndX - previewSeekBarStartX) * offset;
        float startX = currentX - (float)this.previewView.getWidth() / 2.0f;
        float endX = startX + (float)this.previewView.getWidth();
        if (startX >= (float)minimumX && endX <= (float)maximumX) {
            return (int)startX;
        }
        if (startX < (float)minimumX) {
            return minimumX;
        }
        return maximumX - this.previewView.getWidth();
    }

    public void removeOnPreviewVisibilityListener(PreviewBar.OnPreviewVisibilityListener listener) {
        this.visibilityListeners.remove(listener);
    }
}

