/*
 * Decompiled with CFR 0.152.
 */
package com.github.rubensousa.previewseekbar;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.SeekBar;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.NonNull;
import androidx.appcompat.R;
import androidx.appcompat.widget.AppCompatSeekBar;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import com.github.rubensousa.previewseekbar.PreviewBar;
import com.github.rubensousa.previewseekbar.PreviewDelegate;
import com.github.rubensousa.previewseekbar.PreviewLoader;
import com.github.rubensousa.previewseekbar.R;
import com.github.rubensousa.previewseekbar.animator.PreviewAnimator;

public class PreviewSeekBar
extends AppCompatSeekBar
implements PreviewBar {
    private PreviewDelegate delegate;
    private int previewId = -1;
    private int scrubberColor = 0;

    public PreviewSeekBar(Context context) {
        this(context, null);
    }

    public PreviewSeekBar(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.seekBarStyle);
    }

    public PreviewSeekBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        this.delegate = new PreviewDelegate(this);
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.PreviewSeekBar, 0, 0);
        TypedArray themeTypedArray = context.getTheme().obtainStyledAttributes(new int[]{R.attr.colorAccent});
        int defaultThumbColor = themeTypedArray.getColor(0, 0);
        themeTypedArray.recycle();
        this.previewId = typedArray.getResourceId(R.styleable.PreviewSeekBar_previewFrameLayout, -1);
        this.scrubberColor = typedArray.getColor(R.styleable.PreviewSeekBar_previewThumbTint, defaultThumbColor);
        this.setPreviewThumbTint(this.scrubberColor);
        this.delegate.setAnimationEnabled(typedArray.getBoolean(R.styleable.PreviewSeekBar_previewAnimationEnabled, true));
        this.delegate.setPreviewEnabled(typedArray.getBoolean(R.styleable.PreviewSeekBar_previewEnabled, true));
        this.delegate.setAutoHidePreview(typedArray.getBoolean(R.styleable.PreviewSeekBar_previewAutoHide, true));
        typedArray.recycle();
        super.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                PreviewSeekBar.this.delegate.onScrubMove(progress, fromUser);
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
                PreviewSeekBar.this.delegate.onScrubStart();
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
                PreviewSeekBar.this.delegate.onScrubStop();
            }
        });
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        FrameLayout previewView;
        super.onLayout(changed, left, top, right, bottom);
        if (!this.delegate.isPreviewViewAttached() && !this.isInEditMode() && (previewView = PreviewDelegate.findPreviewView((ViewGroup)this.getParent(), this.previewId)) != null) {
            this.delegate.attachPreviewView(previewView);
        }
    }

    public synchronized void setProgress(int progress) {
        super.setProgress(progress);
        if (this.delegate != null) {
            this.delegate.updateProgress(progress, this.getMax());
        }
    }

    public synchronized void setMax(int max) {
        super.setMax(max);
        if (this.delegate != null) {
            this.delegate.updateProgress(this.getProgress(), this.getMax());
        }
    }

    public void setOnSeekBarChangeListener(SeekBar.OnSeekBarChangeListener l) {
    }

    @Override
    public void attachPreviewView(@NonNull FrameLayout previewView) {
        this.delegate.attachPreviewView(previewView);
    }

    @Override
    public void setPreviewThumbTint(int color) {
        Drawable drawable2 = DrawableCompat.wrap((Drawable)this.getThumb());
        DrawableCompat.setTint((Drawable)drawable2, (int)color);
        this.setThumb(drawable2);
        this.scrubberColor = color;
    }

    @Override
    public void setPreviewThumbTintResource(int colorResource) {
        this.setPreviewThumbTint(ContextCompat.getColor((Context)this.getContext(), (int)colorResource));
    }

    @Override
    public int getScrubberColor() {
        return this.scrubberColor;
    }

    @Override
    public boolean isShowingPreview() {
        return this.delegate.isShowingPreview();
    }

    @Override
    public boolean isPreviewEnabled() {
        return this.delegate.isPreviewEnabled();
    }

    @Override
    public void setPreviewEnabled(boolean enabled) {
        this.delegate.setPreviewEnabled(enabled);
    }

    @Override
    public void showPreview() {
        this.delegate.show();
    }

    @Override
    public void hidePreview() {
        this.delegate.hide();
    }

    @Override
    public void setAutoHidePreview(boolean autoHide) {
        this.delegate.setAutoHidePreview(autoHide);
    }

    @Override
    public void setPreviewLoader(PreviewLoader previewLoader) {
        this.delegate.setPreviewLoader(previewLoader);
    }

    @Override
    public void addOnScrubListener(PreviewBar.OnScrubListener listener) {
        this.delegate.addOnScrubListener(listener);
    }

    @Override
    public void removeOnScrubListener(PreviewBar.OnScrubListener listener) {
        this.delegate.removeOnScrubListener(listener);
    }

    @Override
    public void addOnPreviewVisibilityListener(PreviewBar.OnPreviewVisibilityListener listener) {
        this.delegate.addOnPreviewVisibilityListener(listener);
    }

    @Override
    public void removeOnPreviewVisibilityListener(PreviewBar.OnPreviewVisibilityListener listener) {
        this.delegate.removeOnPreviewVisibilityListener(listener);
    }

    @Override
    public void setPreviewAnimator(@NonNull PreviewAnimator animator) {
        this.delegate.setAnimator(animator);
    }

    @Override
    public void setPreviewAnimationEnabled(boolean enable) {
        this.delegate.setAnimationEnabled(enable);
    }

    public void setProgressTint(@ColorInt int color) {
        Drawable drawable2 = DrawableCompat.wrap((Drawable)this.getProgressDrawable());
        DrawableCompat.setTint((Drawable)drawable2, (int)color);
        this.setProgressDrawable(drawable2);
    }

    public void setProgressTintResource(@ColorRes int colorResource) {
        this.setProgressTint(ContextCompat.getColor((Context)this.getContext(), (int)colorResource));
    }
}

