/*
 * Decompiled with CFR 0.152.
 */
package com.studio.piyaponf.base_project.network;

import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.studio.piyaponf.base_project.network.DefaultHeader;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public abstract class BaseApiService<T> {
    protected String baseUrl;
    private T api;
    private boolean logger = false;
    private long TIMEOUT = 6000L;
    private DefaultHeader defaultHeader;

    protected abstract Class<T> getApiClassType();

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public boolean isLogger() {
        return this.logger;
    }

    protected abstract Request.Builder getRequestInterceptor(Request.Builder var1);

    private Interceptor getOnTopInterceptor() {
        return new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request.Builder newRequestBuilder = BaseApiService.this.getRequestInterceptor(chain.request().newBuilder());
                if (newRequestBuilder == null) {
                    return chain.proceed(chain.request());
                }
                return chain.proceed(newRequestBuilder.build());
            }
        };
    }

    private OkHttpClient getClient() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        this.configCertificate(builder);
        return builder.addInterceptor((Interceptor)this.getDefaultHeader()).addInterceptor(this.getOnTopInterceptor()).addNetworkInterceptor((Interceptor)this.getDefaultHttpLogging(this.isLogger())).readTimeout(this.getDefaultTimeout(), TimeUnit.MILLISECONDS).writeTimeout(this.getDefaultTimeout(), TimeUnit.MILLISECONDS).connectTimeout(this.getDefaultTimeout(), TimeUnit.MILLISECONDS).build();
    }

    protected long getDefaultTimeout() {
        return this.TIMEOUT;
    }

    public abstract DefaultHeader getDefaultHeader();

    private void configCertificate(OkHttpClient.Builder builder) {
    }

    public T getApi() {
        return (T)this.getBaseRetrofitBuilder().build().create(this.getApiClassType());
    }

    public void setApi(T api) {
        this.api = api;
    }

    private Retrofit.Builder getBaseRetrofitBuilder() {
        if (this.addConverter() == null) {
            return new Retrofit.Builder().baseUrl(this.getBaseUrl()).client(this.getClient());
        }
        return new Retrofit.Builder().baseUrl(this.getBaseUrl()).addConverterFactory(this.addConverter()).client(this.getClient());
    }

    protected HttpLoggingInterceptor getDefaultHttpLogging(boolean showLog) {
        if (showLog) {
            return new HttpLoggingInterceptor((HttpLoggingInterceptor.Logger)new BaseHttpLogger()).setLevel(HttpLoggingInterceptor.Level.BODY);
        }
        return new HttpLoggingInterceptor().setLevel(HttpLoggingInterceptor.Level.NONE);
    }

    protected Converter.Factory addConverter() {
        return GsonConverterFactory.create((Gson)new GsonBuilder().setPrettyPrinting().create());
    }

    public void largeLog(String tag, String content) {
        int MAX_LOG_LENGTH = 4076;
        int offset = 0;
        while (offset + MAX_LOG_LENGTH <= content.length()) {
            Log.d((String)tag, (String)content.substring(offset, offset += MAX_LOG_LENGTH).replace("&quot;", "\""));
        }
        if (offset < content.length()) {
            Log.d((String)tag, (String)content.substring(offset).replace("&quot;", "\""));
        }
    }

    class BaseHttpLogger
    implements HttpLoggingInterceptor.Logger {
        BaseHttpLogger() {
        }

        public void log(String message) {
            String logName = "OkHttp";
            if (!message.startsWith("{") && !message.startsWith("[")) {
                BaseApiService.this.largeLog("OkHttp", message);
                return;
            }
            try {
                String prettyPrintJson = new GsonBuilder().setPrettyPrinting().create().toJson(new JsonParser().parse(message));
                BaseApiService.this.largeLog("OkHttp", prettyPrintJson);
            }
            catch (JsonSyntaxException m) {
                Log.d((String)"TRUST", (String)"html header parse failed");
                m.printStackTrace();
                Log.d((String)"OkHttp", (String)message);
            }
        }
    }
}

