/*
 * Decompiled with CFR 0.152.
 */
package com.github.rutledgepaulv.qbuilders.visitors;

import com.github.rutledgepaulv.qbuilders.nodes.AbstractNode;
import com.github.rutledgepaulv.qbuilders.nodes.AndNode;
import com.github.rutledgepaulv.qbuilders.nodes.ComparisonNode;
import com.github.rutledgepaulv.qbuilders.nodes.OrNode;
import com.github.rutledgepaulv.qbuilders.operators.ComparisonOperator;
import com.github.rutledgepaulv.qbuilders.visitors.AbstractVoidContextNodeVisitor;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class RSQLVisitor
extends AbstractVoidContextNodeVisitor<String> {
    private final Function<Object, String> serializer;

    public RSQLVisitor() {
        this(DefaultSerializationStrategy.INSTANCE);
    }

    public RSQLVisitor(Function<Object, String> serializationStrategy) {
        this.serializer = serializationStrategy;
    }

    @Override
    protected String visit(AndNode node) {
        String body = node.getChildren().stream().map(this::visitAny).collect(Collectors.joining(";"));
        return this.nodeBelongsToParentExpression(node) ? "(" + body + ")" : body;
    }

    @Override
    protected String visit(OrNode node) {
        String body = node.getChildren().stream().map(this::visitAny).collect(Collectors.joining(","));
        return this.nodeBelongsToParentExpression(node) ? "(" + body + ")" : body;
    }

    @Override
    protected String visit(ComparisonNode node) {
        ComparisonOperator operator = node.getOperator();
        if (ComparisonOperator.EQ.equals(operator)) {
            return this.single(node, "==");
        }
        if (ComparisonOperator.NE.equals(operator)) {
            return this.single(node, "!=");
        }
        if (ComparisonOperator.EX.equals(operator)) {
            return this.single(node, "=ex=");
        }
        if (ComparisonOperator.GT.equals(operator)) {
            return this.single(node, "=gt=");
        }
        if (ComparisonOperator.LT.equals(operator)) {
            return this.single(node, "=lt=");
        }
        if (ComparisonOperator.GTE.equals(operator)) {
            return this.single(node, "=ge=");
        }
        if (ComparisonOperator.LTE.equals(operator)) {
            return this.single(node, "=le=");
        }
        if (ComparisonOperator.IN.equals(operator)) {
            return this.list(node, "=in=");
        }
        if (ComparisonOperator.NIN.equals(operator)) {
            return this.list(node, "=out=");
        }
        if (ComparisonOperator.RE.equals(operator)) {
            return this.single(node, "=re=");
        }
        if (ComparisonOperator.SUB_CONDITION_ANY.equals(operator)) {
            return node.getField().asKey() + "=q=" + this.serialize(this.condition(node));
        }
        throw new UnsupportedOperationException("This visitor does not support the operator " + operator + ".");
    }

    protected boolean nodeBelongsToParentExpression(AbstractNode node) {
        return node.getParent() != null;
    }

    protected String single(ComparisonNode node, String op) {
        return node.getField().asKey() + op + this.serialize(this.single(node.getValues()));
    }

    protected String list(ComparisonNode node, String op) {
        return node.getField().asKey() + op + node.getValues().stream().map(this::serialize).collect(Collectors.joining(",", "(", ")"));
    }

    protected String serialize(Object value) {
        return this.serializer.apply(value);
    }

    protected static class DefaultSerializationStrategy
    implements Function<Object, String> {
        protected static final DefaultSerializationStrategy INSTANCE = new DefaultSerializationStrategy();
        private static final CharSequence DOUBLE_QUOTE = "\"";
        private static final CharSequence SINGLE_QUOTE = "'";

        protected DefaultSerializationStrategy() {
        }

        @Override
        public String apply(Object value) {
            String string = Objects.toString(value);
            if (string.contains("\\")) {
                string = string.replaceAll("\\\\", "\\\\\\\\");
            }
            boolean containsDoubleQuotes = string.contains("\"");
            boolean containsSingleQuotes = string.contains("'");
            if (!containsDoubleQuotes) {
                return DOUBLE_QUOTE + string + DOUBLE_QUOTE;
            }
            if (!containsSingleQuotes) {
                return SINGLE_QUOTE + string + SINGLE_QUOTE;
            }
            string = string.replaceAll("\"", "\\\\\"");
            return DOUBLE_QUOTE + string + DOUBLE_QUOTE;
        }
    }
}

