/*
 * Decompiled with CFR 0.152.
 */
package com.github.rutledgepaulv.qbuilders.builders;

import com.github.rutledgepaulv.qbuilders.conditions.Condition;
import com.github.rutledgepaulv.qbuilders.conditions.Partial;
import com.github.rutledgepaulv.qbuilders.delegates.concrete.BooleanPropertyDelegate;
import com.github.rutledgepaulv.qbuilders.delegates.concrete.ConditionPropertyDelegate;
import com.github.rutledgepaulv.qbuilders.delegates.concrete.DoublePropertyDelegate;
import com.github.rutledgepaulv.qbuilders.delegates.concrete.EnumPropertyDelegate;
import com.github.rutledgepaulv.qbuilders.delegates.concrete.FloatPropertyDelegate;
import com.github.rutledgepaulv.qbuilders.delegates.concrete.InstantPropertyDelegate;
import com.github.rutledgepaulv.qbuilders.delegates.concrete.IntegerPropertyDelegate;
import com.github.rutledgepaulv.qbuilders.delegates.concrete.LongPropertyDelegate;
import com.github.rutledgepaulv.qbuilders.delegates.concrete.ShortPropertyDelegate;
import com.github.rutledgepaulv.qbuilders.delegates.concrete.StringPropertyDelegate;
import com.github.rutledgepaulv.qbuilders.delegates.virtual.Delegate;
import com.github.rutledgepaulv.qbuilders.delegates.virtual.PropertyDelegate;
import com.github.rutledgepaulv.qbuilders.nodes.AbstractNode;
import com.github.rutledgepaulv.qbuilders.nodes.AndNode;
import com.github.rutledgepaulv.qbuilders.nodes.ComparisonNode;
import com.github.rutledgepaulv.qbuilders.nodes.LogicalNode;
import com.github.rutledgepaulv.qbuilders.nodes.OrNode;
import com.github.rutledgepaulv.qbuilders.operators.ComparisonOperator;
import com.github.rutledgepaulv.qbuilders.properties.concrete.BooleanProperty;
import com.github.rutledgepaulv.qbuilders.properties.concrete.ConditionProperty;
import com.github.rutledgepaulv.qbuilders.properties.concrete.DoubleProperty;
import com.github.rutledgepaulv.qbuilders.properties.concrete.EnumProperty;
import com.github.rutledgepaulv.qbuilders.properties.concrete.FloatProperty;
import com.github.rutledgepaulv.qbuilders.properties.concrete.InstantProperty;
import com.github.rutledgepaulv.qbuilders.properties.concrete.IntegerProperty;
import com.github.rutledgepaulv.qbuilders.properties.concrete.LongProperty;
import com.github.rutledgepaulv.qbuilders.properties.concrete.ShortProperty;
import com.github.rutledgepaulv.qbuilders.properties.concrete.StringProperty;
import com.github.rutledgepaulv.qbuilders.properties.virtual.Property;
import com.github.rutledgepaulv.qbuilders.structures.FieldPath;
import com.github.rutledgepaulv.qbuilders.utilities.ObjectUtils;
import com.github.rutledgepaulv.qbuilders.visitors.ContextualNodeVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class QBuilder<T extends QBuilder<T>>
implements Partial<T> {
    protected LogicalNode root;
    protected LogicalNode current;

    public QBuilder() {
        this.root = this.current = new OrNode();
    }

    @Override
    public final <S extends Enum<S>> EnumProperty<T, S> enumeration(String field) {
        return this.prop(field, EnumPropertyDelegate.class, EnumProperty.class);
    }

    @Override
    public final BooleanProperty<T> bool(String field) {
        return this.prop(field, BooleanPropertyDelegate.class, BooleanProperty.class);
    }

    @Override
    public final StringProperty<T> string(String field) {
        return this.prop(field, StringPropertyDelegate.class, StringProperty.class);
    }

    @Override
    public final ShortProperty<T> shortNum(String field) {
        return this.prop(field, ShortPropertyDelegate.class, ShortProperty.class);
    }

    @Override
    public final IntegerProperty<T> intNum(String field) {
        return this.prop(field, IntegerPropertyDelegate.class, IntegerProperty.class);
    }

    @Override
    public final LongProperty<T> longNum(String field) {
        return this.prop(field, LongPropertyDelegate.class, LongProperty.class);
    }

    @Override
    public final FloatProperty<T> floatNum(String field) {
        return this.prop(field, FloatPropertyDelegate.class, FloatProperty.class);
    }

    @Override
    public final DoubleProperty<T> doubleNum(String field) {
        return this.prop(field, DoublePropertyDelegate.class, DoubleProperty.class);
    }

    @Override
    public final InstantProperty<T> instant(String field) {
        return this.prop(field, InstantPropertyDelegate.class, InstantProperty.class);
    }

    @Override
    public final <S extends QBuilder<S>> ConditionProperty<T, S> condition(String field) {
        return this.prop(field, ConditionPropertyDelegate.class, ConditionProperty.class);
    }

    protected final <S extends PropertyDelegate<T>, Q extends Property<T>> Q prop(String field, Class<S> delegate, Class<Q> inter) {
        if (!inter.isAssignableFrom(delegate)) {
            throw new IllegalArgumentException("Must provide a delegate that implements the interface to be returned.");
        }
        return (Q)((Property)ObjectUtils.init(delegate, new FieldPath(field), this.self()));
    }

    @Override
    @SafeVarargs
    public final Condition<T> and(Condition<T> c1, Condition<T> c2, Condition<T> ... cn) {
        ArrayList<Condition<T>> conditions = new ArrayList<Condition<T>>();
        conditions.addAll(Arrays.asList(c1, c2));
        conditions.addAll(Arrays.asList(cn));
        return this.and(conditions);
    }

    @Override
    @SafeVarargs
    public final Condition<T> or(Condition<T> c1, Condition<T> c2, Condition<T> ... cn) {
        ArrayList<Condition<T>> conditions = new ArrayList<Condition<T>>();
        conditions.addAll(Arrays.asList(c1, c2));
        conditions.addAll(Arrays.asList(cn));
        return this.or(conditions);
    }

    @Override
    public final Condition<T> and(List<Condition<T>> conditions) {
        return this.combine(conditions, AndNode.class);
    }

    @Override
    public final Condition<T> or(List<Condition<T>> conditions) {
        return this.combine(conditions, OrNode.class);
    }

    private <S extends LogicalNode> Condition<T> combine(List<Condition<T>> conditions, Class<S> type) {
        List children = conditions.stream().map(condition -> ((QBuilder)((QBuilder)((Object)condition)).self()).current).collect(Collectors.toList());
        LogicalNode node = (LogicalNode)ObjectUtils.init(type, ((QBuilder)this.self()).current, children);
        ((QBuilder)this.self()).current.getChildren().add(node);
        return new ConditionDelegate(this, (QBuilder)this.self());
    }

    protected final Condition<T> condition(FieldPath field, ComparisonOperator operator, Collection<?> values) {
        ComparisonNode node = new ComparisonNode(((QBuilder)this.self()).current);
        node.setField(field);
        node.setOperator(operator);
        node.setValues(values);
        ((QBuilder)this.self()).current.getChildren().add(node);
        return new ConditionDelegate(this, (QBuilder)this.self());
    }

    protected T self() {
        return (T)this;
    }

    protected static final class ConditionDelegate
    extends Delegate<T>
    implements Condition<T> {
        final /* synthetic */ QBuilder this$0;

        private ConditionDelegate(T canonical) {
            this.this$0 = this$0;
            super(canonical);
        }

        @Override
        public final T and() {
            Object self = this.self();
            LogicalNode current = ((QBuilder)self).current;
            if (!(current instanceof AndNode)) {
                ArrayList<AbstractNode> children = new ArrayList<AbstractNode>();
                children.add(current);
                AndNode node = new AndNode(current.getParent(), children);
                if (current == ((QBuilder)self).root) {
                    ((QBuilder)self).root = node;
                }
                ((QBuilder)self).current = node;
            }
            return self;
        }

        @Override
        public final T or() {
            Object self = this.self();
            LogicalNode current = ((QBuilder)self).current;
            if (!(current instanceof OrNode)) {
                ArrayList<AbstractNode> children = new ArrayList<AbstractNode>();
                children.add(current);
                OrNode node = new OrNode(current.getParent(), children);
                if (current == ((QBuilder)self).root) {
                    ((QBuilder)self).root = node;
                }
                ((QBuilder)self).current = node;
            }
            return self;
        }

        @Override
        public final <Q> Q query(ContextualNodeVisitor<Q, Void> visitor) {
            Object self = this.self();
            return ((QBuilder)self).root.visit(visitor);
        }

        @Override
        public final <Q, S> Q query(ContextualNodeVisitor<Q, S> visitor, S context) {
            Object self = this.self();
            return ((QBuilder)self).root.visit(visitor, context);
        }

        public final LogicalNode getRootNode() {
            return ((QBuilder)this.self()).root;
        }
    }
}

