/*
 * Decompiled with CFR 0.152.
 */
package com.github.rutledgepaulv.rqe.argconverters;

import com.github.rutledgepaulv.rqe.argconverters.ArgConverter;
import com.github.rutledgepaulv.rqe.contexts.ArgConversionContext;
import com.github.rutledgepaulv.rqe.exceptions.FailedArgumentConversionException;
import com.github.rutledgepaulv.rqe.utils.StreamUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ConverterChain
implements Iterable<ArgConverter>,
ArgConverter {
    private Map<Class<? extends ArgConverter>, Boolean> switchBoard = new HashMap<Class<? extends ArgConverter>, Boolean>();
    private List<ArgConverter> converters = new LinkedList<ArgConverter>();

    public ConverterChain() {
    }

    public ConverterChain(Iterable<ArgConverter> converters) {
        converters.forEach(this::appendInternal);
    }

    public ConverterChain(ConverterChain clone) {
        clone.converters.forEach(this::appendInternal);
        clone.switchBoard.entrySet().stream().forEach(entry -> this.switchBoard.put((Class<? extends ArgConverter>)entry.getKey(), (Boolean)entry.getValue()));
    }

    public ConverterChain disable(Class<? extends ArgConverter> clazz) {
        ConverterChain result = new ConverterChain(this);
        result.switchBoard.put(clazz, false);
        return result;
    }

    public ConverterChain enable(Class<? extends ArgConverter> clazz) {
        ConverterChain result = new ConverterChain(this);
        result.switchBoard.put(clazz, true);
        return result;
    }

    public ConverterChain append(ArgConverter converter) {
        ConverterChain result = new ConverterChain(this);
        if (!result.switchBoard.containsKey(converter.getClass())) {
            result.switchBoard.put(converter.getClass(), true);
        }
        result.converters.add(converter);
        return result;
    }

    public ConverterChain prepend(ArgConverter converter) {
        ConverterChain result = new ConverterChain(this);
        if (!result.switchBoard.containsKey(converter.getClass())) {
            result.switchBoard.put(converter.getClass(), true);
        }
        result.converters.add(0, converter);
        return result;
    }

    private void appendInternal(ArgConverter converter) {
        if (!this.switchBoard.containsKey(converter.getClass())) {
            this.switchBoard.put(converter.getClass(), true);
        }
        this.converters.add(converter);
    }

    @Override
    public Iterator<ArgConverter> iterator() {
        return this.converters.stream().filter(converter -> this.switchBoard.getOrDefault(converter.getClass(), false)).iterator();
    }

    @Override
    public boolean supports(ArgConversionContext context) {
        return StreamUtil.fromIterator(this.iterator()).anyMatch(converter -> converter.supports(context));
    }

    @Override
    public List<?> apply(ArgConversionContext context) {
        return StreamUtil.fromIterator(this.iterator()).filter(converter -> converter.supports(context)).findFirst().map(converter -> (List)converter.apply(context)).orElseThrow(FailedArgumentConversionException::new);
    }
}

