/*
 * Decompiled with CFR 0.152.
 */
package com.github.rutledgepaulv.rqe.argconverters;

import com.github.rutledgepaulv.qbuilders.structures.FieldPath;
import com.github.rutledgepaulv.rqe.argconverters.ArgConverter;
import com.github.rutledgepaulv.rqe.contexts.ArgConversionContext;
import com.github.rutledgepaulv.rqe.conversions.StringToTypeConverter;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public class EntityFieldTypeConverter
implements ArgConverter {
    private BiFunction<FieldPath, Class<?>, Class<?>> fieldTypeResolver;
    private StringToTypeConverter converter;

    public EntityFieldTypeConverter(BiFunction<FieldPath, Class<?>, Class<?>> fieldTypeResolver, StringToTypeConverter converter) {
        this.fieldTypeResolver = fieldTypeResolver;
        this.converter = converter;
    }

    @Override
    public boolean supports(ArgConversionContext context) {
        return this.isNotAnOperatorSpecificArgument(context) && this.pathResolvesToConvertibleType(context);
    }

    @Override
    public List<Object> apply(ArgConversionContext context) {
        Class<?> clazz = this.fieldTypeResolver.apply(context.getPropertyPath(), context.getEntityType());
        return context.getValues().stream().map(val -> this.converter.apply(val, clazz)).collect(Collectors.toList());
    }

    private boolean isNotAnOperatorSpecificArgument(ArgConversionContext context) {
        return !context.getQueryOperator().doesOperatorDetermineValueType();
    }

    private boolean pathResolvesToConvertibleType(ArgConversionContext context) {
        Class<?> clazz = this.fieldTypeResolver.apply(context.getPropertyPath(), context.getEntityType());
        return this.converter.supports(clazz);
    }
}

