/*
 * Decompiled with CFR 0.152.
 */
package com.github.rutledgepaulv.rqe.argconverters;

import com.github.rutledgepaulv.qbuilders.nodes.AbstractNode;
import com.github.rutledgepaulv.qbuilders.structures.FieldPath;
import com.github.rutledgepaulv.rqe.argconverters.ArgConverter;
import com.github.rutledgepaulv.rqe.contexts.ArgConversionContext;
import com.github.rutledgepaulv.rqe.contexts.ParseTreeContext;
import com.github.rutledgepaulv.rqe.exceptions.UnsupportedQueryOperatorException;
import com.github.rutledgepaulv.rqe.utils.TriFunction;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public class OperatorSpecificConverter
implements ArgConverter {
    private TriFunction<String, Class<?>, ParseTreeContext, AbstractNode> subqueryPipeline;
    private BiFunction<FieldPath, Class<?>, Class<?>> resolver;

    public OperatorSpecificConverter(TriFunction<String, Class<?>, ParseTreeContext, AbstractNode> subqueryPipeline, BiFunction<FieldPath, Class<?>, Class<?>> resolver) {
        this.subqueryPipeline = subqueryPipeline;
        this.resolver = resolver;
    }

    @Override
    public boolean supports(ArgConversionContext context) {
        return context.getQueryOperator().doesOperatorDetermineValueType();
    }

    @Override
    public List<?> apply(ArgConversionContext context) {
        switch (context.getQueryOperator()) {
            case REGEX: {
                return context.getValues().stream().limit(1L).map(Object::toString).collect(Collectors.toList());
            }
            case EXISTS: {
                return context.getValues().stream().map(Boolean::valueOf).collect(Collectors.toList());
            }
            case SUBQUERY_ANY: {
                return Collections.singletonList(this.parse(context));
            }
        }
        throw new UnsupportedQueryOperatorException("This converter cannot handle the operator " + (Object)((Object)context.getQueryOperator()));
    }

    private AbstractNode parse(ArgConversionContext context) {
        ParseTreeContext subqueryContext = new ParseTreeContext();
        subqueryContext.setParentPath(context.getPropertyPath());
        return this.subqueryPipeline.apply(context.getValues().iterator().next(), this.subType(context.getPropertyPath(), context.getEntityType()), subqueryContext);
    }

    private Class<?> subType(FieldPath propertyPath, Class<?> entityType) {
        return this.resolver.apply(propertyPath, entityType);
    }
}

