/*
 * Decompiled with CFR 0.152.
 */
package com.github.rutledgepaulv.rqe.conversions.parsers;

import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.Optional;
import org.springframework.core.convert.converter.Converter;

public class StringToObjectBestEffortConverter
implements Converter<String, Object> {
    private static final DateTimeFormatter PARSER = DateTimeFormatter.ISO_DATE_TIME;

    public Object convert(String source) {
        return StringToObjectBestEffortConverter.tryParseBoolean(source).orElseGet(() -> StringToObjectBestEffortConverter.tryParseDate(source).orElseGet(() -> StringToObjectBestEffortConverter.tryParseNumber(source).orElse(source)));
    }

    private static Optional<Object> tryParseBoolean(String value) {
        String normalized = Objects.toString(value);
        if (Boolean.TRUE.toString().equals(normalized)) {
            return Optional.of(true);
        }
        if (Boolean.FALSE.toString().equals(normalized)) {
            return Optional.of(false);
        }
        return Optional.empty();
    }

    private static Optional<Object> tryParseDate(String value) {
        try {
            return Optional.of(Instant.from(PARSER.parse(value)));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private static Optional<Object> tryParseNumber(String value) {
        try {
            return Optional.of(Long.parseLong(value));
        }
        catch (NumberFormatException e) {
            try {
                return Optional.of(Double.parseDouble(value));
            }
            catch (NumberFormatException e2) {
                return Optional.empty();
            }
        }
    }
}

