/*
 * Decompiled with CFR 0.152.
 */
package com.github.rutledgepaulv.rqe.pipes;

import com.github.rutledgepaulv.qbuilders.nodes.AbstractNode;
import com.github.rutledgepaulv.qbuilders.nodes.LogicalNode;
import com.github.rutledgepaulv.qbuilders.structures.FieldPath;
import com.github.rutledgepaulv.rqe.argconverters.ArgConverter;
import com.github.rutledgepaulv.rqe.argconverters.ConverterChain;
import com.github.rutledgepaulv.rqe.argconverters.EntityFieldTypeConverter;
import com.github.rutledgepaulv.rqe.argconverters.OperatorSpecificConverter;
import com.github.rutledgepaulv.rqe.contexts.ArgConversionContext;
import com.github.rutledgepaulv.rqe.contexts.ParseTreeContext;
import com.github.rutledgepaulv.rqe.conversions.SpringConversionServiceConverter;
import com.github.rutledgepaulv.rqe.conversions.StringToTypeConverter;
import com.github.rutledgepaulv.rqe.operators.QueryOperator;
import com.github.rutledgepaulv.rqe.pipes.DefaultParsingPipe;
import com.github.rutledgepaulv.rqe.resolvers.EntityFieldTypeResolver;
import com.github.rutledgepaulv.rqe.utils.TriFunction;
import cz.jirutka.rsql.parser.ast.AndNode;
import cz.jirutka.rsql.parser.ast.ComparisonNode;
import cz.jirutka.rsql.parser.ast.Node;
import cz.jirutka.rsql.parser.ast.OrNode;
import cz.jirutka.rsql.parser.ast.RSQLVisitor;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DefaultArgumentConversionPipe
implements BiFunction<Node, Class<?>, AbstractNode>,
TriFunction<Node, Class<?>, ParseTreeContext, AbstractNode> {
    private Function<String, Node> parsingPipe;
    private StringToTypeConverter stringToTypeConverter;
    private BiFunction<FieldPath, Class<?>, Class<?>> fieldResolver;
    private Collection<ArgConverter> customConverters = new LinkedList<ArgConverter>();

    public static DefaultArgumentConversionPipe defaults() {
        return new DefaultArgumentConversionPipeBuilder().build();
    }

    public static DefaultArgumentConversionPipeBuilder builder() {
        return new DefaultArgumentConversionPipeBuilder();
    }

    private DefaultArgumentConversionPipe(DefaultArgumentConversionPipeBuilder builder) {
        this.parsingPipe = Objects.requireNonNull(builder.parsingPipe);
        this.stringToTypeConverter = Objects.requireNonNull(builder.stringToTypeConverter);
        this.fieldResolver = Objects.requireNonNull(builder.fieldResolver);
        this.customConverters.addAll(builder.customConverters);
    }

    @Override
    public AbstractNode apply(Node node, Class<?> entityClass) {
        return this.apply(node, entityClass, new ParseTreeContext());
    }

    @Override
    public AbstractNode apply(Node node, Class<?> entityClass, ParseTreeContext parseTreeContext) {
        ConverterChain chain = new ConverterChain();
        for (ArgConverter converter : this.customConverters) {
            chain = chain.append(converter);
        }
        chain = chain.append(new OperatorSpecificConverter(this.subqueryPipeline(this), this.fieldResolver));
        chain = chain.append(new EntityFieldTypeConverter(this.fieldResolver, this.stringToTypeConverter));
        return (AbstractNode)node.accept((RSQLVisitor)new ConvertingVisitor(entityClass, chain), (Object)parseTreeContext);
    }

    private TriFunction<String, Class<?>, ParseTreeContext, AbstractNode> subqueryPipeline(TriFunction<Node, Class<?>, ParseTreeContext, AbstractNode> pipe) {
        return (rsql, clazz, parseTreeContext) -> this.parsingPipe.andThen(node -> (AbstractNode)pipe.apply((Node)node, (Class<?>)clazz, (ParseTreeContext)parseTreeContext)).apply((String)rsql);
    }

    private class ConvertingVisitor
    implements RSQLVisitor<AbstractNode, ParseTreeContext> {
        private ConverterChain converterChain;
        private Class<?> entityClass;

        public ConvertingVisitor(Class<?> entityClass, ConverterChain chain) {
            this.entityClass = entityClass;
            this.converterChain = chain;
        }

        public AbstractNode visit(AndNode node, ParseTreeContext param) {
            LinkedList<AbstractNode> children = new LinkedList<AbstractNode>();
            com.github.rutledgepaulv.qbuilders.nodes.AndNode parent = new com.github.rutledgepaulv.qbuilders.nodes.AndNode(param.getParent(), children);
            param.setParent((LogicalNode)parent);
            children.addAll(this.visitChildren((cz.jirutka.rsql.parser.ast.LogicalNode)node, param));
            return parent;
        }

        public AbstractNode visit(OrNode node, ParseTreeContext param) {
            LinkedList<AbstractNode> children = new LinkedList<AbstractNode>();
            com.github.rutledgepaulv.qbuilders.nodes.OrNode parent = new com.github.rutledgepaulv.qbuilders.nodes.OrNode(param.getParent(), children);
            param.setParent((LogicalNode)parent);
            children.addAll(this.visitChildren((cz.jirutka.rsql.parser.ast.LogicalNode)node, param));
            return parent;
        }

        public AbstractNode visit(ComparisonNode node, ParseTreeContext param) {
            QueryOperator operator = QueryOperator.fromParserOperator(node.getOperator());
            FieldPath path = new FieldPath(node.getSelector());
            if (param.getParentPath().isPresent()) {
                path = path.prepend(param.getParentPath().get());
            }
            ArgConversionContext context = new ArgConversionContext().setChain(this.converterChain).setEntityType(this.entityClass).setValues(node.getArguments()).setPropertyPath(path).setQueryOperator(operator);
            com.github.rutledgepaulv.qbuilders.nodes.ComparisonNode leaf = new com.github.rutledgepaulv.qbuilders.nodes.ComparisonNode(param.getParent());
            leaf.setField(path);
            leaf.setOperator(operator.qbuilderOperator());
            leaf.setValues(this.converterChain.apply(context));
            return leaf;
        }

        private Collection<AbstractNode> visitChildren(cz.jirutka.rsql.parser.ast.LogicalNode node, ParseTreeContext param) {
            return node.getChildren().stream().map(child -> {
                if (child instanceof AndNode) {
                    return this.visit((AndNode)child, param);
                }
                if (child instanceof OrNode) {
                    return this.visit((OrNode)child, param);
                }
                return this.visit((ComparisonNode)child, param);
            }).collect(Collectors.toList());
        }
    }

    public static class DefaultArgumentConversionPipeBuilder {
        private Function<String, Node> parsingPipe = new DefaultParsingPipe();
        private StringToTypeConverter stringToTypeConverter = new SpringConversionServiceConverter();
        private BiFunction<FieldPath, Class<?>, Class<?>> fieldResolver = new EntityFieldTypeResolver();
        private List<ArgConverter> customConverters = new LinkedList<ArgConverter>();

        public DefaultArgumentConversionPipeBuilder useNonDefaultParsingPipe(Function<String, Node> parsingPipe) {
            this.parsingPipe = parsingPipe;
            return this;
        }

        public DefaultArgumentConversionPipeBuilder useNonDefaultStringToTypeConverter(StringToTypeConverter stringToTypeConverter) {
            this.stringToTypeConverter = stringToTypeConverter;
            return this;
        }

        public DefaultArgumentConversionPipeBuilder useNonDefaultFieldResolver(BiFunction<FieldPath, Class<?>, Class<?>> fieldResolver) {
            this.fieldResolver = fieldResolver;
            return this;
        }

        public DefaultArgumentConversionPipeBuilder addCustomArgumentConverter(ArgConverter fieldResolver) {
            this.customConverters.add(fieldResolver);
            return this;
        }

        public DefaultArgumentConversionPipe build() {
            return new DefaultArgumentConversionPipe(this);
        }
    }
}

