/*
 * Decompiled with CFR 0.152.
 */
package com.github.rutledgepaulv.rqe.pipes;

import com.github.rutledgepaulv.qbuilders.builders.GeneralQueryBuilder;
import com.github.rutledgepaulv.qbuilders.conditions.Condition;
import com.github.rutledgepaulv.qbuilders.nodes.AbstractNode;
import com.github.rutledgepaulv.rqe.pipes.DefaultArgumentConversionPipe;
import com.github.rutledgepaulv.rqe.pipes.DefaultParsingPipe;
import com.github.rutledgepaulv.rqe.pipes.DefaultQueryBuildingPipe;
import com.github.rutledgepaulv.rqe.pipes.IdentityPipe;
import cz.jirutka.rsql.parser.ast.Node;
import java.util.function.BiFunction;
import java.util.function.Function;

public class QueryConversionPipeline
implements BiFunction<String, Class<?>, Condition<GeneralQueryBuilder>> {
    private Function<String, Node> parsingPipe;
    private Function<Node, Node> preConversionTransformer;
    private BiFunction<Node, Class<?>, AbstractNode> argumentConversionPipe;
    private Function<AbstractNode, AbstractNode> postConversionTransformer;
    private Function<AbstractNode, Condition<GeneralQueryBuilder>> queryBuildingPipe;

    public static QueryConversionPipelineBuilder builder() {
        return new QueryConversionPipelineBuilder();
    }

    public static QueryConversionPipeline defaultPipeline() {
        return QueryConversionPipeline.builder().build();
    }

    private QueryConversionPipeline(Function<String, Node> parsingPipe, Function<Node, Node> preConversionTransformer, BiFunction<Node, Class<?>, AbstractNode> argumentConversionPipe, Function<AbstractNode, AbstractNode> postConversionTransformer, Function<AbstractNode, Condition<GeneralQueryBuilder>> queryBuildingPipe) {
        this.parsingPipe = parsingPipe;
        this.preConversionTransformer = preConversionTransformer;
        this.argumentConversionPipe = argumentConversionPipe;
        this.postConversionTransformer = postConversionTransformer;
        this.queryBuildingPipe = queryBuildingPipe;
    }

    @Override
    public Condition<GeneralQueryBuilder> apply(String rsql, Class<?> targetEntity) {
        return this.reducedPipeline().apply(rsql, targetEntity);
    }

    private BiFunction<String, Class<?>, Condition<GeneralQueryBuilder>> reducedPipeline() {
        return (string, clazz) -> this.parsingPipe.andThen(this.preConversionTransformer).andThen(node -> this.argumentConversionPipe.apply((Node)node, (Class<?>)clazz)).andThen(this.postConversionTransformer).andThen(this.queryBuildingPipe).apply((String)string);
    }

    public static class QueryConversionPipelineBuilder {
        private Function<String, Node> parsingPipe = new DefaultParsingPipe();
        private Function<Node, Node> preConversionTransformer = new IdentityPipe<Node>();
        private Function<AbstractNode, AbstractNode> postConversionTransformer = new IdentityPipe<AbstractNode>();
        private Function<AbstractNode, Condition<GeneralQueryBuilder>> queryBuildingPipe = new DefaultQueryBuildingPipe();
        private BiFunction<Node, Class<?>, AbstractNode> argumentConversionPipe = DefaultArgumentConversionPipe.defaults();

        private QueryConversionPipelineBuilder() {
        }

        public QueryConversionPipelineBuilder useNonDefaultParsingPipe(Function<String, Node> parsingPipe) {
            this.parsingPipe = parsingPipe;
            return this;
        }

        public QueryConversionPipelineBuilder useNonDefaultPreConversionTransformer(Function<Node, Node> preConversionTransformer) {
            this.preConversionTransformer = preConversionTransformer;
            return this;
        }

        public QueryConversionPipelineBuilder useNonDefaultArgumentConversionPipe(BiFunction<Node, Class<?>, AbstractNode> argumentConversionPipe) {
            this.argumentConversionPipe = argumentConversionPipe;
            return this;
        }

        public QueryConversionPipelineBuilder useNonDefaultPostConversionTransformer(Function<AbstractNode, AbstractNode> postConversionTransformer) {
            this.postConversionTransformer = postConversionTransformer;
            return this;
        }

        public QueryConversionPipelineBuilder useNonDefaultQueryBuildingPipe(Function<AbstractNode, Condition<GeneralQueryBuilder>> queryBuildingPipe) {
            this.queryBuildingPipe = queryBuildingPipe;
            return this;
        }

        public QueryConversionPipeline build() {
            return new QueryConversionPipeline(this.parsingPipe, this.preConversionTransformer, this.argumentConversionPipe, this.postConversionTransformer, this.queryBuildingPipe);
        }
    }
}

