/*
 * Decompiled with CFR 0.152.
 */
package com.github.rutledgepaulv.rqe.resolvers;

import com.github.rutledgepaulv.qbuilders.structures.FieldPath;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.function.BiFunction;
import org.apache.commons.lang3.reflect.FieldUtils;

public class EntityFieldTypeResolver
implements BiFunction<FieldPath, Class<?>, Class<?>> {
    @Override
    public Class<?> apply(FieldPath path, Class<?> root) {
        String[] splitField = path.asKey().split("\\.", 2);
        if (splitField.length == 1) {
            return EntityFieldTypeResolver.normalize(FieldUtils.getField(root, (String)splitField[0], (boolean)true));
        }
        return this.apply(new FieldPath(splitField[1]), EntityFieldTypeResolver.normalize(FieldUtils.getField(root, (String)splitField[0], (boolean)true)));
    }

    private static Class<?> normalize(Field field) {
        if (Collection.class.isAssignableFrom(field.getType())) {
            return EntityFieldTypeResolver.getFirstTypeParameterOf(field);
        }
        if (field.getType().isArray()) {
            return field.getType().getComponentType();
        }
        return field.getType();
    }

    private static Class<?> getFirstTypeParameterOf(Field field) {
        return (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
    }
}

