/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.help.cli.bash;

import com.github.rvesse.airline.Accessor;
import com.github.rvesse.airline.annotations.help.bash.BashCompletion;
import com.github.rvesse.airline.help.cli.bash.CompletionBehaviour;
import com.github.rvesse.airline.help.common.AbstractGlobalUsageGenerator;
import com.github.rvesse.airline.model.ArgumentsMetadata;
import com.github.rvesse.airline.model.CommandGroupMetadata;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.GlobalMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.restrictions.common.AbstractAllowedValuesRestriction;
import com.github.rvesse.airline.utils.predicates.restrictions.AllowedValuesOptionFinder;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.StringUtils;

public class BashCompletionGenerator<T>
extends AbstractGlobalUsageGenerator<T> {
    private static final char NEWLINE = '\n';
    private static final String DOUBLE_NEWLINE = "\n\n";
    private final boolean withDebugging;

    public BashCompletionGenerator() {
        this(false, false);
    }

    public BashCompletionGenerator(boolean includeHidden, boolean enableDebugging) {
        super(includeHidden);
        this.withDebugging = enableDebugging;
    }

    public void usage(GlobalMetadata<T> global, OutputStream output) throws IOException {
        boolean hasGroups;
        OutputStreamWriter writer = new OutputStreamWriter(output);
        this.writeHeader(writer);
        this.writeHelperFunctions(writer);
        boolean bl = hasGroups = global.getCommandGroups().size() > 1 || global.getDefaultGroupCommands().size() == 0;
        if (hasGroups) {
            this.generateGroupFunctions(global, writer);
        }
        this.generateCommandFunctions(global, writer);
        this.writeFunctionName(writer, global, true);
        this.indent(writer, 2);
        ((Writer)writer).append("# Get completion data").append('\n');
        this.indent(writer, 2);
        ((Writer)writer).append("CURR_WORD=${COMP_WORDS[COMP_CWORD]}").append('\n');
        this.indent(writer, 2);
        ((Writer)writer).append("PREV_WORD=${COMP_WORDS[COMP_CWORD-1]}").append('\n');
        this.indent(writer, 2);
        ((Writer)writer).append("CURR_CMD=").append('\n');
        this.indent(writer, 2);
        ((Writer)writer).append("if [[ ${COMP_CWORD} -ge 1 ]]; then").append('\n');
        this.indent(writer, 4);
        ((Writer)writer).append("CURR_CMD=${COMP_WORDS[1]}").append('\n');
        this.indent(writer, 2);
        ((Writer)writer).append("fi").append(DOUBLE_NEWLINE);
        HashSet<String> commandNames = new HashSet<String>();
        for (CommandMetadata command : global.getDefaultGroupCommands()) {
            if (command.isHidden() && !this.includeHidden()) continue;
            commandNames.add(command.getName());
        }
        if (hasGroups) {
            for (Object group : global.getCommandGroups()) {
                if (group.isHidden() && !this.includeHidden()) continue;
                commandNames.add(group.getName());
            }
        }
        if (global.getDefaultCommand() != null) {
            commandNames.add(global.getDefaultCommand().getName());
        }
        this.writeWordListVariable(writer, 2, "COMMANDS", commandNames.iterator());
        this.indent(writer, 2);
        ((Writer)writer).append("if [[ ${COMP_CWORD} -eq 1 ]]; then").append('\n');
        if (global.getDefaultCommand() != null) {
            this.writeCommandFunctionCall(writer, global, null, global.getDefaultCommand(), 4);
            this.indent(writer, 4);
            ((Writer)writer).append("DEFAULT_COMMAND_COMPLETIONS=(${COMPREPLY[@]})").append('\n');
        }
        this.indent(writer, 4);
        ((Writer)writer).append("COMPREPLY=()").append('\n');
        if (global.getDefaultCommand() != null) {
            this.writeCompletionGeneration(writer, 4, false, null, "COMMANDS", "DEFAULT_COMMAND_COMPLETIONS");
        } else {
            this.writeCompletionGeneration(writer, 4, false, null, "COMMANDS");
        }
        this.indent(writer, 2);
        ((Writer)writer).append("fi").append(DOUBLE_NEWLINE);
        ((Writer)writer).append("  case ${CURR_CMD} in ").append('\n');
        if (hasGroups) {
            HashSet<String> groups = new HashSet<String>();
            for (CommandGroupMetadata group : global.getCommandGroups()) {
                if (group.isHidden() && !this.includeHidden()) continue;
                this.writeGroupCase(writer, global, group, 4);
                groups.add(group.getName());
            }
            for (CommandMetadata command : global.getDefaultGroupCommands()) {
                if (groups.contains(command.getName())) continue;
                groups.add(command.getName());
                if (command.isHidden() && !this.includeHidden()) continue;
                this.writeCommandCase(writer, global, null, command, 4, false);
                groups.add(command.getName());
            }
        } else {
            for (CommandMetadata command : global.getDefaultGroupCommands()) {
                if (command.isHidden() && !this.includeHidden()) continue;
                this.writeCommandCase(writer, global, null, command, 4, false);
            }
        }
        this.indent(writer, 2);
        ((Writer)writer).append("esac").append(DOUBLE_NEWLINE);
        if (this.withDebugging) {
            this.indent(writer, 2);
            ((Writer)writer).append("set +o xtrace").append('\n');
        }
        ((Writer)writer).append("}").append(DOUBLE_NEWLINE);
        ((Writer)writer).append("complete -F ");
        this.writeFunctionName(writer, global, false);
        ((Writer)writer).append(" ").append(global.getName());
        ((Writer)writer).flush();
        output.flush();
    }

    private void generateCommandFunctions(GlobalMetadata<T> global, Writer writer) throws IOException {
        for (CommandMetadata command : global.getDefaultGroupCommands()) {
            if (command.isHidden() && !this.includeHidden()) continue;
            this.generateCommandCompletionFunction(writer, global, null, command);
        }
    }

    private void generateGroupFunctions(GlobalMetadata<T> global, Writer writer) throws IOException {
        for (CommandGroupMetadata group : global.getCommandGroups()) {
            if (group.isHidden() && !this.includeHidden()) continue;
            this.generateGroupCompletionFunction(writer, global, group);
            for (CommandMetadata command : group.getCommands()) {
                if (command.isHidden() && !this.includeHidden()) continue;
                this.generateCommandCompletionFunction(writer, global, group, command);
            }
        }
    }

    private void writeHeader(Writer writer) throws IOException {
        writer.append("#!/bin/bash").append(DOUBLE_NEWLINE);
        writer.append("# Generated by airline BashCompletionGenerator").append(DOUBLE_NEWLINE);
    }

    private void writeHelperFunctions(Writer writer) throws IOException {
        writer.append("containsElement () {\n");
        this.indent(writer, 2);
        writer.append("# This function from http://stackoverflow.com/a/8574392/107591\n");
        this.indent(writer, 2);
        writer.append("local e\n");
        this.indent(writer, 2);
        writer.append("for e in \"${@:2}\"; do [[ \"$e\" == \"$1\" ]] && return 0; done\n");
        this.indent(writer, 2);
        writer.append("return 1\n");
        writer.append("}\n\n");
    }

    private void writeCommandCase(Writer writer, GlobalMetadata<T> global, CommandGroupMetadata group, CommandMetadata command, int indent, boolean isNestedFunction) throws IOException {
        this.indent(writer, indent);
        writer.append(command.getName()).append(')').append('\n');
        this.writeCommandFunctionCall(writer, global, group, command, indent += 2);
        if (isNestedFunction) {
            this.indent(writer, indent);
            writer.append("echo ${COMPREPLY[@]}").append('\n');
        }
        this.indent(writer, indent);
        writer.append("return $?").append('\n');
        this.indent(writer, indent);
        writer.append(";;").append('\n');
    }

    private void writeCommandFunctionCall(Writer writer, GlobalMetadata<T> global, CommandGroupMetadata group, CommandMetadata command, int indent) throws IOException {
        this.indent(writer, indent);
        writer.append("COMPREPLY=( $(");
        this.writeCommandFunctionName(writer, global, group, command, false);
        writer.append(" \"${COMMANDS}\" ) )").append('\n');
    }

    private void writeGroupCase(Writer writer, GlobalMetadata<T> global, CommandGroupMetadata group, int indent) throws IOException {
        this.indent(writer, indent);
        writer.append(group.getName()).append(')').append('\n');
        this.writeGroupFunctionCall(writer, global, group, indent += 2);
        this.indent(writer, indent);
        writer.append("return $?").append('\n');
        this.indent(writer, indent);
        writer.append(";;").append('\n');
    }

    private void writeGroupFunctionCall(Writer writer, GlobalMetadata<T> global, CommandGroupMetadata group, int indent) throws IOException {
        this.indent(writer, indent);
        writer.append("COMPREPLY=( $( ");
        this.writeGroupFunctionName(writer, global, group, false);
        writer.append(" ) )").append('\n');
    }

    private void generateGroupCompletionFunction(Writer writer, GlobalMetadata<T> global, CommandGroupMetadata group) throws IOException {
        this.writeGroupFunctionName(writer, global, group, true);
        writer.append("  # Get completion data").append('\n');
        writer.append("  COMPREPLY=()").append('\n');
        writer.append("  CURR_WORD=${COMP_WORDS[COMP_CWORD]}").append('\n');
        writer.append("  PREV_WORD=${COMP_WORDS[COMP_CWORD-1]}").append("\n");
        writer.append("  CURR_CMD=").append('\n');
        writer.append("  if [[ ${COMP_CWORD} -ge 2 ]]; then").append('\n');
        writer.append("    CURR_CMD=${COMP_WORDS[2]}").append('\n');
        writer.append("  fi").append(DOUBLE_NEWLINE);
        HashSet<String> commandNames = new HashSet<String>();
        for (CommandMetadata command : group.getCommands()) {
            if (command.isHidden() && !this.includeHidden()) continue;
            commandNames.add(command.getName());
        }
        this.writeWordListVariable(writer, 2, "COMMANDS", commandNames.iterator());
        writer.append("  if [[ ${COMP_CWORD} -eq 2 ]]; then").append('\n');
        if (group.getDefaultCommand() != null) {
            this.writeCommandFunctionCall(writer, global, group, group.getDefaultCommand(), 4);
            this.indent(writer, 4);
            writer.append("DEFAULT_GROUP_COMMAND_COMPLETIONS=(${COMPREPLY[@]})").append('\n');
        }
        if (global.getDefaultCommand() != null) {
            this.writeCompletionGeneration(writer, 4, true, null, "COMMANDS", "DEFAULT_GROUP_COMMAND_COMPLETIONS");
        } else {
            this.writeCompletionGeneration(writer, 4, true, null, "COMMANDS");
        }
        writer.append("  fi").append(DOUBLE_NEWLINE);
        writer.append("  case ${CURR_CMD} in").append('\n');
        for (CommandMetadata command : group.getCommands()) {
            if (command.isHidden() && !this.includeHidden()) continue;
            this.writeCommandCase(writer, global, group, command, 4, true);
        }
        writer.append("  esac").append('\n');
        writer.append('}').append(DOUBLE_NEWLINE);
    }

    private void generateCommandCompletionFunction(Writer writer, GlobalMetadata<T> global, CommandGroupMetadata group, CommandMetadata command) throws IOException {
        this.writeCommandFunctionName(writer, global, group, command, true);
        writer.append("  # Get completion data").append('\n');
        writer.append("  COMPREPLY=()").append('\n');
        writer.append("  CURR_WORD=${COMP_WORDS[COMP_CWORD]}").append('\n');
        writer.append("  PREV_WORD=${COMP_WORDS[COMP_CWORD-1]}").append('\n');
        writer.append("  COMMANDS=$1").append(DOUBLE_NEWLINE);
        HashSet flagOpts = new HashSet();
        HashSet argOpts = new HashSet();
        for (OptionMetadata option : command.getAllOptions()) {
            if (option.isHidden() && !this.includeHidden()) continue;
            if (option.getArity() == 0) {
                flagOpts.addAll(option.getOptions());
                continue;
            }
            argOpts.addAll(option.getOptions());
        }
        this.writeWordListVariable(writer, 2, "FLAG_OPTS", flagOpts.iterator());
        this.writeWordListVariable(writer, 2, "ARG_OPTS", argOpts.iterator());
        writer.append('\n');
        if (argOpts.size() > 0) {
            writer.append("  $( containsElement ${PREV_WORD} ${ARG_OPTS[@]} )").append('\n');
            writer.append("  SAW_ARG=$?").append('\n');
            writer.append("  if [[ ${SAW_ARG} -eq 0 ]]; then").append('\n');
            writer.append("    ARG_VALUES=").append('\n');
            writer.append("    ARG_GENERATED_VALUES=").append('\n');
            writer.append("    case ${PREV_WORD} in").append('\n');
            for (OptionMetadata option : command.getAllOptions()) {
                AbstractAllowedValuesRestriction allowedValues;
                if (option.isHidden() || option.getArity() == 0) continue;
                this.indent(writer, 6);
                Iterator names = option.getOptions().iterator();
                while (names.hasNext()) {
                    writer.append((CharSequence)names.next());
                    if (!names.hasNext()) continue;
                    writer.append('|');
                }
                writer.append(")\n");
                BashCompletion completion = this.getCompletionData(option);
                if (completion != null && StringUtils.isNotEmpty((CharSequence)completion.command())) {
                    this.indent(writer, 8);
                    writer.append("ARG_GENERATED_VALUES=$( ").append(completion.command()).append(" )").append('\n');
                }
                if ((allowedValues = (AbstractAllowedValuesRestriction)CollectionUtils.find((Iterable)option.getRestrictions(), (Predicate)new AllowedValuesOptionFinder())) != null && allowedValues.getAllowedValues().size() > 0) {
                    this.writeWordListVariable(writer, 8, "ARG_VALUES", allowedValues.getAllowedValues().iterator());
                }
                this.writeCompletionGeneration(writer, 8, true, this.getCompletionData(option), "ARG_VALUES", "ARG_GENERATED_VALUES");
                this.indent(writer, 8);
                writer.append(";;").append('\n');
            }
            writer.append("    esac").append('\n');
            writer.append("  fi").append(DOUBLE_NEWLINE);
        }
        BashCompletion completion = null;
        if (command.getArguments() != null) {
            completion = this.getCompletionData(command.getArguments());
            if (completion != null && StringUtils.isNotEmpty((CharSequence)completion.command())) {
                writer.append("  ARGUMENTS=$( ").append(completion.command()).append(" )").append('\n');
            } else {
                writer.append("  ARGUMENTS=").append('\n');
            }
        } else {
            writer.append("  ARGUMENTS=").append('\n');
        }
        this.writeCompletionGeneration(writer, 2, true, completion, "FLAG_OPTS", "ARG_OPTS", "ARGUMENTS");
        writer.append('}').append(DOUBLE_NEWLINE);
    }

    private void indent(Writer writer, int indent) throws IOException {
        this.repeat(writer, indent, ' ');
    }

    private void repeat(Writer writer, int count, char c) throws IOException {
        if (count <= 0) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            writer.append(c);
        }
    }

    private void writeWordListVariable(Writer writer, int indent, String varName, Iterator<String> words) throws IOException {
        this.indent(writer, indent);
        writer.append(varName).append("=\"");
        while (words.hasNext()) {
            writer.append(words.next());
            if (!words.hasNext()) continue;
            writer.append(' ');
        }
        writer.append('\"').append('\n');
    }

    private void writeFunctionName(Writer writer, GlobalMetadata<T> global, boolean declare) throws IOException {
        if (declare) {
            writer.append("function ");
        }
        writer.append("_complete_").append(this.bashize(global.getName()));
        if (declare) {
            writer.append("() {").append('\n');
        }
    }

    private void writeGroupFunctionName(Writer writer, GlobalMetadata<T> global, CommandGroupMetadata group, boolean declare) throws IOException {
        if (declare) {
            writer.append("function ");
        }
        writer.append("_complete_").append(this.bashize(global.getName())).append("_group_").append(this.bashize(group.getName()));
        if (declare) {
            writer.append("() {").append('\n');
        }
    }

    private void writeCommandFunctionName(Writer writer, GlobalMetadata<T> global, CommandGroupMetadata group, CommandMetadata command, boolean declare) throws IOException {
        if (declare) {
            writer.append("function ");
        }
        writer.append("_complete_").append(this.bashize(global.getName()));
        if (group != null) {
            writer.append("_group_").append(this.bashize(group.getName()));
        }
        writer.append("_command_").append(this.bashize(command.getName()));
        if (declare) {
            writer.append("() {").append('\n');
        }
    }

    private void writeCompletionGeneration(Writer writer, int indent, boolean isNestedFunction, BashCompletion completion, String ... varNames) throws IOException {
        this.indent(writer, indent);
        writer.append("COMPREPLY=( $(compgen ");
        if (completion != null) {
            switch (completion.behaviour()) {
                case FILENAMES: {
                    writer.append("-o default ");
                    break;
                }
                case DIRECTORIES: {
                    writer.append("-o dirnames ");
                    break;
                }
                case AS_FILENAMES: {
                    writer.append("-o filenames ");
                    break;
                }
                case AS_DIRECTORIES: {
                    writer.append("-o plusdirs ");
                    break;
                }
                case SYSTEM_COMMANDS: {
                    writer.append("-c ");
                    break;
                }
            }
        }
        writer.append("-W \"");
        for (int i = 0; i < varNames.length; ++i) {
            writer.append("${").append(varNames[i]).append("}");
            if (i >= varNames.length - 1) continue;
            writer.append(' ');
        }
        if (completion != null && completion.behaviour() == CompletionBehaviour.CLI_COMMANDS) {
            writer.append(" ${COMMANDS}");
        }
        writer.append("\" -- ${CURR_WORD}) )").append('\n');
        if (isNestedFunction) {
            this.indent(writer, indent);
            writer.append("echo ${COMPREPLY[@]}").append('\n');
        }
        this.indent(writer, indent);
        writer.append("return 0").append('\n');
    }

    private String bashize(String value) {
        StringBuilder builder = new StringBuilder();
        for (char c : value.toCharArray()) {
            if (!Character.isLetterOrDigit(c) && c != '_') continue;
            builder.append(c);
        }
        return builder.toString();
    }

    protected BashCompletion getCompletionData(OptionMetadata option) {
        return this.getCompletionData(option.getAccessors());
    }

    protected BashCompletion getCompletionData(ArgumentsMetadata arguments) {
        return this.getCompletionData(arguments.getAccessors());
    }

    protected BashCompletion getCompletionData(Collection<Accessor> accessors) {
        Accessor accessor;
        BashCompletion info = null;
        Iterator<Accessor> iterator = accessors.iterator();
        while (iterator.hasNext() && (info = (BashCompletion)(accessor = iterator.next()).getAnnotation(BashCompletion.class)) == null) {
        }
        return info;
    }
}

