/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.io;

import com.github.rvesse.airline.io.colors.BasicColor;
import com.github.rvesse.airline.io.output.AnsiBasicColorizedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestColorizedOutputStream {
    @Test
    public void colorized_output_unecessary_01() {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        AnsiBasicColorizedOutputStream colorOutput = new AnsiBasicColorizedOutputStream((OutputStream)output);
        colorOutput.setForegroundColor((Object)BasicColor.RED);
        colorOutput.close();
        Assert.assertEquals((int)output.size(), (int)0);
    }

    @Test
    public void colorized_output_unecessary_02() {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        AnsiBasicColorizedOutputStream colorOutput = new AnsiBasicColorizedOutputStream((OutputStream)output);
        for (BasicColor color : BasicColor.values()) {
            colorOutput.setForegroundColor((Object)color);
        }
        colorOutput.close();
        Assert.assertEquals((int)output.size(), (int)0);
    }

    @Test
    public void colorized_output_unecessary_03() {
        String test = "Test";
        byte[] testBytes = test.getBytes();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        AnsiBasicColorizedOutputStream colorOutput = new AnsiBasicColorizedOutputStream((OutputStream)output);
        colorOutput.setForegroundColor((Object)BasicColor.RED);
        colorOutput.print(test);
        Assert.assertTrue((output.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((output.size() > testBytes.length ? 1 : 0) != 0);
        int previousSize = output.size();
        colorOutput.setForegroundColor((Object)BasicColor.CYAN);
        Assert.assertEquals((int)output.size(), (int)previousSize);
        colorOutput.close();
        Assert.assertTrue((output.size() > previousSize ? 1 : 0) != 0);
    }

    @Test
    public void colorized_output_01() {
        String test = "Test";
        byte[] testBytes = test.getBytes();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        AnsiBasicColorizedOutputStream colorOutput = new AnsiBasicColorizedOutputStream((OutputStream)output);
        colorOutput.setForegroundColor((Object)BasicColor.RED);
        colorOutput.print(test);
        Assert.assertTrue((output.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((output.size() > testBytes.length ? 1 : 0) != 0);
        int previousSize = output.size();
        colorOutput.resetForegroundColor();
        Assert.assertTrue((output.size() > previousSize ? 1 : 0) != 0);
        previousSize = output.size();
        colorOutput.print(test);
        Assert.assertEquals((int)output.size(), (int)(previousSize + testBytes.length));
        colorOutput.close();
    }

    @Test
    public void colorized_output_02() {
        String test = "Test";
        byte[] testBytes = test.getBytes();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        AnsiBasicColorizedOutputStream colorOutput = new AnsiBasicColorizedOutputStream((OutputStream)output);
        colorOutput.setForegroundColor((Object)BasicColor.RED);
        colorOutput.print(test);
        Assert.assertTrue((output.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((output.size() > testBytes.length ? 1 : 0) != 0);
        int previousSize = output.size();
        colorOutput.resetForegroundColor();
        Assert.assertTrue((output.size() > previousSize ? 1 : 0) != 0);
        previousSize = output.size();
        colorOutput.print(test);
        Assert.assertEquals((int)output.size(), (int)(previousSize + testBytes.length));
        previousSize = output.size();
        colorOutput.setBackgroundColor((Object)BasicColor.BLUE);
        Assert.assertEquals((int)output.size(), (int)previousSize);
        colorOutput.print(test);
        Assert.assertTrue((output.size() > previousSize + testBytes.length ? 1 : 0) != 0);
        colorOutput.close();
    }

    @Test
    public void colorized_output_reset_01() {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        AnsiBasicColorizedOutputStream colorOutput = new AnsiBasicColorizedOutputStream((OutputStream)output);
        colorOutput.reset(false);
        Assert.assertEquals((int)output.size(), (int)0);
        colorOutput.close();
    }

    @Test
    public void colorized_output_reset_02() {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        AnsiBasicColorizedOutputStream colorOutput = new AnsiBasicColorizedOutputStream((OutputStream)output);
        colorOutput.setForegroundColor((Object)BasicColor.RED);
        Assert.assertEquals((int)output.size(), (int)0);
        colorOutput.reset(false);
        Assert.assertEquals((int)output.size(), (int)0);
        colorOutput.close();
    }

    @Test
    public void colorized_output_reset_03() {
        String test = "Test";
        byte[] testBytes = test.getBytes();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        AnsiBasicColorizedOutputStream colorOutput = new AnsiBasicColorizedOutputStream((OutputStream)output);
        colorOutput.setForegroundColor((Object)BasicColor.RED);
        colorOutput.print(test);
        Assert.assertTrue((output.size() > testBytes.length ? 1 : 0) != 0);
        int previousSize = output.size();
        colorOutput.reset(false);
        Assert.assertTrue((output.size() > previousSize ? 1 : 0) != 0);
        colorOutput.close();
    }

    @Test
    public void colorized_output_reset_04() {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        AnsiBasicColorizedOutputStream colorOutput = new AnsiBasicColorizedOutputStream((OutputStream)output);
        colorOutput.reset(true);
        Assert.assertTrue((output.size() > 0 ? 1 : 0) != 0);
        colorOutput.close();
    }
}

