/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.io.printers;

import com.github.rvesse.airline.io.printers.TroffPrinter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTroffPrinter {
    private static final String TABLE_END = ".TE";
    private static final String TABLE_START = ".TS";
    private static final String END_LIST = ".IP \"\" 0";
    private static final String BULLET = ".IP \"-\" 4";
    private static final String PLAIN = ".IP \"\" 4";
    private static final String NUMBER_REG = ".nr list1 1 1";
    private static final String NUMBER_REG_CLEAR = ".rr list1";
    private static final String NUMBER_BULLET_FIRST = ".IP \\n[list1]. 4";
    private static final String NUMBER_BULLET_REST = ".IP \\n+[list1]. 4";
    private static final String TITLED_BULLET = ".TP";
    private static final String BREAK = ".br";

    @Test
    public void title_01() {
        StringWriter strWriter = new StringWriter();
        TroffPrinter printer = new TroffPrinter(new PrintWriter(strWriter));
        printer.start("Test", 1);
        printer.finish();
        String expected = StringUtils.join((Object[])new String[]{".TH \"Test\" \"1\" \"\" \"\" \"\"", ""}, (char)'\n');
        Assert.assertEquals((String)strWriter.toString(), (String)expected);
    }

    @Test
    public void title_02() {
        StringWriter strWriter = new StringWriter();
        TroffPrinter printer = new TroffPrinter(new PrintWriter(strWriter));
        printer.start("Test\"Quotes", 1);
        printer.finish();
        String expected = StringUtils.join((Object[])new String[]{".TH \"Test Quotes\" \"1\" \"\" \"\" \"\"", ""}, (char)'\n');
        Assert.assertEquals((String)strWriter.toString(), (String)expected);
    }

    @Test
    public void basic_text() {
        StringWriter strWriter = new StringWriter();
        TroffPrinter printer = new TroffPrinter(new PrintWriter(strWriter));
        printer.println("This is a line");
        printer.println("Another line");
        printer.finish();
        String expected = StringUtils.join((Object[])new String[]{".", "This is a line", ".", "Another line", ""}, (char)'\n');
        Assert.assertEquals((String)strWriter.toString(), (String)expected);
    }

    @Test
    public void basic_list() {
        StringWriter strWriter = new StringWriter();
        TroffPrinter printer = new TroffPrinter(new PrintWriter(strWriter));
        printer.startBulletedList();
        printer.println("A");
        printer.nextBulletedListItem();
        printer.println("B");
        printer.nextBulletedListItem();
        printer.println("C");
        printer.endList();
        printer.finish();
        String expected = StringUtils.join((Object[])new String[]{BULLET, "A", BULLET, "B", BULLET, "C", END_LIST, ""}, (char)'\n');
        Assert.assertEquals((String)strWriter.toString(), (String)expected);
    }

    @Test
    public void plain_list() {
        StringWriter strWriter = new StringWriter();
        TroffPrinter printer = new TroffPrinter(new PrintWriter(strWriter));
        printer.startPlainList();
        printer.println("A");
        printer.nextPlainListItem();
        printer.println("B");
        printer.nextPlainListItem();
        printer.println("C");
        printer.endList();
        printer.finish();
        String expected = StringUtils.join((Object[])new String[]{PLAIN, "A", PLAIN, "B", PLAIN, "C", END_LIST, ""}, (char)'\n');
        Assert.assertEquals((String)strWriter.toString(), (String)expected);
    }

    @Test
    public void numbered_list() {
        StringWriter strWriter = new StringWriter();
        TroffPrinter printer = new TroffPrinter(new PrintWriter(strWriter));
        printer.startNumberedList();
        printer.println("A");
        printer.nextNumberedListItem();
        printer.println("B");
        printer.nextNumberedListItem();
        printer.println("C");
        printer.endList();
        printer.finish();
        String expected = StringUtils.join((Object[])new String[]{NUMBER_REG, NUMBER_BULLET_FIRST, "A", NUMBER_BULLET_REST, "B", NUMBER_BULLET_REST, "C", END_LIST, NUMBER_REG_CLEAR, ""}, (char)'\n');
        Assert.assertEquals((String)strWriter.toString(), (String)expected);
    }

    @Test
    public void nested_list_01() {
        StringWriter strWriter = new StringWriter();
        TroffPrinter printer = new TroffPrinter(new PrintWriter(strWriter));
        printer.startBulletedList();
        printer.println("A");
        printer.startBulletedList();
        printer.println("B");
        printer.endList();
        printer.nextBulletedListItem();
        printer.println("C");
        printer.endList();
        printer.finish();
        String expected = StringUtils.join((Object[])new String[]{BULLET, "A", ".RS", BULLET, "B", ".RE", BULLET, "C", END_LIST, ""}, (char)'\n');
        Assert.assertEquals((String)strWriter.toString(), (String)expected);
    }

    @Test
    public void nested_list_02() {
        StringWriter strWriter = new StringWriter();
        TroffPrinter printer = new TroffPrinter(new PrintWriter(strWriter));
        printer.startBulletedList();
        printer.println("A");
        printer.startBulletedList();
        printer.println("B");
        printer.endList();
        printer.println("C");
        printer.endList();
        printer.finish();
        String expected = StringUtils.join((Object[])new String[]{BULLET, "A", ".RS", BULLET, "B", ".RE", ".IP", "C", END_LIST, ""}, (char)'\n');
        Assert.assertEquals((String)strWriter.toString(), (String)expected);
    }

    @Test
    public void nested_list_03() {
        StringWriter strWriter = new StringWriter();
        TroffPrinter printer = new TroffPrinter(new PrintWriter(strWriter));
        printer.startBulletedList();
        printer.println("A");
        printer.startPlainList();
        printer.println("B");
        printer.endList();
        printer.nextBulletedListItem();
        printer.println("C");
        printer.endList();
        printer.finish();
        String expected = StringUtils.join((Object[])new String[]{BULLET, "A", ".RS", PLAIN, "B", ".RE", BULLET, "C", END_LIST, ""}, (char)'\n');
        Assert.assertEquals((String)strWriter.toString(), (String)expected);
    }

    @Test
    public void nested_list_04() {
        StringWriter strWriter = new StringWriter();
        TroffPrinter printer = new TroffPrinter(new PrintWriter(strWriter));
        printer.startNumberedList();
        printer.println("A");
        printer.startNumberedList();
        printer.println("B");
        printer.endList();
        printer.nextNumberedListItem();
        printer.println("C");
        printer.endList();
        printer.finish();
        String expected = StringUtils.join((Object[])new String[]{NUMBER_REG, NUMBER_BULLET_FIRST, "A", ".RS", NUMBER_REG.replace("list1", "list2"), NUMBER_BULLET_FIRST.replace("list1", "list2"), "B", ".RE", NUMBER_REG_CLEAR.replace("list1", "list2"), NUMBER_BULLET_REST, "C", END_LIST, NUMBER_REG_CLEAR, ""}, (char)'\n');
        Assert.assertEquals((String)strWriter.toString(), (String)expected);
    }

    @Test
    public void titled_list_01() {
        StringWriter strWriter = new StringWriter();
        TroffPrinter printer = new TroffPrinter(new PrintWriter(strWriter));
        printer.startTitledList("A");
        printer.println("Item A");
        printer.nextTitledListItem("B");
        printer.println("Item B");
        printer.endList();
        printer.finish();
        String expected = StringUtils.join((Object[])new String[]{TITLED_BULLET, "A", BREAK, "Item A", TITLED_BULLET, "B", BREAK, "Item B", END_LIST, ""}, (char)'\n');
        Assert.assertEquals((String)strWriter.toString(), (String)expected);
    }

    @Test
    public void titled_list_02() {
        StringWriter strWriter = new StringWriter();
        TroffPrinter printer = new TroffPrinter(new PrintWriter(strWriter));
        printer.startTitledList();
        printer.print("A");
        printer.lineBreak();
        printer.println("Item A");
        printer.nextTitledListItem("B");
        printer.println("Item B");
        printer.endList();
        printer.finish();
        String expected = StringUtils.join((Object[])new String[]{TITLED_BULLET, "A", BREAK, "Item A", TITLED_BULLET, "B", BREAK, "Item B", END_LIST, ""}, (char)'\n');
        Assert.assertEquals((String)strWriter.toString(), (String)expected);
    }

    @Test
    public void titled_list_03() {
        StringWriter strWriter = new StringWriter();
        TroffPrinter printer = new TroffPrinter(new PrintWriter(strWriter));
        printer.startTitledList();
        printer.printBold("A");
        printer.lineBreak();
        printer.println("Item A");
        printer.nextTitledListItem("B");
        printer.println("Item B");
        printer.endList();
        printer.finish();
        String expected = StringUtils.join((Object[])new String[]{TITLED_BULLET, "\\fBA\\fR", BREAK, "Item A", TITLED_BULLET, "B", BREAK, "Item B", END_LIST, ""}, (char)'\n');
        Assert.assertEquals((String)strWriter.toString(), (String)expected);
    }

    @Test
    public void table_01() {
        StringWriter strWriter = new StringWriter();
        TroffPrinter printer = new TroffPrinter(new PrintWriter(strWriter));
        ArrayList rows = new ArrayList();
        ArrayList<String> header = new ArrayList<String>();
        header.add("A");
        header.add("B");
        rows.add(header);
        ArrayList<String> row = new ArrayList<String>();
        row.add("One");
        rows.add(row);
        printer.printTable(rows, true);
        String expected = StringUtils.join((Object[])new String[]{TABLE_START, "box;", "cb | cb", "l | l .", "A\tB", "_\t|\t_", "One", TABLE_END, ""}, (char)'\n');
        Assert.assertEquals((String)strWriter.toString(), (String)expected);
    }

    @Test
    public void table_02() {
        StringWriter strWriter = new StringWriter();
        TroffPrinter printer = new TroffPrinter(new PrintWriter(strWriter));
        ArrayList rows = new ArrayList();
        ArrayList<String> header = new ArrayList<String>();
        header.add("A");
        header.add("B");
        rows.add(header);
        printer.printTable(rows, true);
        String expected = StringUtils.join((Object[])new String[]{TABLE_START, "box;", "cb | cb .", "A\tB", TABLE_END, ""}, (char)'\n');
        Assert.assertEquals((String)strWriter.toString(), (String)expected);
    }

    @Test
    public void table_03() {
        StringWriter strWriter = new StringWriter();
        TroffPrinter printer = new TroffPrinter(new PrintWriter(strWriter));
        ArrayList rows = new ArrayList();
        ArrayList<String> header = new ArrayList<String>();
        header.add("A");
        header.add("B");
        rows.add(header);
        printer.printTable(rows, true);
        String expected = StringUtils.join((Object[])new String[]{TABLE_START, "box;", "cb | cb .", "A\tB", TABLE_END, ""}, (char)'\n');
        Assert.assertEquals((String)strWriter.toString(), (String)expected);
    }

    @Test
    public void table_04() {
        StringWriter strWriter = new StringWriter();
        TroffPrinter printer = new TroffPrinter(new PrintWriter(strWriter));
        ArrayList rows = new ArrayList();
        ArrayList<String> header = new ArrayList<String>();
        header.add("A");
        header.add("B");
        rows.add(header);
        ArrayList<String> row = new ArrayList<String>();
        row.add("One");
        row.add("Two");
        row.add("Three");
        rows.add(row);
        row = new ArrayList();
        row.add("One");
        rows.add(row);
        row = new ArrayList();
        rows.add(row);
        row = new ArrayList();
        row.add("");
        row.add("Two");
        rows.add(row);
        printer.printTable(rows, true);
        String expected = StringUtils.join((Object[])new String[]{TABLE_START, "box;", "cb | cb | cb", "l | l | l .", "A\tB", "_\t|\t_\t|\t_", "One\tTwo\tThree", "One", "", "\tTwo", TABLE_END, ""}, (char)'\n');
        Assert.assertEquals((String)strWriter.toString(), (String)expected);
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void bad_state_01() {
        StringWriter strWriter = new StringWriter();
        TroffPrinter printer = new TroffPrinter(new PrintWriter(strWriter));
        printer.endList();
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void bad_state_02() {
        StringWriter strWriter = new StringWriter();
        TroffPrinter printer = new TroffPrinter(new PrintWriter(strWriter));
        printer.startBulletedList();
        printer.nextTitledListItem();
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void bad_state_03() {
        StringWriter strWriter = new StringWriter();
        TroffPrinter printer = new TroffPrinter(new PrintWriter(strWriter));
        printer.startTitledList();
        printer.nextBulletedListItem();
    }
}

